# OpenSearch 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・接続手順](#2-ログイン接続手順)
3. [トップページ（クラスタ情報確認）](#3-トップページクラスタ情報確認)

**【業務フローに沿った機能】**
4. [【STEP1】インデックス設計・作成（データ格納先の準備）](#4-step1インデックス設計作成データ格納先の準備)
5. [【STEP2-3】データ取込・ドキュメント操作（データの投入・更新）](#5-step2-3データ取込ドキュメント操作データの投入更新)
6. [【STEP3-4】検索・分析（データの検索・集計）](#6-step3-4検索分析データの検索集計)
7. [【STEP4-5】クラスタ管理・運用（管理者向け）](#7-step4-5クラスタ管理運用管理者向け)

**【サポート機能】**
8. [スナップショット・バックアップ機能](#8-スナップショットバックアップ機能)
9. [インジェストパイプライン機能](#9-インジェストパイプライン機能)
10. [スクリプト・テンプレート機能](#10-スクリプトテンプレート機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 OpenSearchとは

OpenSearchは、オープンソースの分散型検索・分析エンジンです。大量の非構造化データに対して、高速な全文検索、リアルタイムのログ分析、メトリクス集計などを提供します。Apache License 2.0の下で公開されており、Apache Luceneをベースに構築されています。

主な特徴:
- **分散アーキテクチャ**: 複数ノードにデータを分散し、高可用性とスケーラビリティを実現
- **全文検索**: 多言語対応の高精度な全文検索機能
- **リアルタイム分析**: ログ、メトリクス、トレースの可視化と分析
- **REST API**: すべての操作をHTTP REST APIで実行可能
- **プラグイン拡張**: 豊富なプラグインエコシステムによる機能拡張

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **データ格納設計** | インデックスの作成、マッピング定義、テンプレート管理、データストリーム管理 |
| **データ取込・管理** | ドキュメントの登録・更新・削除、バルク操作、インジェストパイプラインによるデータ変換 |
| **検索・分析** | 全文検索、複合クエリ、アグリゲーション（集計）、地理空間検索、サジェスト機能 |
| **クラスタ運用** | クラスタヘルス監視、ノード管理、シャード割り当て、スナップショット・リストア |
| **セキュリティ管理** | 認証・認可、暗号化、アクセス制御（Security Pluginによる拡張） |
| **監視・分析** | インデックス統計、ノード統計、タスク管理、CAT API によるクラスタ状況確認 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】管理者がインデックスを設計・作成（データ格納先の準備）  │
│      ↓                                                          │
│  【STEP 2】データエンジニアがデータを投入・更新                   │
│      ↓                                                          │
│  【STEP 3】ユーザーがデータを検索・分析                          │
│      ↓                                                          │
│  【STEP 4】管理者がクラスタを監視・運用                          │
│      ↓                                                          │
│  【STEP 5】管理者がバックアップ・メンテナンスを実施              │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **クラスタ管理者** | インデックス設計・作成、クラスタヘルス監視、ノード管理、シャード割り当て、スナップショット管理、セキュリティ設定 |
| **データエンジニア** | インジェストパイプライン設計、データ投入・更新・削除、バルク操作、リインデックス |
| **アプリケーション開発者** | 検索クエリの設計・実行、アグリゲーション、検索テンプレート作成 |
| **運用担当者** | 日常的なクラスタ監視、タスク管理、トラブルシューティング |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| インデックス管理 | インデックスの作成・削除・設定変更、マッピング管理、テンプレート管理 | STEP 1 |
| ドキュメント操作 | ドキュメントの登録・取得・更新・削除、バルク操作 | STEP 2 |
| インジェストパイプライン | データ投入時の変換・加工処理（GeoIP、User-Agent解析等） | STEP 2 |
| 検索 | 全文検索、複合クエリ、スクロール検索、Point-in-Time検索 | STEP 3 |
| アグリゲーション | バケット集計、メトリクス集計、パイプライン集計 | STEP 3 |
| クラスタ管理 | ヘルス監視、ノード管理、シャード割り当て、ルーティング設定 | STEP 4 |
| スナップショット | バックアップの作成・管理・リストア | STEP 5 |
| CAT API | クラスタ状態の簡易確認（テキスト形式での出力） | 随時参照 |
| スクリプト | Painlessスクリプト、Mustacheテンプレートの管理・実行 | 随時利用 |
| タスク管理 | 長時間実行タスクの監視・キャンセル | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| クラスタ管理者 | クラスタ全体の管理権限を持つ。インデックス作成、ノード管理、スナップショット管理などを行う |
| データエンジニア | データの投入・加工・管理を担当。インジェストパイプラインの設計、バルクデータ投入を行う |
| アプリケーション開発者 | アプリケーションからの検索・分析クエリを設計・実行する。検索テンプレートの作成も行う |
| 運用担当者 | 日常的なクラスタ状態の監視、タスク管理、簡易的なトラブルシューティングを行う |

> **注意**: ユーザーのアクセス権限は、Security Plugin（opensearch-security）によって管理されます。具体的な権限設定は、Security Pluginの設定に依存します。

### 1.6 対応環境

**REST APIクライアント：**
- curl（コマンドライン）
- OpenSearch Dashboards（Dev Tools）
- Postman、Insomnia等のHTTPクライアント
- 各言語のOpenSearchクライアントライブラリ（Java、Python、JavaScript、Go、Ruby等）

**対応プロトコル：**
- HTTP/HTTPS（REST API、デフォルトポート: 9200）
- Transport Protocol（ノード間通信、デフォルトポート: 9300）
- gRPC（オプション）

---

## 2. ログイン・接続手順

### 2.1 REST APIへの接続方法

OpenSearchはREST APIベースのシステムです。すべての操作はHTTPリクエストで行います。

**基本的な接続方法（curl）：**

```bash
# HTTPSで接続する場合（推奨）
curl -X GET "https://<ホスト名>:9200/" -u <ユーザー名>:<パスワード> --insecure

# HTTPで接続する場合（開発環境のみ）
curl -X GET "http://<ホスト名>:9200/"
```

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| ホスト名 | OpenSearchノードのホスト名またはIPアドレス |
| ポート番号 | デフォルトは9200（REST API） |
| ユーザー名 | Security Plugin設定時に指定されたユーザー名 |
| パスワード | Security Plugin設定時に指定されたパスワード |

接続に成功すると、クラスタ情報がJSON形式で返却されます。

### 2.2 OpenSearch Dashboardsからの接続

OpenSearch Dashboardsを使用する場合は、ブラウザから以下の手順で接続します：

1. ブラウザで `http://<Dashboardsホスト名>:5601` にアクセスします
2. ログイン画面が表示された場合は、ユーザー名とパスワードを入力します
3. 「Dev Tools」メニューから対話的にREST APIを実行できます

### 2.3 認証トークンの利用

Bearer Token認証を使用する場合：

```bash
curl -X GET "https://<ホスト名>:9200/" -H "Authorization: Bearer <トークン>"
```

> **注意**: 認証方式はSecurity Pluginの設定に依存します。Basic認証、Bearer Token認証、証明書ベースの認証などが利用可能です。

### 2.4 接続確認

接続が成功しているかの確認方法：

```bash
# クラスタ情報の取得
curl -X GET "https://<ホスト名>:9200/"

# レスポンス例
{
  "name" : "node-1",
  "cluster_name" : "opensearch-cluster",
  "cluster_uuid" : "xxxxx",
  "version" : { ... },
  "tagline" : "The OpenSearch Project: https://opensearch.org/"
}
```

レスポンスが正常に返却されれば、接続は成功です。

---

## 3. トップページ（クラスタ情報確認）

### 3.1 クラスタ基本情報の確認

OpenSearchに接続後、まずクラスタの状態を確認します。

**クラスタ情報の取得：**

```
GET /
```

このリクエストにより、クラスタ名、ノード名、バージョン情報が確認できます。

### 3.2 クラスタヘルスの確認

クラスタの健全性を確認するには、以下のリクエストを使用します：

```
GET /_cluster/health
```

**ヘルスステータスの意味：**

| ステータス | 意味 |
|-----------|------|
| **green** | すべてのプライマリシャードとレプリカシャードが割り当て済み。正常な状態 |
| **yellow** | すべてのプライマリシャードは割り当て済みだが、一部のレプリカシャードが未割り当て。データ損失のリスクは低い |
| **red** | 一部のプライマリシャードが未割り当て。データの一部が利用できない可能性がある |

### 3.3 CAT APIによる簡易確認

テキスト形式でクラスタ状態を素早く確認できます：

```
# ノード一覧の確認
GET /_cat/nodes?v

# インデックス一覧の確認
GET /_cat/indices?v

# シャード一覧の確認
GET /_cat/shards?v

# ヘルス確認
GET /_cat/health?v
```

> **Tips**: `?v` パラメータを付けると、ヘッダー行が表示されて読みやすくなります。

---

## 4. 【STEP1】インデックス設計・作成（データ格納先の準備）

> **業務フローでの位置**: 管理者がデータを格納するためのインデックスを設計・作成するステップです。データを投入する前に、適切なインデックス構造を定義する必要があります。

### 4.1 インデックステンプレートの作成（管理者向け）

繰り返し同じ設定でインデックスを作成する場合は、テンプレートを活用します。

**業務シーン**: ログデータなど、日次でインデックスを作成する場合

**やるべきこと**:
- インデックスのマッピング（フィールド定義）を設計する
- シャード数、レプリカ数などの設定を決定する
- インデックステンプレートとして登録する

**操作手順**:

1. Composableインデックステンプレートを作成します

```
PUT /_index_template/<テンプレート名>
{
  "index_patterns": ["logs-*"],
  "template": {
    "settings": {
      "number_of_shards": 1,
      "number_of_replicas": 1
    },
    "mappings": {
      "properties": {
        "timestamp": { "type": "date" },
        "message": { "type": "text" },
        "level": { "type": "keyword" }
      }
    }
  }
}
```

2. テンプレートが正しく登録されたか確認します

```
GET /_index_template/<テンプレート名>
```

**関連画面**: インデックステンプレート登録（画面No.62）、インデックステンプレート取得（画面No.61）

> **注意**: テンプレートのパターンが重複する場合は `priority` パラメータで優先順位を設定してください。

### 4.2 インデックスの作成

**業務シーン**: 新しいデータを格納するためのインデックスを作成する場合

**操作手順**:

1. インデックスを作成します

```
PUT /<インデックス名>
{
  "settings": {
    "number_of_shards": 3,
    "number_of_replicas": 1
  },
  "mappings": {
    "properties": {
      "title": { "type": "text" },
      "content": { "type": "text" },
      "created_at": { "type": "date" },
      "category": { "type": "keyword" },
      "price": { "type": "float" }
    }
  }
}
```

2. インデックスが作成されたか確認します

```
GET /<インデックス名>
```

**関連画面**: インデックス作成（画面No.30）、インデックス情報取得（画面No.32）

> **注意**: インデックス名は小文字のみ使用可能です。特殊文字（`\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, スペース, `,`, `#`）は使用できません。

### 4.3 マッピングの管理

**業務シーン**: 既存インデックスにフィールドを追加する場合

**操作手順**:

1. 現在のマッピングを確認します

```
GET /<インデックス名>/_mapping
```

2. 新しいフィールドを追加します

```
PUT /<インデックス名>/_mapping
{
  "properties": {
    "new_field": { "type": "keyword" }
  }
}
```

> **注意**: 既存フィールドの型（type）は変更できません。型を変更する場合は、新しいインデックスを作成してリインデックスする必要があります。

**関連画面**: マッピング取得（画面No.39）、マッピング登録・更新（画面No.40）

### 4.4 エイリアスの設定

**業務シーン**: 複数のインデックスを論理的にまとめて検索する場合や、インデックスの切り替えをアプリケーションに影響なく行う場合

**操作手順**:

1. エイリアスを作成します

```
POST /_aliases
{
  "actions": [
    { "add": { "index": "logs-2024-01", "alias": "logs-current" } }
  ]
}
```

2. エイリアスの確認

```
GET /_alias/logs-current
```

**関連画面**: エイリアス一括操作（画面No.49）、エイリアス取得（画面No.45）

### 4.5 データストリームの管理

**業務シーン**: 時系列データ（ログ、メトリクス等）を自動的にローテーション管理する場合

**操作手順**:

1. データストリーム用のインデックステンプレートを作成します

```
PUT /_index_template/my-data-stream-template
{
  "index_patterns": ["my-data-stream*"],
  "data_stream": {},
  "template": {
    "settings": {
      "number_of_shards": 1,
      "number_of_replicas": 1
    }
  }
}
```

2. データストリームを作成します

```
PUT /_data_stream/my-data-stream
```

**関連画面**: データストリーム作成（画面No.55）、データストリーム取得（画面No.56）

**次のステップ**: インデックスの準備が完了したら、STEP2のデータ投入に進みます。

---

## 5. 【STEP2-3】データ取込・ドキュメント操作（データの投入・更新）

> **業務フローでの位置**: データエンジニアがインデックスにデータを投入し、ドキュメントの登録・更新・削除を行うステップです。

### 5.1 ドキュメントの種類と操作

| 操作 | 説明 | HTTPメソッド |
|------|------|-------------|
| 登録（Index） | 新しいドキュメントを登録する | PUT / POST |
| 取得（Get） | ドキュメントをIDで取得する | GET |
| 更新（Update） | 既存ドキュメントの一部を更新する | POST |
| 削除（Delete） | ドキュメントを削除する | DELETE |
| バルク操作（Bulk） | 複数のドキュメント操作を一括実行する | POST |

### 5.2 ドキュメントの登録

**業務シーン**: 新しいデータをインデックスに登録する場合

**操作手順**:

1. IDを指定して登録する場合

```
PUT /<インデックス名>/_doc/<ドキュメントID>
{
  "title": "OpenSearch入門",
  "content": "OpenSearchは分散型検索エンジンです",
  "created_at": "2024-01-15T10:30:00Z",
  "category": "技術書"
}
```

2. IDを自動生成して登録する場合

```
POST /<インデックス名>/_doc
{
  "title": "検索エンジンの仕組み",
  "content": "転置インデックスについて解説します",
  "created_at": "2024-01-16T14:00:00Z"
}
```

**関連画面**: ドキュメント登録・更新（画面No.3）

### 5.3 ドキュメントの取得

**操作手順**:

```
GET /<インデックス名>/_doc/<ドキュメントID>
```

複数ドキュメントを一括取得する場合：

```
POST /_mget
{
  "docs": [
    { "_index": "my-index", "_id": "1" },
    { "_index": "my-index", "_id": "2" }
  ]
}
```

**関連画面**: ドキュメント取得（画面No.4）、マルチGet（画面No.6）

### 5.4 ドキュメントの更新

**業務シーン**: 既存ドキュメントの一部フィールドを更新する場合

**操作手順**:

```
POST /<インデックス名>/_update/<ドキュメントID>
{
  "doc": {
    "category": "技術書（改訂版）"
  }
}
```

**関連画面**: ドキュメント更新（画面No.5）

### 5.5 ドキュメントの削除

**操作手順**:

```
DELETE /<インデックス名>/_doc/<ドキュメントID>
```

条件に一致するドキュメントを一括削除する場合：

```
POST /<インデックス名>/_delete_by_query
{
  "query": {
    "match": {
      "category": "古いデータ"
    }
  }
}
```

**関連画面**: ドキュメント削除（画面No.8）、クエリ指定削除（画面No.10）

### 5.6 バルク操作（大量データの一括処理）

**業務シーン**: 大量のデータを効率的に投入・更新する場合

**操作手順**:

```
POST /_bulk
{"index": {"_index": "my-index", "_id": "1"}}
{"title": "ドキュメント1", "content": "内容1"}
{"index": {"_index": "my-index", "_id": "2"}}
{"title": "ドキュメント2", "content": "内容2"}
{"delete": {"_index": "my-index", "_id": "3"}}
```

> **注意**: バルクリクエストのボディは、各行を改行（`\n`）で区切ったNDJSON形式です。最後の行も改行で終わる必要があります。

**関連画面**: バルク操作（画面No.7）

> **Tips**: 大量データ投入時は、一度に1,000〜5,000件程度のバッチサイズが推奨されます。サイズが大きすぎるとメモリ不足になる場合があります。

### 5.7 リインデックス

**業務シーン**: マッピングの変更やインデックス設定の変更のため、既存データを別のインデックスに移行する場合

**操作手順**:

```
POST /_reindex
{
  "source": {
    "index": "old-index"
  },
  "dest": {
    "index": "new-index"
  }
}
```

**関連画面**: リインデックス（画面No.11）

**次のステップ**: データの投入が完了したら、STEP3の検索・分析に進みます。

---

## 6. 【STEP3-4】検索・分析（データの検索・集計）

> **業務フローでの位置**: ユーザーが投入されたデータを検索・分析し、必要な情報を取得するステップです。

### 6.1 基本的な検索

**業務シーン**: インデックスに格納されたデータを検索する場合

**操作手順**:

1. 全文検索（match クエリ）

```
GET /<インデックス名>/_search
{
  "query": {
    "match": {
      "content": "検索キーワード"
    }
  }
}
```

2. 完全一致検索（term クエリ）

```
GET /<インデックス名>/_search
{
  "query": {
    "term": {
      "category": "技術書"
    }
  }
}
```

3. 複合条件検索（bool クエリ）

```
GET /<インデックス名>/_search
{
  "query": {
    "bool": {
      "must": [
        { "match": { "content": "OpenSearch" } }
      ],
      "filter": [
        { "range": { "created_at": { "gte": "2024-01-01" } } }
      ]
    }
  }
}
```

**関連画面**: 検索（画面No.21）

### 6.2 検索結果の制御

**ページネーション：**

```
GET /<インデックス名>/_search
{
  "from": 0,
  "size": 10,
  "query": { "match_all": {} },
  "sort": [
    { "created_at": { "order": "desc" } }
  ]
}
```

**ハイライト表示：**

```
GET /<インデックス名>/_search
{
  "query": { "match": { "content": "OpenSearch" } },
  "highlight": {
    "fields": { "content": {} }
  }
}
```

**ソース項目の絞り込み：**

```
GET /<インデックス名>/_search
{
  "_source": ["title", "category"],
  "query": { "match_all": {} }
}
```

### 6.3 スクロール検索（大量データの取得）

**業務シーン**: 検索結果が大量にあり、全件を順次取得する場合

**操作手順**:

1. スクロール検索を開始します

```
POST /<インデックス名>/_search?scroll=5m
{
  "size": 1000,
  "query": { "match_all": {} }
}
```

2. スクロールIDを使って次のバッチを取得します

```
POST /_search/scroll
{
  "scroll": "5m",
  "scroll_id": "<前回のレスポンスに含まれるscroll_id>"
}
```

3. 使い終わったらスクロールをクリアします

```
DELETE /_search/scroll
{
  "scroll_id": "<scroll_id>"
}
```

**関連画面**: スクロール検索（画面No.22）、スクロールクリア（画面No.23）

### 6.4 Point-in-Time（PIT）検索

**業務シーン**: 検索中にデータが変更されても、一貫性のある検索結果を取得したい場合

**操作手順**:

1. PITを作成します

```
POST /<インデックス名>/_search/point_in_time?keep_alive=5m
```

2. PITを使って検索します

```
GET /_search
{
  "size": 100,
  "query": { "match_all": {} },
  "pit": {
    "id": "<pit_id>",
    "keep_alive": "5m"
  },
  "sort": [{ "_shard_doc": "asc" }]
}
```

3. 使い終わったらPITを削除します

```
DELETE /_search/point_in_time
{
  "pit_id": "<pit_id>"
}
```

**関連画面**: PIT作成（画面No.24）、PIT削除（画面No.25）

### 6.5 アグリゲーション（集計）

**業務シーン**: データの統計情報や集計結果を取得する場合

**バケットアグリゲーション（グルーピング）：**

```
GET /<インデックス名>/_search
{
  "size": 0,
  "aggs": {
    "category_count": {
      "terms": {
        "field": "category",
        "size": 10
      }
    }
  }
}
```

**メトリクスアグリゲーション（統計値）：**

```
GET /<インデックス名>/_search
{
  "size": 0,
  "aggs": {
    "avg_price": { "avg": { "field": "price" } },
    "max_price": { "max": { "field": "price" } },
    "min_price": { "min": { "field": "price" } }
  }
}
```

**日時ヒストグラム：**

```
GET /<インデックス名>/_search
{
  "size": 0,
  "aggs": {
    "daily_count": {
      "date_histogram": {
        "field": "created_at",
        "calendar_interval": "day"
      }
    }
  }
}
```

**関連画面**: 検索（画面No.21）

### 6.6 マルチ検索

**業務シーン**: 複数の検索クエリを一度に実行する場合

```
POST /_msearch
{"index": "index-1"}
{"query": {"match": {"title": "OpenSearch"}}}
{"index": "index-2"}
{"query": {"match": {"content": "分析"}}}
```

**関連画面**: マルチ検索（画面No.27）

### 6.7 サジェスト機能

**業務シーン**: ユーザーの入力を補完するサジェストを提供する場合

```
GET /<インデックス名>/_search
{
  "suggest": {
    "title-suggest": {
      "text": "opensarch",
      "term": {
        "field": "title"
      }
    }
  }
}
```

**関連画面**: 検索（画面No.21）

**次のステップ**: 検索・分析が完了したら、STEP4のクラスタ管理に進みます。

---

## 7. 【STEP4-5】クラスタ管理・運用（管理者向け）

> **業務フローでの位置**: 管理者がクラスタの状態を監視し、必要な管理操作を実行するステップです。

### 7.1 クラスタヘルス監視

**業務シーン**: クラスタの健全性を定期的に確認する場合

**操作手順**:

1. クラスタヘルスを確認します

```
GET /_cluster/health
```

2. インデックスレベルのヘルスを確認します

```
GET /_cluster/health?level=indices
```

3. シャードレベルのヘルスを確認します

```
GET /_cluster/health?level=shards
```

**関連画面**: クラスタヘルス（画面No.91）

### 7.2 クラスタ状態の確認

```
GET /_cluster/state
```

特定の情報のみ取得する場合：

```
GET /_cluster/state/metadata,routing_table
```

**関連画面**: クラスタ状態取得（画面No.92）

### 7.3 ノード管理

**ノード情報の確認：**

```
GET /_nodes
GET /_nodes/<ノードID>
```

**ノード統計の確認：**

```
GET /_nodes/stats
GET /_nodes/stats/jvm,os
```

**ホットスレッドの確認：**

```
GET /_nodes/hot_threads
```

**関連画面**: ノード情報取得（画面No.112）、ノード統計取得（画面No.113）、ホットスレッド取得（画面No.114）

### 7.4 シャード割り当て管理

**業務シーン**: シャードの配置を手動で調整する場合

**シャード割り当ての説明取得：**

```
GET /_cluster/allocation/explain
{
  "index": "my-index",
  "shard": 0,
  "primary": true
}
```

**シャードの手動再配置：**

```
POST /_cluster/reroute
{
  "commands": [
    {
      "move": {
        "index": "my-index",
        "shard": 0,
        "from_node": "node-1",
        "to_node": "node-2"
      }
    }
  ]
}
```

**関連画面**: シャード割り当て説明（画面No.96）、シャード再配置（画面No.97）

### 7.5 クラスタ設定の変更

**操作手順**:

```
PUT /_cluster/settings
{
  "persistent": {
    "cluster.routing.allocation.enable": "all"
  }
}
```

> **注意**: `persistent` は永続設定（再起動後も有効）、`transient` は一時設定（再起動でリセット）です。

**関連画面**: クラスタ設定取得（画面No.93）、クラスタ設定更新（画面No.94）

### 7.6 タスク管理

**業務シーン**: 長時間実行されているタスクの確認やキャンセルが必要な場合

**タスク一覧の取得：**

```
GET /_tasks
GET /_tasks?actions=*reindex*
```

**特定タスクの詳細取得：**

```
GET /_tasks/<タスクID>
```

**タスクのキャンセル：**

```
POST /_tasks/<タスクID>/_cancel
```

**関連画面**: タスク一覧取得（画面No.118）、タスク詳細取得（画面No.119）、タスクキャンセル（画面No.120）

### 7.7 インデックスの運用操作

**リフレッシュ**（検索可能にする）:

```
POST /<インデックス名>/_refresh
```

**フラッシュ**（メモリ上のデータをディスクに永続化）:

```
POST /<インデックス名>/_flush
```

**フォースマージ**（セグメントの統合によるパフォーマンス改善）:

```
POST /<インデックス名>/_forcemerge?max_num_segments=1
```

**キャッシュクリア**:

```
POST /<インデックス名>/_cache/clear
```

**関連画面**: リフレッシュ（画面No.75）、フラッシュ（画面No.76）、フォースマージ（画面No.78）、キャッシュクリア（画面No.79）

### 7.8 ノードのデコミッション

**業務シーン**: ノードを計画的にクラスタから除外する場合

```
PUT /_cluster/decommission/awareness/<awareness属性>/<属性値>
```

> **注意**: デコミッションは段階的にシャードを移動してからノードを除外するため、データの安全性が確保されます。

**関連画面**: ノードデコミッション（画面No.103）

---

## 8. スナップショット・バックアップ機能

### 8.1 スナップショットリポジトリの登録

**業務シーン**: バックアップの保存先を設定する場合

**操作手順**:

1. リポジトリを登録します

```
PUT /_snapshot/<リポジトリ名>
{
  "type": "fs",
  "settings": {
    "location": "/mnt/backups/opensearch"
  }
}
```

対応するリポジトリタイプ：
- `fs`（共有ファイルシステム）
- `s3`（Amazon S3）
- `gcs`（Google Cloud Storage）
- `azure`（Azure Blob Storage）
- `hdfs`（HDFS）

2. リポジトリを確認します

```
GET /_snapshot/<リポジトリ名>
```

**関連画面**: スナップショットリポジトリ登録（画面No.121）、スナップショットリポジトリ取得（画面No.122）

### 8.2 スナップショットの作成

**操作手順**:

```
PUT /_snapshot/<リポジトリ名>/<スナップショット名>
{
  "indices": "index-1,index-2",
  "ignore_unavailable": true,
  "include_global_state": false
}
```

> **Tips**: `wait_for_completion=true` パラメータを追加すると、スナップショット完了まで待機します。

**関連画面**: スナップショット作成（画面No.124）

### 8.3 スナップショットからのリストア

**業務シーン**: バックアップからデータを復元する場合

**操作手順**:

1. リストア対象のスナップショットを確認します

```
GET /_snapshot/<リポジトリ名>/<スナップショット名>
```

2. リストアを実行します

```
POST /_snapshot/<リポジトリ名>/<スナップショット名>/_restore
{
  "indices": "index-1",
  "rename_pattern": "(.+)",
  "rename_replacement": "restored_$1"
}
```

**関連画面**: スナップショットリストア（画面No.124）

> **注意**: リストア先に同名のインデックスが存在する場合はエラーになります。`rename_pattern` / `rename_replacement` で別名にリストアしてください。

### 8.4 スナップショットの管理

**一覧取得：**

```
GET /_snapshot/<リポジトリ名>/_all
```

**削除：**

```
DELETE /_snapshot/<リポジトリ名>/<スナップショット名>
```

**関連画面**: スナップショット取得（画面No.125）、スナップショット削除（画面No.126）

---

## 9. インジェストパイプライン機能

### 9.1 パイプラインとは

インジェストパイプラインは、ドキュメントがインデックスに格納される前に、データの変換・加工を行う仕組みです。

### 9.2 パイプラインの作成

**業務シーン**: ログデータからUser-Agent情報を自動的にパースする場合

**操作手順**:

```
PUT /_ingest/pipeline/my-pipeline
{
  "description": "User-Agent情報を解析するパイプライン",
  "processors": [
    {
      "user_agent": {
        "field": "user_agent_string"
      }
    },
    {
      "geoip": {
        "field": "client_ip"
      }
    }
  ]
}
```

**関連画面**: インジェストパイプライン登録・更新（画面No.133）

### 9.3 パイプラインのシミュレーション

**業務シーン**: パイプラインの動作を本番データに適用する前にテストする場合

```
POST /_ingest/pipeline/my-pipeline/_simulate
{
  "docs": [
    {
      "_source": {
        "user_agent_string": "Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
        "client_ip": "203.0.113.1"
      }
    }
  ]
}
```

**関連画面**: パイプラインシミュレーション（画面No.135）

### 9.4 パイプラインを使ったデータ投入

```
POST /my-index/_doc?pipeline=my-pipeline
{
  "user_agent_string": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7)",
  "client_ip": "198.51.100.1",
  "message": "アクセスログ"
}
```

---

## 10. スクリプト・テンプレート機能

### 10.1 Painlessスクリプト

**業務シーン**: カスタムスコアリングや複雑なフィールド計算を行う場合

**ストアドスクリプトの登録：**

```
PUT /_scripts/calculate_score
{
  "script": {
    "lang": "painless",
    "source": "doc['price'].value * params.factor"
  }
}
```

**スクリプトの使用：**

```
GET /my-index/_search
{
  "query": {
    "script_score": {
      "query": { "match_all": {} },
      "script": {
        "id": "calculate_score",
        "params": { "factor": 1.5 }
      }
    }
  }
}
```

**関連画面**: スクリプト登録・更新（画面No.140）、スクリプト取得（画面No.139）

### 10.2 検索テンプレート

**業務シーン**: よく使う検索クエリをテンプレートとして保存し、再利用する場合

**テンプレートの登録：**

```
PUT /_scripts/my-search-template
{
  "script": {
    "lang": "mustache",
    "source": {
      "query": {
        "match": {
          "{{field}}": "{{value}}"
        }
      }
    }
  }
}
```

**テンプレートを使った検索：**

```
GET /my-index/_search/template
{
  "id": "my-search-template",
  "params": {
    "field": "title",
    "value": "OpenSearch"
  }
}
```

**関連画面**: 検索テンプレート（画面No.28）

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】管理者がインデックスを設計・作成（データ格納先の準備） → 4章参照
    ↓
【STEP 2】データエンジニアがデータを投入・更新 → 5章参照
    ↓
【STEP 3】ユーザーがデータを検索・分析 → 6章参照
    ↓
【STEP 4】管理者がクラスタを監視・管理 → 7章参照
    ↓
【STEP 5】管理者がバックアップ・メンテナンスを実施 → 8章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【管理者】STEP1: インデックスの設計・作成

業務開始時に、データを格納するインデックスの設計・作成を行います。

1. 格納するデータの構造（フィールドとデータ型）を決定します
2. シャード数、レプリカ数を決定します
3. テンプレートが必要な場合は先にテンプレートを作成します（4.1参照）
4. インデックスを作成します（4.2参照）
5. 必要に応じてエイリアスを設定します（4.4参照）

### 11.2 【データエンジニア】STEP2: データの投入

インデックスが準備できたら、データの投入を行います。

1. データの前処理が必要な場合は、インジェストパイプラインを作成します（9章参照）
2. 少量データの場合は個別登録で投入します（5.2参照）
3. 大量データの場合はバルク操作で投入します（5.6参照）
4. データ投入後、`_refresh` を実行して検索可能にします（7.7参照）

### 11.3 【ユーザー】STEP3: データの検索・分析

データが投入されたら、検索・分析業務を行います。

1. 基本検索で必要なデータを探します（6.1参照）
2. アグリゲーションで集計・統計を取得します（6.5参照）
3. 大量の結果はスクロール検索またはPIT検索で取得します（6.3、6.4参照）
4. よく使う検索はテンプレートに保存します（10.2参照）

### 11.4 【管理者】STEP4-5: クラスタ監視とメンテナンス

日常的にクラスタの状態を監視し、必要に応じてメンテナンスを実施します。

1. クラスタヘルスを定期的に確認します（7.1参照）
   - ステータスが「green」であることを確認
   - 「yellow」や「red」の場合は原因を調査
2. ノード統計を確認し、リソース使用状況を把握します（7.3参照）
3. 定期的にスナップショットを作成します（8.2参照）
4. 必要に応じてフォースマージやキャッシュクリアを実施します（7.7参照）

---

## 12. よくある質問と対処法

### 12.1 接続に関するQ&A

**Q: OpenSearchに接続できません**

A: 以下を確認してください：
- ホスト名とポート番号（デフォルト: 9200）が正しいか
- OpenSearchプロセスが起動しているか
- ファイアウォールでポートがブロックされていないか
- Security Pluginが有効な場合、認証情報が正しいか
- HTTPS接続の場合、証明書の設定が正しいか

**Q: 認証エラー（401 Unauthorized）が返されます**

A: 以下を確認してください：
- ユーザー名とパスワードが正しいか
- Bearer Tokenが有効期限内か
- Security Pluginの設定が正しいか

### 12.2 インデックスに関するQ&A

**Q: インデックスが作成できません**

A: 以下を確認してください：
- インデックス名が小文字のみで構成されているか
- 禁止文字（`\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, スペース, `,`, `#`）が含まれていないか
- ディスク容量が十分にあるか（ウォーターマーク設定を確認）
- 必要な権限（`indices:admin/create`）を持っているか

**Q: マッピングの変更ができません**

A: 既存フィールドのデータ型変更はできません。以下のいずれかの方法で対応してください：
- 新しいフィールドを追加する（既存フィールドとは別名）
- 新しいインデックスを作成し、リインデックス（`_reindex` API）でデータを移行する

### 12.3 検索に関するQ&A

**Q: 検索結果が返ってきません**

A: 以下を確認してください：
- インデックスにデータが投入されているか（`GET /<インデックス名>/_count`で確認）
- データ投入後にリフレッシュ（`_refresh`）が完了しているか
- クエリのフィールド名が正しいか（マッピングと一致しているか）
- `text` 型フィールドと `keyword` 型フィールドの使い分けが正しいか

**Q: 検索が遅いです**

A: 以下を検討してください：
- `size` パラメータで取得件数を必要最小限にする
- `_source` フィールドのフィルタリングを使用する
- `filter` コンテキスト（スコア計算不要）を活用する
- 不要な `wildcard` クエリや `regexp` クエリを避ける
- シャード数が適切か見直す

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| `index_not_found_exception` | 指定したインデックスが存在しない | インデックス名を確認。`GET /_cat/indices?v` で存在するインデックスを確認 |
| `mapper_parsing_exception` | ドキュメントのフィールドがマッピングと一致しない | マッピング定義とドキュメントのデータ型を確認 |
| `cluster_block_exception` | インデックスがread-only状態になっている | ディスク容量を確認。`PUT /<インデックス名>/_settings {"index.blocks.read_only_allow_delete": null}` で解除 |
| `circuit_breaking_exception` | メモリ使用量がサーキットブレーカーの閾値を超えた | クエリの規模を小さくする。ノードのヒープサイズを確認 |
| `version_conflict_engine_exception` | ドキュメントの楽観的排他制御が競合した | `retry_on_conflict` パラメータを使用するか、`_seq_no` と `_primary_term` を指定して再試行 |
| `rejected_execution_exception` | スレッドプールのキューが満杯 | リクエスト数を減らすか、ノードを追加してスケールアウト |
| `search_phase_execution_exception` | 検索の実行中にエラーが発生 | クエリの構文を確認。`_validate/query?explain` でクエリを検証 |

### 13.2 よくあるトラブルと解決方法

**トラブル: クラスタステータスがyellowのまま**

原因: レプリカシャードが割り当てられていない
解決方法:
1. `GET /_cluster/allocation/explain` でどのシャードが未割り当てか確認
2. ノード数がレプリカ数+1以上あるか確認
3. ノードが1台のみの場合は、レプリカ数を0に設定

```
PUT /<インデックス名>/_settings
{
  "number_of_replicas": 0
}
```

**トラブル: ディスク容量不足でインデックスがread-onlyになった**

解決方法:
1. 不要なインデックスやスナップショットを削除してディスクを確保
2. read-only制限を解除

```
PUT /_all/_settings
{
  "index.blocks.read_only_allow_delete": null
}
```

3. ウォーターマーク設定を確認

```
GET /_cluster/settings?include_defaults=true&filter_path=*.cluster.routing.allocation.disk
```

**トラブル: バルクインデックスが途中で失敗する**

解決方法:
1. バッチサイズを小さくする（5,000〜10,000件 → 1,000件程度）
2. レスポンスの `errors` フィールドで失敗した項目を確認
3. ヒープメモリの使用量を確認（`GET /_nodes/stats/jvm`）

**トラブル: スナップショットの作成が失敗する**

解決方法:
1. リポジトリの設定が正しいか確認（`GET /_snapshot/<リポジトリ名>/_verify`）
2. リポジトリのストレージ容量が十分か確認
3. 他のスナップショット操作が同時実行されていないか確認

### 13.3 サポートへの連絡方法

OpenSearchのサポートやコミュニティリソース：

- **公式フォーラム**: OpenSearch Project Discussion Forum
- **GitHub Issues**: OpenSearch GitHubリポジトリ
- **Slack**: OpenSearch Community Slack
- **ドキュメント**: OpenSearch公式ドキュメント（https://opensearch.org/docs/）

問い合わせの際は、以下の情報を含めてください：
- OpenSearchのバージョン（`GET /` で確認可能）
- クラスタ構成（ノード数、シャード数）
- 発生しているエラーメッセージ
- 再現手順

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-03 | 初版作成 |

---

*本マニュアルは、OpenSearchのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、APIの仕様や操作方法が変更される場合があります。*
