---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 46
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：46 / 50、根拠なし：4
- 優先レビュー（高）
  1. **NFT-019（大量同時検索リクエスト処理）**：具体的な合格基準値（同時接続数・スループット閾値）がコードから特定不可
  2. **NFT-020（大量同時インデックスリクエスト処理）**：具体的な合格基準値（同時接続数・スループット閾値）がコードから特定不可
  3. **NFT-021（長時間連続稼働安定性確認）**：24時間という基準がコード上に明示されていない
  4. **NFT-003（バルクインデックス処理スループット）**：具体的なスループット合格基準がコードから特定不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/search/SearchService.java` - search.default_search_timeout設定定義
- E-02: `server/src/main/java/org/opensearch/index/SearchSlowLog.java` - 検索スローログ設定
- E-03: `server/src/main/java/org/opensearch/index/IndexingSlowLog.java` - インデキシングスローログ設定
- E-04: `server/src/main/java/org/opensearch/indices/breaker/HierarchyCircuitBreakerService.java` - サーキットブレーカー設定（TOTAL/FIELDDATA/REQUEST/IN_FLIGHT_REQUESTS）
- E-05: `distribution/src/config/jvm.options` - JVM設定（ヒープ・GC・ヒープダンプ・GCログ）
- E-06: `server/src/main/java/org/opensearch/http/HttpTransportSettings.java` - HTTP制限設定（max_content_length/max_header_size/max_initial_line_length）
- E-07: `server/src/main/java/org/opensearch/search/aggregations/MultiBucketConsumerService.java` - search.max_buckets設定
- E-08: `server/src/main/java/org/opensearch/common/settings/SettingsModule.java` - indices.query.bool.max_clause_count設定
- E-09: `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` - スレッドプール管理
- E-10: `server/src/main/java/org/opensearch/threadpool/FixedExecutorBuilder.java` - 固定サイズスレッドプール
- E-11: `server/src/main/java/org/opensearch/threadpool/ScalingExecutorBuilder.java` - スケーリングスレッドプール
- E-12: `server/src/main/java/org/opensearch/indices/ShardLimitValidator.java` - cluster.max_shards_per_node設定
- E-13: `server/src/main/java/org/opensearch/index/IndexSettings.java` - index.refresh_interval設定
- E-14: `server/src/main/java/org/opensearch/wlm/WorkloadManagementSettings.java` - ワークロード管理設定
- E-15: `server/src/main/java/org/opensearch/wlm/WorkloadGroupService.java` - ワークロードグループサービス
- E-16: `server/src/main/java/org/opensearch/wlm/cancellation/WorkloadGroupTaskCancellationService.java` - タスクキャンセルサービス
- E-17: `server/src/main/java/org/opensearch/cluster/health/ClusterHealthStatus.java` - クラスタヘルスステータス定義
- E-18: `server/src/main/java/org/opensearch/cluster/health/ClusterStateHealth.java` - クラスタ状態ヘルス
- E-19: `server/src/main/java/org/opensearch/snapshots/RestoreService.java` - スナップショットリストアサービス
- E-20: `distribution/src/config/opensearch.yml` - OpenSearch構成ファイル（remote_store/gateway/destructive_requires_name設定）
- E-21: `server/src/main/java/org/opensearch/bootstrap/Security.java` - セキュリティマネージャー設定
- E-22: `server/src/main/java/org/opensearch/bootstrap/OpenSearchPolicy.java` - セキュリティポリシー
- E-23: `server/src/main/java/org/opensearch/bootstrap/BootstrapChecks.java` - ブートストラップチェック
- E-24: `server/src/main/java/org/opensearch/bootstrap/OpenSearchUncaughtExceptionHandler.java` - 未キャッチ例外ハンドラ
- E-25: `distribution/docker/src/docker/Dockerfile` - Dockerビルド定義
- E-26: `distribution/bwc/` - 後方互換性テスト定義
- E-27: `distribution/archives/` - マルチプラットフォームアーカイブビルド定義
- E-28: `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` - ノード統計
- E-29: `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsIndices.java` - クラスタ統計
- E-30: `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheAction.java` - キャッシュクリアアクション
- E-31: `server/src/main/java/org/opensearch/action/admin/cluster/settings/TransportClusterUpdateSettingsAction.java` - クラスタ設定更新
- E-32: `distribution/tools/plugin-cli/` - プラグインCLIツール
- E-33: `server/src/main/java/org/opensearch/rest/RestController.java` - RESTコントローラ（インフライトリクエストブレーカー使用）
- E-34: `benchmarks/src/main/java/org/opensearch/benchmark/indices/breaker/MemoryStatsBenchmark.java` - メモリ統計ベンチマーク
- E-35: `benchmarks/src/main/java/org/opensearch/benchmark/routing/allocation/AllocationBenchmark.java` - アロケーションベンチマーク
- E-36: `server/src/main/java/org/opensearch/action/search/SearchRequestSlowLog.java` - 検索リクエストスローログ
- E-37: `server/src/main/java/org/opensearch/action/search/SearchType.java` - 検索タイプ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: 検索クエリレスポンス時間はsearch.default_search_timeout以内 | E-01 | ○ |
| C-02 | NFT-002: スローログ閾値超過でログが出力される | E-02, E-03 | ○ |
| C-03 | NFT-003: バルクインデックスのスループット合格基準 | E-03 | △ |
| C-04 | NFT-004: 総メモリサーキットブレーカーのデフォルト閾値はJVMヒープの95% | E-04 | ○ |
| C-05 | NFT-005: フィールドデータブレーカーのデフォルト閾値はJVMヒープの40% | E-04 | ○ |
| C-06 | NFT-006: リクエストブレーカーのデフォルト閾値はJVMヒープの60% | E-04 | ○ |
| C-07 | NFT-007: インフライトリクエストブレーカーのデフォルト閾値はJVMヒープの100% | E-04, E-33 | ○ |
| C-08 | NFT-008: JVMヒープのXmsとXmxは同一値に設定すべき | E-05 | ○ |
| C-09 | NFT-009: G1GCのG1ReservePercent=25、InitiatingHeapOccupancyPercent=30 | E-05 | ○ |
| C-10 | NFT-010: HeapDumpOnOutOfMemoryErrorでヒープダンプが生成される | E-05 | ○ |
| C-11 | NFT-011: http.max_content_lengthのデフォルトは100MB | E-06 | ○ |
| C-12 | NFT-012: search.max_bucketsのデフォルトは65535 | E-07 | ○ |
| C-13 | NFT-013: indices.query.bool.max_clause_count制限 | E-08 | ○ |
| C-14 | NFT-014: スレッドプール飽和時にEsRejectedExecutionException | E-09, E-10 | ○ |
| C-15 | NFT-015: スケーリングスレッドプールのmin/max範囲制御 | E-11 | ○ |
| C-16 | NFT-016: cluster.max_shards_per_nodeによるシャード数制限 | E-12 | ○ |
| C-17 | NFT-017: index.refresh_intervalによるドキュメント可視性制御 | E-13 | ○ |
| C-18 | NFT-018: ワークロードグループによるリソース超過タスクキャンセル | E-14, E-15, E-16 | ○ |
| C-19 | NFT-019: 大量同時検索リクエストの安定処理 | **根拠なし** | △ |
| C-20 | NFT-020: 大量同時インデックスリクエストの安定処理 | **根拠なし** | △ |
| C-21 | NFT-021: 24時間以上の長時間稼働安定性 | **根拠なし** | △ |
| C-22 | NFT-022: クラスタヘルスステータスがgreen/yellow/redで表現される | E-17, E-18 | ○ |
| C-23 | NFT-023: レプリカシャードによるノード障害時のフェイルオーバー | E-18 | ○ |
| C-24 | NFT-024: クラスタマネージャー障害時の再選出 | E-23 | ○ |
| C-25 | NFT-025: スナップショット作成・リストアによるデータ保護 | E-19 | ○ |
| C-26 | NFT-026: リモートストア機能でのデータ永続性 | E-20 | ○ |
| C-27 | NFT-027: インデックスリカバリの性能 | E-01 | ○ |
| C-28 | NFT-028: gateway.recover_after_data_nodesによるリカバリ制御 | E-20 | ○ |
| C-29 | NFT-029: セキュリティマネージャーポリシーによるアクセス制御 | E-21, E-22 | ○ |
| C-30 | NFT-030: ブートストラップチェックの本番モード強制実行 | E-23 | ○ |
| C-31 | NFT-031: destructive_requires_nameによる破壊的操作制限 | E-20 | ○ |
| C-32 | NFT-032: http.max_header_sizeによるヘッダーサイズ制限 | E-06 | ○ |
| C-33 | NFT-033: http.max_initial_line_lengthによるURL長制限 | E-06 | ○ |
| C-34 | NFT-034: Dockerコンテナでの非rootユーザー実行 | E-25 | ○ |
| C-35 | NFT-035: 未キャッチ例外のハンドリング | E-24 | ○ |
| C-36 | NFT-036: BWCバージョン互換性 | E-26 | ○ |
| C-37 | NFT-037: マルチアーキテクチャ対応（x86_64/aarch64/ppc64le/s390x/riscv64） | E-27 | ○ |
| C-38 | NFT-038: マルチOS対応（Linux/Darwin/FreeBSD/Windows） | E-27 | ○ |
| C-39 | NFT-039: JVMバージョン互換性 | E-05, E-23 | ○ |
| C-40 | NFT-040: SearchTypeの後方互換性 | E-37 | ○ |
| C-41 | NFT-041: ノード統計APIの応答内容 | E-28 | ○ |
| C-42 | NFT-042: クラスタ統計APIの応答内容 | E-29 | ○ |
| C-43 | NFT-043: GCログのファイルローテーション設定 | E-05 | ○ |
| C-44 | NFT-044: 検索スローログの出力 | E-02, E-36 | ○ |
| C-45 | NFT-045: インデキシングスローログの出力 | E-03 | ○ |
| C-46 | NFT-046: プラグインCLIによるインストール・アンインストール | E-32 | ○ |
| C-47 | NFT-047: 動的クラスタ設定変更の即時反映 | E-31 | ○ |
| C-48 | NFT-048: キャッシュクリアAPIの動作 | E-30 | ○ |
| C-49 | NFT-049: メモリ統計ベンチマークの存在 | E-34 | ○ |
| C-50 | NFT-050: シャードアロケーションベンチマークの存在 | E-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- NFT-003（バルクインデックス処理スループット）：具体的なスループット合格基準値がコード上に定義されていない。スローログ閾値を代替基準とした
  - 候補：性能テスト計画書 / SLA定義書 / 運用基準書
- NFT-019/NFT-020（大量同時リクエスト処理）：具体的な同時接続数やスループット閾値がコードから特定できない。テスト環境のスペックに依存する
  - 候補：負荷テスト計画書 / インフラスペック定義 / SLA定義書
- NFT-021（長時間連続稼働安定性）：24時間という基準値はコード上に存在しない。一般的な非機能要件テストのベストプラクティスから設定した
  - 候補：運用要件定義書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの設定値・クラス定義から直接導出されており信頼性が高い
- 1: 中リスク - 負荷テスト・ストレステスト（NFT-019〜021）は具体的な合格基準値がコードから導出できないため、実運用環境に応じた基準値の定義が必要
- 1: 中リスク - セキュリティプラグイン（OpenSearch Security Plugin）に関するテストケースが含まれていない。本プロジェクトではセキュリティプラグインが別リポジトリで管理されている可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] サーキットブレーカーのデフォルト閾値（95%/40%/60%/100%）がHierarchyCircuitBreakerService.javaの実装と一致しているか
- [ ] 負荷テスト・ストレステスト（NFT-019〜021）の合格基準値が運用要件・SLAに基づいて適切に設定されているか
- [ ] セキュリティプラグイン（認証・認可・TLS等）に関するテストケースが別途管理されているか確認
- [ ] JVMバージョン互換性テスト（NFT-039）で対象JDKバージョンが最新のサポート状況と一致しているか
- [ ] マルチプラットフォーム対応テスト（NFT-037/038）で対象アーキテクチャ・OSが実際のビルド定義と一致しているか
- [ ] ワークロード管理テスト（NFT-018）のリソース制限パラメータが実装と整合しているか
