---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 68
  claims_with_evidence: 59
  claims_without_evidence: 9
confidence_derived: 0.87
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：59 / 68、根拠なし：9
- 優先レビュー（高）
  1. **ディスクウォーターマーク具体値**：デフォルト値のコード内定義箇所が未確認
  2. **HTTP最大コンテンツ長・ヘッダサイズの具体値**：設定キーは存在するがデフォルト値未確認
  3. **リモートストアの実験的機能ステータス**：GA移行状況の確認が必要
  4. **アダプティブレプリカ選択のデフォルト状態**：有効/無効のデフォルト値未確認
  5. **デフォルトレプリカ数の具体値**：設定の存在は確認済みだが具体値未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/search/SearchService.java` — 検索タイムアウト・Keep-Alive設定
- E-02: `server/src/main/java/org/opensearch/indices/IndicesQueryCache.java` — クエリキャッシュ設定
- E-03: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` — リクエストキャッシュ設定
- E-04: `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` — スレッドプール設定
- E-05: `server/src/main/java/org/opensearch/indices/breaker/HierarchyCircuitBreakerService.java` — サーキットブレーカー設定
- E-06: `server/src/main/java/org/opensearch/indices/recovery/RecoverySettings.java` — リカバリ設定
- E-07: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/AdmissionControlSettings.java` — アドミッションコントロール設定
- E-08: `server/src/main/java/org/opensearch/gateway/GatewayService.java` — ゲートウェイリカバリ設定
- E-09: `server/src/main/java/org/opensearch/transport/TransportSettings.java` — トランスポート設定
- E-10: `server/src/main/java/org/opensearch/cluster/routing/allocation/DiskThresholdSettings.java` — ディスク閾値設定
- E-11: `distribution/src/config/log4j2.properties` — ログ設定
- E-12: `distribution/src/config/jvm.options` — JVM設定
- E-13: `distribution/src/config/opensearch.yml` — OpenSearch設定ファイル
- E-14: `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheDiskCacheSettings.java` — Ehcacheディスクキャッシュ設定
- E-15: `server/src/main/java/org/opensearch/common/settings/ClusterSettings.java` — クラスタ設定一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 検索デフォルトタイムアウトは-1ms（タイムアウトなし） | E-01 | ○ |
| C-02 | デフォルトKeep-Aliveは5分 | E-01 | ○ |
| C-03 | 最大Keep-Aliveは24時間 | E-01 | ○ |
| C-04 | 最大PIT Keep-Aliveは24時間 | E-01 | ○ |
| C-05 | リカバリ内部アクションタイムアウトは15分 | E-06 | ○ |
| C-06 | リカバリリトライタイムアウトは1分 | E-06 | ○ |
| C-07 | セグメントレプリケーションタイムアウトは15分 | E-06 | ○ |
| C-08 | WRITEスレッドプールはallocatedProcessorsスレッド、キュー10,000 | E-04 | ○ |
| C-09 | SEARCHスレッドプールはリサイザブル型、キュー1,000 | E-04 | ○ |
| C-10 | GETスレッドプールはallocatedProcessorsスレッド、キュー1,000 | E-04 | ○ |
| C-11 | GENERICスレッドプールは4〜512スレッド、keepalive 30秒 | E-04 | ○ |
| C-12 | TRANSLOG_SYNCスレッドプールはallocatedProcessors*4、キュー10,000 | E-04 | ○ |
| C-13 | REMOTE_STATE_READスレッドプールは4*allocatedProcessors（4〜32）、キュー120,000 | E-04 | ○ |
| C-14 | リカバリ帯域は40MB/秒 | E-06 | ○ |
| C-15 | 並行リカバリファイルチャンクは2（範囲1〜5） | E-06 | ○ |
| C-16 | 並行リカバリオペレーションは1（範囲1〜4） | E-06 | ○ |
| C-17 | タイマー推定間隔は200ms | E-04 | ○ |
| C-18 | 低レベルキャンセルはデフォルト有効 | E-15 | ○ |
| C-19 | 高コストクエリ許可はデフォルト有効 | E-15 | ○ |
| C-20 | サーキットブレーカー合計はヒープ95%（実メモリ使用時）/70% | E-05 | ○ |
| C-21 | フィールドデータサーキットブレーカーはヒープ40% | E-05 | ○ |
| C-22 | リクエストサーキットブレーカーはヒープ60% | E-05 | ○ |
| C-23 | フィールドデータオーバーヘッド係数は1.03 | E-05 | ○ |
| C-24 | リクエストオーバーヘッド係数は1.0 | E-05 | ○ |
| C-25 | ディスク低水位の設定キーが存在 | E-10 | ○ |
| C-26 | ディスク低水位の具体的なデフォルト値 | **根拠なし** | △ |
| C-27 | ディスク高水位の具体的なデフォルト値 | **根拠なし** | △ |
| C-28 | ディスクフラッドステージの具体的なデフォルト値 | **根拠なし** | △ |
| C-29 | 状態同期リトライ遅延は500ms | E-06 | ○ |
| C-30 | ネットワークリトライ遅延は5秒 | E-06 | ○ |
| C-31 | SSL/TLSデュアルモード設定の存在 | E-15 | ○ |
| C-32 | ホスト名検証設定の存在 | E-15 | ○ |
| C-33 | CORSデフォルト無効 | E-15 | ○ |
| C-34 | CORS最大キャッシュ時間1,728,000秒 | E-15 | ○ |
| C-35 | HTTP最大コンテンツ長の具体的なデフォルト値 | **根拠なし** | △ |
| C-36 | HTTP最大ヘッダサイズの具体的なデフォルト値 | **根拠なし** | △ |
| C-37 | TCP Keep Alive設定の存在 | E-09 | ○ |
| C-38 | TCP No Delay設定の存在 | E-09 | ○ |
| C-39 | ノードあたり最大シャード数設定の存在 | E-15 | ○ |
| C-40 | アウェアネス属性による配置制御の存在 | E-15 | ○ |
| C-41 | 負荷分散設定の存在 | E-15 | ○ |
| C-42 | リモートクラスタ接続設定の存在 | E-15 | ○ |
| C-43 | クエリキャッシュはヒープの10% | E-02 | ○ |
| C-44 | クエリキャッシュのエントリ数上限10,000 | E-02 | ○ |
| C-45 | クエリキャッシュの最小頻度2回 | E-02 | ○ |
| C-46 | 高コストクエリのキャッシュ最小頻度4回 | E-02 | ○ |
| C-47 | リクエストキャッシュはヒープの1% | E-03 | ○ |
| C-48 | リクエストキャッシュのデフォルト有効期限は無期限 | E-03 | ○ |
| C-49 | Ehcacheディスクキャッシュデフォルト1GB | E-14 | ○ |
| C-50 | Ehcacheセグメント数16 | E-14 | ○ |
| C-51 | Ehcache並行性1〜3 | E-14 | ○ |
| C-52 | アドミッションコントロールデフォルトdisabled | E-07 | ○ |
| C-53 | アドミッションコントロールの3段階モード | E-07 | ○ |
| C-54 | サーバーログ最大128MB | E-11 | ○ |
| C-55 | サーバーログ累積2GB制限 | E-11 | ○ |
| C-56 | デプリケーションログ最大1GB、4ファイル | E-11 | ○ |
| C-57 | レートリミッティングフィルタの存在 | E-11 | ○ |
| C-58 | スローログ最大1GB | E-11 | ○ |
| C-59 | GCログ最大64MB、32ファイル | E-12 | ○ |
| C-60 | ログフォーマットの記述 | E-11 | ○ |
| C-61 | ファイル権限rw-r----- | E-11 | ○ |
| C-62 | G1GCの使用 | E-12 | ○ |
| C-63 | G1ReservePercent=25 | E-12 | ○ |
| C-64 | InitiatingHeapOccupancyPercent=30 | E-12 | ○ |
| C-65 | HeapDumpOnOutOfMemoryError有効 | E-12 | ○ |
| C-66 | アダプティブレプリカ選択のデフォルト状態 | **根拠なし** | △ |
| C-67 | デフォルトレプリカ数の具体値 | **根拠なし** | △ |
| C-68 | リモートストアが実験的機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ディスクウォーターマーク（C-26, C-27, C-28）の具体的なデフォルト値は `DiskThresholdSettings.java` 内で定義されているが、本解析では設定キーの存在のみ確認。実際の値（例: low=85%, high=90%, flood_stage=95%）はソースコードの詳細確認が必要。
  - 候補：`DiskThresholdSettings.java` の定数定義 / OpenSearch公式ドキュメント / テストコード
- HTTP最大コンテンツ長・ヘッダサイズ（C-35, C-36）の具体値はHttpTransportSettings等の別ファイルで定義されている可能性がある。
  - 候補：`HttpTransportSettings.java` / `Netty4HttpServerTransport.java` / 公式ドキュメント
- アダプティブレプリカ選択（C-66）のデフォルト有効/無効状態の確認が必要。
  - 候補：`TransportSearchAction.java` / `OperationRouting.java`
- デフォルトレプリカ数（C-67）の具体値（通常は1）の確認が必要。
  - 候補：`IndexMetadata.java` / `IndexSettings.java`
- リモートストアの実験的機能ステータス（C-68）は、バージョンによりGA移行している可能性がある。
  - 候補：リリースノート / CHANGELOG.md / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク — 性能要件のスレッドプール設定値（ソースコードに明確な定義あり）
- 0: 低リスク — キャッシュ設定値（ソースコードにデフォルト値が明記）
- 0: 低リスク — ログ設定（log4j2.propertiesに明記）
- 1: 中リスク — ディスクウォーターマークの具体値未確認（C-26, C-27, C-28）
- 1: 中リスク — HTTP制限値の具体値未確認（C-35, C-36）
- 1: 中リスク — リモートストアの実験的/GA状態の確認不足（C-68）
- 0: 低リスク — セキュリティプラグインによる認証・認可は本書のスコープ外として明示済み

## 6) レビュアーチェックリスト（最小）
- [ ] ディスクウォーターマーク（low/high/flood_stage）の具体的なデフォルト値を `DiskThresholdSettings.java` で確認
- [ ] HTTP最大コンテンツ長・ヘッダサイズのデフォルト値を確認
- [ ] アダプティブレプリカ選択のデフォルト有効/無効状態を確認
- [ ] デフォルトレプリカ数の具体値を確認
- [ ] リモートストア機能の現在のステータス（Experimental / GA）を確認
- [ ] セキュリティプラグインの非機能要件が別途文書化されていることを確認
- [ ] 運用環境のワークロードに合わせたタイムアウト・スレッドプール値の妥当性を確認
