# 非機能要件定義書

## 概要

本ドキュメントは、OpenSearch プロジェクトのソースコードから抽出した非機能要件を定義する。OpenSearch は Apache Lucene ベースの分散型検索・分析エンジンであり、高可用性・高スループット・水平スケーラビリティを備えた設計となっている。本書では、性能、可用性、セキュリティ、拡張性、保守性、運用・監視の各観点から非機能要件を整理する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 検索リクエスト（デフォルト） | タイムアウトなし（`search.default_search_timeout` = -1ms） | 動的変更可能（Dynamic, NodeScope）。運用環境では明示的なタイムアウト設定を推奨 |
| スクロールコンテキスト維持 | 5分（`search.default_keep_alive`） | 最大24時間（`search.max_keep_alive`）まで延長可能 |
| PIT (Point in Time) 維持 | 最大24時間（`point_in_time.max_keep_alive`） | 動的変更可能 |
| リカバリ内部アクション | 15分以内（`indices.recovery.internal_action_timeout`） | 長時間アクションは2倍の30分 |
| リカバリリトライ | 1分（`indices.recovery.internal_action_retry_timeout`） | 動的変更可能 |
| セグメントレプリケーション | 15分（`indices.replication.merges.warmer.timeout`） | 動的変更可能 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| WRITE スレッドプール | allocatedProcessors スレッド、キュー 10,000 | 書き込みスループットの上限を規定 |
| SEARCH スレッドプール | searchThreadPoolSize スレッド、キュー 1,000 | リサイザブル型。検索スループットの上限を規定 |
| GET スレッドプール | allocatedProcessors スレッド、キュー 1,000 | 取得操作のスループット |
| GENERIC スレッドプール | 4〜512 スレッド（スケーリング型）、keepalive 30秒 | 汎用処理用 |
| TRANSLOG_SYNC スレッドプール | allocatedProcessors * 4 スレッド、キュー 10,000 | トランザクションログ同期用 |
| SYSTEM_READ スレッドプール | halfProcMaxAt5 スレッド、キュー 2,000 | システム読み取り用 |
| SYSTEM_WRITE スレッドプール | halfProcMaxAt5 スレッド、キュー 1,000 | システム書き込み用 |
| REMOTE_STATE_READ スレッドプール | 4*allocatedProcessors（4〜32）、キュー 120,000 | リモート状態読み取り用 |
| リカバリ帯域 | 40MB/秒（`indices.recovery.max_bytes_per_sec`） | 動的変更可能 |
| 並行リカバリファイルチャンク | 2（範囲: 1〜5） | `indices.recovery.max_concurrent_file_chunks` |
| 並行リカバリオペレーション | 1（範囲: 1〜4） | `indices.recovery.max_concurrent_operations` |
| タイマー推定間隔 | 200ms（`thread_pool.estimated_time_interval`） | スレッドプールの時間推定精度 |

### 検索性能

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 低レベルキャンセル | 有効（`search.low_level_cancellation` = true） | タイムアウト時のリソース解放 |
| 高コストクエリ許可 | 有効（`search.allow_expensive_queries` = true） | 動的に無効化可能 |
| 並行セグメント検索 | 設定可能（`CONCURRENT_SEGMENT_SEARCH_MODE`） | スライス数・パーティション戦略を制御 |
| インデックスサーチャースレッドプール | 2*allocatedProcessors スレッド、キュー 1,000 | リサイザブル型 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| クラスタ復旧条件 | `gateway.expected_data_nodes` で期待ノード数を指定 | `gateway.recover_after_data_nodes` で最低ノード数指定可能 |
| 復旧待機時間 | `gateway.recover_after_time` で設定 | 正の時間値で指定 |
| サーキットブレーカー（合計） | ヒープの95%（実メモリ使用時）/ 70%（非実メモリ使用時） | `indices.breaker.total.limit`。動的変更可能 |
| フィールドデータサーキットブレーカー | ヒープの40% | `indices.breaker.fielddata.limit`。オーバーヘッド係数 1.03 |
| リクエストサーキットブレーカー | ヒープの60% | `indices.breaker.request.limit`。オーバーヘッド係数 1.0 |
| ディスク低水位 | `cluster.routing.allocation.disk.watermark.low` | シャード割り当て抑制開始閾値 |
| ディスク高水位 | `cluster.routing.allocation.disk.watermark.high` | シャード再配置開始閾値 |
| ディスクフラッドステージ | `cluster.routing.allocation.disk.watermark.flood_stage` | インデックス書き込みブロック閾値 |
| リーダーチェック | タイムアウト＋リトライ回数設定可能 | `LEADER_CHECK_TIMEOUT_SETTING`, `LEADER_CHECK_RETRY_COUNT_SETTING` |
| フォロワーチェック | タイムアウト＋リトライ回数設定可能 | `FOLLOWER_CHECK_TIMEOUT_SETTING`, `FOLLOWER_CHECK_RETRY_COUNT_SETTING` |
| リモートストア | セグメント・トランスログのリモート保存対応 | `cluster.remote_store.enabled` で有効化 |
| リモートクラスタ状態 | リモートクラスタ状態の永続化対応 | `REMOTE_CLUSTER_STATE_ENABLED_SETTING` |
| アダプティブレプリカ選択 | 設定可能（`USE_ADAPTIVE_REPLICA_SELECTION_SETTING`） | 負荷に応じた最適レプリカ選択 |

### リカバリ設定

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| 状態同期リトライ遅延 | 500ms | `indices.recovery.retry_delay_state_sync` |
| ネットワークリトライ遅延 | 5秒 | `indices.recovery.retry_delay_network` |
| レプリケーション初期リトライバックオフ | 設定可能 | `REPLICATION_INITIAL_RETRY_BACKOFF_BOUND` |
| レプリケーションリトライタイムアウト | 設定可能 | `REPLICATION_RETRY_TIMEOUT` |

## セキュリティ要件

### トランスポート層セキュリティ

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| SSL/TLS デュアルモード | `transport.ssl.dual_mode.enabled` | 暗号化・非暗号化の共存を許可 |
| ホスト名検証 | `transport.ssl.enforce_hostname_verification` | SSL証明書のホスト名検証を強制 |
| ホスト名解決検証 | `transport.ssl.enforce_hostname_verification_resolve_host_name` | ホスト名の正引きによる検証 |
| サーバーサイド暗号化 | `CLUSTER_SERVER_SIDE_ENCRYPTION_ENABLED` | リモートストアのサーバーサイド暗号化 |

### HTTP セキュリティ

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| CORS | 無効（`http.cors.enabled` = false） | クロスオリジンリクエストの制御 |
| CORS最大キャッシュ時間 | 1,728,000秒（20日） | `http.cors.max-age` |
| 詳細エラー表示 | `http.detailed_errors.enabled` | 本番環境では無効化を推奨 |
| コンテンツタイプ必須 | `http.content_type.required` | リクエストのContent-Typeヘッダ検証 |
| 最大コンテンツ長 | `http.max_content_length` | リクエストボディの最大サイズ制限 |
| 最大ヘッダサイズ | `http.max_header_size` | HTTPヘッダの最大サイズ制限 |
| 最大初期行長 | `http.max_initial_line_length` | HTTPリクエスト行の最大長制限 |

### ネットワークセキュリティ

| 項目 | 設定キー | 備考 |
| --- | --- | --- |
| TCP Keep Alive | `transport.tcp.keep_alive` | コネクション生存確認 |
| TCP Keep Idle | `transport.tcp.keep_idle` | アイドル時間 |
| TCP Keep Interval | `transport.tcp.keep_interval` | Keep-Alive間隔 |
| TCP Keep Count | `transport.tcp.keep_count` | Keep-Alive試行回数 |
| TCP No Delay | `transport.tcp.no_delay` | Nagleアルゴリズム無効化 |
| TCP アドレス再利用 | `transport.tcp.reuse_address` | アドレスの再利用 |
| 破壊的操作の名前必須 | `action.destructive_requires_name` | インデックス削除等で明示的な名前指定を要求 |

## 拡張性要件

### クラスタスケーリング

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| ノードあたり最大シャード数 | `cluster.max_shards_per_node` | クラスタ全体のシャード上限も設定可能 |
| クラスタ最大シャード数 | `SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER` | クラスタ全体の制限 |
| リモート対応ノードの最大シャード数 | `SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE` | リモートストア対応ノードの制限 |
| ノード別合計シャード数 | `CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING` | ノードレベルの制限 |
| ノード別プライマリシャード数 | `CLUSTER_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING` | プライマリシャードの分散制御 |
| デフォルトレプリカ数 | `DEFAULT_REPLICA_COUNT_SETTING` | インデックスのデフォルトレプリカ数 |

### シャード分散

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| インデックスバランス係数 | `INDEX_BALANCE_FACTOR_SETTING` | インデックス間のバランス制御 |
| シャードバランス係数 | `SHARD_BALANCE_FACTOR_SETTING` | シャード間のバランス制御 |
| プライマリシャード優先バランス | `PREFER_PRIMARY_SHARD_BALANCE` | プライマリシャードの分散優先 |
| シャード移動戦略 | `SHARD_MOVEMENT_STRATEGY_SETTING` | シャード移動の戦略設定 |
| 同一ホスト配置制限 | `CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING` | 同一ホストへの配置制御 |
| アウェアネス属性 | `cluster.routing.allocation.awareness.attribute` | ラック/ゾーンを考慮した配置 |
| 強制アウェアネス | `CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING` | 強制的なゾーン分散 |

### 負荷分散

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| プロビジョニング容量 | `CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING` | プロビジョニング済み容量 |
| スキュー係数 | `CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING` | 負荷偏りの許容係数 |
| フラットスキュー | `CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING` | フラットスキュー設定 |
| 並行リバランス数 | `CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING` | クラスタ全体の並行リバランス数 |

### リモートクラスタ

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| リモートクラスタ有効化 | `ENABLE_REMOTE_CLUSTERS` | クロスクラスタ検索の有効化 |
| クラスタ間接続数 | `REMOTE_CONNECTIONS_PER_CLUSTER` | リモートクラスタあたりの接続数 |
| 未到達クラスタのスキップ | `REMOTE_CLUSTER_SKIP_UNAVAILABLE` | 未到達リモートクラスタのスキップ |
| 接続モード | `REMOTE_CONNECTION_MODE` | 接続モード（sniff/proxy） |
| Ping スケジュール | `REMOTE_CLUSTER_PING_SCHEDULE` | ヘルスチェック間隔 |
| 圧縮 | `REMOTE_CLUSTER_COMPRESS` | リモートクラスタ間通信の圧縮 |

## 保守性要件

### キャッシュ管理

| キャッシュ種別 | サイズ設定 | 有効期限 | 備考 |
| --- | --- | --- | --- |
| クエリキャッシュ | ヒープの10%（`indices.cache.query.size`） | エントリ数上限 10,000 | 最小頻度2回で キャッシュ、高コストクエリは4回 |
| リクエストキャッシュ | ヒープの1%（`indices.requests.cache.size`） | 無期限（デフォルト） | `index.requests.cache.enable` で有効/無効切替可能 |
| フィールドデータキャッシュ | `indices.fielddata.cache.size` で設定 | 設定可能 | ヒープ圧迫の主要因 |
| スクリプトキャッシュ | `script.cache.size` / `script.general.cache.size` | `script.cache.expire` で設定可能 | コンパイル済みスクリプトのキャッシュ |
| Ehcache ディスクキャッシュ | デフォルト1GB | アクセス後有効期限設定可能 | セグメント数16、並行性1〜3 |
| ファイルキャッシュ | `node.file_cache.size_ratio` で設定 | アクティブ使用率閾値あり | 検索・インデキシング別閾値 |
| ページキャッシュリサイクラー | ヒープ制限設定可能 | タイプ設定可能 | bytes/int/long/objectsの重み設定 |

### インデキシング圧力管理

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| シャードインデキシング圧力 | `SHARD_INDEXING_PRESSURE_ENABLED` | シャードレベルの圧力監視 |
| 強制モード | `SHARD_INDEXING_PRESSURE_ENFORCED` | 圧力制限の強制適用 |
| ノードソフトリミット | `NODE_SOFT_LIMIT` | ノードレベルのソフト制限 |
| スループット劣化制限 | `THROUGHPUT_DEGRADATION_LIMITS` | スループット劣化の閾値 |
| 最大未処理リクエスト | `MAX_OUTSTANDING_REQUESTS` | 未処理リクエストの上限 |

### マージ設定

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| 最大マージスレッド数 | `CLUSTER_MAX_THREAD_COUNT_SETTING` | クラスタレベルのマージスレッド制限 |
| 最大マージ数 | `CLUSTER_MAX_MERGE_COUNT_SETTING` | 同時マージの上限 |
| 自動スロットル | `CLUSTER_AUTO_THROTTLE_SETTING` | マージI/Oの自動スロットリング |
| 強制マージ速度 | `CLUSTER_MAX_FORCE_MERGE_MB_PER_SEC_SETTING` | 強制マージのMB/秒制限 |

### アドミッションコントロール

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| トランスポート層モード | disabled | disabled / monitor / enforced の3段階 |
| CPU使用率制限（インデキシング） | `INDEXING_CPU_USAGE_LIMIT` | CPU使用率によるインデキシング制御 |
| CPU使用率制限（検索） | `SEARCH_CPU_USAGE_LIMIT` | CPU使用率による検索制御 |
| CPU使用率制限（クラスタ管理） | `CLUSTER_ADMIN_CPU_USAGE_LIMIT` | CPU使用率によるクラスタ管理制御 |
| I/O使用率制限（検索） | `SEARCH_IO_USAGE_LIMIT` | I/O使用率による検索制御 |
| I/O使用率制限（インデキシング） | `INDEXING_IO_USAGE_LIMIT` | I/O使用率によるインデキシング制御 |

## 運用・監視要件

### ログ設定

| ログ種別 | ファイルサイズ | ローテーション | 備考 |
| --- | --- | --- | --- |
| サーバーログ | 最大128MB | 累積2GBで削除 | JSON形式。ファイル権限: rw-r----- |
| デプリケーションログ | 最大1GB | 最大4ファイル | レートリミッティングフィルタ付き |
| 検索リクエストスローログ | 最大1GB | 最大4ファイル | WARN/INFO/DEBUG/TRACE閾値設定可能 |
| インデックス検索スローログ | 最大1GB | 設定可能 | `index.search.slowlog` で制御 |
| インデキシングスローログ | 最大1GB | 設定可能 | `index.indexing.slowlog.index` で制御 |
| タスク詳細ログ | 最大1GB | 設定可能 | `task.detailslog` で制御 |
| GCログ | 最大64MB | 最大32ファイル | JVMオプションで設定 |

### ログフォーマット

- サーバーログ: `[%d{ISO8601}][%-5p][%-25c{1.}] [%node_name]%marker %m%n`
- JSON形式の構造化ログを標準採用
- ノード名がログエントリに含まれる

### 監視設定

| 監視項目 | 設定 | 備考 |
| --- | --- | --- |
| OS情報リフレッシュ | `OsService.REFRESH_INTERVAL_SETTING` | OS統計情報の更新間隔 |
| プロセス情報リフレッシュ | `ProcessService.REFRESH_INTERVAL_SETTING` | プロセス統計情報の更新間隔 |
| JVM情報リフレッシュ | `JvmService.REFRESH_INTERVAL_SETTING` | JVM統計情報の更新間隔 |
| ファイルシステム情報リフレッシュ | `FsService.REFRESH_INTERVAL_SETTING` | ファイルシステム統計情報の更新間隔 |
| ファイルシステムヘルス | `FsHealthService.ENABLED_SETTING` | ファイルシステムの健全性監視 |
| 低速パスログ閾値 | `FsHealthService.SLOW_PATH_LOGGING_THRESHOLD_SETTING` | 遅いディスクアクセスの検出 |

### JVM / GC 監視

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| GC監視 | `JvmGcMonitorService.ENABLED_SETTING` | GC監視の有効/無効 |
| GC監視リフレッシュ間隔 | `JvmGcMonitorService.REFRESH_INTERVAL_SETTING` | GC統計情報の更新間隔 |
| GCオーバーヘッド警告 | `JvmGcMonitorService.GC_OVERHEAD_WARN_SETTING` | GCオーバーヘッドの警告閾値 |
| GCオーバーヘッド情報 | `JvmGcMonitorService.GC_OVERHEAD_INFO_SETTING` | GCオーバーヘッドの情報閾値 |
| GCオーバーヘッドデバッグ | `JvmGcMonitorService.GC_OVERHEAD_DEBUG_SETTING` | GCオーバーヘッドのデバッグ閾値 |
| ヒープダンプ | `-XX:+HeapDumpOnOutOfMemoryError` | OOMエラー時の自動ヒープダンプ |

### タスク監視

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| タスクキャンセル監視 | `TaskCancellationMonitoringSettings.IS_ENABLED_SETTING` | タスクキャンセルの監視 |
| タスクリソーストラッキング | `TASK_RESOURCE_TRACKING_ENABLED` | タスクリソース使用量の追跡 |
| トップクエリログサイズ | `LOG_TOP_QUERIES_SIZE_SETTING` | ログに記録するトップクエリ数 |
| トップクエリログ頻度 | `LOG_TOP_QUERIES_FREQUENCY_SETTING` | トップクエリ記録の頻度 |

### リソース使用率監視

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| CPU使用率監視ウィンドウ | `GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING` | CPU使用率の集計ウィンドウ |
| JVM使用率監視ウィンドウ | `GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING` | JVM使用率の集計ウィンドウ |
| I/O使用率監視ウィンドウ | `GLOBAL_IO_USAGE_AC_WINDOW_DURATION_SETTING` | I/O使用率の集計ウィンドウ |

### JVM設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| ヒープサイズ | `-Xms${heap.min}` / `-Xmx${heap.max}` | 環境変数で設定 |
| GCアルゴリズム（Java 11+） | G1GC | `-XX:+UseG1GC` |
| G1予約パーセント | 25% | `-XX:G1ReservePercent=25` |
| ヒープ占有率初期化 | 30% | `-XX:InitiatingHeapOccupancyPercent=30` |
| コンパクトオブジェクトヘッダ（Java 25+） | 有効 | `-XX:+UseCompactObjectHeaders` |

## 備考

- 本ドキュメントに記載された設定値は、ソースコード上のデフォルト値に基づく。運用環境では、ワークロード特性に応じた調整が必要である。
- 多くの設定は `Dynamic` 属性を持ち、クラスタ再起動なしに変更可能である。
- `NodeScope` の設定はノード単位、`IndexScope` の設定はインデックス単位で適用される。
- OpenSearch はプラグインアーキテクチャを採用しており、セキュリティプラグイン（Security Plugin）によるTLS/SSL、認証・認可機能は別途導入が必要である。
- リモートストア機能は実験的機能（Experimental）として提供されており、本番環境での利用には注意が必要である。
- サーキットブレーカーの閾値は実メモリ使用量計測の有無で異なり（95% vs 70%）、`indices.breaker.total.use_real_memory` のデフォルトは `true` である。
