# API設計書

## 概要

本ドキュメントは、QUASTO（Quality Assurance Tool for Oracle databases）が提供するPL/SQL APIの設計仕様を定義するものです。QUASTOはOracleデータベース内のガイドラインとコード品質をチェックするためのフレームワークであり、PL/SQLパッケージを通じてAPIを提供します。

## 共通仕様

### ベースURL

```
N/A（PL/SQLパッケージとしてOracleデータベース内で直接呼び出し）
```

### 認証方式

- Oracleデータベースのスキーマ権限に基づく認証
- `authid current_user` または `authid definer` によるセキュリティモデル
- 特定のスキーマに対するGRANT権限による認可

### 共通エラーレスポンス

| エラーコード | 説明 |
| --- | --- |
| -20001 | 入力パラメータの不正・欠落 |
| -20006 | ユーザーがブラックリストに登録されている |
| -20007 | ブラックリスト例外（スキーマがテスト対象外） |
| -1436 | ルール先行順序のループ検出 |
| NO_DATA_FOUND | 指定されたルールまたはデータが存在しない |

## API一覧

| カテゴリ | パッケージ名 | 機能 | 説明 |
| --- | --- | --- | --- |
| コアAPI | qa_api_pkg | tf_run_rule | 単一ルールの実行 |
| コアAPI | qa_api_pkg | tf_run_rules | 全ルールの実行 |
| APEX API | qa_apex_api_pkg | tf_run_rule | APEX用単一ルール実行 |
| APEX API | qa_apex_api_pkg | tf_run_rules | APEX用全ルール実行 |
| APEX API | qa_apex_api_pkg | p_exclude_not_whitelisted_apex_entries | ホワイトリスト外APEXエントリ除外 |
| メインAPI | qa_main_pkg | f_get_rule | ルール属性取得 |
| メインAPI | qa_main_pkg | f_get_rule_pk | ルールPK取得 |
| メインAPI | qa_main_pkg | f_is_rule_active | ルール有効状態確認 |
| メインAPI | qa_main_pkg | f_get_rule_category | ルールカテゴリ取得 |
| メインAPI | qa_main_pkg | f_get_rule_name | ルール名取得 |
| メインAPI | qa_main_pkg | f_get_rule_layer | ルールレイヤー取得 |
| メインAPI | qa_main_pkg | f_get_rule_error_level | ルールエラーレベル取得 |
| メインAPI | qa_main_pkg | f_exist_rules | ルール存在確認 |
| メインAPI | qa_main_pkg | tf_get_rule_numbers | ルール番号一覧取得 |
| メインAPI | qa_main_pkg | p_test_rule | ルールテスト実行 |
| メインAPI | qa_main_pkg | f_insert_rule | 新規ルール挿入 |
| メインAPI | qa_main_pkg | p_exclude_objects | 除外オブジェクト処理 |
| メインAPI | qa_main_pkg | f_check_for_loop | 先行ルールループ検出 |
| メインAPI | qa_main_pkg | f_get_full_rule_pred | 先行ルールID取得 |
| メインAPI | qa_main_pkg | f_is_owner_black_listed | ブラックリスト確認 |
| エクスポート/インポート | qa_export_import_rules_pkg | f_export_rules_table_to_clob | ルールをCLOB形式でエクスポート |
| エクスポート/インポート | qa_export_import_rules_pkg | f_export_rules_to_script_clob | スクリプト形式でエクスポート |
| エクスポート/インポート | qa_export_import_rules_pkg | f_import_clob_to_qa_import_files | CLOBをインポートファイルテーブルに登録 |
| エクスポート/インポート | qa_export_import_rules_pkg | p_import_clob_to_rules_table | CLOBからルールテーブルにインポート |
| ユニットテスト | qa_unit_tests_pkg | p_create_unit_test_packages | ユニットテストパッケージ作成 |
| ユニットテスト | qa_unit_tests_pkg | p_delete_unit_test_packages | ユニットテストパッケージ削除 |
| ユニットテスト | qa_unit_tests_pkg | p_run_all_unit_tests | 全ユニットテスト実行 |
| ユニットテスト | qa_unit_tests_pkg | f_run_all_unit_tests | 全ユニットテスト実行（結果返却） |
| ユニットテスト | qa_unit_tests_pkg | p_run_custom_unit_test | カスタムユニットテスト実行 |
| ユニットテスト | qa_unit_tests_pkg | f_import_test_result | テスト結果インポート |
| ユニットテスト | qa_unit_tests_pkg | f_export_test_result | テスト結果エクスポート |
| ユーティリティ | qa_utils_pkg | f_get_table_as_string | テーブルを文字列に変換 |
| ユーティリティ | qa_utils_pkg | f_get_string_as_table | 文字列をテーブルに変換 |
| ユーティリティ | qa_utils_pkg | f_get_unified_string | 文字列の正規化 |
| APEXアプリ | qa_apex_app_pkg | get_faceted_search_dashboard_data | ダッシュボードデータ取得 |
| APEXアプリ | qa_apex_app_pkg | p_upload_rules_json | JSONルールファイルアップロード |
| APEXアプリ | qa_apex_app_pkg | p_download_rules_json | JSONルールファイルダウンロード |

## 各APIエンドポイント定義

### qa_api_pkg（コアAPI）

#### 1. tf_run_rule

指定されたルール番号とクライアント名に基づいて単一のQUASTOルールを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_api_pkg |
| セキュリティモデル | authid current_user |
| 戻り値型 | qa_rules_t |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | - | ルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント/プロジェクト名 |
| pi_target_scheme | varchar2 | - | user | テスト対象スキーマ名 |

**使用例**

```sql
select *
from qa_api_pkg.tf_run_rule(pi_qaru_rule_number => '23.1'
                           ,pi_qaru_client_name => 'MT AG'
                           ,pi_target_scheme    => 'QUASTO')
```

**例外**

| 例外 | 説明 |
| --- | --- |
| -20001 | 入力パラメータが欠落している場合 |
| -20001 | ルールが非アクティブの場合 |
| NO_DATA_FOUND | 指定されたルールが存在しない場合 |

---

#### 2. tf_run_rules

指定されたクライアント名に基づいて全てのアクティブなQUASTOルールを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_api_pkg |
| セキュリティモデル | authid current_user |
| 戻り値型 | qa_rules_t |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント/プロジェクト名 |
| pi_target_scheme | varchar2 | - | user | テスト対象スキーマ名 |

**使用例**

```sql
select *
from qa_api_pkg.tf_run_rules(pi_qaru_client_name => 'MT AG'
                            ,pi_target_scheme    => 'QUASTO')
```

**例外**

| 例外 | 説明 |
| --- | --- |
| -20001 | 入力パラメータが欠落している場合 |
| NO_DATA_FOUND | 該当するルールが存在しない場合 |

---

### qa_apex_api_pkg（APEX API）

#### 1. tf_run_rule

APEX固有のルールを実行します。APEXアプリケーションIDとページIDを指定して実行できます。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_api_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | qa_rules_t |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_app_id | apex_application_items.application_id%type | ○ | - | APEXアプリケーションID |
| pi_page_id | apex_application_pages.page_id%type | ○ | - | APEXページID |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | - | ルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント名 |
| pi_target_scheme | varchar2 | - | user | テスト対象スキーマ名 |

**例外**

| 例外 | 説明 |
| --- | --- |
| -20001 | 入力パラメータが欠落している場合 |
| -20001 | ルールが非アクティブの場合 |
| NO_DATA_FOUND | 指定されたルールが存在しない場合 |

---

#### 2. tf_run_rules

APEX固有の全ルールを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_api_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | qa_rules_t |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_app_id | apex_application_items.application_id%type | ○ | - | APEXアプリケーションID |
| pi_page_id | apex_application_pages.page_id%type | ○ | - | APEXページID |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | - | null | クライアント名 |
| pi_target_scheme | varchar2 | - | user | テスト対象スキーマ名 |
| pi_rule_number | qa_rules.qaru_rule_number%type | - | null | 特定のルール番号 |

---

#### 3. p_exclude_not_whitelisted_apex_entries

ホワイトリストに登録されていないAPEXアプリケーションのエントリを除外します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_api_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_qa_rules_t | qa_rules_t IN OUT | ○ | 処理対象のルールエンティティ |

---

### qa_main_pkg（メインAPI）

#### 1. f_get_rule

ルール番号とクライアント名からルール属性を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_main_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | qa_rule_t |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | ルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | クライアント名 |

**例外**

| 例外 | 説明 |
| --- | --- |
| NO_DATA_FOUND | 指定されたルールが存在しない場合 |

---

#### 2. f_insert_rule

新規ルールをQA_RULESテーブルに挿入します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_main_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | qa_rules.qaru_id%type |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | - | ルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント名 |
| pi_qaru_name | qa_rules.qaru_name%type | ○ | - | ルール名 |
| pi_qaru_category | qa_rules.qaru_category%type | ○ | - | ルールカテゴリ |
| pi_qaru_object_types | qa_rules.qaru_object_types%type | ○ | - | 対象オブジェクトタイプ |
| pi_qaru_error_message | qa_rules.qaru_error_message%type | ○ | - | エラーメッセージ |
| pi_qaru_comment | qa_rules.qaru_comment%type | - | null | コメント |
| pi_qaru_exclude_objects | qa_rules.qaru_exclude_objects%type | - | null | 除外オブジェクト名 |
| pi_qaru_error_level | qa_rules.qaru_error_level%type | ○ | - | エラーレベル |
| pi_qaru_is_active | qa_rules.qaru_is_active%type | - | 1 | アクティブフラグ |
| pi_qaru_sql | qa_rules.qaru_sql%type | ○ | - | SQL文 |
| pi_qaru_predecessor_ids | qa_rules.qaru_predecessor_ids%type | - | null | 先行ルールID |
| pi_qaru_layer | qa_rules.qaru_layer%type | ○ | - | ルールレイヤー |

---

#### 3. p_test_rule

指定されたルールのテストを実行し、結果を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_main_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | クライアント名 |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | ルール番号 |
| pi_scheme_names | varchar2_tab_t | ○ | テスト対象スキーマ名リスト |
| po_result | number OUT | - | テスト結果（0=失敗、1=成功） |
| po_scheme_objects | qa_scheme_object_amounts_t OUT | - | スキーマごとの無効オブジェクト数 |
| po_invalid_objects | qa_rules_t OUT | - | 無効オブジェクト詳細 |

---

### qa_export_import_rules_pkg（エクスポート/インポートAPI）

#### 1. f_export_rules_table_to_clob

ルールテーブルをJSON形式のCLOBにエクスポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_export_import_rules_pkg |
| 戻り値型 | clob |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント名 |
| pi_category | qa_rules.qaru_category%type | - | null | ルールカテゴリ |

**レスポンス形式（JSON）**

```json
{
  "version": 1.1,
  "qa_rules": [{
    "client_names": [{
      "client_name": "MT AG",
      "categories": [{
        "category": "DDL",
        "rules": [{
          "rule_number": "1",
          "name": "Primary Key Check",
          "object_types": "TABLE",
          "error_message": "Table without primary key",
          "comment": null,
          "exclude_objects": null,
          "error_level": 1,
          "is_active": 1,
          "sql": "...",
          "predecessor_ids": "",
          "layer": "DB"
        }]
      }]
    }]
  }]
}
```

---

#### 2. p_import_clob_to_rules_table

JSON形式のCLOBをルールテーブルにインポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_export_import_rules_pkg |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_qaif_id | qa_import_files.qaif_id%type | ○ | インポートファイルID |

---

### qa_unit_tests_pkg（ユニットテストAPI）

#### 1. p_create_unit_test_packages

utPLSQL準拠のユニットテストパッケージを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_unit_tests_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_option | number | ○ | - | 作成方式（1=単一パッケージ、2=ルールごとにパッケージ） |
| pi_scheme_names | varchar2_tab_t | - | null | 対象スキーマ名リスト |

---

#### 2. f_run_all_unit_tests

全ユニットテストを実行し、XML形式の結果を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_unit_tests_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | clob |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | - | null | クライアント名 |
| pi_scheme_name | varchar2 | - | null | スキーマ名 |
| pi_quasto_scheme | varchar2 | - | CURRENT_USER | QUASTOスキーマ名 |
| pi_character_set | varchar2 | - | Windows-1251 | 文字エンコーディング |

---

#### 3. p_run_custom_unit_test

特定のユニットテストを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_unit_tests_pkg |
| セキュリティモデル | authid definer |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | ○ | - | ルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | ○ | - | クライアント名 |
| pi_scheme_name | varchar2 | ○ | - | スキーマ名 |
| pi_character_set | varchar2 | - | Windows-1251 | 文字エンコーディング |

---

### qa_utils_pkg（ユーティリティAPI）

#### 1. f_get_table_as_string

varchar2_tab_t型のテーブルを文字列に変換します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_utils_pkg |
| 戻り値型 | varchar2 |
| 特性 | deterministic |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_table | varchar2_tab_t | ○ | - | 変換対象テーブル |
| pi_separator | varchar2 | - | : | セパレータ文字 |

---

#### 2. f_get_unified_string

文字列を統一された形式に変換します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_utils_pkg |
| 戻り値型 | varchar2 |
| 特性 | deterministic |

**パラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pi_string | varchar2 | ○ | - | 変換対象文字列 |
| pi_regexp | varchar2 | - | [^a-zA-Z0-9_] | 正規表現パターン |
| pi_replace_blank_space | varchar2 | - | Y | スペース置換フラグ |
| pi_replacement_char | varchar2 | - | _ | 置換文字 |
| pi_transform_case | varchar2 | - | null | 大小文字変換（l=小文字、u=大文字） |

---

### qa_apex_app_pkg（APEXアプリケーションAPI）

#### 1. get_faceted_search_dashboard_data

ダッシュボードページのファセット検索データを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_app_pkg |
| 戻り値型 | qa_test_results_table_t（PIPELINED） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_page_id | number | ○ | ページID |
| pi_region_static_id | varchar2 | ○ | リージョンの静的ID |

---

#### 2. p_upload_rules_json

JSONルールファイルをアップロードしてインポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_app_pkg |
| 戻り値型 | なし（プロシージャ） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_file_name | varchar2 | ○ | ファイル名 |

**例外**

| 例外 | 説明 |
| --- | --- |
| -20001 | MIMEタイプがapplication/json以外の場合 |

---

#### 3. p_download_rules_json

クライアント名に基づいてルールをJSON形式でダウンロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| パッケージ | qa_apex_app_pkg |
| 戻り値型 | なし（プロシージャ、HTTPレスポンスを生成） |

**パラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pi_client_name | varchar2 | ○ | クライアント名 |

**レスポンスヘッダー**

| ヘッダー | 値 |
| --- | --- |
| Content-Type | application/json; charset=UTF-8 |
| Content-Disposition | attachment; filename="export_rules_{client_name}_{timestamp}.json" |
| Cache-Control | no-cache |

---

## データ型定義

### qa_rule_t

ルール情報を格納するオブジェクト型です。

| 属性 | 型 | 説明 |
| --- | --- | --- |
| qaru_id | number | ルールID |
| qaru_category | varchar2(10) | ルールカテゴリ |
| qaru_error_level | number | エラーレベル |
| qaru_error_message | varchar2(4000) | エラーメッセージ |
| qaru_object_types | varchar2(4000) | 対象オブジェクトタイプ |
| qaru_sql | clob | ルールSQL |
| scheme_name | varchar2(100) | スキーマ名 |
| object_id | number | オブジェクトID |
| object_name | varchar2(1000) | オブジェクト名 |
| object_details | varchar2(2000) | オブジェクト詳細 |
| object_type | varchar2(100) | オブジェクトタイプ |
| object_value | varchar2(4000) | オブジェクト値 |
| object_updated_user | varchar2(50) | 最終更新ユーザー |
| object_updated_date | date | 最終更新日時 |
| apex_app_id | number | APEXアプリケーションID |
| apex_page_id | number | APEXページID |

### qa_rules_t

qa_rule_tのコレクション型（TABLE OF qa_rule_t）です。

### varchar2_tab_t

VARCHAR2のコレクション型（TABLE OF VARCHAR2）です。

---

## 備考

- QUASTOはOracle 19c以降での動作を前提としています
- utPLSQLフレームワークとの連携機能はオプションです
- Oracle APEXとの連携機能もオプションです
- ルールのSQL文は、QUASTOフォーマットに従って記述する必要があります
- ブラックリスト機能により、Oracleシステムスキーマへのテスト実行は自動的にブロックされます
