---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 47
  claims_with_evidence: 45
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：45 / 47、根拠なし：2
- 優先レビュー（高）
  1. **ベースURL表記**：PL/SQLパッケージのためN/Aとしているが、APEX REST APIの可能性
  2. **エラーコード詳細**：全エラーコードの網羅性は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql`
- E-02: `src/plsql/pkg/qa_apex_api_pkg.sql`
- E-03: `src/plsql/pkg/qa_main_pkg.sql`
- E-04: `src/plsql/pkg/qa_export_import_rules_pkg.sql`
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql`
- E-06: `src/plsql/pkg/qa_utils_pkg.sql`
- E-07: `src/plsql/pkg/qa_apex_app_pkg.sql`
- E-08: `src/plsql/typ/qa_rule_t.sql`
- E-09: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはOracleデータベース品質チェックツール | E-09 | ○ |
| C-02 | qa_api_pkg.tf_run_ruleは単一ルール実行機能 | E-01 (行24-29) | ○ |
| C-03 | qa_api_pkg.tf_run_rulesは全ルール実行機能 | E-01 (行39-43) | ○ |
| C-04 | tf_run_ruleのパラメータpi_qaru_rule_number必須 | E-01 (行74-80) | ○ |
| C-05 | tf_run_ruleのパラメータpi_qaru_client_name必須 | E-01 (行74-80) | ○ |
| C-06 | tf_run_ruleのpi_target_schemeデフォルト値はuser | E-01 (行53) | ○ |
| C-07 | qa_api_pkgはauthid current_user | E-01 (行2) | ○ |
| C-08 | qa_apex_api_pkg.tf_run_ruleはAPEX用ルール実行 | E-02 (行19-26) | ○ |
| C-09 | qa_apex_api_pkg.tf_run_rulesはAPEX用全ルール実行 | E-02 (行28-35) | ○ |
| C-10 | qa_apex_api_pkgはauthid definer | E-02 (行1) | ○ |
| C-11 | p_exclude_not_whitelisted_apex_entriesはブラックリスト処理 | E-02 (行13-17) | ○ |
| C-12 | qa_main_pkg.f_get_ruleはルール属性取得 | E-03 (行21-25) | ○ |
| C-13 | qa_main_pkg.f_get_rule_pkはルールPK取得 | E-03 (行33-38) | ○ |
| C-14 | qa_main_pkg.f_is_rule_activeはアクティブ状態確認 | E-03 (行44-50) | ○ |
| C-15 | qa_main_pkg.f_insert_ruleは新規ルール挿入 | E-03 (行136-166) | ○ |
| C-16 | f_insert_ruleには14個のパラメータ | E-03 (行152-165) | ○ |
| C-17 | qa_main_pkg.p_test_ruleはテスト実行プロシージャ | E-03 (行117-132) | ○ |
| C-18 | qa_main_pkg.f_check_for_loopはループ検出 | E-03 (行181-185) | ○ |
| C-19 | qa_main_pkg.f_is_owner_black_listedはブラックリスト確認 | E-03 (行197-200) | ○ |
| C-20 | qa_export_import_rules_pkg.f_export_rules_table_to_clobはJSONエクスポート | E-04 (行26-31) | ○ |
| C-21 | JSONエクスポート形式にversionフィールドあり | E-04 (行215-217) | ○ |
| C-22 | バージョン番号は1.1 | E-04 (行14) | ○ |
| C-23 | p_import_clob_to_rules_tableはMERGE文を使用 | E-04 (行403-447) | ○ |
| C-24 | qa_unit_tests_pkg.p_create_unit_test_packagesはutPLSQL対応 | E-05 (行14-23) | ○ |
| C-25 | pi_optionは1または2の値を取る | E-05 (行312-315) | ○ |
| C-26 | f_run_all_unit_testsはXML結果を返す | E-05 (行51-63) | ○ |
| C-27 | デフォルト文字セットはWindows-1251 | E-05 (行63, 77) | ○ |
| C-28 | p_run_custom_unit_testは個別テスト実行 | E-05 (行71-77) | ○ |
| C-29 | qa_utils_pkg.f_get_table_as_stringはdeterministic | E-06 (行22) | ○ |
| C-30 | f_get_unified_stringは正規化処理 | E-06 (行36-51) | ○ |
| C-31 | デフォルト正規表現は[^a-zA-Z0-9_] | E-06 (行47) | ○ |
| C-32 | qa_apex_app_pkg.get_faceted_search_dashboard_dataはPIPELINED | E-07 (行18-23) | ○ |
| C-33 | p_upload_rules_jsonはapplication/jsonのみ許可 | E-07 (行143-146) | ○ |
| C-34 | p_download_rules_jsonはHTTPレスポンス生成 | E-07 (行183-189) | ○ |
| C-35 | qa_rule_t型にqaru_id属性あり | E-08 (行17) | ○ |
| C-36 | qa_rule_t型にapex_app_id属性あり | E-08 (行37) | ○ |
| C-37 | qa_rule_t型にapex_page_id属性あり | E-08 (行38) | ○ |
| C-38 | qa_rule_tに4つのコンストラクタがある | E-08 (行41-99) | ○ |
| C-39 | Oracle 19c以降が必要 | E-09 | ○ |
| C-40 | utPLSQLフレームワーク連携はオプション | E-09 | ○ |
| C-41 | Oracle APEX連携はオプション | E-09 | ○ |
| C-42 | エラーコード-20001は入力パラメータ不正 | E-01 (行78-80), E-02 (行126-128) | ○ |
| C-43 | エラーコード-20007はブラックリスト例外 | E-03 (行1044-1046) | ○ |
| C-44 | エラーコード-1436はループ検出例外 | E-03 (行910-911) | ○ |
| C-45 | tf_get_rule_numbersはvarch2_tab_tを返す | E-03 (行113) | ○ |
| C-46 | 認証方式はOracleスキーマ権限に基づく | **根拠なし** | △ |
| C-47 | 全エラーコードの網羅性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 認証方式に関する明示的なドキュメントが存在しない
  - 候補：QUASTO開発者ドキュメント / Oracle権限設定ドキュメント / セキュリティガイドライン
- 全エラーコード一覧の公式ドキュメントが未確認
  - 候補：qa_constant_pkg.sql（未読）/ エラーハンドリング仕様書

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: APIの基本機能・パラメータ記載（ソースコードから直接抽出）
- **0 (低リスク)**: データ型定義（型定義ファイルから直接抽出）
- **1 (中リスク)**: エラーコード一覧（一部のみ確認、網羅性未検証）
- **0 (低リスク)**: 使用例（README.mdと整合）
- **1 (中リスク)**: 認証・認可仕様（暗黙的な仕様として記載）

## 6) レビュアーチェックリスト（最小）
- [ ] qa_api_pkg.tf_run_ruleのパラメータ仕様がソースコードと一致しているか
- [ ] qa_api_pkg.tf_run_rulesのパラメータ仕様がソースコードと一致しているか
- [ ] qa_apex_api_pkgの各関数のパラメータ仕様がソースコードと一致しているか
- [ ] qa_main_pkg.f_insert_ruleの14パラメータが全て記載されているか
- [ ] qa_export_import_rules_pkgのJSONエクスポート形式が実際の出力と一致しているか
- [ ] qa_unit_tests_pkgのpi_optionの値（1, 2）が正しいか
- [ ] qa_rule_t型の属性一覧が型定義と一致しているか
- [ ] エラーコードの説明が実際のエラーハンドリングと一致しているか
- [ ] 認証方式の記載が実際の動作と一致しているか（要動作確認）
- [ ] Oracle 19c以降という前提条件がREADMEと一致しているか
