# QUASTO

## 概要

QUASTOは、Oracleデータベース内のコードガイドライン遵守と品質チェックを行うためのツールです。データモデル、PL/SQLコード、データ自体の品質検証をサポートし、utPLSQLテストとOracle APEXフロントエンドを提供します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ルールベース品質チェック | SQLクエリベースのルールを定義し、データモデル・PL/SQLコード・データの品質をチェック |
| DDLチェック | テーブル構造、主キー制約などのデータベースオブジェクトの検証 |
| DMLチェック | データ整合性、空テーブル検出などのデータ品質検証 |
| APEXチェック | Oracle APEXアプリケーションのオブジェクト（Item、Region、Button等）の検証 |
| ルール実行順序制御 | 先行ルール（predecessor）を設定し、ルール実行順序を制御 |
| ルールのエクスポート/インポート | JSON形式でのルール定義のエクスポートおよびインポート |
| utPLSQL連携 | utPLSQLフレームワークと連携した単体テストの実行 |
| APEXフロントエンド | Oracle APEXを利用したWebベースの管理UI |
| Loggerデバッグ | オープンソースのLoggerフレームワークによるデバッグ機能 |

## 技術スタック

### コア

- データベース: Oracle Database 19c以上
- 言語: PL/SQL
- フロントエンド: Oracle APEX（オプション）
- テストフレームワーク: utPLSQL（オプション）
- デバッグツール: Logger（オプション）
- ライセンス: MIT License

### 主要ライブラリ

- utPLSQL 3.1.11（オプション） - PL/SQL単体テストフレームワーク
- Logger（オプション） - デバッグ・ロギングフレームワーク

## ディレクトリ構成

```
quasto-dev/
├── install.sql               # メインインストールスクリプト
├── uninstall.sql             # アンインストールスクリプト
├── license.txt               # MITライセンス
├── README.md                 # プロジェクトドキュメント
├── src/
│   ├── install_objects.sql           # オブジェクトインストール制御
│   ├── install_quasto_objects.sql    # QUASTOコアオブジェクト
│   ├── install_utplsql_objects.sql   # utPLSQL連携オブジェクト
│   ├── install_apex_objects.sql      # APEX連携オブジェクト
│   ├── uninstall_all_objects.sql     # 全オブジェクト削除
│   ├── quasto_rules_template.json    # ルールテンプレート
│   ├── apex/                         # APEXアプリケーション
│   │   └── f141/                     # APEXアプリケーションID 141
│   ├── ddl/                          # DDL定義
│   │   ├── cons/                     # 制約定義
│   │   ├── ind/                      # インデックス定義
│   │   ├── seq/                      # シーケンス定義
│   │   └── tab/                      # テーブル定義
│   │       ├── qa_rules.sql          # ルール定義テーブル
│   │       ├── qa_test_runs.sql      # テスト実行履歴
│   │       ├── qa_test_results.sql   # テスト結果
│   │       ├── qa_test_run_invalid_objects.sql  # 無効オブジェクト
│   │       └── qa_import_files.sql   # インポートファイル
│   ├── plsql/                        # PL/SQLソースコード
│   │   ├── pkg/                      # パッケージ
│   │   │   ├── qa_api_pkg.sql        # メインAPI
│   │   │   ├── qa_main_pkg.sql       # コアロジック
│   │   │   ├── qa_apex_api_pkg.sql   # APEX API
│   │   │   ├── qa_apex_app_pkg.sql   # APEXアプリ連携
│   │   │   ├── qa_export_import_rules_pkg.sql  # エクスポート/インポート
│   │   │   ├── qa_unit_tests_pkg.sql # ユニットテスト
│   │   │   ├── qa_utils_pkg.sql      # ユーティリティ
│   │   │   └── qa_logger_pkg.sql     # ログ機能
│   │   ├── trg/                      # トリガー
│   │   ├── typ/                      # 型定義
│   │   │   ├── qa_rule_t.sql         # ルール型
│   │   │   ├── qa_rules_t.sql        # ルールコレクション型
│   │   │   └── ...
│   │   └── vw/                       # ビュー
│   └── scripts/                      # ユーティリティスクリプト
│       ├── export_rules_to_file.sql  # ルールエクスポート
│       ├── import_file_to_rules.js   # ルールインポート（SQLcl用）
│       ├── install_prereqs.sql       # 前提条件チェック
│       ├── install_constant_package.sql  # 定数パッケージ生成
│       └── recompile_*.sql           # 再コンパイルスクリプト
└── docs/                             # ドキュメント
```

## セットアップ

### 必要条件

- Oracle Database 19c以上
- SQL*PlusまたはSQLcl
- 以下の権限が付与されたデータベーススキーマ:

```sql
grant create procedure, public synonym, sequence, table, trigger, type, view, job to {スキーマ名};
grant create session to {スキーマ名};
```

- APEX連携を使用する場合の追加権限:

```sql
grant APEX_ADMINISTRATOR_ROLE to {スキーマ名};
```

### インストール手順

1. SQL*PlusまたはSQLclでインストール先スキーマに接続

2. utPLSQLやLoggerを使用する場合は、先にそれらをインストール

3. プロジェクトルートでインストールスクリプトを実行:

```sql
@install.sql [utPLSQL: 1/0] [APEX: 1/0] [Jenkins: 1/0] [Logger: 1/0]
```

#### 引数の説明

| 引数 | 説明 |
| --- | --- |
| 第1引数 | utPLSQL連携オブジェクトのインストール（1=有効, 0=無効） |
| 第2引数 | Oracle APEX連携オブジェクトのインストール（1=有効, 0=無効） |
| 第3引数 | Jenkins連携オブジェクトのインストール（将来実装予定） |
| 第4引数 | Loggerデバッグ機能のインストール（1=有効, 0=無効） |

### 個別インストール

コアオブジェクトのみ、またはオプション機能を個別にインストールする場合:

```sql
-- QUASTOコアオブジェクト（必須）
@src/install_quasto_objects.sql

-- utPLSQL連携オブジェクト（オプション）
@src/install_utplsql_objects.sql

-- APEX連携オブジェクト（オプション）
@src/install_apex_objects.sql
```

### アンインストール

```sql
@uninstall.sql
```

## 開発

### ルールの定義

QA_RULESテーブルにSQLクエリベースのルールを登録します。クエリは品質基準を満たさないオブジェクトを返すように記述します。

### ルールの実行

```sql
-- 単一ルールの実行
select *
from qa_api_pkg.tf_run_rule(
    pi_qaru_rule_number => '23.1',
    pi_qaru_client_name => 'MT AG',
    pi_target_scheme    => 'QUASTO'
);

-- 全ルールの実行
select *
from qa_api_pkg.tf_run_rules(
    pi_qaru_client_name => 'MT AG',
    pi_target_scheme    => 'QUASTO'
);
```

### ルールのエクスポート

```sql
@src/scripts/export_rules_to_file.sql "クライアント名" "カテゴリ（オプション）"
```

### ルールのインポート（SQLcl使用）

```sh
script src/scripts/import_file_to_rules.js "ファイル名.json" 1
```

### 再コンパイル

```sql
@src/scripts/recompile_quasto_objects.sql
@src/scripts/recompile_utplsql_objects.sql
@src/scripts/recompile_apex_objects.sql
```
