---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/README.md`（既存README.md）
- E-02: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/install.sql`
- E-03: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/install_objects.sql`
- E-04: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/plsql/pkg/qa_api_pkg.sql`
- E-05: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/ddl/tab/qa_rules.sql`
- E-06: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/license.txt`
- E-07: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/uninstall.sql`
- E-08: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/plsql/pkg/` ディレクトリ構造
- E-09: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/ddl/` ディレクトリ構造
- E-10: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/` ディレクトリ構造

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはOracleデータベース内の品質チェックツールである | E-01 | ○ |
| C-02 | データモデル、PL/SQLコード、データの品質検証をサポート | E-01, E-04 | ○ |
| C-03 | utPLSQLテストとOracle APEXフロントエンドを提供 | E-01, E-03 | ○ |
| C-04 | Oracle Database 19c以上が必要 | E-01 | ○ |
| C-05 | MITライセンスで提供 | E-06 | ○ |
| C-06 | DDLチェック機能（主キー制約等の検証） | E-01, E-04 | ○ |
| C-07 | DMLチェック機能（データ整合性検証） | E-01, E-04 | ○ |
| C-08 | APEXチェック機能（Item、Region、Button等の検証） | E-01, E-04 | ○ |
| C-09 | ルール実行順序制御（predecessor機能） | E-04, E-05 | ○ |
| C-10 | JSON形式でのルールエクスポート/インポート | E-01, E-10 | ○ |
| C-11 | QA_RULESテーブルにルールを定義 | E-05 | ○ |
| C-12 | qa_api_pkg.tf_run_rule関数でルール実行 | E-04 | ○ |
| C-13 | qa_api_pkg.tf_run_rules関数で全ルール実行 | E-04 | ○ |
| C-14 | install.sqlで4つの引数を受け取る | E-03 | ○ |
| C-15 | uninstall.sqlでアンインストール可能 | E-07 | ○ |
| C-16 | src/plsql/pkg/に主要パッケージが存在 | E-08 | ○ |
| C-17 | src/ddl/tab/にテーブル定義が存在 | E-09 | ○ |
| C-18 | src/scripts/にユーティリティスクリプトが存在 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての主張は既存のREADME.mdおよびソースコードから確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張が既存ドキュメントまたはソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ディレクトリ構成が実際のプロジェクト構造と一致しているか確認
- [ ] インストール手順が実際の手順と一致しているか確認
- [ ] API使用例（tf_run_rule、tf_run_rules）が正しく動作するか確認
- [ ] 日本語訳が適切かどうか確認（技術用語の翻訳精度）
