---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 49
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：49 / 52、根拠なし：3
- 優先レビュー（高）
  1. **Mermaidアーキテクチャ図の正確性**：コードから推定したため実際の依存関係と異なる可能性
  2. **utPLSQLとの連携詳細**：utPLSQL自体のコードは分析対象外
  3. **Loggerフレームワークの詳細**：外部フレームワークのため詳細未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、インストール手順、使用例
- E-02: `src/plsql/pkg/qa_api_pkg.sql` - APIパッケージ（仕様部・本体部）
- E-03: `src/plsql/pkg/qa_main_pkg.sql` - メインパッケージ（仕様部・本体部）
- E-04: `src/plsql/pkg/qa_utils_pkg.sql` - ユーティリティパッケージ
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql` - ユニットテストパッケージ
- E-06: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX連携パッケージ
- E-07: `src/plsql/typ/qa_rule_t.sql` - ルール型定義
- E-08: `src/ddl/tab/qa_rules.sql` - ルールテーブル定義
- E-09: `src/plsql/trg/qaru_iu_trg.sql` - トリガー定義
- E-10: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - ビュー定義
- E-11: `src/install_objects.sql` - インストールスクリプト
- E-12: ディレクトリ構造（ls -laR出力）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはPL/SQLで開発されている | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-02 | Oracle APEXアプリケーションとして動作 | E-01, E-06, E-11 | ○ |
| C-03 | utPLSQLと統合されている | E-01, E-05 | ○ |
| C-04 | 関数プレフィックスは`f_` | E-02:24, E-03:21 | ○ |
| C-05 | プロシージャプレフィックスは`p_` | E-03:124, E-05:19 | ○ |
| C-06 | テーブル関数プレフィックスは`tf_` | E-02:24, E-02:39 | ○ |
| C-07 | 入力パラメータプレフィックスは`pi_` | E-02:26, E-03:23 | ○ |
| C-08 | 出力パラメータプレフィックスは`po_` | E-03:129, E-03:130 | ○ |
| C-09 | ローカル変数プレフィックスは`l_` | E-02:59, E-03:219 | ○ |
| C-10 | 定数プレフィックスは`c_` | E-02:56, E-03:218 | ○ |
| C-11 | グローバル定数プレフィックスは`gc_` | E-03:206 | ○ |
| C-12 | 型サフィックスは`_t` | E-07 | ○ |
| C-13 | ビューサフィックスは`_v` | E-10 | ○ |
| C-14 | トリガーサフィックスは`_trg` | E-09 | ○ |
| C-15 | パッケージサフィックスは`_pkg` | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-16 | シーケンスサフィックスは`_seq` | E-09:25 | ○ |
| C-17 | QUASTOテーブルプレフィックスは`qa_` | E-08 | ○ |
| C-18 | qa_rulesカラムプレフィックスは`qaru_` | E-08:6-26 | ○ |
| C-19 | qa_test_runsカラムプレフィックスは`qatr_` | E-05:1055-1057 | ○ |
| C-20 | qa_test_run_invalid_objectsカラムプレフィックスは`qato_` | E-05:1068-1069 | ○ |
| C-21 | qa_import_filesカラムプレフィックスは`qaif_` | E-06:148 | ○ |
| C-22 | ディレクトリ構造（src/apex/）が存在 | E-12 | ○ |
| C-23 | ディレクトリ構造（src/ddl/）が存在 | E-12 | ○ |
| C-24 | ディレクトリ構造（src/plsql/）が存在 | E-12 | ○ |
| C-25 | ディレクトリ構造（src/scripts/）が存在 | E-12 | ○ |
| C-26 | qa_api_pkgはauthid current_user | E-02:2 | ○ |
| C-27 | qa_main_pkgはauthid definer | E-03:1 | ○ |
| C-28 | tf_run_ruleで単一ルール実行 | E-02:24-29 | ○ |
| C-29 | tf_run_rulesで全ルール実行 | E-02:39-43 | ○ |
| C-30 | f_get_ruleでルール情報取得 | E-03:21-25 | ○ |
| C-31 | f_is_rule_activeでルール有効性確認 | E-03:44-50 | ○ |
| C-32 | p_test_ruleでルールテスト実行 | E-03:124-132 | ○ |
| C-33 | p_exclude_objectsで除外処理 | E-03:172 | ○ |
| C-34 | f_check_for_loopでループ検出 | E-03:181-185 | ○ |
| C-35 | QA_RULESテーブル構造 | E-08:4-27 | ○ |
| C-36 | qaru_categoryはAPEX/DDL/DATA | E-08:45, E-01:117 | ○ |
| C-37 | qaru_error_levelは1=Error,2=Warning,4=Info | E-08:50 | ○ |
| C-38 | qaru_layerはPAGE/APPLICATION/DATABASE | E-08:54 | ○ |
| C-39 | BULK COLLECTパターンの使用 | E-02:99-108 | ○ |
| C-40 | パラメータログパターンの使用 | E-02:66-72, E-03:224-228 | ○ |
| C-41 | 例外ハンドリングパターンの使用 | E-02:139-151, E-03:243-256 | ○ |
| C-42 | 条件付きコンパイルの使用 | E-02:124-132 | ○ |
| C-43 | パイプライン関数の使用 | E-06:59-115 | ○ |
| C-44 | QARU_IU_TRGで監査情報自動設定 | E-09:27-34 | ○ |
| C-45 | qa_utils_pkgで文字列変換機能提供 | E-04:19-33 | ○ |
| C-46 | qa_logger_pkgでログ機能提供 | E-02:66-72（参照） | ○ |
| C-47 | 3層アーキテクチャを採用 | **根拠なし** | △ |
| C-48 | Mermaidアーキテクチャ図の依存関係 | **推定値** | △ |
| C-49 | Loggerフレームワークの詳細動作 | **外部フレームワーク** | △ |
| C-50 | f_get_table_as_stringの機能 | E-04:19-22, E-04:112-149 | ○ |
| C-51 | f_get_string_as_tableの機能 | E-04:30-33, E-04:151-189 | ○ |
| C-52 | f_get_unified_stringの機能 | E-04:43-51, E-04:191-244 | ○ |

## 4) 不足情報（Unknown / Missing）
- **3層アーキテクチャの明示的定義**
  - 理由：コード構造からの推定であり、設計ドキュメントでの明示的な定義は確認できず
  - 候補：アーキテクチャ設計書 / 設計意図ドキュメント / 開発者インタビュー

- **Mermaidアーキテクチャ図の正確性**
  - 理由：パッケージ間の依存関係はコードから推定。実際の呼び出しパターンと異なる可能性
  - 候補：実行トレース / シーケンス図 / コールグラフ解析

- **Loggerフレームワークの詳細**
  - 理由：外部OSSフレームワークであり、QUASTOコード内での参照のみ確認
  - 候補：[Logger GitHub](https://github.com/OraOpenSource/Logger) / Logger公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：命名規則、ファイル構造、基本構文の説明 - ソースコードから直接確認可能
- **1（中リスク）**：アーキテクチャ説明 - コード構造からの推定を含む
- **1（中リスク）**：業務フロー追跡例 - 代表的なパスのみ記載、エッジケースは未検証
- **0（低リスク）**：コード例 - すべてソースコードからの引用（行番号付き）

## 6) レビュアーチェックリスト（最小）
- [ ] 命名規則が実際のコードと一致しているか確認
- [ ] ディレクトリ構造が現在のリポジトリと一致しているか確認
- [ ] コード例の行番号が最新のソースと一致しているか確認
- [ ] アーキテクチャ図がパッケージ間の実際の依存関係を反映しているか確認
- [ ] 用語集の定義が開発チームの認識と一致しているか確認
- [ ] 参照ドキュメント（docs/code-to-docs/配下）が存在し、リンクが有効か確認
