---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **CI/CD連携の将来計画**：README記載のみ、具体的な実装計画ファイルなし
  2. **トランザクション分離レベルの詳細**：Oracle デフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`
- E-02: `src/install_objects.sql`
- E-03: `src/plsql/pkg/qa_api_pkg.sql`
- E-04: `src/plsql/pkg/qa_main_pkg.sql`
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql`
- E-06: `src/plsql/pkg/qa_apex_app_pkg.sql`
- E-07: `src/plsql/pkg/qa_utils_pkg.sql`
- E-08: `src/plsql/pkg/qa_logger_pkg.sql`
- E-09: `src/ddl/tab/qa_rules.sql`
- E-10: `src/ddl/tab/qa_test_runs.sql`
- E-11: `src/apex/f141/application/shared_components/security/authentications/oracle_apex_accounts.sql`
- E-12: `src/apex/f141/application/shared_components/plugins/region_type/quasto_region.sql`
- E-13: `src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql`
- E-14: ディレクトリ構造（`src/ddl/`, `src/plsql/`, `src/apex/`）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはOracle 19c以上で動作する | E-01 (README.md: "Oracle 19c or higher") | ○ |
| C-02 | Oracle APEX 24.1を使用している | E-11, E-12 (p_release=>'24.1.5') | ○ |
| C-03 | レイヤードアーキテクチャ（3層）を採用 | E-14 (ディレクトリ構造から推定) | ○ |
| C-04 | qa_api_pkgが外部APIを提供 | E-03 (tf_run_rule, tf_run_rules 関数定義) | ○ |
| C-05 | qa_main_pkgがコアビジネスロジックを担当 | E-04 (f_get_rule, p_test_rule 等の関数定義) | ○ |
| C-06 | qa_unit_tests_pkgがユニットテスト管理を担当 | E-05 (p_create_unit_test_packages, f_run_all_unit_tests 等) | ○ |
| C-07 | QA_RULESテーブルがルール定義を保持 | E-09 (テーブル定義とカラム構造) | ○ |
| C-08 | QA_TEST_RUNSテーブルがテスト結果を保持 | E-10 (テーブル定義) | ○ |
| C-09 | utPLSQLフレームワークと連携 | E-01, E-05 (ut.run呼び出し、ut_junit_reporter使用) | ○ |
| C-10 | Loggerフレームワークと連携（オプション） | E-01, E-08 (qa_logger_pkg定義) | ○ |
| C-11 | Oracle Schedulerを使用した非同期処理 | E-05 (dbms_scheduler.create_job呼び出し) | ○ |
| C-12 | Oracle APEX Accounts認証を使用 | E-11 (NATIVE_APEX_ACCOUNTS) | ○ |
| C-13 | QUASTO_REGIONプラグインが存在 | E-12 (プラグイン定義) | ○ |
| C-14 | ルール実行時にブラックリストチェックを実行 | E-03, E-04 (f_is_owner_black_listed関数) | ○ |
| C-15 | 先行関係（predecessor）に基づくルール実行順序制御 | E-03, E-04 (f_check_for_loop, predecessor_ids処理) | ○ |
| C-16 | autonomous_transactionでテスト結果を保存 | E-05 (p_handle_test_result: pragma autonomous_transaction) | ○ |
| C-17 | raise_application_errorでカスタム例外を使用 | E-03, E-04 (-20001, -20007等) | ○ |
| C-18 | qa_logger_pkg.p_qa_logでエラーログを記録 | E-03, E-04, E-05 (例外処理ブロック内での呼び出し) | ○ |
| C-19 | 条件コンパイルでAPEX機能を分離 | E-03 (`$IF qa_constant_pkg.gc_apex_flag = 1 $THEN`) | ○ |
| C-20 | Result Cacheを使用した関数キャッシュ | E-04 (f_get_excluded_objects: result_cache) | ○ |
| C-21 | APEX Collectionをダッシュボードデータに使用 | E-06 (apex_collection.create_collection_from_query) | ○ |
| C-22 | JSON形式でルールをエクスポート・インポート | E-06 (p_upload_rules_json, p_download_rules_json) | ○ |
| C-23 | XML形式でテスト結果をエクスポート | E-06 (p_download_unit_test_xml) | ○ |
| C-24 | インストール時にutPLSQL/APEX/Logger機能を選択可能 | E-02 (引数1-4の処理) | ○ |
| C-25 | 命名規約（qa_xxx_pkg, qaru_xxx等）を使用 | E-03, E-04, E-09 (一貫した命名規則) | ○ |
| C-26 | 変数命名規約（l_xxx, pi_xxx, po_xxx）を使用 | E-03, E-04, E-05 (変数宣言の確認) | ○ |
| C-27 | Jenkins/Azure DevOps/GitLab/GitHub CI/CD連携を予定 | E-01 (README記載) | △ |
| C-28 | トランザクション分離レベルがREAD COMMITTED | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **CI/CD連携の具体的計画**
  - README.mdに「planned for the future」と記載されているが、具体的な設計・実装ファイルは存在しない
  - 候補：CI/CD設計ドキュメント / Jenkinsfile / azure-pipelines.yml

- **トランザクション分離レベルの明示的設定**
  - Oracle Database のデフォルト動作（READ COMMITTED）を前提としているが、明示的な設定箇所は確認できず
  - 候補：データベース初期化パラメータ / セッション設定スクリプト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的な信頼度は0.93と高い
- **1: 中リスク** - CI/CD連携の記述は将来計画であり、現時点では未実装
- **0: 低リスク** - トランザクション分離レベルはOracleデフォルトで問題ない可能性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] QA_RULESテーブルの全カラムがドキュメントに反映されているか確認
- [ ] パッケージ間の依存関係図がコード内のUSING句と一致するか確認
- [ ] APEXアプリケーションのページ一覧が実際のページファイル数と一致するか確認
- [ ] utPLSQL連携部分の記述がutPLSQL v3.x仕様と整合しているか確認
- [ ] エラーコード一覧（-20001〜-20007）の用途が正確か確認
