# アーキテクチャ構成図

本ドキュメントは、QUASTOのアーキテクチャ構成をMermaid図で表現したものです。

## システム全体構成図

```mermaid
graph TB
    subgraph "Presentation Layer"
        APEX[Oracle APEX 24.1<br/>Application f141]
        PLUGIN[QUASTO_REGION<br/>Plugin]
    end

    subgraph "Application Layer"
        subgraph "API Packages"
            QA_API[qa_api_pkg<br/>External API]
            QA_APEX_API[qa_apex_api_pkg<br/>APEX API]
            QA_APEX_APP[qa_apex_app_pkg<br/>APEX App Helper]
        end

        subgraph "Business Logic Packages"
            QA_MAIN[qa_main_pkg<br/>Core Business Logic]
            QA_UNIT[qa_unit_tests_pkg<br/>Unit Test Management]
            QA_EXPORT[qa_export_import_rules_pkg<br/>Export/Import]
        end

        subgraph "Utility Packages"
            QA_UTILS[qa_utils_pkg<br/>Utilities]
            QA_LOGGER[qa_logger_pkg<br/>Logging]
            QA_CONST[qa_constant_pkg<br/>Constants]
        end
    end

    subgraph "Data Layer"
        subgraph "Core Tables"
            QA_RULES[(QA_RULES)]
        end

        subgraph "Test Result Tables"
            QA_TEST_RUNS[(QA_TEST_RUNS)]
            QA_TEST_RESULTS[(QA_TEST_RESULTS)]
            QA_TEST_INVALID[(QA_TEST_RUN_INVALID_OBJECTS)]
        end

        subgraph "Import Tables"
            QA_IMPORT[(QA_IMPORT_FILES)]
        end

        subgraph "Views"
            VIEWS[Various Views<br/>qa_xxx_v]
        end
    end

    subgraph "External Systems"
        UTPLSQL[utPLSQL Framework]
        LOGGER[Logger Framework]
        SCHEDULER[Oracle Scheduler]
    end

    %% Presentation to Application
    APEX --> QA_APEX_APP
    PLUGIN --> QA_APEX_API

    %% API Package dependencies
    QA_API --> QA_MAIN
    QA_APEX_API --> QA_API
    QA_APEX_APP --> QA_UNIT
    QA_APEX_APP --> QA_EXPORT

    %% Business Logic dependencies
    QA_MAIN --> QA_LOGGER
    QA_MAIN --> QA_UTILS
    QA_MAIN --> QA_CONST
    QA_UNIT --> QA_MAIN
    QA_UNIT --> QA_API
    QA_UNIT --> QA_UTILS
    QA_EXPORT --> QA_UTILS

    %% Data Layer access
    QA_MAIN --> QA_RULES
    QA_UNIT --> QA_TEST_RUNS
    QA_UNIT --> QA_TEST_RESULTS
    QA_UNIT --> QA_TEST_INVALID
    QA_EXPORT --> QA_IMPORT
    QA_MAIN --> VIEWS

    %% External integrations
    QA_UNIT --> UTPLSQL
    QA_LOGGER --> LOGGER
    QA_UNIT --> SCHEDULER
```

## パッケージ依存関係図

```mermaid
graph LR
    subgraph "Public API"
        QA_API[qa_api_pkg]
        QA_APEX_API[qa_apex_api_pkg]
    end

    subgraph "APEX Support"
        QA_APEX_APP[qa_apex_app_pkg]
    end

    subgraph "Core Logic"
        QA_MAIN[qa_main_pkg]
        QA_UNIT[qa_unit_tests_pkg]
        QA_EXPORT[qa_export_import_rules_pkg]
    end

    subgraph "Infrastructure"
        QA_UTILS[qa_utils_pkg]
        QA_LOGGER[qa_logger_pkg]
        QA_CONST[qa_constant_pkg]
    end

    QA_API --> QA_MAIN
    QA_API --> QA_LOGGER

    QA_APEX_API --> QA_API
    QA_APEX_API --> QA_MAIN

    QA_APEX_APP --> QA_UNIT
    QA_APEX_APP --> QA_EXPORT
    QA_APEX_APP --> QA_LOGGER
    QA_APEX_APP --> QA_UTILS

    QA_MAIN --> QA_LOGGER
    QA_MAIN --> QA_CONST
    QA_MAIN --> QA_UTILS

    QA_UNIT --> QA_MAIN
    QA_UNIT --> QA_API
    QA_UNIT --> QA_UTILS
    QA_UNIT --> QA_CONST
    QA_UNIT --> QA_LOGGER

    QA_EXPORT --> QA_MAIN
    QA_EXPORT --> QA_UTILS
    QA_EXPORT --> QA_LOGGER

    QA_UTILS --> QA_LOGGER
    QA_UTILS --> QA_CONST
```

## データモデル概要図

```mermaid
erDiagram
    QA_RULES ||--o{ QA_TEST_RUNS : "qaru_id"
    QA_TEST_RUNS ||--o{ QA_TEST_RUN_INVALID_OBJECTS : "qatr_id"

    QA_RULES {
        number qaru_id PK
        varchar2 qaru_rule_number
        varchar2 qaru_client_name
        varchar2 qaru_name
        varchar2 qaru_category
        varchar2 qaru_object_types
        varchar2 qaru_error_message
        clob qaru_sql
        number qaru_error_level
        number qaru_is_active
        varchar2 qaru_layer
        varchar2 qaru_predecessor_ids
        varchar2 qaru_exclude_objects
    }

    QA_TEST_RUNS {
        number qatr_id PK
        varchar2 qatr_scheme_name
        date qatr_date
        number qatr_result
        number qatr_qaru_id FK
        varchar2 qatr_program_name
        varchar2 qatr_runtime_error
    }

    QA_TEST_RUN_INVALID_OBJECTS {
        number qato_id PK
        varchar2 qato_object_name
        varchar2 qato_object_details
        number qato_qatr_id FK
    }

    QA_TEST_RESULTS {
        number qatr_id PK
        clob qatr_xml_result
        varchar2 qatr_description
        date qatr_added_on
    }

    QA_IMPORT_FILES {
        number qaif_id PK
        clob qaif_content
        varchar2 qaif_filename
        varchar2 qaif_mimetype
    }
```

## ルール実行フロー図

```mermaid
sequenceDiagram
    participant User
    participant APEX
    participant qa_api_pkg
    participant qa_main_pkg
    participant QA_RULES
    participant Target_Schema

    User->>APEX: ルール実行要求
    APEX->>qa_api_pkg: tf_run_rule(rule_number, client_name, scheme)

    qa_api_pkg->>qa_main_pkg: f_is_owner_black_listed(scheme)
    qa_main_pkg-->>qa_api_pkg: false (許可)

    qa_api_pkg->>qa_main_pkg: f_is_rule_active(rule_number, client_name)
    qa_main_pkg->>QA_RULES: SELECT qaru_is_active
    QA_RULES-->>qa_main_pkg: 1 (active)
    qa_main_pkg-->>qa_api_pkg: true

    qa_api_pkg->>qa_main_pkg: f_get_rule(rule_number, client_name)
    qa_main_pkg->>QA_RULES: SELECT rule definition
    QA_RULES-->>qa_main_pkg: qa_rule_t
    qa_main_pkg-->>qa_api_pkg: qa_rule_t

    qa_api_pkg->>Target_Schema: EXECUTE IMMEDIATE qaru_sql
    Target_Schema-->>qa_api_pkg: qa_rules_t (violations)

    qa_api_pkg->>qa_main_pkg: p_exclude_objects(qa_rules_t)
    qa_main_pkg-->>qa_api_pkg: filtered qa_rules_t

    qa_api_pkg-->>APEX: qa_rules_t
    APEX-->>User: 結果表示
```

## ユニットテスト実行フロー図

```mermaid
sequenceDiagram
    participant User
    participant APEX
    participant qa_unit_tests_pkg
    participant Oracle_Scheduler
    participant utPLSQL
    participant QA_TEST_RUNS
    participant QA_TEST_RESULTS

    User->>APEX: カスタムテスト実行要求
    APEX->>qa_unit_tests_pkg: p_create_custom_unit_test_job()

    qa_unit_tests_pkg->>Oracle_Scheduler: create_job(5秒後実行)
    Oracle_Scheduler-->>qa_unit_tests_pkg: job created
    qa_unit_tests_pkg-->>APEX: success
    APEX-->>User: ジョブ開始通知

    Note over Oracle_Scheduler: 5秒後...

    Oracle_Scheduler->>qa_unit_tests_pkg: p_run_custom_unit_test()
    qa_unit_tests_pkg->>utPLSQL: ut.run(unit_test_call)
    utPLSQL-->>qa_unit_tests_pkg: XML result

    qa_unit_tests_pkg->>QA_TEST_RESULTS: INSERT xml_result
    qa_unit_tests_pkg->>QA_TEST_RUNS: INSERT test_run

    Note over qa_unit_tests_pkg: autonomous_transaction

    qa_unit_tests_pkg-->>Oracle_Scheduler: completed
    Oracle_Scheduler->>Oracle_Scheduler: auto_drop job
```

## APEX アプリケーション構成図

```mermaid
graph TB
    subgraph "Oracle APEX Application (f141)"
        subgraph "Pages"
            P0000[Page 0: Global]
            P0001[Page 1: Dashboard]
            P0002[Page 2: Unit Tests]
            P0003[Page 3: Test Errors]
            P0004[Page 4: Test Details]
            P0005[Page 5: Test Results]
            P0006[Page 6: Rules]
            P0007[Page 7: Rule Edit]
            P0008[Page 8: Clients]
            P0009[Page 9: Jobs]
            P0011[Page 11: Job Run Details]
            P0020[Page 20: Import/Export]
            P9999[Page 9999: Login]
        end

        subgraph "Shared Components"
            AUTH[Authentication<br/>Oracle APEX Accounts]
            AUTHZ[Authorization<br/>Administration Rights]
            NAV[Navigation Menu]
            PLUGIN[QUASTO_REGION Plugin]
        end

        subgraph "Application Items"
            AI_CLIENT[AI_CLIENT_NAME]
            AI_TEST_ID[AI_XML_TEST_RESULT_ID]
        end

        subgraph "Application Processes"
            AP_RULE_JSON[GetRuleJSONAttachment]
            AP_UT_XML[GetUTXMLAttachment]
        end
    end

    P0001 --> NAV
    P0001 --> PLUGIN
    AUTH --> P9999
    AUTHZ --> P0006
    AUTHZ --> P0007

    AP_RULE_JSON --> P0020
    AP_UT_XML --> P0005
```

## インストール構成図

```mermaid
graph TB
    subgraph "Installation Options"
        INSTALL[install.sql]

        subgraph "Core Installation"
            CORE[install_quasto_objects.sql]
            DDL[DDL Objects]
            PLSQL[PL/SQL Objects]
        end

        subgraph "Optional: utPLSQL"
            UTPLSQL_OBJ[install_utplsql_objects.sql]
        end

        subgraph "Optional: APEX"
            APEX_OBJ[install_apex_objects.sql]
            APEX_APP[APEX Application f141]
        end

        subgraph "Optional: Logger"
            LOGGER_OBJ[Logger Integration]
        end
    end

    INSTALL --> CORE
    INSTALL -->|arg1=1| UTPLSQL_OBJ
    INSTALL -->|arg2=1| APEX_OBJ
    INSTALL -->|arg4=1| LOGGER_OBJ

    CORE --> DDL
    CORE --> PLSQL

    APEX_OBJ --> APEX_APP

    subgraph "DDL Objects"
        TAB[Tables<br/>QA_RULES, QA_TEST_RUNS, etc.]
        IND[Indexes]
        SEQ[Sequences]
        CONS[Constraints]
    end

    DDL --> TAB
    DDL --> IND
    DDL --> SEQ
    DDL --> CONS

    subgraph "PL/SQL Objects"
        PKG[Packages<br/>qa_xxx_pkg]
        TYP[Types<br/>qa_xxx_t]
        VW[Views<br/>qa_xxx_v]
        TRG[Triggers<br/>xxx_trg]
    end

    PLSQL --> PKG
    PLSQL --> TYP
    PLSQL --> VW
    PLSQL --> TRG
```
