# アーキテクチャ設計書

## 概要

本ドキュメントは、QUASTO (Quality Assurance Tool for Oracle databases) のアーキテクチャ設計を記載したものです。QUASTOは、Oracleデータベース向けの品質保証ツールであり、データモデル、PL/SQLコード、およびデータ自体に対するガイドラインとコード品質チェックを実行します。Oracle APEX 24.1をフロントエンドとし、PL/SQLパッケージによるバックエンド処理、utPLSQLとの統合によるユニットテスト機能を提供します。

## システム全体構成

### アーキテクチャ概要図

詳細は [アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照してください。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| Oracle Database 19c+ | PL/SQL | データ永続化、ルール実行、品質チェック対象 |
| Oracle APEX 24.1 | HTTP/SQL | Web UI、ユーザーインタラクション |
| utPLSQL Framework | PL/SQL API | ユニットテスト実行、JUnit形式XML出力 |
| Logger Framework | PL/SQL API | デバッグ・ログ記録（オプション） |
| Jenkins/Azure DevOps/GitLab/GitHub | 予定 | CI/CD連携（将来機能） |

## レイヤー構成

### アーキテクチャスタイル

**レイヤードアーキテクチャ（3層アーキテクチャ）**

QUASTOは、Oracle APEXを採用した典型的な3層アーキテクチャを採用しています。プレゼンテーション層（APEX UI）、ビジネスロジック層（PL/SQLパッケージ）、データ層（テーブル・ビュー）で構成されます。

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| Presentation | ユーザーインターフェース、画面表示、ユーザー入力の受付 | Oracle APEX アプリケーション (f141)、リージョンプラグイン (QUASTO_REGION)、ページ、リスト、テンプレート |
| Application/Business | ビジネスロジックの実行、ルール評価、テスト管理 | qa_api_pkg, qa_main_pkg, qa_unit_tests_pkg, qa_apex_app_pkg, qa_apex_api_pkg, qa_utils_pkg, qa_export_import_rules_pkg |
| Data | データの永続化、データアクセス | QA_RULES, QA_TEST_RUNS, QA_TEST_RESULTS, QA_TEST_RUN_INVALID_OBJECTS, QA_IMPORT_FILES テーブル、ビュー、トリガー、シーケンス |

### レイヤー間の依存関係ルール

```
Presentation → Application → Data
```

- **Presentation → Application**: APEX画面からPL/SQLパッケージのAPIを呼び出し
- **Application → Data**: PL/SQLパッケージからテーブル・ビューへのSQLアクセス
- **禁止される参照**: Data → Application、Data → Presentation、Application → Presentation

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| Core (ルール管理) | 品質ルールの定義・管理・実行 | qa_api_pkg, qa_main_pkg, QA_RULES |
| Testing (テスト管理) | ユニットテストの生成・実行・結果管理 | qa_unit_tests_pkg, QA_TEST_RUNS, QA_TEST_RESULTS, QA_TEST_RUN_INVALID_OBJECTS |
| APEX Integration | APEXアプリケーション向けAPI・画面機能 | qa_apex_app_pkg, qa_apex_api_pkg, QUASTO_REGION プラグイン |
| Export/Import | ルールのJSON形式エクスポート・インポート | qa_export_import_rules_pkg, QA_IMPORT_FILES |
| Utility | 共通ユーティリティ機能 | qa_utils_pkg, qa_logger_pkg, qa_constant_pkg |

### パッケージ構造

```
src/
├── apex/                          # Oracle APEX アプリケーション
│   ├── f141/                      # アプリケーション ID 141
│   │   ├── application/
│   │   │   ├── pages/            # ページ定義 (0001-0020, 9999)
│   │   │   ├── shared_components/
│   │   │   │   ├── security/     # 認証・認可設定
│   │   │   │   ├── plugins/      # QUASTO_REGION プラグイン
│   │   │   │   ├── logic/        # アプリケーションアイテム・プロセス
│   │   │   │   ├── navigation/   # ナビゲーション・ブレッドクラム
│   │   │   │   └── user_interface/ # テーマ・テンプレート
│   │   │   └── deployment/       # デプロイ設定
│   │   └── embedded_code/        # 埋め込みコード
│   └── plugin/                    # プラグインソース
├── ddl/                           # DDL定義
│   ├── tab/                       # テーブル定義
│   ├── ind/                       # インデックス定義
│   ├── seq/                       # シーケンス定義
│   └── cons/                      # 制約定義
├── plsql/                         # PL/SQLオブジェクト
│   ├── pkg/                       # パッケージ
│   ├── typ/                       # 型定義
│   ├── trg/                       # トリガー
│   └── vw/                        # ビュー
└── scripts/                       # インストール・メンテナンススクリプト
```

### コンポーネント依存関係

```
qa_api_pkg
    └── qa_main_pkg
        ├── qa_logger_pkg
        ├── qa_constant_pkg
        └── qa_utils_pkg

qa_unit_tests_pkg
    ├── qa_main_pkg
    ├── qa_api_pkg
    ├── qa_utils_pkg
    └── qa_constant_pkg

qa_apex_app_pkg
    ├── qa_unit_tests_pkg
    ├── qa_export_import_rules_pkg
    └── qa_logger_pkg

qa_apex_api_pkg
    └── qa_api_pkg
```

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| RDB | Oracle Database | 19c以上 | データ永続化、ルール実行、PL/SQL処理 |

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| Oracle Result Cache | - | f_get_excluded_objects 関数の結果キャッシュ | Oracle デフォルト |
| APEX Collection | - | FACETED_SEARCH_DASHBOARD_DATA_P0001 ダッシュボードデータ | セッション単位 |

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Oracle Scheduler | - | ユニットテストのバックグラウンド実行・定期実行 |

### 検索エンジン

該当なし

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Oracle APEX | 24.1.5 | Web UI フレームワーク |
| utPLSQL | 3.x | ユニットテストフレームワーク（オプション） |
| Logger | - | デバッグ・ロギングフレームワーク（オプション） |

## データフロー

### リクエスト処理の流れ

**ルール実行フロー（単一ルール）**

1. ユーザーがAPEX画面またはSQLクライアントからルール実行を要求
2. `qa_api_pkg.tf_run_rule` が呼び出される
3. `qa_main_pkg.f_is_owner_black_listed` でターゲットスキーマの検証
4. `qa_main_pkg.f_is_rule_active` でルールのアクティブ状態確認
5. `qa_main_pkg.f_get_rule` でルール定義を取得
6. 動的SQLでルールのSQLクエリを実行
7. APEXルールの場合、`qa_apex_api_pkg.p_exclude_not_whitelisted_apex_entries` でフィルタリング
8. `qa_main_pkg.p_exclude_objects` で除外オブジェクトを除去
9. 結果（qa_rules_t型）を返却

**全ルール実行フロー**

1. `qa_api_pkg.tf_run_rules` が呼び出される
2. `qa_main_pkg.f_check_for_loop` でルール依存関係のループチェック
3. 先行関係（predecessor）に基づいてルールを順序付け
4. 各ルールに対して `tf_run_rule` を順次実行
5. 先行ルールが失敗した場合、依存ルールはスキップ
6. 全結果を集約して返却

### 非同期処理の流れ

**カスタムユニットテストジョブ**

1. `qa_unit_tests_pkg.p_create_custom_unit_test_job` が呼び出される
2. `DBMS_SCHEDULER.CREATE_JOB` で5秒後に実行されるジョブを作成
3. ジョブが `qa_unit_tests_pkg.p_run_custom_unit_test` を実行
4. utPLSQL経由でテスト実行
5. 結果をQA_TEST_RESULTSテーブルに保存
6. ジョブは自動的に削除（auto_drop=true）

**定期実行クロンジョブ**

1. Oracle Schedulerで定期的に `qa_unit_tests_pkg.p_run_all_unit_tests` を実行
2. utPLSQLスイートパス経由で全テストを実行
3. JUnit XML形式で結果を生成
4. QA_TEST_RESULTSに結果を保存

### データ永続化の流れ

**ルール定義の保存**

1. `qa_main_pkg.f_insert_rule` または APEX画面から INSERT
2. `qaru_iu_trg` トリガーでシーケンス値・監査情報を設定
3. QA_RULESテーブルに永続化

**テスト結果の保存**

1. `qa_unit_tests_pkg.p_handle_test_result` が呼び出される（autonomous_transaction）
2. QA_TEST_RUNSに実行結果を保存
3. 失敗の場合、QA_TEST_RUN_INVALID_OBJECTSに無効オブジェクト詳細を保存
4. コミット

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| Oracle APEX Accounts | 認証スキーム (NATIVE_APEX_ACCOUNTS) | APEXアプリケーションユーザー |
| Administration Rights | 認可スキーム (administration_rights.sql) | 管理者機能へのアクセス制御 |
| Database Schema | PL/SQLパッケージの `authid current_user` / `authid definer` | SQLクライアント経由のアクセス |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| デバッグログ | qa_logger_pkg (Loggerフレームワーク連携) | logger_logs テーブル |
| 監査ログ | qaru_created_on/by, qaru_updated_on/by カラム | QA_RULESテーブル |
| テスト実行ログ | qatr_program_name, qatr_runtime_error | QA_TEST_RUNSテーブル |

### エラーハンドリング

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| バリデーションエラー | raise_application_error (-20001) | カスタムエラーメッセージ |
| ブラックリストユーザー | raise_application_error (-20007) + ログ出力 | gc_black_list_exception_text |
| ルールループ検出 | ORA-01436例外のキャッチ + ログ出力 | ループ検出メッセージ |
| 一般的なエラー | WHEN OTHERS + qa_logger_pkg.p_qa_log + RAISE | エラー詳細をログ出力後、再スロー |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| ルール実行 | 暗黙的（読み取りのみ） | READ COMMITTED（デフォルト） |
| テスト結果保存 | PRAGMA AUTONOMOUS_TRANSACTION | 独立トランザクション |
| ルール定義更新 | 呼び出し元制御 | READ COMMITTED（デフォルト） |

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| 単一責任原則 (SRP) | パッケージ分割 | qa_api_pkg（API）, qa_main_pkg（ビジネスロジック）, qa_utils_pkg（ユーティリティ）の分離 |
| 依存性逆転原則 (DIP) | 条件コンパイル | `$IF qa_constant_pkg.gc_apex_flag = 1 $THEN` によるオプション機能の分離 |
| Don't Repeat Yourself (DRY) | 共通処理の集約 | qa_utils_pkg.f_get_unified_string, qa_logger_pkg.append_param |
| Fail Fast | 入力検証 | 各関数冒頭での必須パラメータチェック + raise_application_error |

### コーディング規約

- **命名規約**
  - テーブル: QA_XXX (例: QA_RULES, QA_TEST_RUNS)
  - カラム: qaru_xxx, qatr_xxx, qato_xxx (テーブル接頭辞 + 名称)
  - パッケージ: qa_xxx_pkg
  - 型: qa_xxx_t
  - ビュー: qa_xxx_v
  - トリガー: qaru_iu_trg (テーブル接頭辞 + 操作 + _trg)
  - シーケンス: qaru_seq (テーブル接頭辞 + _seq)

- **変数命名規約**
  - 定数: c_xxx, gc_xxx (グローバル定数)
  - ローカル変数: l_xxx
  - パラメータ: pi_xxx (入力), po_xxx (出力)

- **例外処理**
  - 各プロシージャ/関数にEXCEPTIONブロックを設置
  - qa_logger_pkg.p_qa_log でエラー情報を記録
  - 適切なカスタム例外 (-20001〜-20007) の使用

## 備考

- QUASTOはMITライセンスで提供されるオープンソースプロジェクト
- utPLSQL/APEX/Logger機能はインストール時にオプションで選択可能
- Jenkins/Azure DevOps/GitLab/GitHub CI/CD連携は将来リリースで予定
- バージョン24.1では、ユニットテスト生成機能の大幅刷新とAPEX UI経由のテスト管理機能が追加
