---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Oracle RAC/Data Guard構成**: インフラ設計の推奨構成であり、実際の環境依存
  2. **CI/CD連携の詳細仕様**: 将来計画として記載されており、具体的な実装は未定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、インストール手順、要件定義
- E-02: `install.sql` - インストールスクリプト
- E-03: `src/install_objects.sql` - オブジェクトインストールスクリプト
- E-04: `src/install_quasto_objects.sql` - QUASTOコアオブジェクトインストール
- E-05: `src/install_utplsql_objects.sql` - utPLSQLオブジェクトインストール
- E-06: `src/install_apex_objects.sql` - APEXオブジェクトインストール
- E-07: `src/scripts/install_prereqs.sql` - 権限チェックスクリプト
- E-08: `src/scripts/install_constant_package.sql` - 定数パッケージ生成
- E-09: `src/scripts/create_scheduler_job_for_unit_tests.sql` - スケジューラージョブ作成
- E-10: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-11: `src/plsql/pkg/qa_api_pkg.sql` - API パッケージ定義
- E-12: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - ブラックリストビュー定義
- E-13: `src/uninstall_all_objects.sql` - アンインストールスクリプト（オブジェクト一覧）
- E-14: `src/scripts/export_rules_to_file.sql` - ルールエクスポートスクリプト
- E-15: `src/scripts/import_file_to_rules.js` - ルールインポートスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはOracle 19c以上で動作 | E-01 | ○ |
| C-02 | 3つのインストール方式（コア、utPLSQL、APEX） | E-01, E-03, E-04, E-05, E-06 | ○ |
| C-03 | utPLSQLは3.1.11バージョン推奨 | E-01 | ○ |
| C-04 | CREATE SESSION等の必要権限一覧 | E-01, E-07 | ○ |
| C-05 | APEX_ADMINISTRATOR_ROLEはオプション | E-01 | ○ |
| C-06 | QA_RULESテーブルの構造 | E-10 | ○ |
| C-07 | 5つのテーブル（QA_RULES, QA_IMPORT_FILES等） | E-04, E-05, E-13 | ○ |
| C-08 | 5つのシーケンス（QARU_SEQ等） | E-04, E-05, E-13 | ○ |
| C-09 | QA_API_PKGパッケージの機能 | E-11 | ○ |
| C-10 | スケジューラージョブCRONJOB_RUN_UNIT_TESTS | E-09 | ○ |
| C-11 | 日次実行（FREQ=DAILY）でデフォルト無効 | E-09 | ○ |
| C-12 | ブラックリストでOracle予約スキーマを除外 | E-12 | ○ |
| C-13 | JSONエクスポート・インポート機能 | E-01, E-14, E-15 | ○ |
| C-14 | Loggerフレームワーク連携（オプション） | E-01, E-08 | ○ |
| C-15 | バージョン24.1が現行バージョン | E-03, E-08 | ○ |
| C-16 | アップグレードパス（1.0->1.1->23.2->24.1） | E-01, E-03 | ○ |
| C-17 | MITライセンス | E-01 | ○ |
| C-18 | PUBLICへのEXECUTE権限付与 | E-04 | ○ |
| C-19 | install.sqlの引数形式（4つのフラグ） | E-01, E-03 | ○ |
| C-20 | APEXアプリケーションf141 | E-06, src/apex/f141.sql | ○ |
| C-21 | 9つのコアパッケージ | E-04, E-05, E-06, E-13 | ○ |
| C-22 | Jenkins連携は将来計画 | E-01 | ○ |
| C-23 | Oracle RAC構成での水平スケーリング | **根拠なし** | △ |
| C-24 | Data Guardによるディザスタリカバリ | **根拠なし** | △ |
| C-25 | APEXダッシュボードビュー群 | E-06, E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Oracle RAC/Data Guard構成に関する記載**
  - ソースコード内にはRAC/Data Guard固有の設定や考慮事項の記載なし
  - これらは一般的なOracle高可用性構成の推奨であり、QUASTO固有の設計ではない
  - 候補：実際のインフラ構成ドキュメント / 運用設計書 / DBパラメータ設定

- **CI/CD連携の具体的仕様**
  - README.mdに「将来計画」として言及されているが、具体的な実装は存在しない
  - 候補：Jenkins連携用オブジェクト / REST API仕様 / CI/CDパイプライン定義

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - データベースオブジェクト構成（ソースコードから完全に特定可能）
- **0: 低リスク** - 必要権限（install_prereqs.sqlで明確に定義）
- **0: 低リスク** - インストール手順（install.sqlで自動化）
- **1: 中リスク** - スケーリング設計（Oracle標準機能への依存、環境固有の設定が必要）
- **1: 中リスク** - バックアップ設計（運用ポリシーに依存する部分あり）
- **1: 中リスク** - 監視設計（Logger連携はオプション、有効化が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] Oracle 19c以上の要件は実際の運用環境と整合しているか
- [ ] 必要権限一覧は漏れなく付与されているか
- [ ] スケジューラージョブの実行スケジュールは運用要件に適合しているか
- [ ] バックアップ頻度・保持期間は運用ポリシーと整合しているか
- [ ] 高可用性構成（RAC/Data Guard）は実際の環境構成に適合しているか
- [ ] Logger連携の有効化が必要な場合、Loggerフレームワークは事前にインストールされているか
- [ ] utPLSQL連携を使用する場合、utPLSQLフレームワーク（3.1.11推奨）は事前にインストールされているか
