# インフラ構成図

## 全体システム構成

```mermaid
graph TB
    subgraph "クライアント層"
        SQL[SQL*Plus/SQLcl]
        APEX_UI[APEX Web UI]
        CI_CD[CI/CD Tool<br/>Jenkins/Azure DevOps<br/>GitLab/GitHub]
    end

    subgraph "Oracle Database Server"
        subgraph "QUASTOスキーマ"
            subgraph "コアオブジェクト"
                QA_RULES[(QA_RULES<br/>テーブル)]
                QA_IMPORT[(QA_IMPORT_FILES<br/>テーブル)]
                QA_API[QA_API_PKG<br/>パッケージ]
                QA_MAIN[QA_MAIN_PKG<br/>パッケージ]
                QA_UTILS[QA_UTILS_PKG<br/>パッケージ]
                QA_CONST[QA_CONSTANT_PKG<br/>パッケージ]
                QA_EXPORT[QA_EXPORT_IMPORT_RULES_PKG<br/>パッケージ]
            end

            subgraph "utPLSQLオブジェクト（オプション）"
                QA_TEST_RESULTS[(QA_TEST_RESULTS<br/>テーブル)]
                QA_TEST_RUNS[(QA_TEST_RUNS<br/>テーブル)]
                QA_TEST_INVALID[(QA_TEST_RUN_INVALID_OBJECTS<br/>テーブル)]
                QA_UNIT[QA_UNIT_TESTS_PKG<br/>パッケージ]
                SCHEDULER[CRONJOB_RUN_UNIT_TESTS<br/>スケジューラージョブ]
            end

            subgraph "APEXオブジェクト（オプション）"
                QA_APEX_APP[QA_APEX_APP_PKG<br/>パッケージ]
                QA_APEX_API[QA_APEX_API_PKG<br/>パッケージ]
                APEX_VIEWS[APEXビュー群]
            end

            subgraph "ロギング（オプション）"
                QA_LOGGER[QA_LOGGER_PKG<br/>パッケージ]
            end
        end

        subgraph "外部フレームワーク（別スキーマ）"
            UTPLSQL[utPLSQL<br/>フレームワーク]
            LOGGER[Logger<br/>フレームワーク]
        end

        subgraph "対象スキーマ"
            TARGET_SCHEMA[テスト対象<br/>スキーマ]
        end
    end

    subgraph "Oracle APEX Server（オプション）"
        ORDS[ORDS]
        APEX_ENGINE[APEX Engine]
        APEX_APP[APEX Application<br/>f141]
    end

    SQL --> QA_API
    SQL --> QA_EXPORT
    APEX_UI --> ORDS
    ORDS --> APEX_ENGINE
    APEX_ENGINE --> APEX_APP
    APEX_APP --> QA_APEX_APP
    CI_CD -.-> |将来対応| QA_API

    QA_API --> QA_MAIN
    QA_MAIN --> QA_RULES
    QA_MAIN --> TARGET_SCHEMA
    QA_MAIN --> QA_LOGGER
    QA_LOGGER --> LOGGER

    QA_UNIT --> QA_API
    QA_UNIT --> QA_TEST_RESULTS
    QA_UNIT --> QA_TEST_RUNS
    QA_UNIT --> QA_TEST_INVALID
    QA_UNIT --> UTPLSQL

    SCHEDULER --> QA_UNIT

    QA_EXPORT --> QA_RULES
    QA_EXPORT --> QA_IMPORT

    QA_APEX_APP --> QA_TEST_RESULTS
    QA_APEX_APP --> QA_TEST_RUNS
    QA_APEX_API --> QA_API
```

## データベースオブジェクト構成

```mermaid
graph LR
    subgraph "テーブル"
        T1[QA_RULES]
        T2[QA_IMPORT_FILES]
        T3[QA_TEST_RESULTS]
        T4[QA_TEST_RUNS]
        T5[QA_TEST_RUN_INVALID_OBJECTS]
    end

    subgraph "シーケンス"
        S1[QARU_SEQ]
        S2[QAIF_SEQ]
        S3[QATR_SEQ]
        S4[QATRU_SEQ]
        S5[QATO_SEQ]
    end

    subgraph "トリガー"
        TR1[QARU_IU_TRG]
        TR2[QAIF_I_TRG]
        TR3[QATR_I_TRG]
        TR4[QATRU_I_TRG]
        TR5[QATO_I_TRG]
    end

    S1 --> TR1
    S2 --> TR2
    S3 --> TR3
    S4 --> TR4
    S5 --> TR5

    TR1 --> T1
    TR2 --> T2
    TR3 --> T3
    TR4 --> T4
    TR5 --> T5
```

## パッケージ依存関係

```mermaid
graph TB
    subgraph "APIレイヤー"
        API[QA_API_PKG]
        APEX_API[QA_APEX_API_PKG]
    end

    subgraph "ビジネスロジックレイヤー"
        MAIN[QA_MAIN_PKG]
        UNIT[QA_UNIT_TESTS_PKG]
        APEX_APP[QA_APEX_APP_PKG]
        EXPORT[QA_EXPORT_IMPORT_RULES_PKG]
    end

    subgraph "ユーティリティレイヤー"
        UTILS[QA_UTILS_PKG]
        LOGGER[QA_LOGGER_PKG]
        CONST[QA_CONSTANT_PKG]
    end

    API --> MAIN
    APEX_API --> API
    APEX_API --> APEX_APP

    MAIN --> UTILS
    MAIN --> LOGGER
    MAIN --> CONST

    UNIT --> API
    UNIT --> LOGGER
    UNIT --> CONST

    APEX_APP --> LOGGER
    APEX_APP --> CONST

    EXPORT --> UTILS
    EXPORT --> LOGGER

    UTILS --> CONST
    LOGGER --> CONST
```

## インストール構成

```mermaid
flowchart TD
    START[install.sql] --> CHECK[install_prereqs.sql<br/>権限チェック]
    CHECK --> CONST[install_constant_package.sql<br/>定数パッケージ生成]
    CONST --> CORE[install_quasto_objects.sql<br/>コアオブジェクト]

    CORE --> UTPLSQL_CHECK{utPLSQL<br/>インストール?}
    UTPLSQL_CHECK -->|Yes| UTPLSQL[install_utplsql_objects.sql]
    UTPLSQL_CHECK -->|No| APEX_CHECK

    UTPLSQL --> APEX_CHECK{APEX<br/>インストール?}
    APEX_CHECK -->|Yes| APEX[install_apex_objects.sql]
    APEX_CHECK -->|No| RECOMPILE

    APEX --> RECOMPILE[recompile_*_objects.sql<br/>オブジェクト再コンパイル]
    RECOMPILE --> VALIDATE[インストール検証]
    VALIDATE --> END[完了]

    subgraph "コアオブジェクト内訳"
        CORE --> TABLES[テーブル作成]
        CORE --> INDEXES[インデックス作成]
        CORE --> CONSTRAINTS[制約作成]
        CORE --> SEQUENCES[シーケンス作成]
        CORE --> TYPES[型作成]
        CORE --> VIEWS[ビュー作成]
        CORE --> PACKAGES[パッケージ作成]
        CORE --> TRIGGERS[トリガー作成]
        CORE --> GRANTS[権限付与]
    end
```

## スケジューラージョブ構成

```mermaid
sequenceDiagram
    participant SCHEDULER as Oracle Scheduler
    participant JOB as CRONJOB_RUN_UNIT_TESTS
    participant PKG as qa_unit_tests_pkg
    participant TEST as ユニットテスト
    participant RESULT as QA_TEST_RESULTS
    participant RUNS as QA_TEST_RUNS

    SCHEDULER->>JOB: 日次トリガー
    JOB->>PKG: p_run_all_unit_tests()
    PKG->>TEST: テスト実行
    TEST-->>PKG: 結果返却
    PKG->>RESULT: 結果保存
    PKG->>RUNS: 実行履歴保存
    PKG-->>JOB: 完了
```

## 外部フレームワーク連携

```mermaid
graph LR
    subgraph "QUASTOスキーマ"
        QA[QUASTO<br/>オブジェクト]
    end

    subgraph "utPLSQLスキーマ"
        UT3[ut3<br/>フレームワーク]
    end

    subgraph "Loggerスキーマ"
        LOG[logger<br/>フレームワーク]
    end

    QA -->|GRANT/SYNONYM| UT3
    QA -->|GRANT/SYNONYM| LOG

    UT3 -->|"ut.run()"| QA
    LOG -->|logger_logs| QA
```

## 権限構成

```mermaid
graph TB
    subgraph "システム権限"
        SP1[CREATE SESSION]
        SP2[CREATE TABLE]
        SP3[CREATE VIEW]
        SP4[CREATE SEQUENCE]
        SP5[CREATE PROCEDURE]
        SP6[CREATE TRIGGER]
        SP7[CREATE TYPE]
        SP8[CREATE JOB]
        SP9[CREATE PUBLIC SYNONYM]
    end

    subgraph "オブジェクト権限"
        OP1[EXECUTE on QA_API_PKG]
        OP2[EXECUTE on QA_RULE_T]
    end

    subgraph "ロール（オプション）"
        R1[APEX_ADMINISTRATOR_ROLE]
    end

    QUASTO_SCHEMA[QUASTOスキーマ] --> SP1
    QUASTO_SCHEMA --> SP2
    QUASTO_SCHEMA --> SP3
    QUASTO_SCHEMA --> SP4
    QUASTO_SCHEMA --> SP5
    QUASTO_SCHEMA --> SP6
    QUASTO_SCHEMA --> SP7
    QUASTO_SCHEMA --> SP8
    QUASTO_SCHEMA --> SP9

    PUBLIC[PUBLIC] --> OP1
    PUBLIC --> OP2

    QUASTO_SCHEMA -.->|APEX連携時| R1
```
