# インフラ設計書

## 概要

本ドキュメントは、QUASTO（Quality Assurance Tool for Oracle databases）のインフラストラクチャ設計について記載する。QUASTOはOracle Database上で動作する品質保証ツールであり、データモデル、PL/SQLコード、データ自体のガイドライン準拠チェックを行う。オプションでutPLSQLテストフレームワーク、Oracle APEX、Loggerフレームワークと連携可能。

## システム構成

### 全体構成

QUASTOは、Oracle Databaseスキーマ内にインストールされるデータベースネイティブアプリケーションである。以下の構成要素から成り立つ：

1. **QUASTOコアオブジェクト**: テーブル、ビュー、パッケージ、型、トリガー、シーケンス
2. **utPLSQLオブジェクト（オプション）**: ユニットテスト実行・結果管理用オブジェクト
3. **APEXオブジェクト（オプション）**: フロントエンドUI用ビュー・パッケージ
4. **Logger機能（オプション）**: デバッグ・ロギング機能

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Oracle DBサーバー | QUASTO実行基盤、データ永続化、ビジネスロジック実行 | Oracle 19c以上 | 1台以上（構成による） |
| APEXサーバー（オプション） | Webフロントエンド提供 | Oracle APEX環境 | 1台（APEXを使用する場合） |

### ネットワーク構成

- **データベース接続**: SQL*Plus、SQLcl、またはOracle Net経由でのデータベース接続
- **APEXアクセス（オプション）**: HTTP/HTTPS経由でAPEXアプリケーションにアクセス
- **Jenkins/CI/CD連携（将来予定）**: REST API経由での連携を想定

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Oracle Database | 19c以上（11gR2, 12c, 12c R2, 18c, 19cもutPLSQL連携時対応） | QUASTOの実行基盤、データ永続化 |
| Oracle APEX | 任意（オプション） | WebベースのフロントエンドUI |
| utPLSQL | 3.1.11（推奨） | ユニットテストフレームワーク |
| Logger | GitHub版（オプション） | デバッグ・ロギング機能 |
| ORDS | 任意（オプション） | APEXのREST API提供 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| utPLSQL | PL/SQLユニットテスト実行 | 同一DB内のPL/SQL呼び出し |
| Logger | デバッグログ記録 | 同一DB内のPL/SQL呼び出し |
| Jenkins/Azure DevOps（将来） | CI/CD連携 | 予定：REST API、SQLスクリプト実行 |
| GitLab/GitHub（将来） | CI/CD連携 | 予定：REST API |

## スケーリング設計

### 水平スケーリング

- **データベースレベル**: Oracle RAC（Real Application Clusters）構成での水平スケーリングが可能
- **APEXレベル**: ORDS（Oracle REST Data Services）を使用したロードバランシング

### 垂直スケーリング

- **データベースリソース**: CPU、メモリ、ストレージのスケールアップ
- **テーブルスペース拡張**: QA_RULESテーブルのCLOBデータ（SQL文格納）に対応したストレージ拡張

### スケジューラージョブ

- `CRONJOB_RUN_UNIT_TESTS`: 日次実行のスケジューラージョブ
  - 実行頻度: FREQ=DAILY
  - 実行内容: `qa_unit_tests_pkg.p_run_all_unit_tests`プロシージャ呼び出し
  - デフォルト: 無効状態で作成（手動有効化が必要）

## 可用性設計

### データベースレベル

- **Oracle RAC**: 複数ノード構成によるフェイルオーバー（構成次第）
- **Data Guard**: スタンバイDB構成によるディザスタリカバリ（構成次第）

### アプリケーションレベル

- **再インストール**: `install.sql`スクリプトによる自動アップグレード検知・適用
- **バージョン互換性**: 1.0, 1.1, 23.2, 24.1間での自動アップグレード対応

### エラーハンドリング

- **例外処理**: 各PL/SQLパッケージでの例外捕捉とLoggerへのログ出力
- **ブラックリスト機能**: `qa_scheme_names_for_testing_v`ビューでOracle予約スキーマを除外

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| QA_RULESテーブル | JSONエクスポート（export_rules_to_file.sql） | 手動または定期実行 | 運用ポリシーによる |
| テスト結果（QA_TEST_RESULTS） | Oracle標準バックアップ | DBバックアップに依存 | DBバックアップポリシーによる |
| テスト実行履歴（QA_TEST_RUNS） | Oracle標準バックアップ | DBバックアップに依存 | DBバックアップポリシーによる |
| APEXアプリケーション（f141） | APEXエクスポート | 手動または定期実行 | 運用ポリシーによる |

### ルールのエクスポート・インポート

- **エクスポート**: `@export_rules_to_file.sql "[Client Name]" "[Category]"`
- **インポート**: `script import_file_to_rules.js "[Filename.json]" "[Full Import Flag]"`（SQLclが必要）

## 監視設計

### データベースレベル監視

- **Oracle Enterprise Manager**: データベースパフォーマンス監視（Oracle標準）
- **Logger**: QUASTOパッケージ内のエラー・デバッグログ記録
  - `logger_logs`: 全ログテーブル
  - `logger_logs_5_min`: 直近5分のログビュー
  - `logger_logs_60_min`: 直近60分のログビュー

### アプリケーションレベル監視

- **ユニットテスト結果**: `QA_TEST_RESULTS`テーブルでテスト結果を永続化
- **テスト実行履歴**: `QA_TEST_RUNS`テーブルで実行履歴を管理
- **不正オブジェクト検出**: `QA_TEST_RUN_INVALID_OBJECTS`テーブルで無効オブジェクトを記録

### APEXダッシュボード（オプション）

- **テスト概要**: `qa_overview_tests_p0001_v`ビュー
- **成功率**: `qa_overview_quota_p0001_v`ビュー
- **タイムライン**: エラー、失敗、成功それぞれのタイムラインビュー

## データベースオブジェクト一覧

### テーブル

| テーブル名 | 用途 |
| --- | --- |
| QA_RULES | ルール定義の格納 |
| QA_IMPORT_FILES | インポートファイル管理 |
| QA_TEST_RESULTS | テスト結果格納（utPLSQL連携時） |
| QA_TEST_RUNS | テスト実行履歴（utPLSQL連携時） |
| QA_TEST_RUN_INVALID_OBJECTS | 無効オブジェクト記録（utPLSQL連携時） |

### シーケンス

| シーケンス名 | 用途 |
| --- | --- |
| QARU_SEQ | QA_RULESテーブルの主キー生成 |
| QAIF_SEQ | QA_IMPORT_FILESテーブルの主キー生成 |
| QATR_SEQ | QA_TEST_RESULTSテーブルの主キー生成 |
| QATO_SEQ | QA_TEST_RUN_INVALID_OBJECTSテーブルの主キー生成 |
| QATRU_SEQ | QA_TEST_RUNSテーブルの主キー生成 |

### パッケージ

| パッケージ名 | 用途 |
| --- | --- |
| QA_API_PKG | ルール実行API |
| QA_MAIN_PKG | コアロジック |
| QA_UTILS_PKG | ユーティリティ関数 |
| QA_LOGGER_PKG | ロギング機能 |
| QA_CONSTANT_PKG | 定数定義 |
| QA_EXPORT_IMPORT_RULES_PKG | ルールエクスポート・インポート |
| QA_UNIT_TESTS_PKG | ユニットテスト管理（utPLSQL連携時） |
| QA_APEX_APP_PKG | APEXアプリ連携（APEX連携時） |
| QA_APEX_API_PKG | APEX API（APEX連携時） |

## 必要権限

### 基本権限（必須）

```sql
grant create procedure, public synonym, sequence, table, trigger, type, view, job to {schemeName};
grant create session to {schemeName};
```

### 詳細権限一覧

| 権限 | 用途 |
| --- | --- |
| CREATE SESSION | データベース接続 |
| CREATE TABLE | QUASTOテーブル作成 |
| CREATE VIEW | ビュー作成 |
| CREATE SEQUENCE | シーケンス作成 |
| CREATE PROCEDURE | パッケージ作成 |
| CREATE TRIGGER | トリガー作成 |
| CREATE TYPE | 型作成 |
| CREATE JOB | スケジューラージョブ作成 |
| CREATE PUBLIC SYNONYM | 公開シノニム作成 |

### オプション権限

| 権限 | 用途 |
| --- | --- |
| APEX_ADMINISTRATOR_ROLE | APEX連携時、他スキーマのAPEXオブジェクト参照 |
| DROP PUBLIC SYNONYM | 公開シノニム削除 |
| DROP ANY SYNONYM | 任意のシノニム削除 |

## 備考

### バージョン情報

- 現行バージョン: 24.1
- サポートされるアップグレードパス: 1.0 -> 1.1 -> 23.2 -> 24.1

### CI/CD連携（将来計画）

- Jenkins連携オブジェクトは将来リリースで追加予定
- Azure DevOps、GitLab、GitHub連携も計画中

### ライセンス

- MITライセンスを採用
