---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **セッション有効期限の具体値**：APEXワークスペース設定に依存するため未確認
  2. **HTTPS/HSTS設定**：インフラ設定に依存するため未確認
  3. **Oracle TDE推奨**：コードからは直接確認できない推奨事項
  4. **ログ保持期間**：Logger設定ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/shared_components/security/authentications/oracle_apex_accounts.sql`
- E-02: `src/apex/f141/application/shared_components/security/authentications/opendoor.sql`
- E-03: `src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql`
- E-04: `src/apex/f141/application/create_application.sql`
- E-05: `src/apex/f141/embedded_code/shared_components/security/authorizations.sql`
- E-06: `src/plsql/pkg/qa_api_pkg.sql`
- E-07: `src/plsql/pkg/qa_main_pkg.sql`
- E-08: `src/plsql/pkg/qa_logger_pkg.sql`
- E-09: `src/plsql/pkg/qa_export_import_rules_pkg.sql`
- E-10: `src/plsql/vw/qa_scheme_names_for_testing_v.sql`
- E-11: `src/ddl/tab/qa_rules.sql`
- E-12: `src/ddl/tab/qa_test_results.sql`
- E-13: `src/apex/f141/application/pages/page_00001.sql`
- E-14: `src/apex/f141.sql`
- E-15: `README.md`
- E-16: `src/install_objects.sql`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Oracle APEX Accountsが本番用認証として設定されている | E-01 | ○ |
| C-02 | opendoor（開発用認証）が存在する | E-02 | ○ |
| C-03 | 認証スキームタイプがNATIVE_APEX_ACCOUNTS | E-01 (`p_scheme_type=>'NATIVE_APEX_ACCOUNTS'`) | ○ |
| C-04 | opendoorがNATIVE_OPEN_DOOR | E-02 (`p_scheme_type=>'NATIVE_OPEN_DOOR'`) | ○ |
| C-05 | Secure Cookieが'N'に設定 | E-01, E-02 (`p_use_secure_cookie_yn=>'N'`) | ○ |
| C-06 | セッション状態コミットがIMMEDIATE | E-04 (`p_session_state_commits=>'IMMEDIATE'`) | ○ |
| C-07 | ブラウザキャッシュが無効化 | E-04 (`p_browser_cache=>'N'`) | ○ |
| C-08 | Rejoin Existing Sessionsが無効化 | E-04 (`p_rejoin_existing_sessions=>'N'`) | ○ |
| C-09 | セッション有効期限がAPEXデフォルト | **根拠なし** | △ |
| C-10 | Administration Rightsセキュリティスキームが存在 | E-03 | ○ |
| C-11 | 認可が`return true;`で実装 | E-03, E-05 (`p_attribute_01=>'return true;'`) | ○ |
| C-12 | セキュリティスキームのキャッシングがBY_USER_BY_PAGE_VIEW | E-03 (`p_caching=>'BY_USER_BY_PAGE_VIEW'`) | ○ |
| C-13 | qa_api_pkgがAUTHID CURRENT_USER | E-06 (`authid current_user`) | ○ |
| C-14 | qa_main_pkgがAUTHID DEFINER | E-07 (`authid definer`) | ○ |
| C-15 | ブラックリストビューでOracleシステムスキーマを除外 | E-10 | ○ |
| C-16 | Browser Frame設定が'D' (Deny) | E-04 (`p_browser_frame=>'D'`) | ○ |
| C-17 | チェックサムソルトが設定されている | E-04 (`p_checksum_salt=>'9AC41E02D...'`) | ○ |
| C-18 | ブックマークチェックサム関数がSHA512 | E-04, E-14 (`p_bookmark_checksum_function=>'SH512'`) | ○ |
| C-19 | HTTPS設定がWebサーバーに依存 | **根拠なし** | △ |
| C-20 | Oracle TDE推奨 | **根拠なし** | △ |
| C-21 | escape_on_http_output設定でXSS対策 | E-13, E-14 (`p_escape_on_http_output=>'Y'`) | ○ |
| C-22 | SQLインジェクション対策でバインド変数使用 | E-06 (`using pi_target_scheme, l_qa_rule.qaru_id, ...`) | ○ |
| C-23 | 入力バリデーションプロシージャが存在 | E-14 (`p_validate_input`) | ○ |
| C-24 | QA_RULESに監査カラムが存在 | E-11 (`qaru_created_on`, `qaru_created_by`, etc.) | ○ |
| C-25 | QA_TEST_RESULTSに監査カラムが存在 | E-12 (`qatr_added_on`, `qatr_added_by`) | ○ |
| C-26 | Loggerフレームワークが条件付きコンパイルで有効化 | E-08 (`$IF qa_constant_pkg.gc_logger_flag = 1`) | ○ |
| C-27 | ログ保持期間がLogger設定に依存 | **根拠なし** | △ |
| C-28 | インストールに必要な最小権限が文書化 | E-15 (README.md) | ○ |

## 4) 不足情報（Unknown / Missing）
- **セッション有効期限**: APEXワークスペースの設定ファイルまたは管理画面での設定値が未確認
  - 候補：APEX管理画面 / ワークスペース設定 / インスタンス設定
- **HTTPS/HSTS設定**: インフラストラクチャ設定（ORDS/Webサーバー）が範囲外
  - 候補：ORDS設定ファイル / Apache/Nginx設定 / ロードバランサー設定
- **Oracle TDE**: データベースレベルの設定であり、アプリケーションコードには含まれない
  - 候補：DBAマニュアル / インフラ設計書
- **ログ保持期間**: Loggerフレームワークの設定ファイルが未確認
  - 候補：Logger設定テーブル / Logger_prefs

## 5) リスクフラグ（レビュー観点）
- **2: 高リスク** - C-11: 認可が`return true;`で全ユーザーに管理者権限が付与されている。本番環境では適切なロールベースアクセス制御の実装が必要
- **1: 中リスク** - C-05: Secure Cookieが'N'に設定されている。HTTPS環境では'Y'への変更を推奨
- **1: 中リスク** - C-02: opendoor認証スキームが存在する。本番環境では無効化が必要
- **0: 低リスク** - C-09, C-19, C-20, C-27: インフラ依存の設定項目。別途インフラ設計書で確認

## 6) レビュアーチェックリスト（最小）
- [ ] 認可実装（`return true;`）が本番環境で適切に変更されているか確認
- [ ] opendoor認証スキームが本番環境で無効化されているか確認
- [ ] Secure Cookie設定がHTTPS環境で有効化されているか確認
- [ ] チェックサムソルト値が環境ごとに適切に設定されているか確認
- [ ] ブラックリストビューに追加すべきスキーマがないか確認
- [ ] Logger設定が本番環境で適切に構成されているか確認
