# セキュリティ設計書

## 概要

本ドキュメントは、QUASTO (Quality Assurance Tool for Oracle databases) のセキュリティ設計について記述する。QUASTOはOracleデータベース用の品質保証ツールであり、Oracle APEX 24.1をフロントエンドとして使用し、PL/SQLパッケージでバックエンド処理を行う。本設計書では、認証・認可、データセキュリティ、入出力対策、監査ログについて説明する。

## 認証設計

### 認証方式

本システムは、Oracle APEXのネイティブ認証機能を使用した認証を採用している。以下の2つの認証スキームが定義されている。

| 認証スキーム名 | 認証タイプ | 用途 | セキュリティレベル |
| --- | --- | --- | --- |
| Oracle APEX Accounts | NATIVE_APEX_ACCOUNTS | 本番環境用 | 高 |
| opendoor | NATIVE_OPEN_DOOR | 開発環境用（認証なし） | 低 |

**本番環境での推奨設定:**
- `Oracle APEX Accounts` を使用し、APEXワークスペースのユーザー管理機能で認証を行う
- `opendoor` スキームは開発・テスト環境専用とし、本番環境では無効化する

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション有効期限 | APEXデフォルト設定に準拠 | ワークスペース設定で管理 |
| セッション固定化対策 | 有効 | APEXビルトイン機能 |
| Secure Cookie | N (設定可) | HTTPS環境ではYに変更を推奨 |
| セッション状態コミット | IMMEDIATE | 即時コミットモード |
| ブラウザキャッシュ | N | セキュリティ考慮で無効化 |
| Rejoin Existing Sessions | N | セッション再利用を無効化 |

### セキュリティ推奨設定

1. **Secure Cookie の有効化**: HTTPS環境では `p_use_secure_cookie_yn => 'Y'` を設定
2. **opendoorスキームの無効化**: 本番環境では開発用認証スキームを削除または無効化

## 認可設計

### 権限体系

| ロール | 権限 | 説明 |
| --- | --- | --- |
| Administration Rights | 全機能へのアクセス | 管理者用セキュリティスキーム |
| 一般ユーザー | ダッシュボード、テスト結果閲覧 | 認証済みユーザー |

### アクセス制御

**セキュリティスキーム:**
- **名称**: Administration Rights
- **タイプ**: NATIVE_FUNCTION_BODY
- **キャッシング**: BY_USER_BY_PAGE_VIEW（ユーザー・ページビュー単位でキャッシュ）
- **現在の実装**: `return true;` （全ユーザーに管理者権限を付与）

**注意事項:**
現在の認可実装は `return true;` となっており、認証済みの全ユーザーが管理者権限を持つ設計になっている。本番環境では、適切なロールベースアクセス制御（RBAC）の実装を推奨する。

**ページ保護レベル:**
- Dashboard (Page 1): Protection Level = 'C' (チェックサム付き)

### スキーマアクセス制御

PL/SQLレベルでのアクセス制御として、以下の機能が実装されている。

**AUTHID設定:**
| パッケージ | AUTHID | 説明 |
| --- | --- | --- |
| qa_api_pkg | CURRENT_USER | 呼び出しユーザーの権限で実行 |
| qa_main_pkg | DEFINER | パッケージ所有者の権限で実行 |
| qa_logger_pkg | DEFINER | パッケージ所有者の権限で実行 |
| qa_export_import_rules_pkg | (DEFINER) | パッケージ所有者の権限で実行 |

**ブラックリスト機能:**
`qa_scheme_names_for_testing_v` ビューにより、テスト対象外のスキーマ（Oracleシステムスキーマ、APEXスキーマ、ORDSスキーマ等）を定義し、これらのスキーマへのアクセスを制限している。

ブラックリスト対象スキーマ（抜粋）:
- Oracleシステム: SYS, SYSTEM, DBSNMP, OUTLN, XDB など
- APEX関連: APEX_LISTENER, APEX_PUBLIC_USER, APEX_REST_PUBLIC_USER, APEX_XXXXXX
- ORDS関連: ORDS_METADATA, ORDS_PUBLIC_USER

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| HTTPS | Oracle APEXサーバー/ORDS設定に依存 |
| HSTS | Webサーバー/ロードバランサー設定に依存 |
| Browser Frame | 'D' (Deny) - iframeでの埋め込みを拒否 |

**注意事項:**
通信の暗号化は、Oracle APEXが動作するWebサーバー（ORDS/Tomcat/Apache等）およびロードバランサーの設定に依存する。アプリケーションレベルでの設定は限定的である。

## データセキュリティ

### 暗号化

| 対象 | 暗号化方式 |
| --- | --- |
| 通信 | Oracleデータベース/Webサーバー設定に依存 |
| 保存データ | Oracle TDE（透過的データ暗号化）を推奨 |
| チェックサムソルト | SHA512ハッシュ（APEX設定） |
| ブックマークチェックサム | SHA512（`p_bookmark_checksum_function=>'SH512'`） |

### 機密情報管理

**チェックサムソルト:**
APEXアプリケーションレベルでチェックサムソルトが設定されている。
- ソルト値: `9AC41E02D39C3D5E83A9E01377D839F72C884F8CF0068184C398674912DC5651`
- 用途: URLパラメータの改ざん検知

**データベース権限:**
インストール時に必要な最小権限:
```sql
grant create procedure, public synonym, sequence, table, trigger, type, view, job to {schemeName};
grant create session to {schemeName};
```

**APEX管理権限（オプション）:**
```sql
grant APEX_ADMINISTRATOR_ROLE to {schemeName};
```

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | APEXビルトインエスケープ機能を使用（`escape_on_http_output=>'Y'`、`HIDDEN_ESCAPE_SC`、`LOV_ESCAPE_SC`等） |
| SQLインジェクション | バインド変数の使用（`:1`, `:2`等のプレースホルダー）、EXECUTE IMMEDIATEでのUSING句使用 |
| CSRF | APEXビルトインCSRF保護（チェックサムベース） |

### XSS対策の実装詳細

- レポートカラムでの `escape_on_http_output=>'Y'` 設定
- フォームアイテムでの `HIDDEN_ESCAPE_SC`、`LOV_ESCAPE_SC` 表示タイプ使用
- APEXプラグインでの `p_default_escape_mode=>'HTML'` 設定

### SQLインジェクション対策の実装詳細

ルール実行時にはバインド変数を使用:
```plsql
execute immediate l_qa_rule.qaru_sql bulk collect
  into l_qa_rules
  using pi_target_scheme, l_qa_rule.qaru_id, l_qa_rule.qaru_category, ...
```

### 入力バリデーション

`qa_unit_tests_pkg` パッケージ内に `p_validate_input` プロシージャが実装され、ユーザー入力の検証を行っている。

APEXページレベルでのバリデーション:
- `Validate Option selected for Generate`
- `Validate if Rule already exists`
- `Validate if Name already exists`
- `Validate if rule can be deleted`

## 監査ログ

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| QA_RULES監査 | ルール作成日時・作成者、更新日時・更新者 | 永続（テーブル内） |
| QA_TEST_RESULTS | テスト結果追加日時・追加者 | 永続（テーブル内） |
| Loggerログ | パラメータ値、エラー情報、スコープ情報 | Logger設定に依存 |

### データ監査カラム

**QA_RULESテーブル:**
| カラム | 説明 |
| --- | --- |
| qaru_created_on | ルール作成日時 |
| qaru_created_by | ルール作成者 |
| qaru_updated_on | ルール更新日時 |
| qaru_updated_by | ルール更新者 |

**QA_TEST_RESULTSテーブル:**
| カラム | 説明 |
| --- | --- |
| qatr_added_on | テスト結果追加日時 |
| qatr_added_by | テスト結果追加者 |

### ロギングフレームワーク

オプションでLogger（オープンソースロギングフレームワーク）を使用可能。
- 条件付きコンパイル（`$IF qa_constant_pkg.gc_logger_flag = 1`）で有効化
- 以下のビューでログを参照可能:
  - `logger_logs`
  - `logger_logs_5_min`
  - `logger_logs_60_min`

**ログ出力例:**
```plsql
qa_logger_pkg.p_qa_log(
  p_text   => 'エラーメッセージ',
  p_scope  => 'パッケージ名.プロシージャ名',
  p_extra  => sqlerrm,
  p_params => l_param_list
);
```

## 備考

### セキュリティ強化推奨事項

1. **認証スキームの見直し**
   - 本番環境では `opendoor` スキームを無効化
   - Secure Cookie設定の有効化（HTTPS環境）

2. **認可の強化**
   - 現在の `return true;` を適切なロールチェックに変更
   - ユーザーロール管理機能の実装

3. **通信セキュリティ**
   - HTTPS/TLSの強制
   - HSTSヘッダーの設定

4. **監査ログの強化**
   - Loggerフレームワークの本番環境での有効化
   - ログの定期的なアーカイブと分析

5. **データベースセキュリティ**
   - Oracle TDEの導入検討
   - 最小権限の原則に基づいたスキーマ設計

### ライセンス

本プロジェクトはMITライセンスで提供されている。
