---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な数値目標がソースコードに記載なし
  2. **Oracle APEXバージョン**：READMEに具体的バージョン記載なし
  3. **性能テストの具体的実施方法**：プロジェクト内に定義なし
  4. **セキュリティテストの具体的実施方法**：プロジェクト内に定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、インストール手順、utPLSQL/Logger説明
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` - ユニットテストパッケージ実装
- E-03: `src/scripts/create_scheduler_job_for_unit_tests.sql` - スケジューラジョブ定義
- E-04: `src/install_utplsql_objects.sql` - utPLSQLオブジェクトインストールスクリプト
- E-05: `src/install_quasto_objects.sql` - QUASTOコアオブジェクトインストールスクリプト
- E-06: `src/install_objects.sql` - インストールスクリプト（引数処理）
- E-07: `src/scripts/qa_rules_mt_ag.json` - サンプルルールファイル
- E-08: `src/scripts/qa_rules_mt_ag_ddl.json` - サンプルDDLルールファイル
- E-09: `src/scripts/export_rules_to_file.sql` - ルールエクスポートスクリプト
- E-10: `src/scripts/import_file_to_rules.js` - ルールインポートスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUASTOはOracle Database上でのコード品質チェックツール | E-01 | ○ |
| C-02 | utPLSQL 3.1.11以上が必要 | E-01 | ○ |
| C-03 | Oracle 19c以上が必要 | E-01 | ○ |
| C-04 | qa_unit_tests_pkgでユニットテストパッケージを自動生成 | E-02 | ○ |
| C-05 | p_create_unit_test_packagesで2つの生成オプション提供 | E-02 | ○ |
| C-06 | JUnit互換XMLレポート出力機能あり | E-02 | ○ |
| C-07 | CRONJOB_RUN_UNIT_TESTSで日次自動テスト実行 | E-03 | ○ |
| C-08 | スケジューラジョブの有効化/無効化が可能 | E-02 | ○ |
| C-09 | QA_TEST_RESULTSテーブルにXML結果を保存 | E-02, E-04 | ○ |
| C-10 | QA_TEST_RUNSテーブルにテスト実行履歴を保存 | E-02, E-04 | ○ |
| C-11 | QA_TEST_RUN_INVALID_OBJECTSに違反オブジェクトを保存 | E-02, E-04 | ○ |
| C-12 | Loggerフレームワークでデバッグ可能 | E-01, E-05 | ○ |
| C-13 | qa_logger_pkgでログ出力 | E-05 | ○ |
| C-14 | qa_api_pkg.tf_run_ruleで個別ルール実行 | E-01 | ○ |
| C-15 | qa_api_pkg.tf_run_rulesで全ルール実行 | E-01 | ○ |
| C-16 | QARU_PREDECESSOR_IDSでテスト順序制御 | E-01 | ○ |
| C-17 | QARU_EXCLUDE_OBJECTSで除外設定 | E-01 | ○ |
| C-18 | JSON形式でルールエクスポート可能 | E-01, E-09 | ○ |
| C-19 | SQLclでルールインポート可能 | E-01, E-10 | ○ |
| C-20 | サンプルルールファイル提供 | E-07, E-08 | ○ |
| C-21 | p_handle_test_exceptionでエラー捕捉 | E-02 | ○ |
| C-22 | ut_junit_reporter使用でXML生成 | E-02 | ○ |
| C-23 | Jenkins/Azure DevOps/GitLab/GitHub連携は将来対応 | E-01 | ○ |
| C-24 | バージョン24.1でAPEX UI機能追加 | E-01 | ○ |
| C-25 | 行カバレッジ目標値 | **根拠なし** | △ |
| C-26 | 分岐カバレッジ目標値 | **根拠なし** | △ |
| C-27 | Oracle APEXの具体的バージョン | **根拠なし** | △ |
| C-28 | 性能テスト・セキュリティテストの具体的手順 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値が未定義**
  - ソースコードおよびREADMEにカバレッジ目標の記載なし
  - 候補：プロジェクト要件定義書 / チームのテスト基準ドキュメント / 組織のQAガイドライン
- **Oracle APEXバージョン情報**
  - READMEに具体的なAPEXバージョン要件の記載なし
  - 候補：APEX export SQL（f141ディレクトリ内） / APEXアプリケーション定義
- **性能テスト・セキュリティテストの詳細手順**
  - プロジェクト内にテスト手順書やテスト計画書が存在しない
  - 候補：別途作成が必要 / 組織のテスト標準ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - utPLSQL連携機能（ソースコードで明確に実装確認済み）
- **0: 低リスク** - スケジューラジョブ機能（create_scheduler_job_for_unit_tests.sqlで確認済み）
- **1: 中リスク** - CI/CD連携（将来対応と明記されているが実装なし）
- **1: 中リスク** - カバレッジ目標（数値目標の根拠なし、チームで決定が必要）
- **2: 高リスク** - テスト環境の具体的構成（インフラ設計書等の参照が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値をプロジェクト要件に基づいて決定・記載すべきか確認
- [ ] Oracle APEXの対応バージョンをAPEXアプリケーション定義から確認
- [ ] CI/CDパイプライン連携の計画・タイムラインを関係者と確認
- [ ] テスト環境構成がチームの実態と一致しているか確認
- [ ] 性能テスト・セキュリティテストの実施要否をプロジェクト要件から確認
