# テスト方針書

## 概要

本ドキュメントは、QUASTO（Quality Assurance Tool for Oracle databases）プロジェクトのテスト方針を定義するものである。QUASTOはOracle Database上でのコード品質チェックとガイドライン検証を行うツールであり、utPLSQL フレームワークとの連携によるユニットテスト機能、Oracle APEX フロントエンド、およびLogger フレームワークによるデバッグ機能を提供する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | QUASTOルールの個別検証、PL/SQLパッケージの関数・プロシージャテスト | 開発者（utPLSQL使用） |
| 結合テスト | ルール実行と結果保存の連携確認、APEX UIとバックエンドの連携テスト | 開発者・QAチーム |
| システムテスト | 複数ルールの一括実行、スケジューラジョブの動作確認、XMLレポート出力検証 | QAチーム |
| 受入テスト | ユーザー定義ルールの実行確認、APEXアプリケーションの操作性確認 | エンドユーザー・顧客 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | QUASTOルール定義・実行・結果表示の機能検証 | 開発完了時、リリース前 |
| 回帰テスト | 既存ルール・機能への影響確認 | コード変更時 |
| 性能テスト | 大量ルール実行時のパフォーマンス測定 | リリース前（必要に応じて） |
| セキュリティテスト | データベース権限、APEX認証・認可の検証 | リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 開発者によるユニットテスト実行 | Oracle 19c以上 + utPLSQL 3.1.11 + APEX（オプション） |
| テスト環境 | 結合テスト・システムテスト実行 | Oracle 19c以上 + utPLSQL + APEX + Logger |
| ステージング環境 | 受入テスト・本番相当の検証 | 本番と同等構成 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| utPLSQL | PL/SQL単体テストフレームワーク | 3.1.11以上 |
| Oracle APEX | フロントエンドUIテスト | 対応バージョン（README未記載） |
| Logger | デバッグ・ログ出力 | 最新安定版 |
| DBMS_SCHEDULER | テスト自動実行（スケジューラジョブ） | Oracle標準 |
| SQL*Plus / SQLcl | テストスクリプト実行 | Oracle標準 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値の記載なし（要検討） |
| 分岐カバレッジ | 明示的な目標値の記載なし（要検討） |
| ルールカバレッジ | アクティブな全ルール（qaru_is_active = 1）100% |

## テストデータ

### テストデータの準備方針

1. **ルール定義データ**
   - `QA_RULES`テーブルにテスト用ルールを定義
   - JSON形式でルールのエクスポート・インポートが可能（`export_rules_to_file.sql`, `import_file_to_rules.js`）
   - サンプルルールファイル: `src/scripts/qa_rules_mt_ag.json`, `src/scripts/qa_rules_mt_ag_ddl.json`

2. **テストスキーマ**
   - `qa_scheme_names_for_testing_v`ビューで定義されたスキーマを対象にテスト実行
   - テスト対象スキーマは動的に指定可能

3. **テスト結果データ**
   - `QA_TEST_RESULTS`: XMLテスト結果を格納
   - `QA_TEST_RUNS`: テスト実行履歴を格納
   - `QA_TEST_RUN_INVALID_OBJECTS`: 検出された違反オブジェクトを格納

## 不具合管理

### 不具合の管理方法

1. **テスト実行時のエラーハンドリング**
   - `qa_unit_tests_pkg.p_handle_test_exception`でランタイムエラーを捕捉・記録
   - エラーバックトレース情報を`QA_TEST_RUNS.qatr_runtime_error`に保存

2. **ログ機能**
   - Loggerフレームワークを使用したデバッグログ
   - `qa_logger_pkg`パッケージによるパラメータ・変数値の記録
   - ログ参照: `logger_logs`, `logger_logs_5_min`, `logger_logs_60_min`ビュー

3. **テスト結果の追跡**
   - テスト結果は`QA_TEST_RESULTS`テーブルにXML形式で永続化
   - JUnit互換XMLフォーマットでのエクスポート機能

## CI/CD連携

### テスト実行方法

1. **手動実行**
   - SQL*Plus/SQLclから`exec ut.run;`でutPLSQLテストを実行
   - 特定ルールの実行: `qa_api_pkg.tf_run_rule()`
   - 全ルールの実行: `qa_api_pkg.tf_run_rules()`

2. **スケジューラジョブによる自動実行**
   - `CRONJOB_RUN_UNIT_TESTS`: 日次でユニットテストを自動実行
   - `qa_unit_tests_pkg.p_run_all_unit_tests`を呼び出し
   - スケジューラジョブの有効化/無効化: `qa_unit_tests_pkg.p_enable_scheduler_cronjob`

3. **CI/CDパイプライン連携（計画中）**
   - Jenkins/Azure DevOps/GitLab/GitHubとの連携は将来リリースで対応予定
   - JUnit互換XMLレポート出力機能により外部CIツールとの連携が可能

### テスト結果レポート

- **JUnit XMLフォーマット**: `ut_junit_reporter()`を使用したXMLレポート生成
- **文字エンコーディング**: Windows-1251（デフォルト、変更可能）
- **レポートのインポート/エクスポート**:
  - `qa_unit_tests_pkg.f_export_test_result`
  - `qa_unit_tests_pkg.f_import_test_result`

## ユニットテスト生成機能

### テストパッケージの自動生成

QUASTOは定義されたルールに基づいてutPLSQL準拠のテストパッケージを自動生成する機能を提供する。

1. **生成オプション**
   - `gc_utplsql_single_package`: クライアント・スキーマごとに1つのパッケージ
   - `gc_utplsql_single_package_per_rule`: ルールごとに1つのパッケージ

2. **生成手順**
   - `qa_unit_tests_pkg.p_create_unit_test_packages()`を呼び出し
   - 対象スキーマを指定可能
   - APEX UIからも生成・削除が可能

3. **テストパッケージ命名規則**
   - プレフィックス: `qa_constant_pkg.gc_utplsql_ut_test_packages_prefix`
   - 形式: `{prefix}_{scheme_name}_{client_name}_pkg`

## 備考

1. **前提条件**
   - Oracle Database 19c以上が必要
   - utPLSQL使用時は事前インストールが必要
   - APEX機能使用時は`APEX_ADMINISTRATOR_ROLE`の付与が推奨

2. **ルールの前提条件定義**
   - `QARU_PREDECESSOR_IDS`カラムでテスト実行順序を制御可能
   - 前提条件ルールが失敗した場合、依存ルールはスキップ

3. **除外オブジェクトの設定**
   - `QARU_EXCLUDE_OBJECTS`カラムで特定オブジェクトをテスト対象から除外可能

4. **将来の機能拡張**
   - Jenkins/Azure DevOps/GitLab/GitHub CI/CD連携の計画あり
   - バージョン24.1でAPEX UIからのテスト管理機能が追加
