# ER図

## 概要

本ドキュメントは、QUASTOプロジェクトのデータベーステーブル間の関係を示すER図（Entity-Relationship Diagram）を記載したものである。

## ER図（Mermaid形式）

```mermaid
erDiagram
    QA_RULES {
        NUMBER QARU_ID PK "主キー"
        VARCHAR2 QARU_RULE_NUMBER "ルール番号"
        VARCHAR2 QARU_CLIENT_NAME "クライアント名"
        VARCHAR2 QARU_NAME "ルール名"
        VARCHAR2 QARU_CATEGORY "カテゴリ(APEX/DDL/DATA)"
        VARCHAR2 QARU_OBJECT_TYPES "オブジェクトタイプ"
        VARCHAR2 QARU_ERROR_MESSAGE "エラーメッセージ"
        VARCHAR2 QARU_COMMENT "コメント"
        VARCHAR2 QARU_EXCLUDE_OBJECTS "除外オブジェクト"
        NUMBER QARU_ERROR_LEVEL "エラーレベル(1/2/4)"
        NUMBER QARU_IS_ACTIVE "有効フラグ(0/1)"
        CLOB QARU_SQL "SQLクエリ"
        VARCHAR2 QARU_PREDECESSOR_IDS "前提ルールID"
        VARCHAR2 QARU_LAYER "レイヤー(PAGE/APPLICATION/DATABASE)"
        DATE QARU_CREATED_ON "作成日時"
        VARCHAR2 QARU_CREATED_BY "作成者"
        DATE QARU_UPDATED_ON "更新日時"
        VARCHAR2 QARU_UPDATED_BY "更新者"
        NUMBER QARU_FAILURE_RATE "失敗率"
        VARCHAR2 QARU_APP_ID "アプリケーションID"
        VARCHAR2 QARU_PAGE_ID "ページID"
    }

    QA_TEST_RUNS {
        NUMBER QATR_ID PK "主キー"
        VARCHAR2 QATR_SCHEME_NAME "スキーマ名"
        DATE QATR_DATE "テスト実行日時"
        NUMBER QATR_RESULT "テスト結果(0/1/2)"
        NUMBER QATR_QARU_ID FK "ルールID"
        VARCHAR2 QATR_ADDED_BY "追加者"
        VARCHAR2 QATR_RUNTIME_ERROR "ランタイムエラー"
        VARCHAR2 QATR_PROGRAM_NAME "プログラム名"
    }

    QA_TEST_RUN_INVALID_OBJECTS {
        NUMBER QATO_ID PK "主キー"
        VARCHAR2 QATO_OBJECT_NAME "オブジェクト名"
        VARCHAR2 QATO_OBJECT_DETAILS "オブジェクト詳細"
        NUMBER QATO_QATR_ID FK "テスト実行ID"
    }

    QA_TEST_RESULTS {
        NUMBER QATR_ID PK "主キー"
        CLOB QATR_XML_RESULT "XML結果"
        DATE QATR_ADDED_ON UK "追加日時"
        VARCHAR2 QATR_ADDED_BY "追加者"
        VARCHAR2 QATR_DESCRIPTION "説明"
    }

    QA_IMPORT_FILES {
        NUMBER QAIF_ID PK "主キー"
        VARCHAR2 QAIF_FILENAME "ファイル名"
        VARCHAR2 QAIF_MIMETYPE "MIMEタイプ"
        CLOB QAIF_CLOB_DATA "CLOBデータ"
        VARCHAR2 QAIF_STATUS "ステータス"
        VARCHAR2 QAIF_ERROR_LOG "エラーログ"
        DATE QAIF_CREATED_ON "作成日時"
        VARCHAR2 QAIF_CREATED_BY "作成者"
        DATE QAIF_UPDATED_ON "更新日時"
        VARCHAR2 QAIF_UPDATED_BY "更新者"
    }

    QA_RULES ||--o{ QA_TEST_RUNS : "has"
    QA_TEST_RUNS ||--o{ QA_TEST_RUN_INVALID_OBJECTS : "has"
```

## リレーションシップ説明

### QA_RULES と QA_TEST_RUNS

- **関係**: 1対多（One-to-Many）
- **説明**: 1つのルール（QA_RULES）に対して、複数のテスト実行（QA_TEST_RUNS）が記録される
- **外部キー**: QA_TEST_RUNS.QATR_QARU_ID は QA_RULES.QARU_ID を参照

### QA_TEST_RUNS と QA_TEST_RUN_INVALID_OBJECTS

- **関係**: 1対多（One-to-Many）
- **説明**: 1回のテスト実行（QA_TEST_RUNS）に対して、複数の不正オブジェクト（QA_TEST_RUN_INVALID_OBJECTS）が検出される可能性がある
- **外部キー**: QA_TEST_RUN_INVALID_OBJECTS.QATO_QATR_ID は QA_TEST_RUNS.QATR_ID を参照

### QA_TEST_RESULTS（独立テーブル）

- **関係**: 独立（他テーブルとの外部キー関係なし）
- **説明**: utPLSQLテスト実行のXML結果を格納する独立したテーブル

### QA_IMPORT_FILES（独立テーブル）

- **関係**: 独立（他テーブルとの外部キー関係なし）
- **説明**: JSONファイルのインポート管理用の独立したテーブル

## テーブル関係の概念図

```
+----------------+       +------------------+       +-----------------------------+
|   QA_RULES     |       |  QA_TEST_RUNS    |       | QA_TEST_RUN_INVALID_OBJECTS |
+----------------+       +------------------+       +-----------------------------+
|  QARU_ID (PK)  |<------| QATR_QARU_ID(FK) |       |                             |
|  ...           |   1:N |  QATR_ID (PK)    |<------| QATO_QATR_ID (FK)           |
+----------------+       |  ...             |   1:N |  QATO_ID (PK)               |
                         +------------------+       |  ...                        |
                                                    +-----------------------------+

+-------------------+     +-------------------+
|  QA_TEST_RESULTS  |     |  QA_IMPORT_FILES  |
+-------------------+     +-------------------+
|  QATR_ID (PK)     |     |  QAIF_ID (PK)     |
|  ...              |     |  ...              |
+-------------------+     +-------------------+
      (独立)                    (独立)
```

## データフロー

1. **ルール定義**: QA_IMPORT_FILESを通じてJSONファイルからルールをインポート、またはQA_RULESに直接登録
2. **テスト実行**: QA_RULESに定義されたルールに基づいてテストを実行し、結果をQA_TEST_RUNSに記録
3. **不正オブジェクト記録**: テスト実行で検出された不正オブジェクトをQA_TEST_RUN_INVALID_OBJECTSに記録
4. **utPLSQLテスト結果**: utPLSQLによるユニットテスト結果はXML形式でQA_TEST_RESULTSに格納
