---
generated_at: 2026-01-21 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-02: `src/ddl/tab/qa_test_runs.sql` - QA_TEST_RUNSテーブル定義
- E-03: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義
- E-04: `src/ddl/tab/qa_import_files.sql` - QA_IMPORT_FILESテーブル定義
- E-05: `src/ddl/tab/qa_test_run_invalid_objects.sql` - QA_TEST_RUN_INVALID_OBJECTSテーブル定義
- E-06: `src/ddl/cons/qa_rules.sql` - QA_RULES制約定義
- E-07: `src/ddl/cons/qa_test_runs.sql` - QA_TEST_RUNS制約定義
- E-08: `src/ddl/cons/qa_test_results.sql` - QA_TEST_RESULTS制約定義
- E-09: `src/ddl/cons/qa_import_files.sql` - QA_IMPORT_FILES制約定義
- E-10: `src/ddl/cons/qa_test_run_invalid_objects.sql` - QA_TEST_RUN_INVALID_OBJECTS制約定義
- E-11: `src/ddl/ind/qa_rules.sql` - QA_RULESインデックス定義
- E-12: `src/ddl/ind/qa_test_runs.sql` - QA_TEST_RUNSインデックス定義
- E-13: `src/ddl/ind/qa_test_results.sql` - QA_TEST_RESULTSインデックス定義
- E-14: `src/ddl/ind/qa_import_files.sql` - QA_IMPORT_FILESインデックス定義
- E-15: `src/ddl/ind/qa_test_run_invalid_objects.sql` - QA_TEST_RUN_INVALID_OBJECTSインデックス定義
- E-16: `src/ddl/seq/qaru_seq.sql` - QARU_SEQシーケンス定義
- E-17: `src/ddl/seq/qatru_seq.sql` - QATRU_SEQシーケンス定義
- E-18: `src/ddl/seq/qatr_seq.sql` - QATR_SEQシーケンス定義
- E-19: `src/ddl/seq/qaif_seq.sql` - QAIF_SEQシーケンス定義
- E-20: `src/ddl/seq/qato_seq.sql` - QATO_SEQシーケンス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QA_RULESテーブルは21カラムを持つ | E-01 | ○ |
| C-02 | QARU_IDは主キーである | E-01, E-06 | ○ |
| C-03 | QARU_CATEGORYはAPEX/DDL/DATAのいずれか | E-06 | ○ |
| C-04 | QARU_ERROR_LEVELは1/2/4のいずれか | E-06 | ○ |
| C-05 | QARU_IS_ACTIVEは0/1のいずれか | E-06 | ○ |
| C-06 | QARU_SQLの長さは32767以下 | E-06 | ○ |
| C-07 | QARU_LAYERはPAGE/APPLICATION/DATABASEのいずれか | E-06 | ○ |
| C-08 | QA_RULESにはQARU_PK_I, QARU_RULE_UNIQUE_I, QARU_NAME_UNIQUE_Iの3つのインデックスがある | E-11 | ○ |
| C-09 | QA_TEST_RUNSテーブルは8カラムを持つ | E-02 | ○ |
| C-10 | QATR_IDは主キーである | E-02, E-07 | ○ |
| C-11 | QATR_QARU_IDはQA_RULES.QARU_IDへの外部キー | E-07 | ○ |
| C-12 | QATR_RESULTは0/1/2のいずれか | E-07 | ○ |
| C-13 | QA_TEST_RUNSにはQATR_PK_Iインデックスがある | E-12 | ○ |
| C-14 | QA_TEST_RUN_INVALID_OBJECTSテーブルは4カラムを持つ | E-05 | ○ |
| C-15 | QATO_IDは主キーである | E-05, E-10 | ○ |
| C-16 | QATO_QATR_IDはQA_TEST_RUNS.QATR_IDへの外部キー | E-10 | ○ |
| C-17 | QA_TEST_RUN_INVALID_OBJECTSにはQATO_PK_Iインデックスがある | E-15 | ○ |
| C-18 | QA_TEST_RESULTSテーブルは5カラムを持つ | E-03 | ○ |
| C-19 | QATR_IDは主キーである（QA_TEST_RESULTS） | E-03, E-08 | ○ |
| C-20 | QATR_ADDED_ONはユニーク制約を持つ | E-08 | ○ |
| C-21 | QA_TEST_RESULTSにはQATR_PK_Iインデックスがある | E-13 | ○ |
| C-22 | QA_IMPORT_FILESテーブルは10カラムを持つ | E-04 | ○ |
| C-23 | QAIF_IDは主キーである | E-04, E-09 | ○ |
| C-24 | QAIF_CREATED_ONのデフォルトはSYSDATE | E-04 | ○ |
| C-25 | QAIF_CREATED_BYのデフォルトはUSER | E-04 | ○ |
| C-26 | QA_IMPORT_FILESにはQAIF_PK_Iインデックスがある | E-14 | ○ |
| C-27 | QARU_SEQシーケンスが存在する | E-16 | ○ |
| C-28 | QATRU_SEQシーケンスが存在する | E-17 | ○ |
| C-29 | QATR_SEQシーケンスが存在する | E-18 | ○ |
| C-30 | QAIF_SEQシーケンスが存在する | E-19 | ○ |
| C-31 | QATO_SEQシーケンスが存在する | E-20 | ○ |
| C-32 | QA_RULESとQA_TEST_RUNSは1対多の関係 | E-07 | ○ |
| C-33 | QA_TEST_RUNSとQA_TEST_RUN_INVALID_OBJECTSは1対多の関係 | E-10 | ○ |
| C-34 | QA_TEST_RESULTSは独立テーブル | E-08 | ○ |
| C-35 | QA_IMPORT_FILESは独立テーブル | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全ての主張がDDLファイルから直接確認されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードのDDL定義から直接抽出されており、高い信頼性があります

## 6) レビュアーチェックリスト（最小）
- [ ] テーブル定義のカラム数とデータ型が実際のDDLと一致しているか確認
- [ ] 制約名と制約条件が正しく記載されているか確認
- [ ] 外部キー関係が正しく記載されているか確認
- [ ] コメント（説明）がDDL内のcomment on文と一致しているか確認
- [ ] シーケンスとテーブルの対応関係が正しいか確認
