# データベース設計書

## 概要

本ドキュメントは、QUASTO（Quality Assurance Tool）プロジェクトのデータベース設計について記載したものである。QUASTOは、Oracle APEXアプリケーションおよびデータベースオブジェクトの品質保証ルールを管理・実行し、テスト結果を記録するためのツールである。

データベースはOracle Databaseを使用しており、5つのテーブル、5つのシーケンス、関連する制約およびインデックスで構成されている。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| QA_RULES | ルール | QAツール用に定義されたルールを管理するテーブル |
| QA_TEST_RUNS | テスト実行 | ルールに基づくテスト実行結果を記録するテーブル |
| QA_TEST_RUN_INVALID_OBJECTS | 不正オブジェクト | テスト実行で検出された不正オブジェクトを記録するテーブル |
| QA_TEST_RESULTS | テスト結果 | utPLSQLテスト実行のXML結果を格納するテーブル |
| QA_IMPORT_FILES | インポートファイル | JSONファイルのインポートを管理するテーブル |

## シーケンス一覧

| シーケンス名 | 対象テーブル | 説明 |
| --- | --- | --- |
| QARU_SEQ | QA_RULES | QA_RULESテーブルの主キー生成用 |
| QATRU_SEQ | QA_TEST_RUNS | QA_TEST_RUNSテーブルの主キー生成用 |
| QATO_SEQ | QA_TEST_RUN_INVALID_OBJECTS | QA_TEST_RUN_INVALID_OBJECTSテーブルの主キー生成用 |
| QATR_SEQ | QA_TEST_RESULTS | QA_TEST_RESULTSテーブルの主キー生成用 |
| QAIF_SEQ | QA_IMPORT_FILES | QA_IMPORT_FILESテーブルの主キー生成用 |

## 各テーブル定義

### 1. QA_RULES

QAツール用に定義されたルールを管理するテーブル。APEX、DDL、DATAの各カテゴリに対するチェックルールを定義し、テスト実行時に使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| QARU_ID | NUMBER | NOT NULL | 主キーカラム |
| QARU_RULE_NUMBER | VARCHAR2(20 CHAR) | NOT NULL | ルール番号 |
| QARU_CLIENT_NAME | VARCHAR2(100 CHAR) | NOT NULL | クライアントプロジェクト名 |
| QARU_NAME | VARCHAR2(100 CHAR) | NOT NULL | ルール名。ルール有効化時やプラグイン出力領域の見出しとして表示される |
| QARU_CATEGORY | VARCHAR2(100 CHAR) | NOT NULL | カテゴリ（APEX/DDL/DATA）。ルールの用途を定義する |
| QARU_OBJECT_TYPES | VARCHAR2(4000 CHAR) | NOT NULL | 各カテゴリに対応するオブジェクトタイプ。コロン区切りのリスト |
| QARU_ERROR_MESSAGE | VARCHAR2(4000 CHAR) | NOT NULL | ルール不適合時に表示されるエラーメッセージ |
| QARU_COMMENT | VARCHAR2(4000 CHAR) | NULL | ルールに関する補足情報 |
| QARU_EXCLUDE_OBJECTS | VARCHAR2(4000 CHAR) | NULL | ルール適用から除外するオブジェクト。コロン区切りのリスト |
| QARU_ERROR_LEVEL | NUMBER | NOT NULL | エラーレベル（1=Error、2=Warning、4=Info）。実行時にフィルタリング可能 |
| QARU_IS_ACTIVE | NUMBER | NOT NULL | ルールの有効/無効（1=有効、0=無効）。デフォルト: 1 |
| QARU_SQL | CLOB | NOT NULL | t_plugin_ruleタイプに基づくSQLクエリ。最大32767文字 |
| QARU_PREDECESSOR_IDS | VARCHAR2(4000 CHAR) | NULL | 前提ルールIDのコロン区切りリスト。前提ルールでエラーがない場合のみ実行 |
| QARU_LAYER | VARCHAR2(100 CHAR) | NOT NULL | レイヤー（PAGE/APPLICATION/DATABASE） |
| QARU_CREATED_ON | DATE | NOT NULL | ルール作成日時 |
| QARU_CREATED_BY | VARCHAR2(255 CHAR) | NOT NULL | ルール作成者 |
| QARU_UPDATED_ON | DATE | NOT NULL | ルール更新日時 |
| QARU_UPDATED_BY | VARCHAR2(255 CHAR) | NOT NULL | ルール更新者 |
| QARU_FAILURE_RATE | NUMBER | NULL | 失敗率 |
| QARU_APP_ID | VARCHAR2(4000 CHAR) | NULL | テスト対象のアプリケーションIDリスト。NULLの場合は全アプリケーションが対象 |
| QARU_PAGE_ID | VARCHAR2(4000 CHAR) | NULL | テスト対象のページIDリスト。NULLの場合は全ページが対象 |

#### 制約

| 制約名 | 種別 | 内容 |
| --- | --- | --- |
| QARU_PK | PRIMARY KEY | QARU_ID |
| QARU_CHK_CATEGORY | CHECK | QARU_CATEGORY IN ('APEX','DDL','DATA') |
| QARU_CHK_ERROR_LEVEL | CHECK | QARU_ERROR_LEVEL IN (1,2,4) |
| QARU_CHK_IS_ACTIVE | CHECK | QARU_IS_ACTIVE IN (0,1) |
| QARU_CHK_SQL | CHECK | length(QARU_SQL) <= 32767 |
| QARU_CHK_LAYER | CHECK | QARU_LAYER IN ('PAGE','APPLICATION','DATABASE') |

#### インデックス

| インデックス名 | 種別 | カラム |
| --- | --- | --- |
| QARU_PK_I | UNIQUE | QARU_ID |
| QARU_RULE_UNIQUE_I | UNIQUE | QARU_RULE_NUMBER, QARU_CLIENT_NAME |
| QARU_NAME_UNIQUE_I | UNIQUE | QARU_NAME, QARU_CLIENT_NAME |

---

### 2. QA_TEST_RUNS

テスト実行の結果を記録するテーブル。各ルールに対するテスト実行の履歴を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| QATR_ID | NUMBER | NOT NULL | 主キーカラム |
| QATR_SCHEME_NAME | VARCHAR2(255 CHAR) | NOT NULL | テスト実行対象のスキーマ名 |
| QATR_DATE | DATE | NOT NULL | テスト実行日時 |
| QATR_RESULT | NUMBER | NOT NULL | テスト結果（0/1/2） |
| QATR_QARU_ID | NUMBER | NOT NULL | QA_RULES.QARU_IDへの外部キー |
| QATR_ADDED_BY | VARCHAR2(255 CHAR) | NOT NULL | テスト実行追加者 |
| QATR_RUNTIME_ERROR | VARCHAR2(4000 CHAR) | NULL | ランタイムエラーのバックトレース情報 |
| QATR_PROGRAM_NAME | VARCHAR2(4000 CHAR) | NULL | ユニットテストプロシージャ名 |

#### 制約

| 制約名 | 種別 | 内容 |
| --- | --- | --- |
| QATRU_PK | PRIMARY KEY | QATR_ID |
| QATR_QARU_ID_FK | FOREIGN KEY | QATR_QARU_ID REFERENCES QA_RULES(QARU_ID) |
| QATR_CHK_RESULT | CHECK | QATR_RESULT IN (0,1,2) |

#### インデックス

| インデックス名 | 種別 | カラム |
| --- | --- | --- |
| QATR_PK_I | UNIQUE | QATR_ID |

---

### 3. QA_TEST_RUN_INVALID_OBJECTS

テスト実行で検出された不正オブジェクトを記録するテーブル。QA_TEST_RUNSと1対多の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| QATO_ID | NUMBER | NOT NULL | 主キーカラム |
| QATO_OBJECT_NAME | VARCHAR2(4000 CHAR) | NOT NULL | 不正オブジェクト名 |
| QATO_OBJECT_DETAILS | VARCHAR2(4000 CHAR) | NOT NULL | オブジェクトの詳細情報 |
| QATO_QATR_ID | NUMBER | NOT NULL | QA_TEST_RUNS.QATR_IDへの外部キー |

#### 制約

| 制約名 | 種別 | 内容 |
| --- | --- | --- |
| QATO_PK | PRIMARY KEY | QATO_ID |
| QATO_QATR_ID_FK | FOREIGN KEY | QATO_QATR_ID REFERENCES QA_TEST_RUNS(QATR_ID) |

#### インデックス

| インデックス名 | 種別 | カラム |
| --- | --- | --- |
| QATO_PK_I | UNIQUE | QATO_ID |

---

### 4. QA_TEST_RESULTS

utPLSQLテスト実行のXML結果を格納するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| QATR_ID | NUMBER | NOT NULL | 主キーカラム |
| QATR_XML_RESULT | CLOB | NOT NULL | utPLSQLテスト実行のXML結果 |
| QATR_ADDED_ON | DATE | NOT NULL | テスト結果追加日時 |
| QATR_ADDED_BY | VARCHAR2(255 CHAR) | NOT NULL | テスト結果追加者 |
| QATR_DESCRIPTION | VARCHAR2(255 CHAR) | NOT NULL | テスト結果の説明 |

#### 制約

| 制約名 | 種別 | 内容 |
| --- | --- | --- |
| QATR_PK | PRIMARY KEY | QATR_ID |
| QATR_CHK_ADDED_ON | UNIQUE | QATR_ADDED_ON |

#### インデックス

| インデックス名 | 種別 | カラム |
| --- | --- | --- |
| QATR_PK_I | UNIQUE | QATR_ID |

---

### 5. QA_IMPORT_FILES

JSONファイルのインポートを管理するテーブル。ルール定義等のインポート処理に使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| QAIF_ID | NUMBER | NOT NULL | 主キーカラム |
| QAIF_FILENAME | VARCHAR2(200 CHAR) | NOT NULL | インポートファイル名 |
| QAIF_MIMETYPE | VARCHAR2(200 CHAR) | NOT NULL | ファイルのMIMEタイプ |
| QAIF_CLOB_DATA | CLOB | NOT NULL | CLOBファイルデータ |
| QAIF_STATUS | VARCHAR2(50 CHAR) | NULL | アップロードステータス |
| QAIF_ERROR_LOG | VARCHAR2(4000 CHAR) | NULL | ステータスがERRORの場合のエラー原因 |
| QAIF_CREATED_ON | DATE | NULL | ファイルアップロード日時。デフォルト: SYSDATE |
| QAIF_CREATED_BY | VARCHAR2(255 CHAR) | NULL | ファイルアップロード者。デフォルト: USER |
| QAIF_UPDATED_ON | DATE | NULL | 最終更新日時。デフォルト: SYSDATE |
| QAIF_UPDATED_BY | VARCHAR2(255) | NULL | 最終更新者。デフォルト: USER |

#### 制約

| 制約名 | 種別 | 内容 |
| --- | --- | --- |
| QAIF_PK | PRIMARY KEY | QAIF_ID |

#### インデックス

| インデックス名 | 種別 | カラム |
| --- | --- | --- |
| QAIF_PK_I | UNIQUE | QAIF_ID |

## 備考

### 命名規則

- テーブル名: `QA_`プレフィックス + 機能名
- カラム名: テーブル接頭辞（4文字） + アンダースコア + カラム名
  - QARU: QA_RULES
  - QATR: QA_TEST_RUNS / QA_TEST_RESULTS（同一プレフィックス）
  - QATO: QA_TEST_RUN_INVALID_OBJECTS
  - QAIF: QA_IMPORT_FILES
- 主キーカラム: テーブル接頭辞 + `_ID`
- 外部キーカラム: テーブル接頭辞 + `_` + 参照テーブル接頭辞 + `_ID`
- シーケンス: テーブル接頭辞 + `_SEQ`
- 主キー制約: テーブル接頭辞 + `_PK`
- 外部キー制約: カラム名 + `_FK`
- チェック制約: テーブル接頭辞 + `_CHK_` + チェック対象
- インデックス: 制約名 + `_I` または カラム名 + `_UNIQUE_I`

### エラーレベルについて

QA_RULESテーブルのQARU_ERROR_LEVELカラムは以下の値を取る：

| 値 | 意味 |
| --- | --- |
| 1 | Error（エラー） |
| 2 | Warning（警告） |
| 4 | Info（情報） |

### テスト結果について

QA_TEST_RUNSテーブルのQATR_RESULTカラムは以下の値を取る：

| 値 | 意味 |
| --- | --- |
| 0 | 成功 |
| 1 | 失敗 |
| 2 | エラー |

### レイヤーについて

QA_RULESテーブルのQARU_LAYERカラムは以下の値を取る：

| 値 | 意味 |
| --- | --- |
| PAGE | APEXの単一ページに関連するルール |
| APPLICATION | APEXアプリケーション全体に関連するルール |
| DATABASE | データベースオブジェクトに関連するルール |
