---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/create_scheduler_job_for_unit_tests.sql`
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql`
- E-03: `src/scripts/export_rules_to_file.sql`
- E-04: `src/scripts/import_file_to_rules.js`
- E-05: `src/scripts/import_qa_import_file_to_qa_rules.sql`
- E-06: `src/scripts/recompile_quasto_objects.sql`
- E-07: `src/scripts/recompile_apex_objects.sql`
- E-08: `src/scripts/recompile_utplsql_objects.sql`
- E-09: `src/plsql/pkg/qa_export_import_rules_pkg.sql`
- E-10: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CRONJOB_RUN_UNIT_TESTSは毎日実行される定期ジョブである | E-01（repeat_interval => 'FREQ=DAILY'）, E-02 | ○ |
| C-02 | CRONJOB_RUN_UNIT_TESTSはqa_unit_tests_pkg.p_run_all_unit_testsを実行する | E-01（job_action => 'BEGIN qa_unit_tests_pkg.p_run_all_unit_tests; END;'）| ○ |
| C-03 | カスタムユニットテストジョブはAPEXアプリからトリガー可能 | E-02（p_create_custom_unit_test_job手続き、コメント参照）| ○ |
| C-04 | export_rules_to_file.sqlはJSON形式でルールをエクスポートする | E-03, E-09（f_export_rules_table_to_clob関数）| ○ |
| C-05 | import_file_to_rules.jsはSQLclで実行する必要がある | E-04, E-10（README.md内の説明）| ○ |
| C-06 | import_qa_import_file_to_qa_rules.sqlはimport_file_to_rules.jsから呼び出される | E-04（sql_import = "@import_qa_import_file_to_qa_rules.sql"）, E-05 | ○ |
| C-07 | recompile_quasto_objects.sqlはコアオブジェクトを再コンパイルする | E-06（対象オブジェクト一覧がソースコード内に定義）| ○ |
| C-08 | recompile_apex_objects.sql/recompile_utplsql_objects.sqlは各種オブジェクトを再コンパイルする | E-07, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点では不足情報なし
- 全てのバッチ処理はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] CRONJOB_RUN_UNIT_TESTSのスケジュール設定（毎日実行）が業務要件に合致しているか確認
- [ ] カスタムユニットテストジョブのauto_drop設定が適切か確認
- [ ] エクスポート/インポートスクリプトのJSON形式がプロジェクト標準に準拠しているか確認
- [ ] 再コンパイルスクリプトの対象オブジェクト一覧が最新のコードベースと一致しているか確認
