# バッチ設計書 1-CRONJOB_RUN_UNIT_TESTS

## 概要

本ドキュメントは、QUASTOシステムにおける定期ユニットテスト実行スケジューラジョブ「CRONJOB_RUN_UNIT_TESTS」の設計仕様を記載したものです。

### 本バッチの処理概要

CRONJOB_RUN_UNIT_TESTSは、QUASTOシステムのコード品質チェックルールに基づくユニットテストを自動的に実行し、テスト結果をデータベースに保存する定期実行ジョブです。

**業務上の目的・背景**：QUASTOはOracle PL/SQLコードの品質を検証するためのフレームワークであり、定義されたルールに従ってデータベースオブジェクトの品質チェックを行います。本ジョブは、手動実行の手間を省き、継続的にコード品質を監視することで、開発チームが早期に問題を発見し、コード品質を維持・向上させることを目的としています。定期的なテスト実行により、新たに発生した無効オブジェクトや品質違反を迅速に検出できます。

**バッチの実行タイミング**：日次（FREQ=DAILY）で実行されます。デフォルトでは無効状態で作成され、管理者が明示的に有効化する必要があります。開始日時は2023年7月7日01:00に設定されています。

**主要な処理内容**：
1. `qa_unit_tests_pkg.p_run_all_unit_tests`プロシージャを呼び出し
2. utPLSQL フレームワークを使用して全QUASTOユニットテストパッケージを実行
3. テスト結果をXML形式で生成し、`QA_TEST_RESULTS`テーブルに保存
4. 各スキーマごとのテスト結果を`QA_TEST_RUNS`テーブルに記録
5. 無効なオブジェクトの詳細を`QA_TEST_RUN_INVALID_OBJECTS`テーブルに保存

**前後の処理との関連**：本ジョブ実行前に、QUASTOルールが`QA_RULES`テーブルに定義されている必要があります。また、`p_create_unit_test_packages`により生成されたutPLSQLテストパッケージが存在している必要があります。後続処理として、APEXアプリケーションでテスト結果を閲覧・分析できます。

**影響範囲**：`QA_TEST_RESULTS`、`QA_TEST_RUNS`、`QA_TEST_RUN_INVALID_OBJECTS`テーブルにデータが挿入されます。QUASTOスキーマ内のユニットテストパッケージが実行されるため、テスト対象スキーマへの読み取りアクセスが発生します。

## バッチ種別

テスト実行 / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 01:00 |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | DBMS_SCHEDULER (cron) |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ルール定義 | `QA_RULES`テーブルに少なくとも1つのアクティブなルールが定義されていること |
| テストパッケージ | utPLSQLテストパッケージが生成済みであること |
| スケジューラジョブ有効化 | ジョブが有効状態（enabled=true）に設定されていること |
| utPLSQLインストール | utPLSQLフレームワークがインストールされていること |

### 実行可否判定

- スケジューラジョブが有効状態である場合のみ実行されます
- ジョブは重複実行を防ぐため、同一ジョブが実行中の場合は新規実行が抑制されます
- `f_is_job_running`関数によりジョブの実行状態が確認されます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | ジョブ自体にはパラメータなし（number_of_arguments = 0） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| QA_RULES | DBテーブル | テスト対象のルール定義 |
| QA_SCHEME_NAMES_FOR_TESTING_V | DBビュー | テスト対象スキーマ一覧 |
| USER_OBJECTS | DBテーブル | utPLSQLテストパッケージ情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| QA_TEST_RESULTS | DBテーブル | XML形式のテスト結果全体 |
| QA_TEST_RUNS | DBテーブル | スキーマごとのテスト実行結果 |
| QA_TEST_RUN_INVALID_OBJECTS | DBテーブル | 検出された無効オブジェクトの詳細 |

### 出力ファイル仕様

ファイル出力はありません。テスト結果はすべてデータベーステーブルに保存されます。

## 処理フロー

### 処理シーケンス

```
1. ジョブ起動
   └─ DBMS_SCHEDULERによりPL/SQLブロック実行
2. p_run_all_unit_tests呼び出し
   └─ qa_unit_tests_pkg.p_run_all_unit_tests実行
3. f_run_all_unit_tests実行
   └─ スートパス取得（f_get_suitepath）
4. utPLSQL実行
   └─ ut.run()によりテストスイート実行
5. 結果XML生成
   └─ ut_junit_reporter()でJUnit形式XML生成
6. 結果保存
   └─ QA_TEST_RESULTSテーブルにINSERT
7. 個別テスト結果処理
   └─ p_handle_test_resultで各テスト結果を処理
8. 無効オブジェクト記録
   └─ p_save_scheme_faulty_objectsで詳細保存
```

### フローチャート

```mermaid
flowchart TD
    A[スケジューラジョブ起動] --> B[p_run_all_unit_tests呼び出し]
    B --> C[スートパス取得]
    C --> D[utPLSQL ut.run実行]
    D --> E[XML結果生成]
    E --> F[QA_TEST_RESULTSに保存]
    F --> G{テスト結果あり?}
    G -->|あり| H[p_handle_test_result実行]
    H --> I[QA_TEST_RUNSに保存]
    I --> J{無効オブジェクトあり?}
    J -->|あり| K[QA_TEST_RUN_INVALID_OBJECTSに保存]
    J -->|なし| L[次のテスト結果へ]
    K --> L
    L --> G
    G -->|なし| M[ジョブ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト結果全体保存 | QA_TEST_RESULTS | INSERT | XML形式の全体テスト結果を保存 |
| スキーマ別結果保存 | QA_TEST_RUNS | INSERT | 各スキーマのテスト結果を保存 |
| 無効オブジェクト保存 | QA_TEST_RUN_INVALID_OBJECTS | INSERT | 検出された無効オブジェクトの詳細を保存 |
| ルール参照 | QA_RULES | SELECT | テスト対象ルールの取得 |
| スキーマ参照 | QA_SCHEME_NAMES_FOR_TESTING_V | SELECT | テスト対象スキーマの取得 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QATR_XML_RESULT | utPLSQL実行結果のXML | CLOB型 |
| INSERT | QATR_DESCRIPTION | 'Executed by Suite Path: ' + スートパス | 実行方法の説明 |

#### QA_TEST_RUNS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QATR_SCHEME_NAME | 対象スキーマ名 | テスト対象スキーマ |
| INSERT | QATR_DATE | SYSDATE | 実行日時 |
| INSERT | QATR_RESULT | 0:成功, 1:失敗, 2:エラー | テスト結果ステータス |
| INSERT | QATR_QARU_ID | ルールID | QA_RULESへの外部キー |
| INSERT | QATR_PROGRAM_NAME | プログラム名 | 実行したテストプロシージャ名 |

#### QA_TEST_RUN_INVALID_OBJECTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QATO_OBJECT_NAME | 無効オブジェクト名 | 検出されたオブジェクト名 |
| INSERT | QATO_OBJECT_DETAILS | オブジェクト詳細 | 追加情報 |
| INSERT | QATO_QATR_ID | テスト実行ID | QA_TEST_RUNSへの外部キー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | アプリケーションエラー | 必須パラメータ不足 | パラメータを確認して再実行 |
| ORA-* | Oracleエラー | utPLSQL実行時エラー | qa_logger_pkgでログ記録後、例外を再スロー |
| - | ランタイムエラー | テストプロシージャ内エラー | p_handle_test_exceptionで記録し、QATR_RUNTIME_ERRORに保存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 設定なし（DBMS_SCHEDULERのデフォルト動作） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. `QA_LOGS`テーブルでエラーログを確認
2. `USER_SCHEDULER_JOB_RUN_DETAILS`でジョブ実行履歴を確認
3. 必要に応じて`p_trigger_scheduler_cronjob`で手動再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | テスト結果ごと（autonomous_transaction使用） |
| コミットタイミング | p_handle_test_result内でCOMMIT |
| ロールバック条件 | 個別テスト結果の保存失敗時は該当結果のみロールバック |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ルール数 × 対象スキーマ数 |
| 目標処理時間 | ルール複雑性により変動 |
| メモリ使用量上限 | dbms_output buffer_size: 1000000 |

## 排他制御

- `f_is_job_running`関数により同一ジョブの重複実行を防止
- `USER_SCHEDULER_RUNNING_JOBS`ビューでジョブ実行状態を確認
- 同一ジョブが実行中の場合、手動トリガー時にエラー（-20001）発生

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト実行開始時 | - |
| 進捗ログ | 各テスト結果処理時 | XML形式でResults/Scheme/Object情報をdbms_outputに出力 |
| 終了ログ | テスト実行完了時 | - |
| エラーログ | エラー発生時 | qa_logger_pkg.p_qa_logでQA_LOGSテーブルに記録 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ実行状態 | enabled = TRUE/FALSE | APEXアプリケーション画面 |
| ジョブ実行中状態 | USER_SCHEDULER_RUNNING_JOBS | APEXアプリケーション画面 |

## 備考

- ジョブはデフォルトで無効状態（enabled=false）で作成されます
- ジョブの有効化/無効化は`qa_unit_tests_pkg.p_enable_scheduler_cronjob`プロシージャで行います
- ジョブ名は`gc_utplsql_scheduler_cronjob_name`定数で定義されています（'CRONJOB_RUN_UNIT_TESTS'）
- `auto_drop = false`のため、ジョブは実行後も削除されません
- 文字セットはデフォルトで'Windows-1251'が使用されます
