# バッチ設計書 2-カスタムユニットテストジョブ

## 概要

本ドキュメントは、QUASTOシステムにおける個別ユニットテスト実行用のオンデマンドスケジューラジョブの設計仕様を記載したものです。

### 本バッチの処理概要

カスタムユニットテストジョブは、特定のルール番号・クライアント名・スキーマ名を指定して、単一のQUASTOルールに対するユニットテストをオンデマンドで実行するスケジューラジョブです。

**業務上の目的・背景**：QUASTOの定期実行ジョブ（CRONJOB_RUN_UNIT_TESTS）は全ルールを一括でテストしますが、開発者やQA担当者が特定のルールのみを即座にテストしたい場合があります。例えば、新規ルールの動作確認、既存ルールの修正後の検証、特定スキーマへの影響確認などのシナリオです。本ジョブは、APEXアプリケーションのUIから簡単にトリガーでき、必要なテストだけを素早く実行できる機能を提供します。

**バッチの実行タイミング**：APEXアプリケーションから手動でトリガーされた際に実行されます。ジョブは作成後5秒後に実行開始され、実行完了後は自動的に削除されます（auto_drop=true）。

**主要な処理内容**：
1. DBMS_SCHEDULERでカスタムジョブを動的に作成
2. 指定されたルール番号、クライアント名、スキーマ名でユニットテストを実行
3. `qa_unit_tests_pkg.p_run_custom_unit_test`プロシージャを呼び出し
4. テスト結果をXML形式で生成し、`QA_TEST_RESULTS`テーブルに保存
5. ジョブ完了後、自動的にジョブを削除

**前後の処理との関連**：本ジョブ実行前に、対象ルールが`QA_RULES`テーブルに定義されており、かつutPLSQLテストパッケージが生成されている必要があります。APEXアプリケーションから呼び出される前提で設計されています。

**影響範囲**：`QA_TEST_RESULTS`テーブルにテスト結果XMLが挿入されます。`USER_SCHEDULER_JOBS`に一時的なジョブエントリが作成されますが、実行後は自動削除されます。

## バッチ種別

テスト実行 / オンデマンド品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（オンデマンド） |
| 実行時刻 | 作成後5秒後 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | APEXアプリケーション/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ルール定義 | 対象ルールが`QA_RULES`テーブルに存在すること |
| テストパッケージ | 対象ルールのutPLSQLテストパッケージが生成済みであること |
| スキーマ存在 | 指定されたスキーマ名がテスト対象スキーマビューに存在すること |
| utPLSQLインストール | utPLSQLフレームワークがインストールされていること |

### 実行可否判定

- `f_exists_custom_job`関数により、同一パラメータのジョブが既に存在するかを確認
- 同一パラメータのジョブが実行中の場合、新規作成が可能（タイムスタンプで区別）
- ジョブ名の一意性は末尾のタイムスタンプで保証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pi_qaru_rule_number | qa_rules.qaru_rule_number%type | Yes | - | 実行対象のルール番号 |
| pi_qaru_client_name | qa_rules.qaru_client_name%type | Yes | - | ルールが属するクライアント名 |
| pi_scheme_name | varchar2 | Yes | - | テスト対象のスキーマ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| QA_RULES | DBテーブル | ルール定義（ルール番号、クライアント名の検証） |
| USER_OBJECTS | DBテーブル | utPLSQLテストパッケージの存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| QA_TEST_RESULTS | DBテーブル | XML形式のテスト結果 |
| USER_SCHEDULER_JOBS | システムビュー | 一時的なジョブエントリ（実行後削除） |

### 出力ファイル仕様

ファイル出力はありません。テスト結果はすべてデータベーステーブルに保存されます。

## 処理フロー

### 処理シーケンス

```
1. ジョブ作成リクエスト
   └─ p_create_custom_unit_test_job呼び出し
2. ジョブ名生成
   └─ f_get_job_nameでベース名取得 + タイムスタンプ付加
3. DBMS_SCHEDULERでジョブ作成
   └─ start_date = systimestamp + 5秒
4. ジョブ実行（5秒後）
   └─ p_run_custom_unit_test呼び出し
5. ユニットテスト呼び出し取得
   └─ f_get_unit_test_callでプロシージャ名取得
6. utPLSQL実行
   └─ ut.run()で単一テスト実行
7. 結果保存
   └─ QA_TEST_RESULTSにINSERT
8. ジョブ自動削除
   └─ auto_drop=trueにより削除
```

### フローチャート

```mermaid
flowchart TD
    A[APEXアプリからリクエスト] --> B[p_create_custom_unit_test_job呼び出し]
    B --> C[ジョブ名生成]
    C --> D[DBMS_SCHEDULER.CREATE_JOB]
    D --> E[5秒待機]
    E --> F[p_run_custom_unit_test実行]
    F --> G[f_get_unit_test_call]
    G --> H[utPLSQL ut.run実行]
    H --> I[XML結果生成]
    I --> J[QA_TEST_RESULTSに保存]
    J --> K[ジョブ自動削除]
    K --> L[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ジョブ作成 | USER_SCHEDULER_JOBS | INSERT（内部） | DBMSスケジューラジョブ作成 |
| テスト結果保存 | QA_TEST_RESULTS | INSERT | テスト結果XMLを保存 |
| ルール検索 | QA_RULES | SELECT | ルール情報の取得 |
| パッケージ検索 | USER_OBJECTS | SELECT | テストパッケージ名の取得 |
| ジョブ削除 | USER_SCHEDULER_JOBS | DELETE（内部） | auto_dropによる自動削除 |

### テーブル別操作詳細

#### QA_TEST_RESULTS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QATR_XML_RESULT | utPLSQL実行結果のXML | CLOB型 |
| INSERT | QATR_DESCRIPTION | 'Executed by PL/SQL Call: ' + プロシージャ名 | 実行方法の説明 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -20001 | アプリケーションエラー | 必須パラメータ不足（rule_number, client_name, scheme_name, character_set） | パラメータを確認して再実行 |
| NO_DATA_FOUND | Oracleエラー | 指定されたルール/パッケージが存在しない | ルール定義とパッケージ生成を確認 |
| ORA-* | Oracleエラー | utPLSQL実行時エラー | qa_logger_pkgでログ記録後、例外を再スロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ワンショット実行） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. `QA_LOGS`テーブルでエラーログを確認
2. `USER_SCHEDULER_JOB_RUN_DETAILS`でジョブ実行履歴を確認
3. 必要に応じて同一パラメータでジョブを再作成

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ジョブ内の処理全体 |
| コミットタイミング | テスト結果INSERT後に暗黙的コミット |
| ロールバック条件 | エラー発生時はロールバック |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ルール × 1スキーマ |
| 目標処理時間 | ルールの複雑性により変動（通常数秒〜数分） |
| メモリ使用量上限 | dbms_output buffer_size: 1000000 |

## 排他制御

- ジョブ名にタイムスタンプを含めることで、同一パラメータでも複数ジョブを作成可能
- ジョブ名形式: `QUASTO_UT_CUSTOM_{SCHEME}_{CLIENT}_{RULE}_{YYYYMMDDHH24MISS}`
- `f_exists_custom_job`でジョブ存在確認が可能（LIKEで前方一致検索）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | - | - |
| 進捗ログ | - | - |
| 終了ログ | - | - |
| エラーログ | エラー発生時 | qa_logger_pkg.p_qa_logでQA_LOGSテーブルに記録 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ存在確認 | f_exists_custom_job = 'Y' | APEXアプリケーション |
| ジョブ実行状態 | USER_SCHEDULER_RUNNING_JOBS | APEXアプリケーション |

## 備考

- ジョブは`auto_drop=true`設定のため、実行完了後に自動削除されます
- ジョブの開始時刻は作成時刻の5秒後に設定されます
- ジョブ名の定数は`gc_utplsql_custom_scheduler_job_name`（'QUASTO_UT_CUSTOM'）で定義されています
- 文字セットはデフォルトで'Windows-1251'が使用されます
- コメントには「Custom Job to run an Unit Test triggered by APEX app」と記録されます
