# バッチ設計書 3-export_rules_to_file

## 概要

本ドキュメントは、QUASTOシステムにおけるルールエクスポートスクリプト「export_rules_to_file.sql」の設計仕様を記載したものです。

### 本バッチの処理概要

export_rules_to_file.sqlは、QA_RULESテーブルに格納されているQUASTOルール定義をJSON形式でファイルにエクスポートするSQL*Plusスクリプトです。

**業務上の目的・背景**：QUASTOのルール定義は`QA_RULES`テーブルにデータベース上で管理されていますが、環境間でのルール移行（開発→テスト→本番）、ルールのバックアップ、他システムとのルール共有、バージョン管理などの目的でルールをファイルとしてエクスポートする必要があります。本スクリプトは、指定されたクライアント名（および任意でカテゴリ）のルールをJSON形式で出力し、ポータブルなルール定義ファイルを生成します。

**バッチの実行タイミング**：手動実行（随時）。環境移行前、定期バックアップ、またはルール変更後のアーカイブ作成時に実行されます。

**主要な処理内容**：
1. SQL*Plusで引数としてクライアント名とカテゴリ（任意）を受け取る
2. `qa_export_import_rules_pkg.f_export_rules_table_to_clob`関数を呼び出し
3. ルールデータをJSON形式に変換
4. SPOOLコマンドでJSONファイルを出力

**前後の処理との関連**：エクスポートされたJSONファイルは、`import_file_to_rules.js`スクリプトで別環境にインポート可能です。ルール変更履歴の管理やCI/CDパイプラインでの自動エクスポートにも利用できます。

**影響範囲**：読み取り専用の処理のため、データベースへの変更はありません。ファイルシステムに出力ファイルが作成されます。

## バッチ種別

データエクスポート / バックアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（SQL*Plus/SQLcl実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | SQL*PlusまたはSQLclでQUASTOスキーマに接続していること |
| ルール存在 | 指定クライアント名のルールが`QA_RULES`テーブルに存在すること |
| 書き込み権限 | 実行ディレクトリにファイル書き込み権限があること |

### 実行可否判定

- 指定されたクライアント名のルールが存在しない場合、「No rules found.」メッセージを出力して終了
- カテゴリが指定されていない場合は全カテゴリが対象

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| &1 (l_client_name) | varchar2 | Yes | - | エクスポート対象のクライアント名 |
| &2 (l_category) | varchar2 | No | null | フィルタするカテゴリ（指定時はそのカテゴリのみ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| QA_RULES | DBテーブル | ルール定義データ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ファイルシステム | JSON | エクスポートされたルール定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `qa_rules_{client_name}.json`（カテゴリ指定時: `qa_rules_{client_name}_{category}.json`） |
| 出力先 | スクリプト実行ディレクトリ |
| 文字コード | データベースの文字セットに依存 |
| 区切り文字 | - |

#### JSON出力フォーマット

```json
{
  "version": 1.1,
  "qa_rules": [
    {
      "client_names": [
        {
          "client_name": "CLIENT_NAME",
          "categories": [
            {
              "category": "CATEGORY_NAME",
              "rules": [
                {
                  "rule_number": "RULE_001",
                  "name": "Rule Name",
                  "object_types": "TABLE",
                  "error_message": "Error message",
                  "comment": "Comment",
                  "exclude_objects": "",
                  "error_level": 1,
                  "is_active": 1,
                  "sql": "SELECT ...",
                  "predecessor_ids": "",
                  "layer": "PLSQL"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}
```

## 処理フロー

### 処理シーケンス

```
1. SQL*Plus設定
   └─ head off, feedback on, linesize 32767等を設定
2. 引数取得
   └─ &1 → l_client_name, &2 → l_category
3. ファイル名生成
   └─ 'qa_rules_' + client_name + [category] + '.json'
4. CLOB変数宣言
   └─ variable contents clob
5. PL/SQLブロック実行
   └─ g_spool_active := true（出力抑制）
   └─ f_export_rules_table_to_clob呼び出し
6. SPOOLでファイル出力
   └─ print contents
7. SPOOL終了
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[SQL*Plus設定]
    B --> C[引数取得]
    C --> D[ファイル名生成]
    D --> E[f_export_rules_table_to_clob呼び出し]
    E --> F{ルール存在?}
    F -->|あり| G[JSONデータ生成]
    F -->|なし| H[No rules found出力]
    G --> I[SPOOLでファイル出力]
    H --> J[終了]
    I --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルール件数確認 | QA_RULES | SELECT COUNT | エクスポート対象ルール数の確認 |
| クライアント取得 | QA_RULES | SELECT | クライアント名の一覧取得 |
| カテゴリ取得 | QA_RULES | SELECT | カテゴリの一覧取得 |
| ルール取得 | QA_RULES | SELECT | ルール詳細データの取得 |

### テーブル別操作詳細

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | qaru_client_name | WHERE句でフィルタ | クライアント名条件 |
| SELECT | qaru_category | WHERE句でフィルタ（任意） | カテゴリ条件 |
| SELECT | qaru_rule_number | JSONに出力 | ルール番号 |
| SELECT | qaru_name | JSONに出力 | ルール名 |
| SELECT | qaru_object_types | JSONに出力 | 対象オブジェクトタイプ |
| SELECT | qaru_error_message | JSONに出力 | エラーメッセージ |
| SELECT | qaru_comment | JSONに出力 | コメント |
| SELECT | qaru_exclude_objects | JSONに出力 | 除外オブジェクト |
| SELECT | qaru_error_level | JSONに出力 | エラーレベル |
| SELECT | qaru_is_active | JSONに出力 | 有効フラグ |
| SELECT | qaru_sql | JSONに出力（CLOB） | SQL文 |
| SELECT | qaru_predecessor_ids | JSONに出力 | 先行ルールID |
| SELECT | qaru_layer | JSONに出力 | レイヤー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_DATA_FOUND | Oracleエラー | 指定クライアントのルールが存在しない | クライアント名を確認して再実行 |
| ORA-* | Oracleエラー | DB接続エラー、権限不足等 | DBエラーメッセージを確認 |
| - | ファイルエラー | ファイル書き込み権限なし | 実行ディレクトリの権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動実行のため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. クライアント名・カテゴリの綴りを確認
3. データベース接続状態を確認
4. ファイル書き込み権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

※本スクリプトはSELECTのみのため、トランザクション制御は不要

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | クライアントあたり数十〜数百ルール |
| 目標処理時間 | ルール数に比例（通常数秒以内） |
| メモリ使用量上限 | long 100000000, longchunksize 32767 |

## 排他制御

排他制御は不要（読み取り専用処理）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | - | - |
| 進捗ログ | f_export_rules_table_to_clob実行時 | 'Exporting N rules with CLIENT_NAME=xxx and CATEGORY=xxx'（g_spool_active=falseの場合のみ） |
| 終了ログ | - | - |
| エラーログ | エラー発生時 | qa_logger_pkg.p_qa_logでQA_LOGSテーブルに記録 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動実行スクリプトのため、監視設定なし

## 備考

- `g_spool_active`をtrueに設定することで、dbms_output出力を抑制しJSONファイルのみを出力します
- バージョン番号（version: 1.1）はJSONファイルに含まれ、インポート時の互換性確認に使用されます
- JSONはpretty print形式で出力されます（`json_serialize`使用）
- クライアント名に空白が含まれる場合、ファイル名では'_'に置換されます
