# バッチ設計書 4-import_file_to_rules

## 概要

本ドキュメントは、QUASTOシステムにおけるルールインポートスクリプト「import_file_to_rules.js」の設計仕様を記載したものです。

### 本バッチの処理概要

import_file_to_rules.jsは、JSONファイルを`QA_IMPORT_FILES`テーブルにインポートし、オプションで`QA_RULES`テーブルへの移行も行うSQLcl JavaScriptスクリプトです。

**業務上の目的・背景**：`export_rules_to_file.sql`でエクスポートされたQUASTOルール定義JSONファイルを、別の環境（開発→テスト→本番など）にインポートする必要があります。本スクリプトは、環境間でのルール移行、バックアップからのリストア、ルールセットの共有・配布などの目的で使用されます。JavaScriptベースのスクリプトにより、ファイル操作とデータベース操作をシームレスに連携させ、柔軟なインポート処理を実現します。

**バッチの実行タイミング**：手動実行（随時）。新環境構築時、ルール更新時、または環境同期時に実行されます。

**主要な処理内容**：
1. 指定されたJSONファイルをBLOBとして読み込み
2. ファイルのMIMEタイプを拡張子から判定
3. `QA_IMPORT_FILES`テーブルにファイル内容をCLOBとして挿入
4. フルインポートフラグが1の場合、`import_qa_import_file_to_qa_rules.sql`を呼び出して`QA_RULES`テーブルにインポート
5. インポート結果の一覧を表示
6. 処理完了後にコミット

**前後の処理との関連**：`export_rules_to_file.sql`でエクスポートされたJSONファイルが入力となります。フルインポート時は`import_qa_import_file_to_qa_rules.sql`を呼び出し、さらに`qa_export_import_rules_pkg.p_import_clob_to_rules_table`が実行されます。

**影響範囲**：`QA_IMPORT_FILES`テーブルに新規レコードが挿入されます。フルインポート時は`QA_RULES`テーブルにルールがMERGE（挿入または更新）されます。

## バッチ種別

データインポート / データ移行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（SQLcl実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SQLcl | SQLclがインストールされていること（JavaScript実行に必要） |
| データベース接続 | QUASTOスキーマに接続していること |
| ファイル存在 | インポート対象のJSONファイルが存在すること |
| ファイル読み取り権限 | 実行ユーザーがファイルを読み取れること |

### 実行可否判定

- 指定されたファイルが存在しない場合、java.nio.file.Filesでエラー発生
- ファイル拡張子からMIMEタイプを判定（.json, .js, .sql, .log対応）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| args[1] (l_filename) | string | Yes | - | インポートするファイル名（パス含む） |
| args[2] (import_flag) | number | No | 0 | フルインポートフラグ（1: QA_RULESにもインポート, 0: QA_IMPORT_FILESのみ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| JSONファイル | ファイル | エクスポートされたルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| QA_IMPORT_FILES | DBテーブル | インポートされたファイル内容 |
| QA_RULES | DBテーブル | ルール定義（フルインポート時のみ） |
| 標準出力 | テキスト | インポート結果一覧 |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. ファイル名取得
   └─ args[1]からファイル名を取得
2. 拡張子からMIMEタイプ判定
   └─ .json → application/json, .js → application/javascript, etc.
3. BLOBオブジェクト作成
   └─ conn.createBlob()でBLOB作成
4. ファイル読み込み
   └─ java.nio.file.Files.copy()でBLOBにコピー
5. バインド変数設定
   └─ filename, mime, blobをHashMapに設定
6. INSERTステートメント実行
   └─ QA_IMPORT_FILESにINSERT（RETURNING QAIF_ID）
7. フルインポート判定
   └─ import_flag == 1の場合、import_qa_import_file_to_qa_rules.sql実行
8. 結果表示
   └─ QA_IMPORT_FILESの一覧をSELECT
9. コミット
   └─ commit実行
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[ファイル名取得]
    B --> C[拡張子からMIMEタイプ判定]
    C --> D[BLOBオブジェクト作成]
    D --> E[ファイルをBLOBに読み込み]
    E --> F[バインド変数設定]
    F --> G[QA_IMPORT_FILESにINSERT]
    G --> H[QAIF_ID取得]
    H --> I{import_flag == 1?}
    I -->|Yes| J[import_qa_import_file_to_qa_rules.sql実行]
    I -->|No| K[結果一覧表示]
    J --> K
    K --> L[COMMIT]
    L --> M[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ファイル登録 | QA_IMPORT_FILES | INSERT | ファイル内容をCLOBとして登録 |
| ルール移行 | QA_RULES | MERGE | ルールの挿入または更新（フルインポート時） |
| 結果表示 | QA_IMPORT_FILES | SELECT | インポートファイル一覧の取得 |

### テーブル別操作詳細

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | QAIF_FILENAME | 引数のファイル名 | ファイル名 |
| INSERT | QAIF_MIMETYPE | 拡張子から判定したMIMEタイプ | application/json等 |
| INSERT | QAIF_CLOB_DATA | to_clob(:b) | BLOBをCLOBに変換 |
| RETURNING | QAIF_ID | 自動採番 | 生成されたID |

#### QA_RULES（フルインポート時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| MERGE ON | QARU_CLIENT_NAME | JSONから抽出 | マッチ条件 |
| MERGE ON | QARU_RULE_NUMBER | JSONから抽出 | マッチ条件 |
| INSERT/UPDATE | QARU_CATEGORY | JSONから抽出 | カテゴリ |
| INSERT/UPDATE | QARU_NAME | JSONから抽出 | ルール名 |
| INSERT/UPDATE | QARU_OBJECT_TYPES | JSONから抽出 | オブジェクトタイプ |
| INSERT/UPDATE | QARU_ERROR_MESSAGE | JSONから抽出 | エラーメッセージ |
| INSERT/UPDATE | QARU_COMMENT | JSONから抽出 | コメント |
| INSERT/UPDATE | QARU_EXCLUDE_OBJECTS | JSONから抽出 | 除外オブジェクト |
| INSERT/UPDATE | QARU_ERROR_LEVEL | JSONから抽出 | エラーレベル |
| INSERT/UPDATE | QARU_IS_ACTIVE | JSONから抽出 | 有効フラグ |
| INSERT/UPDATE | QARU_SQL | JSONから抽出（CLOB） | SQL文 |
| INSERT/UPDATE | QARU_PREDECESSOR_IDS | JSONから抽出 | 先行ルールID |
| INSERT/UPDATE | QARU_LAYER | JSONから抽出 | レイヤー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | JavaScriptエラー | ファイルが存在しない | ファイルパスを確認 |
| - | JavaScriptエラー | ファイル読み取り権限なし | 権限を確認 |
| ORA-* | Oracleエラー | INSERT失敗 | DBエラーメッセージを確認 |
| ORA-* | Oracleエラー | JSON解析エラー（フルインポート時） | JSONフォーマットを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動実行のため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. ファイルパス・権限を確認
3. JSONフォーマットの妥当性を確認
4. データベース接続状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | スクリプト全体 |
| コミットタイミング | 処理完了時に明示的COMMIT |
| ロールバック条件 | エラー発生時は手動ロールバックが必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル（数十〜数百ルール） |
| 目標処理時間 | ファイルサイズに比例（通常数秒以内） |
| メモリ使用量上限 | Java Heap依存 |

## 排他制御

排他制御は実装されていません。同時に同じファイルをインポートした場合、重複レコードが作成される可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | 現在の作業ディレクトリ（print文） |
| 進捗ログ | フルインポート時 | 'MERGE CLIENT_NAME=xxx RULE_NUMBER=xxx'（dbms_output） |
| 終了ログ | 処理完了時 | QA_IMPORT_FILESの一覧（SELECT結果） |
| エラーログ | エラー発生時 | qa_logger_pkg.p_qa_logでQA_LOGSテーブルに記録（PL/SQL側） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動実行スクリプトのため、監視設定なし

## 備考

- SQLclのJavaScript実行環境が必要です（script import_file_to_rules.js ファイル名 フラグ）
- サポートされるMIMEタイプ:
  - .json → application/json
  - .js → application/javascript
  - .sql → application/sql
  - .log → plain/text
  - その他 → application/octet
- BLOBからCLOBへの変換は`to_clob(:b)`で行われます
- RETURNING句でQAIF_IDを取得し、フルインポート時の引数として使用します
- 処理完了後は必ずコミットされます
