# バッチ設計書 5-import_qa_import_file_to_qa_rules

## 概要

本ドキュメントは、QUASTOシステムにおけるルール移行ラッパースクリプト「import_qa_import_file_to_qa_rules.sql」の設計仕様を記載したものです。

### 本バッチの処理概要

import_qa_import_file_to_qa_rules.sqlは、`QA_IMPORT_FILES`テーブルに格納されたJSONデータを`QA_RULES`テーブルにインポートするSQL*Plusラッパースクリプトです。

**業務上の目的・背景**：`import_file_to_rules.js`でJSONファイルを`QA_IMPORT_FILES`テーブルにインポートした後、そのデータを実際のルール定義テーブル（`QA_RULES`）に移行する必要があります。本スクリプトは、`import_file_to_rules.js`から自動的に呼び出されるか、または手動で実行することで、インポート済みファイルの内容をルールテーブルに反映させます。これにより、二段階のインポート処理（ファイル→ステージング→本番）を実現し、インポート前の確認やロールバックを可能にしています。

**バッチの実行タイミング**：`import_file_to_rules.js`のフルインポート時に自動呼び出し、または手動実行（随時）。

**主要な処理内容**：
1. 引数として`QA_IMPORT_FILES`のQAIF_IDを受け取る
2. `qa_export_import_rules_pkg.p_import_clob_to_rules_table`プロシージャを呼び出し
3. 指定されたIDのCLOBデータをJSON解析
4. `QA_RULES`テーブルにMERGE（挿入または更新）

**前後の処理との関連**：`import_file_to_rules.js`でQAIF_IDが生成された後に呼び出されます。`qa_export_import_rules_pkg.p_import_clob_to_rules_table`が実際のインポート処理を行います。

**影響範囲**：`QA_RULES`テーブルに対してMERGE処理（INSERT/UPDATE）が実行されます。既存のルール（同じclient_name + rule_number）は更新され、新規ルールは挿入されます。

## バッチ種別

データインポート / データ移行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（自動/手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | import_file_to_rules.jsから自動呼び出し、または手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | SQL*PlusまたはSQLclでQUASTOスキーマに接続していること |
| インポートファイル存在 | 指定QAIF_IDのレコードが`QA_IMPORT_FILES`テーブルに存在すること |
| 有効なJSON | `QAIF_CLOB_DATA`カラムに有効なJSONデータが格納されていること |

### 実行可否判定

- 指定されたQAIF_IDが存在しない場合、NO_DATA_FOUNDエラーが発生
- CLOBデータがNULLの場合、処理をスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ~1 (pi_qaif_id) | number | Yes | - | QA_IMPORT_FILESテーブルの主キー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| QA_IMPORT_FILES | DBテーブル | インポート済みJSONデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| QA_RULES | DBテーブル | ルール定義（MERGE処理） |
| 標準出力 | テキスト | MERGE処理のログ（dbms_output） |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. 引数取得
   └─ ~1 → pi_qaif_id
2. p_import_clob_to_rules_table呼び出し
   └─ qa_export_import_rules_pkg.p_import_clob_to_rules_table(pi_qaif_id)
3. CLOB取得
   └─ QA_IMPORT_FILESからQAIF_CLOB_DATAを取得
4. NULL判定
   └─ CLOBがNULLの場合はスキップ
5. JSON解析
   └─ json_tableでJSONをリレーショナルデータに変換
6. MERGE実行
   └─ client_name + rule_numberでマッチング
7. ログ出力
   └─ 各ルールのMERGE結果をdbms_outputに出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[pi_qaif_id取得]
    B --> C[p_import_clob_to_rules_table呼び出し]
    C --> D[QA_IMPORT_FILESからCLOB取得]
    D --> E{CLOB is NOT NULL?}
    E -->|No| F[処理終了]
    E -->|Yes| G[json_tableでJSON解析]
    G --> H[ルールごとにループ]
    H --> I[MERGE実行]
    I --> J['MERGE CLIENT_NAME=xxx RULE_NUMBER=xxx'出力]
    J --> K{次のルールあり?}
    K -->|Yes| H
    K -->|No| F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| CLOB取得 | QA_IMPORT_FILES | SELECT | インポートデータの取得 |
| ルール移行 | QA_RULES | MERGE | ルールの挿入または更新 |

### テーブル別操作詳細

#### QA_IMPORT_FILES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | QAIF_CLOB_DATA | WHERE qaif_id = pi_qaif_id | CLOB型 |

#### QA_RULES

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| MERGE ON | QARU_CLIENT_NAME | JSONの$.client_names[*].client_name | マッチ条件1 |
| MERGE ON | QARU_RULE_NUMBER | JSONの$.rules[*].rule_number | マッチ条件2 |
| UPDATE | QARU_CATEGORY | JSONから抽出 | カテゴリ |
| UPDATE | QARU_COMMENT | JSONから抽出 | コメント |
| UPDATE | QARU_ERROR_LEVEL | JSONから抽出 | エラーレベル |
| UPDATE | QARU_ERROR_MESSAGE | JSONから抽出 | エラーメッセージ |
| UPDATE | QARU_EXCLUDE_OBJECTS | JSONから抽出 | 除外オブジェクト |
| UPDATE | QARU_IS_ACTIVE | JSONから抽出 | 有効フラグ |
| UPDATE | QARU_LAYER | JSONから抽出 | レイヤー |
| UPDATE | QARU_NAME | JSONから抽出 | ルール名 |
| UPDATE | QARU_OBJECT_TYPES | JSONから抽出 | オブジェクトタイプ |
| UPDATE | QARU_PREDECESSOR_IDS | JSONから抽出 | 先行ルールID |
| UPDATE | QARU_SQL | JSONから抽出（CLOB） | SQL文 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_DATA_FOUND | Oracleエラー | 指定QAIF_IDが存在しない | IDを確認して再実行 |
| ORA-* | Oracleエラー | JSON解析エラー | JSONフォーマットを確認 |
| ORA-* | Oracleエラー | MERGE失敗（制約違反等） | データ整合性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. QAIF_IDの存在を確認（QA_IMPORT_FILESテーブル）
3. CLOBデータのJSONフォーマットを確認
4. 既存ルールとの制約違反がないか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 呼び出し元のトランザクションに依存 |
| コミットタイミング | 明示的COMMITなし（呼び出し元で制御） |
| ロールバック条件 | エラー発生時は呼び出し元でロールバック |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ルール（JSONファイルサイズ依存） |
| 目標処理時間 | ルール数に比例（通常数秒以内） |
| メモリ使用量上限 | CLOB処理のためPGA依存 |

## 排他制御

排他制御は実装されていません。同時実行時は後勝ちとなります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | - | - |
| 進捗ログ | 各ルールのMERGE時 | 'MERGE CLIENT_NAME=xxx RULE_NUMBER=xxx' |
| 終了ログ | - | - |
| エラーログ | エラー発生時 | qa_logger_pkg.p_qa_logでQA_LOGSテーブルに記録 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動/自動スクリプトのため、監視設定なし

## 備考

- `set define '~'`により、置換変数の区切り文字を'~'に変更しています（'&'との競合回避）
- `set concat on`、`set concat .`により、連結演算子を'.'に設定しています
- `set verify off`により、置換変数の展開確認メッセージを抑制しています
- トランザクションは呼び出し元（import_file_to_rules.js）で制御されるため、本スクリプト内では明示的なCOMMIT/ROLLBACKは行いません
- JSON解析はOracle 12c以降のjson_table関数を使用しています
