# バッチ設計書 6-recompile_quasto_objects

## 概要

本ドキュメントは、QUASTOシステムにおけるコアオブジェクト再コンパイルスクリプト「recompile_quasto_objects.sql」の設計仕様を記載したものです。

### 本バッチの処理概要

recompile_quasto_objects.sqlは、QUASTOのコアとなるデータベースオブジェクト（型、パッケージ、トリガー、ビュー）を再コンパイルするSQL*Plusスクリプトです。

**業務上の目的・背景**：Oracle PL/SQLオブジェクトは、依存関係のあるオブジェクトが変更された際に無効（INVALID）状態になることがあります。また、パッチ適用やアップグレード後に再コンパイルが必要になる場合があります。本スクリプトは、QUASTOシステムの中核を構成するオブジェクトを正しい依存関係順序で再コンパイルし、システムの整合性を確保します。これにより、デプロイメント後の初回実行時のパフォーマンス低下を防ぎ、無効オブジェクトによるランタイムエラーを予防します。

**バッチの実行タイミング**：手動実行（随時）。パッチ適用後、アップグレード後、または無効オブジェクト検出時に実行されます。

**主要な処理内容**：
1. 再コンパイル対象オブジェクトリストを定義（配列）
2. 各オブジェクトについてUSER_OBJECTSで存在確認
3. オブジェクトタイプに応じたALTER...COMPILE文を動的に生成
4. パッケージの場合はスペックとボディを順番にコンパイル
5. 結果をdbms_outputに出力

**前後の処理との関連**：QUASTOのインストール・アップグレードスクリプトの後に実行されることが想定されます。本スクリプト実行後、APEX関連オブジェクトやutPLSQL関連オブジェクトの再コンパイル（recompile_apex_objects.sql、recompile_utplsql_objects.sql）を実行することが推奨されます。

**影響範囲**：QUASTOスキーマ内の型、パッケージ、トリガー、ビューが再コンパイルされます。データの変更はありません。

## バッチ種別

メンテナンス / システム管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（SQL*Plus/SQLcl実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | SQL*PlusまたはSQLclでQUASTOスキーマに接続していること |
| ALTER権限 | 対象オブジェクトに対するALTER権限があること |
| オブジェクト存在 | 対象オブジェクトがスキーマ内に存在すること（存在しない場合はスキップ） |

### 実行可否判定

- 対象オブジェクトがUSER_OBJECTSに存在しない場合、WARNING出力してスキップ
- コンパイルエラーが発生した場合、ERROR出力して次のオブジェクトに進む

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| スクリプト内定義 | PL/SQL配列 | 再コンパイル対象オブジェクトリスト |
| USER_OBJECTS | DBビュー | オブジェクト存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 再コンパイル結果（dbms_output） |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. dbms_output有効化
   └─ buffer_size => 10000000
2. オブジェクトリスト定義
   └─ 型9個、パッケージ6個、トリガー2個、ビュー2個
3. ループ開始（l_counter = 1）
4. オブジェクト存在確認
   └─ USER_OBJECTSでCOUNT
5. 存在しない場合
   └─ 'WARNING: object does not exist'出力、CONTINUE
6. ALTER文生成
   └─ PACKAGEの場合: spec + body
   └─ その他: ALTER TYPE/TRIGGER/VIEW COMPILE
7. EXECUTE IMMEDIATE実行
8. 結果出力
   └─ 成功: 'INFO: xxx recompiled.'
   └─ 失敗: 'ERROR: The object xxx is invalid.'
9. 次のオブジェクトへ
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[dbms_output有効化]
    B --> C[オブジェクトリスト定義]
    C --> D[l_counter = 1]
    D --> E{l_counter < l_object.count?}
    E -->|No| F[終了]
    E -->|Yes| G[USER_OBJECTSで存在確認]
    G --> H{存在する?}
    H -->|No| I[WARNING出力]
    I --> J[l_counter++]
    J --> E
    H -->|Yes| K{PACKAGE?}
    K -->|Yes| L[ALTER PACKAGE COMPILE]
    L --> M[ALTER PACKAGE COMPILE BODY]
    K -->|No| N[ALTER TYPE/TRIGGER/VIEW COMPILE]
    M --> O[EXECUTE IMMEDIATE]
    N --> O
    O --> P{成功?}
    P -->|Yes| Q[INFO出力]
    P -->|No| R[ERROR出力]
    Q --> J
    R --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在確認 | USER_OBJECTS | SELECT | オブジェクト存在確認 |
| 再コンパイル | 各オブジェクト | ALTER COMPILE | オブジェクトの再コンパイル |

### 対象オブジェクト一覧

#### 型（TYPE）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_RULE_T | ルール情報のオブジェクト型 |
| QA_RULES_T | ルールのコレクション型 |
| QA_RUNNING_RULE_T | 実行中ルールのオブジェクト型 |
| QA_RUNNING_RULES_T | 実行中ルールのコレクション型 |
| VARCHAR2_TAB_T | VARCHAR2のコレクション型 |
| QA_TEST_RESULTS_ROW_T | テスト結果行のオブジェクト型 |
| QA_TEST_RESULTS_TABLE_T | テスト結果のコレクション型 |
| QA_SCHEME_OBJECT_AMOUNT_T | スキーマオブジェクト数のオブジェクト型 |
| QA_SCHEME_OBJECT_AMOUNTS_T | スキーマオブジェクト数のコレクション型 |

#### パッケージ（PACKAGE）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_CONSTANT_PKG | 定数定義パッケージ |
| QA_LOGGER_PKG | ログ出力パッケージ |
| QA_UTILS_PKG | ユーティリティパッケージ |
| QA_MAIN_PKG | メイン処理パッケージ |
| QA_API_PKG | APIパッケージ |
| QA_EXPORT_IMPORT_RULES_PKG | ルールエクスポート/インポートパッケージ |

#### トリガー（TRIGGER）

| オブジェクト名 | 説明 |
|--------------|------|
| QARU_IU_TRG | QA_RULESテーブルのINSERT/UPDATEトリガー |
| QAIF_I_TRG | QA_IMPORT_FILESテーブルのINSERTトリガー |

#### ビュー（VIEW）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_SCHEME_NAMES_FOR_TESTING_V | テスト対象スキーマ名ビュー |
| QA_PREDECESSOR_ORDER_V | 先行ルール順序ビュー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | オブジェクトが存在しない | インストール状態を確認 |
| ORA-* | Oracleエラー | コンパイルエラー | エラーメッセージを確認し、ソースを修正 |
| - | 予期せぬエラー | その他のエラー | 例外を再スロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ERROR出力を確認
2. USER_ERRORSビューでコンパイルエラー詳細を確認
3. ソースコードを修正して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

※DDL操作のため、各ALTER文は自動コミットされます

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 19オブジェクト |
| 目標処理時間 | 通常数秒〜数十秒 |
| メモリ使用量上限 | dbms_output buffer_size: 10000000 |

## 排他制御

排他制御は実装されていません。オブジェクトが使用中の場合、コンパイルがブロックされる可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | 'PROMPT # Recomile QUASTO Objects' |
| 進捗ログ | 各オブジェクト処理時 | 'INFO: TYPE xxx recompiled.' |
| 警告ログ | オブジェクト不存在時 | 'WARNING: object does not exist: xxx' |
| エラーログ | コンパイルエラー時 | 'ERROR: The object TYPE xxx is invalid.' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動実行スクリプトのため、監視設定なし

## 備考

- QA_CONSTANT_PKGはボディを持たないため、specのみコンパイルされます
- 型は依存関係を考慮した順序で定義されています
- パッケージはspecを先にコンパイルし、その後bodyをコンパイルします
- エラーが発生しても次のオブジェクトの処理を継続します
- 最後に予期せぬエラーが発生した場合は例外を再スローします
