# バッチ設計書 7-recompile_apex_objects

## 概要

本ドキュメントは、QUASTOシステムにおけるAPEX関連オブジェクト再コンパイルスクリプト「recompile_apex_objects.sql」の設計仕様を記載したものです。

### 本バッチの処理概要

recompile_apex_objects.sqlは、QUASTOのAPEXアプリケーション関連データベースオブジェクト（型、パッケージ、ビュー）を再コンパイルするSQL*Plusスクリプトです。

**業務上の目的・背景**：QUASTOはOracle APEXアプリケーションとしてUIを提供しており、APEXアプリケーションが参照するパッケージやビューが無効状態になると、アプリケーションの動作に影響を与えます。本スクリプトは、APEXアプリケーションの基盤となるオブジェクト群を再コンパイルし、APEXアプリケーションの安定稼働を確保します。特に、コアオブジェクトの変更後やAPEXアプリケーションのアップグレード後に実行することで、依存関係の不整合を解消します。

**バッチの実行タイミング**：手動実行（随時）。`recompile_quasto_objects.sql`実行後、またはAPEXアプリケーション関連の更新後に実行されます。

**主要な処理内容**：
1. 再コンパイル対象オブジェクトリストを定義（配列）
2. 各オブジェクトについてUSER_OBJECTSで存在確認
3. オブジェクトタイプに応じたALTER...COMPILE文を動的に生成
4. パッケージの場合はスペックとボディを順番にコンパイル
5. 結果をdbms_outputに出力

**前後の処理との関連**：`recompile_quasto_objects.sql`の後に実行されることが想定されます。APEXオブジェクトはQUASTOコアオブジェクトに依存しているため、コアオブジェクトを先にコンパイルする必要があります。

**影響範囲**：QUASTOスキーマ内のAPEX関連の型、パッケージ、ビューが再コンパイルされます。データの変更はありません。

## バッチ種別

メンテナンス / システム管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（SQL*Plus/SQLcl実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | SQL*PlusまたはSQLclでQUASTOスキーマに接続していること |
| ALTER権限 | 対象オブジェクトに対するALTER権限があること |
| コアオブジェクト有効 | QUASTOコアオブジェクトが有効状態であること |
| オブジェクト存在 | 対象オブジェクトがスキーマ内に存在すること（存在しない場合はスキップ） |

### 実行可否判定

- 対象オブジェクトがUSER_OBJECTSに存在しない場合、WARNING出力してスキップ
- コンパイルエラーが発生した場合、ERROR出力して次のオブジェクトに進む

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| スクリプト内定義 | PL/SQL配列 | 再コンパイル対象オブジェクトリスト |
| USER_OBJECTS | DBビュー | オブジェクト存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 再コンパイル結果（dbms_output） |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. dbms_output有効化
   └─ buffer_size => 10000000
2. オブジェクトリスト定義
   └─ 型2個、パッケージ3個、ビュー20個
3. ループ開始（l_counter = 1）
4. オブジェクト存在確認
   └─ USER_OBJECTSでCOUNT
5. 存在しない場合
   └─ 'WARNING: object does not exist'出力、CONTINUE
6. ALTER文生成
   └─ PACKAGEの場合: spec + body
   └─ その他: ALTER TYPE/VIEW COMPILE
7. EXECUTE IMMEDIATE実行
8. 結果出力
   └─ 成功: 'INFO: xxx recompiled.'
   └─ 失敗: 'ERROR: The object xxx is invalid.'
9. 次のオブジェクトへ
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[dbms_output有効化]
    B --> C[オブジェクトリスト定義]
    C --> D[l_counter = 1]
    D --> E{l_counter < l_object.count?}
    E -->|No| F[終了]
    E -->|Yes| G[USER_OBJECTSで存在確認]
    G --> H{存在する?}
    H -->|No| I[WARNING出力]
    I --> J[l_counter++]
    J --> E
    H -->|Yes| K{PACKAGE?}
    K -->|Yes| L[ALTER PACKAGE COMPILE]
    L --> M[ALTER PACKAGE COMPILE BODY]
    K -->|No| N[ALTER TYPE/VIEW COMPILE]
    M --> O[EXECUTE IMMEDIATE]
    N --> O
    O --> P{成功?}
    P -->|Yes| Q[INFO出力]
    P -->|No| R[ERROR出力]
    Q --> J
    R --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在確認 | USER_OBJECTS | SELECT | オブジェクト存在確認 |
| 再コンパイル | 各オブジェクト | ALTER COMPILE | オブジェクトの再コンパイル |

### 対象オブジェクト一覧

#### 型（TYPE）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_TEST_RESULTS_TABLE_T | テスト結果テーブルのコレクション型 |
| QA_TEST_RESULTS_ROW_T | テスト結果行のオブジェクト型 |

#### パッケージ（PACKAGE）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_APEX_APP_PKG | APEXアプリケーション用パッケージ |
| QA_APEX_API_PKG | APEX API用パッケージ |
| QA_APEX_PLUGIN_PKG | APEXプラグイン用パッケージ |

#### ビュー（VIEW）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_APEX_BLACKLISTED_APPS_V | ブラックリストアプリケーションビュー |
| QA_APPLICATION_OWNER_V | アプリケーションオーナービュー |
| QA_OVERVIEW_TESTS_P0001_V | テスト概要ビュー（ページ0001用） |
| QA_OVERVIEW_QUOTA_P0001_V | 割合概要ビュー（ページ0001用） |
| QA_OVERVIEW_TIMELINE_ERROR_P0001_V | エラータイムラインビュー（ページ0001用） |
| QA_OVERVIEW_TIMELINE_FAILURE_P0001_V | 失敗タイムラインビュー（ページ0001用） |
| QA_OVERVIEW_TIMELINE_SUCCESS_P0001_V | 成功タイムラインビュー（ページ0001用） |
| QA_UNIT_TEST_PACKAGES_P0002_V | ユニットテストパッケージビュー（ページ0002用） |
| QA_TEST_RUNTIME_ERROR_P0003_V | ランタイムエラービュー（ページ0003用） |
| QA_TEST_RUN_DETAILS_P0004_V | テスト実行詳細ビュー（ページ0004用） |
| QA_TEST_RESULT_FILES_P0005_V | テスト結果ファイルビュー（ページ0005用） |
| QA_RULES_P0006_V | ルールビュー（ページ0006用） |
| QA_RULES_P0007_V | ルールビュー（ページ0007用） |
| QA_CLIENT_NAMES_P0008_V | クライアント名ビュー（ページ0008用） |
| QA_JOB_DETAILS_P0009_V | ジョブ詳細ビュー（ページ0009用） |
| QA_JOB_RUN_DETAILS_P0009_V | ジョブ実行詳細ビュー（ページ0009用） |
| QA_JOB_RUN_DETAILS_P0011_V | ジョブ実行詳細ビュー（ページ0011用） |
| QA_RULE_CATEGORIES_LOV | ルールカテゴリLOVビュー |
| QA_RULE_ERROR_LEVELS_LOV | エラーレベルLOVビュー |
| QA_RULE_LAYERS_LOV | ルールレイヤーLOVビュー |
| QA_TEST_EXECUTION_DATES_LOV | テスト実行日LOVビュー |
| QA_TEST_SCHEME_NAMES_LOV | テストスキーマ名LOVビュー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | オブジェクトが存在しない | インストール状態を確認 |
| ORA-* | Oracleエラー | コンパイルエラー | エラーメッセージを確認し、ソースを修正 |
| - | 予期せぬエラー | その他のエラー | 例外を再スロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ERROR出力を確認
2. USER_ERRORSビューでコンパイルエラー詳細を確認
3. コアオブジェクトが有効か確認（先にrecompile_quasto_objects.sqlを実行）
4. ソースコードを修正して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

※DDL操作のため、各ALTER文は自動コミットされます

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 25オブジェクト |
| 目標処理時間 | 通常数秒〜数十秒 |
| メモリ使用量上限 | dbms_output buffer_size: 10000000 |

## 排他制御

排他制御は実装されていません。オブジェクトが使用中の場合、コンパイルがブロックされる可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | 'PROMPT # Recomile APEX Objects' |
| 進捗ログ | 各オブジェクト処理時 | 'INFO: TYPE xxx recompiled.' |
| 警告ログ | オブジェクト不存在時 | 'WARNING: object does not exist: xxx' |
| エラーログ | コンパイルエラー時 | 'ERROR: The object TYPE xxx is invalid.' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動実行スクリプトのため、監視設定なし

## 備考

- ビュー名にはページ番号が含まれており（例: P0001, P0002）、APEXアプリケーションの特定ページで使用されることを示しています
- LOV（List of Values）ビューはAPEXの選択リストで使用されます
- パッケージは全てspec + bodyの両方をコンパイルします
- エラーが発生しても次のオブジェクトの処理を継続します
- 最後に予期せぬエラーが発生した場合は例外を再スローします
