# バッチ設計書 8-recompile_utplsql_objects

## 概要

本ドキュメントは、QUASTOシステムにおけるutPLSQL関連オブジェクト再コンパイルスクリプト「recompile_utplsql_objects.sql」の設計仕様を記載したものです。

### 本バッチの処理概要

recompile_utplsql_objects.sqlは、QUASTOのutPLSQL（ユニットテスト）関連データベースオブジェクト（パッケージ、トリガー）を再コンパイルするSQL*Plusスクリプトです。

**業務上の目的・背景**：QUASTOはutPLSQLフレームワークを使用してコード品質ルールのユニットテストを実行します。utPLSQL関連のパッケージやトリガーが無効状態になると、テストの実行に影響を与え、品質チェック機能が正常に動作しなくなります。本スクリプトは、utPLSQL連携に必要なオブジェクト群を再コンパイルし、ユニットテスト機能の安定稼働を確保します。特に、コアオブジェクトの変更後やutPLSQLのアップグレード後に実行することで、依存関係の不整合を解消します。

**バッチの実行タイミング**：手動実行（随時）。`recompile_quasto_objects.sql`および`recompile_apex_objects.sql`実行後、またはutPLSQL関連の更新後に実行されます。

**主要な処理内容**：
1. 再コンパイル対象オブジェクトリストを定義（配列）
2. 各オブジェクトについてUSER_OBJECTSで存在確認
3. オブジェクトタイプに応じたALTER...COMPILE文を動的に生成
4. パッケージの場合はスペックとボディを順番にコンパイル
5. 結果をdbms_outputに出力

**前後の処理との関連**：`recompile_quasto_objects.sql`の後に実行されることが想定されます。utPLSQLオブジェクトはQUASTOコアオブジェクトに依存しているため、コアオブジェクトを先にコンパイルする必要があります。本スクリプトはQUASTO再コンパイル処理の最後に実行します。

**影響範囲**：QUASTOスキーマ内のutPLSQL関連パッケージとトリガーが再コンパイルされます。データの変更はありません。

## バッチ種別

メンテナンス / システム管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（SQL*Plus/SQLcl実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | SQL*PlusまたはSQLclでQUASTOスキーマに接続していること |
| ALTER権限 | 対象オブジェクトに対するALTER権限があること |
| コアオブジェクト有効 | QUASTOコアオブジェクトが有効状態であること |
| utPLSQLインストール | utPLSQLフレームワークがインストールされていること |
| オブジェクト存在 | 対象オブジェクトがスキーマ内に存在すること（存在しない場合はスキップ） |

### 実行可否判定

- 対象オブジェクトがUSER_OBJECTSに存在しない場合、WARNING出力してスキップ
- コンパイルエラーが発生した場合、ERROR出力して次のオブジェクトに進む

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| スクリプト内定義 | PL/SQL配列 | 再コンパイル対象オブジェクトリスト |
| USER_OBJECTS | DBビュー | オブジェクト存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 再コンパイル結果（dbms_output） |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. dbms_output有効化
   └─ buffer_size => 10000000
2. オブジェクトリスト定義
   └─ パッケージ1個、トリガー3個
3. ループ開始（l_counter = 1）
4. オブジェクト存在確認
   └─ USER_OBJECTSでCOUNT
5. 存在しない場合
   └─ 'WARNING: object does not exist'出力、CONTINUE
6. ALTER文生成
   └─ PACKAGEの場合: spec + body
   └─ TRIGGERの場合: ALTER TRIGGER COMPILE
7. EXECUTE IMMEDIATE実行
8. 結果出力
   └─ 成功: 'INFO: xxx recompiled.'
   └─ 失敗: 'ERROR: The object xxx is invalid.'
9. 次のオブジェクトへ
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[dbms_output有効化]
    B --> C[オブジェクトリスト定義]
    C --> D[l_counter = 1]
    D --> E{l_counter < l_object.count?}
    E -->|No| F[終了]
    E -->|Yes| G[USER_OBJECTSで存在確認]
    G --> H{存在する?}
    H -->|No| I[WARNING出力]
    I --> J[l_counter++]
    J --> E
    H -->|Yes| K{PACKAGE?}
    K -->|Yes| L[ALTER PACKAGE COMPILE]
    L --> M[ALTER PACKAGE COMPILE BODY]
    K -->|No| N[ALTER TRIGGER COMPILE]
    M --> O[EXECUTE IMMEDIATE]
    N --> O
    O --> P{成功?}
    P -->|Yes| Q[INFO出力]
    P -->|No| R[ERROR出力]
    Q --> J
    R --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在確認 | USER_OBJECTS | SELECT | オブジェクト存在確認 |
| 再コンパイル | 各オブジェクト | ALTER COMPILE | オブジェクトの再コンパイル |

### 対象オブジェクト一覧

#### パッケージ（PACKAGE）

| オブジェクト名 | 説明 |
|--------------|------|
| QA_UNIT_TESTS_PKG | ユニットテスト管理パッケージ |

#### トリガー（TRIGGER）

| オブジェクト名 | 説明 |
|--------------|------|
| QATR_I_TRG | QA_TEST_RESULTSテーブルのINSERTトリガー |
| QATO_I_TRG | QA_TEST_RUN_INVALID_OBJECTSテーブルのINSERTトリガー |
| QATRU_I_TRG | QA_TEST_RUNSテーブルのINSERTトリガー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | オブジェクトが存在しない | インストール状態を確認 |
| ORA-* | Oracleエラー | コンパイルエラー | エラーメッセージを確認し、ソースを修正 |
| - | 予期せぬエラー | その他のエラー | 例外を再スロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ERROR出力を確認
2. USER_ERRORSビューでコンパイルエラー詳細を確認
3. コアオブジェクトが有効か確認（先にrecompile_quasto_objects.sqlを実行）
4. utPLSQLフレームワークのインストール状態を確認
5. ソースコードを修正して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

※DDL操作のため、各ALTER文は自動コミットされます

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4オブジェクト |
| 目標処理時間 | 通常数秒 |
| メモリ使用量上限 | dbms_output buffer_size: 10000000 |

## 排他制御

排他制御は実装されていません。オブジェクトが使用中の場合、コンパイルがブロックされる可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | 'PROMPT # Recomile utPLSQL Objects' |
| 進捗ログ | 各オブジェクト処理時 | 'INFO: PACKAGE xxx recompiled.' |
| 警告ログ | オブジェクト不存在時 | 'WARNING: object does not exist: xxx' |
| エラーログ | コンパイルエラー時 | 'ERROR: The object PACKAGE xxx is invalid.' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

※手動実行スクリプトのため、監視設定なし

## 備考

- 対象オブジェクト数が少ないため（4個）、処理は高速に完了します
- トリガーはテスト結果関連テーブル（QA_TEST_RESULTS、QA_TEST_RUN_INVALID_OBJECTS、QA_TEST_RUNS）のINSERTトリガーです
- QA_UNIT_TESTS_PKGはスケジューラジョブ（CRONJOB_RUN_UNIT_TESTS）およびカスタムジョブから呼び出されるため、このパッケージのコンパイルは重要です
- エラーが発生しても次のオブジェクトの処理を継続します
- 最後に予期せぬエラーが発生した場合は例外を再スローします
- QUASTO全体の再コンパイル順序は以下の通りです:
  1. recompile_quasto_objects.sql（コアオブジェクト）
  2. recompile_apex_objects.sql（APEXオブジェクト）
  3. recompile_utplsql_objects.sql（utPLSQLオブジェクト）
