---
generated_at: 2026-01-22 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-CRONJOB_RUN_UNIT_TESTS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし
  2. **監視・アラート設定**：APEX側の設定詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/create_scheduler_job_for_unit_tests.sql`（行1-46）
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql`（行1-1556）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行2）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ名はCRONJOB_RUN_UNIT_TESTS | E-01 行13 | ○ |
| C-02 | job_typeはPLSQL_BLOCK | E-01 行14 | ○ |
| C-03 | job_actionでqa_unit_tests_pkg.p_run_all_unit_testsを呼び出し | E-01 行15 | ○ |
| C-04 | number_of_argumentsは0 | E-01 行16 | ○ |
| C-05 | repeat_intervalはFREQ=DAILY | E-01 行19 | ○ |
| C-06 | デフォルトでenabled=false | E-01 行22 | ○ |
| C-07 | auto_drop=false | E-01 行23 | ○ |
| C-08 | 開始日時は2023年7月7日01:00 | E-01 行17-18 | ○ |
| C-09 | p_run_all_unit_testsがf_run_all_unit_testsを呼び出す | E-02 行918-933 | ○ |
| C-10 | utPLSQL ut.runを使用してテスト実行 | E-02 行971-973 | ○ |
| C-11 | ut_junit_reporter()でJUnit形式XML生成 | E-02 行973 | ○ |
| C-12 | QA_TEST_RESULTSテーブルに結果を保存 | E-02 行976-977 | ○ |
| C-13 | p_handle_test_resultでテスト結果を処理 | E-02 行1072-1141 | ○ |
| C-14 | autonomous_transactionを使用 | E-02 行1081 | ○ |
| C-15 | f_save_scheme_resultでQA_TEST_RUNSにINSERT | E-02 行1038-1060 | ○ |
| C-16 | p_save_scheme_faulty_objectsでQA_TEST_RUN_INVALID_OBJECTSにINSERT | E-02 行1062-1070 | ○ |
| C-17 | f_is_job_runningで重複実行を防止 | E-02 行1269-1302, 1372-1377 | ○ |
| C-18 | f_is_scheduler_cronjob_enabledでジョブ状態確認可能 | E-02 行1304-1333 | ○ |
| C-19 | p_enable_scheduler_cronjobでジョブ有効化/無効化 | E-02 行1335-1364 | ○ |
| C-20 | p_trigger_scheduler_cronjobで手動トリガー可能 | E-02 行1366-1386 | ○ |
| C-21 | 文字セットデフォルトはWindows-1251 | E-02 行63, 939 | ○ |
| C-22 | dbms_output buffer_sizeは1000000 | E-02 行970 | ○ |
| C-23 | p_handle_test_exceptionでランタイムエラーを記録 | E-02 行1143-1168 | ○ |
| C-24 | 目標処理時間の具体値 | **根拠なし** | △ |
| C-25 | APEXでの監視・アラート詳細設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：ソースコード内に具体的なSLA定義がないため、環境・データ量に依存すると判断
  - 候補：運用ドキュメント / SLA定義書 / 性能テスト結果
- 監視・アラート設定：APEXアプリケーション側の設定ファイルが未分析
  - 候補：APEXアプリケーションエクスポート / 運用監視設定書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる仕様項目
- 1: 中リスク - 運用・監視関連の設定詳細（APEXアプリ依存）
- 0: 低リスク - トランザクション制御の仕様

## 6) レビュアーチェックリスト（最小）
- [ ] ジョブ作成スクリプト（E-01）の内容が設計書と一致しているか確認
- [ ] qa_unit_tests_pkg（E-02）の主要プロシージャの動作が設計書の記載と一致しているか確認
- [ ] 目標処理時間について運用要件を確認し、必要に応じて設計書を補完
- [ ] 監視・アラートの具体的な設定について運用チームに確認
