---
generated_at: 2026-01-22 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-カスタムユニットテストジョブ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **APEXアプリからのトリガー方法**：APEX側の実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql`（行873-916, 990-1036, 1170-1220, 1222-1267）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行3）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_create_custom_unit_test_jobでジョブを作成 | E-01 行873-916 | ○ |
| C-02 | 入力パラメータはpi_qaru_rule_number, pi_qaru_client_name, pi_scheme_name | E-01 行874-876 | ○ |
| C-03 | ジョブ開始時刻は現在時刻+5秒 | E-01 行892 | ○ |
| C-04 | f_get_job_nameでジョブ名を生成 | E-01 行893-896, 1170-1220 | ○ |
| C-05 | ジョブ名末尾にタイムスタンプを付加 | E-01 行897 | ○ |
| C-06 | タイムスタンプ形式はYYYYMMDDHH24MISS | E-01 行897 | ○ |
| C-07 | job_actionでp_run_custom_unit_testを呼び出し | E-01 行902 | ○ |
| C-08 | auto_drop=true | E-01 行905 | ○ |
| C-09 | enabled=true | E-01 行904 | ○ |
| C-10 | コメントにAPEXトリガーの旨を記載 | E-01 行906 | ○ |
| C-11 | p_run_custom_unit_testで単一テスト実行 | E-01 行990-1036 | ○ |
| C-12 | f_get_unit_test_callでプロシージャ名取得 | E-01 行1017 | ○ |
| C-13 | 必須パラメータ不足時に-20001エラー | E-01 行1012-1015 | ○ |
| C-14 | ut.runで単一テスト実行 | E-01 行1020-1022 | ○ |
| C-15 | QA_TEST_RESULTSに結果INSERT | E-01 行1025-1026 | ○ |
| C-16 | QATR_DESCRIPTIONに'Executed by PL/SQL Call: 'と記録 | E-01 行1026 | ○ |
| C-17 | f_exists_custom_jobでジョブ存在確認 | E-01 行1222-1267 | ○ |
| C-18 | ジョブ名LIKEで前方一致検索 | E-01 行1247-1252 | ○ |
| C-19 | 文字セットデフォルトはWindows-1251 | E-01 行994 | ○ |
| C-20 | dbms_output buffer_sizeは1000000 | E-01 行1019 | ○ |
| C-21 | ジョブ名ベースはQUASTO_UT_CUSTOM | E-01 行1209 | ○ |
| C-22 | APEXアプリからのトリガー方法詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- APEXアプリからのトリガー方法：APEX側のページ・プロセス設定が未分析
  - 候補：APEXアプリケーションエクスポート / APEX画面設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できるジョブ作成・実行仕様
- 1: 中リスク - APEX連携部分の詳細（フロントエンド依存）
- 0: 低リスク - エラー処理・ログ出力の仕様

## 6) レビュアーチェックリスト（最小）
- [ ] qa_unit_tests_pkg（E-01）のp_create_custom_unit_test_jobの動作が設計書と一致しているか確認
- [ ] f_get_job_name関数によるジョブ名生成ロジックが設計書と一致しているか確認
- [ ] p_run_custom_unit_testのパラメータ検証ロジックが設計書と一致しているか確認
- [ ] APEXアプリケーション側の呼び出し実装を確認し、必要に応じて設計書を補完
