---
generated_at: 2026-01-22 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-export_rules_to_file

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/export_rules_to_file.sql`（行1-38）
- E-02: `src/plsql/pkg/qa_export_import_rules_pkg.sql`（行1-239）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行4）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数&1はクライアント名 | E-01 行9 | ○ |
| C-02 | 引数&2はカテゴリ（任意） | E-01 行11 | ○ |
| C-03 | long 100000000を設定 | E-01 行13 | ○ |
| C-04 | longchunksize 32767を設定 | E-01 行13 | ○ |
| C-05 | ファイル名は'qa_rules_' + client_name + '.json' | E-01 行21 | ○ |
| C-06 | カテゴリ指定時は'_category'がファイル名に追加 | E-01 行21 | ○ |
| C-07 | g_spool_activeをtrueに設定 | E-01 行29 | ○ |
| C-08 | f_export_rules_table_to_clob関数を呼び出し | E-01 行30-31 | ○ |
| C-09 | SPOOLコマンドでファイル出力 | E-01 行36-38 | ○ |
| C-10 | ルール件数をカウントして存在確認 | E-02 行113-117 | ○ |
| C-11 | ルールなしの場合'No rules found.'を出力 | E-02 行123-124 | ○ |
| C-12 | バージョン番号は1.1 | E-02 行14, 215-216 | ○ |
| C-13 | JSONはpretty print形式で出力 | E-02 行221-223 | ○ |
| C-14 | json_serialize関数を使用 | E-02 行221 | ○ |
| C-15 | クライアント名でグループ化 | E-02 行133-138 | ○ |
| C-16 | カテゴリでネストしたループ | E-02 行142-147 | ○ |
| C-17 | ルールでネストしたループ | E-02 行153-168 | ○ |
| C-18 | qaru_sqlはCLOBとして出力 | E-02 行188-189 | ○ |
| C-19 | NO_DATA_FOUND例外をハンドリング | E-02 行227-232 | ○ |
| C-20 | qa_logger_pkg.p_qa_logでエラーログ | E-02 行233-238 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] export_rules_to_file.sql（E-01）のSQL*Plus設定が設計書と一致しているか確認
- [ ] qa_export_import_rules_pkg（E-02）のf_export_rules_table_to_clob関数の動作が設計書と一致しているか確認
- [ ] JSON出力フォーマットがソースコードと一致しているか確認
