---
generated_at: 2026-01-22 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-import_file_to_rules

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/import_file_to_rules.js`（行1-89）
- E-02: `src/plsql/pkg/qa_export_import_rules_pkg.sql`（行367-463）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行5）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | args[1]はファイル名 | E-01 行32 | ○ |
| C-02 | args[2]はフルインポートフラグ | E-01 行2 | ○ |
| C-03 | 現在の作業ディレクトリを出力 | E-01 行3 | ○ |
| C-04 | conn.createBlob()でBLOB作成 | E-01 行11 | ○ |
| C-05 | java.nio.file.Files.copyでファイル読み込み | E-01 行18 | ○ |
| C-06 | HashMapでバインド変数管理 | E-01 行23 | ○ |
| C-07 | .json拡張子はapplication/json | E-01 行45-47 | ○ |
| C-08 | .js拡張子はapplication/javascript | E-01 行36-38 | ○ |
| C-09 | .sql拡張子はapplication/sql | E-01 行39-41 | ○ |
| C-10 | .log拡張子はplain/text | E-01 行42-44 | ○ |
| C-11 | その他の拡張子はapplication/octet | E-01 行48-49 | ○ |
| C-12 | QA_IMPORT_FILESにINSERT | E-01 行57 | ○ |
| C-13 | to_clob(:b)でBLOBをCLOBに変換 | E-01 行57 | ○ |
| C-14 | RETURNING句でQAIF_IDを取得 | E-01 行60, 71-76 | ○ |
| C-15 | import_flag==1でフルインポート実行 | E-01 行74 | ○ |
| C-16 | import_qa_import_file_to_qa_rules.sqlを呼び出し | E-01 行77-79 | ○ |
| C-17 | 結果一覧をSELECT表示 | E-01 行85-86 | ○ |
| C-18 | 最後にCOMMIT実行 | E-01 行88-89 | ○ |
| C-19 | p_import_clob_to_rules_tableでMERGE処理 | E-02 行403-447 | ○ |
| C-20 | qaru_client_nameとqaru_rule_numberでマッチ | E-02 行405 | ○ |
| C-21 | MATCHED時はUPDATE | E-02 行406-418 | ○ |
| C-22 | NOT MATCHED時はINSERT | E-02 行419-447 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] import_file_to_rules.js（E-01）のJavaScriptロジックが設計書と一致しているか確認
- [ ] MIMEタイプの判定ロジックが設計書と一致しているか確認
- [ ] qa_export_import_rules_pkg（E-02）のp_import_clob_to_rules_tableのMERGE処理が設計書と一致しているか確認
