---
generated_at: 2026-01-22 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-recompile_quasto_objects

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/recompile_quasto_objects.sql`（行1-145）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行7）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PROMPT '# Recomile QUASTO Objects'を出力 | E-01 行1-3 | ○ |
| C-02 | set serveroutput on | E-01 行4 | ○ |
| C-03 | buffer_size => 10000000 | E-01 行20 | ○ |
| C-04 | QA_RULE_Tが型として定義 | E-01 行25-26 | ○ |
| C-05 | QA_RULES_Tが型として定義 | E-01 行29-30 | ○ |
| C-06 | VARCHAR2_TAB_Tが型として定義 | E-01 行41-42 | ○ |
| C-07 | QA_CONSTANT_PKGがパッケージとして定義 | E-01 行62-63 | ○ |
| C-08 | QA_LOGGER_PKGがパッケージとして定義 | E-01 行66-67 | ○ |
| C-09 | QA_UTILS_PKGがパッケージとして定義 | E-01 行70-71 | ○ |
| C-10 | QA_MAIN_PKGがパッケージとして定義 | E-01 行74-75 | ○ |
| C-11 | QA_API_PKGがパッケージとして定義 | E-01 行78-79 | ○ |
| C-12 | QA_EXPORT_IMPORT_RULES_PKGがパッケージとして定義 | E-01 行82-83 | ○ |
| C-13 | QARU_IU_TRGがトリガーとして定義 | E-01 行87-88 | ○ |
| C-14 | QAIF_I_TRGがトリガーとして定義 | E-01 行90-91 | ○ |
| C-15 | QA_SCHEME_NAMES_FOR_TESTING_Vがビューとして定義 | E-01 行96-97 | ○ |
| C-16 | QA_PREDECESSOR_ORDER_Vがビューとして定義 | E-01 行100-101 | ○ |
| C-17 | USER_OBJECTSで存在確認 | E-01 行106-109 | ○ |
| C-18 | 存在しない場合WARNINGを出力 | E-01 行113-114 | ○ |
| C-19 | QA_CONSTANT_PKG以外のPACKAGEはspec+bodyをコンパイル | E-01 行119-122 | ○ |
| C-20 | QA_CONSTANT_PKGはspecのみコンパイル | E-01 行119 | ○ |
| C-21 | EXECUTE IMMEDIATEでコンパイル実行 | E-01 行127-131 | ○ |
| C-22 | 成功時は'INFO: xxx recompiled.'出力 | E-01 行132 | ○ |
| C-23 | 失敗時は'ERROR: The object xxx is invalid.'出力 | E-01 行136 | ○ |
| C-24 | 予期せぬエラー時は例外を再スロー | E-01 行141-143 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] recompile_quasto_objects.sql（E-01）のオブジェクトリストが設計書と一致しているか確認
- [ ] 各オブジェクトタイプに対するコンパイル処理が設計書と一致しているか確認
- [ ] エラー処理ロジックが設計書と一致しているか確認
