---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-recompile_apex_objects

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/recompile_apex_objects.sql`（行1-152）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行8）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PROMPT '# Recomile APEX Objects'を出力 | E-01 行1-3 | ○ |
| C-02 | set serveroutput on | E-01 行4 | ○ |
| C-03 | buffer_size => 10000000 | E-01 行20 | ○ |
| C-04 | QA_TEST_RESULTS_TABLE_Tが型として定義 | E-01 行24-25 | ○ |
| C-05 | QA_TEST_RESULTS_ROW_Tが型として定義 | E-01 行27-28 | ○ |
| C-06 | QA_APEX_APP_PKGがパッケージとして定義 | E-01 行32-33 | ○ |
| C-07 | QA_APEX_API_PKGがパッケージとして定義 | E-01 行35-36 | ○ |
| C-08 | QA_APEX_PLUGIN_PKGがパッケージとして定義 | E-01 行38-39 | ○ |
| C-09 | QA_APEX_BLACKLISTED_APPS_Vがビューとして定義 | E-01 行43-44 | ○ |
| C-10 | QA_APPLICATION_OWNER_Vがビューとして定義 | E-01 行46-47 | ○ |
| C-11 | QA_OVERVIEW_TESTS_P0001_Vがビューとして定義 | E-01 行50-51 | ○ |
| C-12 | QA_OVERVIEW_QUOTA_P0001_Vがビューとして定義 | E-01 行53-54 | ○ |
| C-13 | QA_OVERVIEW_TIMELINE_ERROR_P0001_Vがビューとして定義 | E-01 行56-57 | ○ |
| C-14 | QA_OVERVIEW_TIMELINE_FAILURE_P0001_Vがビューとして定義 | E-01 行59-60 | ○ |
| C-15 | QA_OVERVIEW_TIMELINE_SUCCESS_P0001_Vがビューとして定義 | E-01 行62-63 | ○ |
| C-16 | QA_UNIT_TEST_PACKAGES_P0002_Vがビューとして定義 | E-01 行65-66 | ○ |
| C-17 | QA_TEST_RUNTIME_ERROR_P0003_Vがビューとして定義 | E-01 行68-69 | ○ |
| C-18 | QA_TEST_RUN_DETAILS_P0004_Vがビューとして定義 | E-01 行71-72 | ○ |
| C-19 | QA_TEST_RESULT_FILES_P0005_Vがビューとして定義 | E-01 行74-75 | ○ |
| C-20 | QA_RULES_P0006_Vがビューとして定義 | E-01 行77-78 | ○ |
| C-21 | QA_RULES_P0007_Vがビューとして定義 | E-01 行80-81 | ○ |
| C-22 | QA_CLIENT_NAMES_P0008_Vがビューとして定義 | E-01 行83-84 | ○ |
| C-23 | QA_JOB_DETAILS_P0009_Vがビューとして定義 | E-01 行86-87 | ○ |
| C-24 | LOVビューが定義されている | E-01 行95-108 | ○ |
| C-25 | USER_OBJECTSで存在確認 | E-01 行113-116 | ○ |
| C-26 | 存在しない場合WARNINGを出力 | E-01 行120-121 | ○ |
| C-27 | PACKAGEはspec+bodyをコンパイル | E-01 行126-129 | ○ |
| C-28 | EXECUTE IMMEDIATEでコンパイル実行 | E-01 行133-138 | ○ |
| C-29 | 成功時は'INFO: xxx recompiled.'出力 | E-01 行139 | ○ |
| C-30 | 失敗時は'ERROR: The object xxx is invalid.'出力 | E-01 行143 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] recompile_apex_objects.sql（E-01）のオブジェクトリストが設計書と一致しているか確認
- [ ] 各オブジェクトタイプに対するコンパイル処理が設計書と一致しているか確認
- [ ] ビュー名のページ番号が実際のAPEXアプリケーションのページ構成と一致しているか確認
