---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-recompile_utplsql_objects

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/scripts/recompile_utplsql_objects.sql`（行1-82）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（行9）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PROMPT '# Recomile utPLSQL Objects'を出力 | E-01 行1-3 | ○ |
| C-02 | set serveroutput on | E-01 行4 | ○ |
| C-03 | buffer_size => 10000000 | E-01 行20 | ○ |
| C-04 | QA_UNIT_TESTS_PKGがパッケージとして定義 | E-01 行24-25 | ○ |
| C-05 | QATR_I_TRGがトリガーとして定義 | E-01 行28-29 | ○ |
| C-06 | QATO_I_TRGがトリガーとして定義 | E-01 行32-33 | ○ |
| C-07 | QATRU_I_TRGがトリガーとして定義 | E-01 行36-37 | ○ |
| C-08 | USER_OBJECTSで存在確認 | E-01 行43-46 | ○ |
| C-09 | 存在しない場合WARNINGを出力 | E-01 行50-51 | ○ |
| C-10 | PACKAGEはspec+bodyをコンパイル | E-01 行56-59 | ○ |
| C-11 | TRIGGERはALTER TRIGGER COMPILE | E-01 行61 | ○ |
| C-12 | EXECUTE IMMEDIATEでコンパイル実行 | E-01 行63-68 | ○ |
| C-13 | 成功時は'INFO: xxx recompiled.'出力 | E-01 行69 | ○ |
| C-14 | 失敗時は'ERROR: The object xxx is invalid.'出力 | E-01 行73 | ○ |
| C-15 | 予期せぬエラー時は例外を再スロー | E-01 行78-80 | ○ |
| C-16 | 対象オブジェクト数は4個 | E-01 行24-37 | ○ |
| C-17 | パッケージ1個、トリガー3個 | E-01 行24-37 | ○ |
| C-18 | エラー時も次のオブジェクト処理を継続 | E-01 行71-74 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] recompile_utplsql_objects.sql（E-01）のオブジェクトリストが設計書と一致しているか確認
- [ ] 各オブジェクトタイプに対するコンパイル処理が設計書と一致しているか確認
- [ ] トリガー名が実際のテーブルトリガーと一致しているか確認
