---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：pkg.csv (単体テストケース一覧)

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・機能が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：全てのパブリックメソッドがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` (278行) - ルール実行API
- E-02: `src/plsql/pkg/qa_main_pkg.sql` (1059行) - メインパッケージ（ルール管理）
- E-03: `src/plsql/pkg/qa_export_import_rules_pkg.sql` (686行) - エクスポート/インポート機能
- E-04: `src/plsql/pkg/qa_apex_api_pkg.sql` (236行) - APEX向けAPI
- E-05: `src/plsql/pkg/qa_utils_pkg.sql` (461行) - ユーティリティ関数
- E-06: `src/plsql/pkg/qa_unit_tests_pkg.sql` (1556行) - 単体テスト管理
- E-07: `src/plsql/pkg/qa_logger_pkg.sql` (508行) - ロギング機能
- E-08: `src/plsql/pkg/qa_apex_app_pkg.sql` (318行) - APEX画面向け機能

## 3) Claims と根拠の対応（レビューの主戦場）

### qa_api_pkg (UT-PKG-001〜008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf_run_rule正常系：単一ルール実行で結果返却 | E-01 (行49-151) | ○ |
| C-02 | tf_run_rule異常系：nullパラメータでORA-20001 | E-01 (行74-80) | ○ |
| C-03 | tf_run_rule異常系：非アクティブルールでORA-20001 | E-01 (行85-91) | ○ |
| C-04 | tf_run_rule異常系：ブラックリストユーザーでnull返却 | E-01 (行82-84, 136-138) | ○ |
| C-05 | tf_run_rule正常系：APEXカテゴリ分岐処理 | E-01 (行97-122) | ○ |
| C-06 | tf_run_rules正常系：全ルール実行 | E-01 (行154-275) | ○ |
| C-07 | tf_run_rules異常系：nullパラメータでORA-20001 | E-01 (行178-183) | ○ |
| C-08 | tf_run_rules異常系：ループ検出でnull返却 | E-01 (行186-191) | ○ |

### qa_main_pkg (UT-PKG-009〜033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | f_get_rule正常系：ルール情報取得 | E-02 (行213-256) | ○ |
| C-10 | f_get_rule異常系：NO_DATA_FOUND発生 | E-02 (行243-249) | ○ |
| C-11 | f_get_rule_pk正常系：主キー取得 | E-02 (行258-288) | ○ |
| C-12 | f_is_rule_active正常系：アクティブでtrue | E-02 (行290-326) | ○ |
| C-13 | f_is_rule_active正常系：非アクティブでfalse | E-02 (行313-315) | ○ |
| C-14 | f_get_rule_category正常系 | E-02 (行328-359) | ○ |
| C-15 | f_get_rule_name正常系 | E-02 (行361-392) | ○ |
| C-16 | f_get_rule_layer正常系 | E-02 (行394-425) | ○ |
| C-17 | f_get_rule_error_level正常系 | E-02 (行427-458) | ○ |
| C-18 | f_exist_rules正常系：存在でtrue | E-02 (行460-491) | ○ |
| C-19 | f_exist_rules正常系：不在でfalse | E-02 (行478-480) | ○ |
| C-20 | tf_get_rule_numbers正常系 | E-02 (行493-531) | ○ |
| C-21 | tf_get_rule_numbers異常系：NO_DATA_FOUND | E-02 (行518-524) | ○ |
| C-22 | p_test_rule正常系 | E-02 (行684-746) | ○ |
| C-23 | p_test_rule正常系：結果=1 | E-02 (行731-733) | ○ |
| C-24 | p_test_rule正常系：結果=0 | E-02 (行727-731) | ○ |
| C-25 | f_insert_rule正常系 | E-02 (行749-838) | ○ |
| C-26 | p_exclude_objects正常系 | E-02 (行842-897) | ○ |
| C-27 | p_exclude_objects境界値：空コレクション | E-02 (行851) | ○ |
| C-28 | f_check_for_loop正常系：ループなし | E-02 (行899-960) | ○ |
| C-29 | f_check_for_loop異常系：ループあり | E-02 (行909-911, 946-952) | ○ |
| C-30 | f_get_full_rule_pred正常系 | E-02 (行962-1004) | ○ |
| C-31 | f_is_owner_black_listed正常系：対象外 | E-02 (行1006-1056) | ○ |
| C-32 | f_is_owner_black_listed異常系：対象 | E-02 (行1029-1032, 1043-1046) | ○ |
| C-33 | f_is_owner_black_listed境界値：null | E-02 (行1039-1041) | ○ |

### qa_export_import_rules_pkg (UT-PKG-034〜040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | f_export_rules_table_to_clob正常系 | E-03 (行82-239) | ○ |
| C-35 | f_export_rules_table_to_clob正常系：データなし | E-03 (行119-125) | ○ |
| C-36 | f_export_rules_to_script_clob正常系 | E-03 (行242-316) | ○ |
| C-37 | f_import_clob_to_qa_import_files正常系 | E-03 (行318-364) | ○ |
| C-38 | p_import_clob_to_rules_table正常系 | E-03 (行367-463) | ○ |
| C-39 | p_import_clob_to_rules_table異常系 | E-03 (行450-456) | ○ |
| C-40 | fc_export_qa_rules正常系 | E-03 (行465-682) | ○ |

### qa_apex_api_pkg (UT-PKG-041〜046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | p_exclude_not_whitelisted_apex_entries正常系 | E-04 (行41-96) | ○ |
| C-42 | p_exclude_not_whitelisted_apex_entries境界値 | E-04 (行49) | ○ |
| C-43 | tf_run_rule正常系 | E-04 (行99-182) | ○ |
| C-44 | tf_run_rule異常系：nullパラメータ | E-04 (行123-128) | ○ |
| C-45 | tf_run_rule異常系：非アクティブ | E-04 (行132-136) | ○ |
| C-46 | tf_run_rules正常系 | E-04 (行184-233) | ○ |

### qa_utils_pkg (UT-PKG-047〜062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | f_get_table_as_string正常系 | E-05 (行112-149) | ○ |
| C-48 | f_get_table_as_string異常系 | E-05 (行126-129) | ○ |
| C-49 | f_get_string_as_table正常系 | E-05 (行151-189) | ○ |
| C-50 | f_get_string_as_table異常系 | E-05 (行167-170) | ○ |
| C-51 | f_get_unified_string正常系 | E-05 (行191-244) | ○ |
| C-52 | f_get_unified_string正常系：小文字 | E-05 (行228-230) | ○ |
| C-53 | f_get_unified_string正常系：大文字 | E-05 (行231-233) | ○ |
| C-54 | f_get_unified_string異常系 | E-05 (行216-220) | ○ |
| C-55 | f_replace_string正常系 | E-05 (行246-296) | ○ |
| C-56 | f_replace_string正常系：対象なし | E-05 (行282) | ○ |
| C-57 | p_print_to_dbms_output(varchar2)正常系 | E-05 (行298-324) | ○ |
| C-58 | p_print_to_dbms_output(clob)正常系 | E-05 (行326-365) | ○ |
| C-59 | f_get_constant_string_value正常系 | E-05 (行367-410) | ○ |
| C-60 | f_get_constant_string_value異常系 | E-05 (行393, 398-403) | ○ |
| C-61 | f_get_constant_number_value正常系 | E-05 (行412-457) | ○ |
| C-62 | f_get_constant_number_value異常系 | E-05 (行440, 445-450) | ○ |

### qa_unit_tests_pkg (UT-PKG-063〜096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | p_create_unit_test_packages正常系：単一 | E-06 (行657-823) | ○ |
| C-64 | p_create_unit_test_packages正常系：ルール別 | E-06 (行754-808) | ○ |
| C-65 | p_create_unit_test_packages異常系 | E-06 (行312-315) | ○ |
| C-66 | p_delete_unit_test_packages正常系 | E-06 (行825-871) | ○ |
| C-67 | p_create_custom_unit_test_job正常系 | E-06 (行873-916) | ○ |
| C-68 | p_run_all_unit_tests正常系 | E-06 (行918-933) | ○ |
| C-69 | f_run_all_unit_tests正常系 | E-06 (行935-988) | ○ |
| C-70 | f_run_all_unit_tests異常系 | E-06 (行958-961) | ○ |
| C-71 | p_run_custom_unit_test正常系 | E-06 (行990-1036) | ○ |
| C-72 | p_run_custom_unit_test異常系 | E-06 (行1012-1015) | ○ |
| C-73 | p_handle_test_result正常系 | E-06 (行1072-1141) | ○ |
| C-74 | p_handle_test_result正常系：失敗時 | E-06 (行1115-1135) | ○ |
| C-75 | p_handle_test_exception正常系 | E-06 (行1143-1168) | ○ |
| C-76 | f_get_job_name正常系：カスタム | E-06 (行1170-1220) | ○ |
| C-77 | f_get_job_name正常系：cron | E-06 (行1201-1203) | ○ |
| C-78 | f_get_job_name異常系 | E-06 (行1195-1199) | ○ |
| C-79 | f_exists_custom_job正常系：存在 | E-06 (行1222-1267) | ○ |
| C-80 | f_exists_custom_job正常系：不在 | E-06 (行1254-1256) | ○ |
| C-81 | f_is_job_running正常系：実行中 | E-06 (行1269-1302) | ○ |
| C-82 | f_is_job_running正常系：停止中 | E-06 (行1289-1291) | ○ |
| C-83 | f_is_scheduler_cronjob_enabled正常系：有効 | E-06 (行1304-1333) | ○ |
| C-84 | f_is_scheduler_cronjob_enabled正常系：無効 | E-06 (行1320-1324) | ○ |
| C-85 | p_enable_scheduler_cronjob正常系：有効化 | E-06 (行1335-1364) | ○ |
| C-86 | p_enable_scheduler_cronjob正常系：無効化 | E-06 (行1354-1356) | ○ |
| C-87 | p_enable_scheduler_cronjob異常系 | E-06 (行1345-1349) | ○ |
| C-88 | p_trigger_scheduler_cronjob正常系 | E-06 (行1366-1386) | ○ |
| C-89 | p_trigger_scheduler_cronjob異常系 | E-06 (行1375-1377) | ○ |
| C-90 | f_has_rule_test_results正常系：あり | E-06 (行1388-1433) | ○ |
| C-91 | f_has_rule_test_results正常系：なし | E-06 (行1420-1424) | ○ |
| C-92 | f_has_rule_test_results異常系 | E-06 (行1406-1409) | ○ |
| C-93 | f_import_test_result正常系 | E-06 (行1435-1458) | ○ |
| C-94 | f_export_test_result正常系 | E-06 (行1460-1486) | ○ |
| C-95 | p_create_unit_tests_for_schemes正常系 | E-06 (行1488-1521) | ○ |
| C-96 | p_delete_unit_tests_for_schemes正常系 | E-06 (行1523-1552) | ○ |

### qa_logger_pkg (UT-PKG-097〜100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | p_qa_log正常系 | E-07 (行261-296) | ○ |
| C-98 | append_param(varchar2)正常系 | E-07 (行336-347) | ○ |
| C-99 | append_param(multi)正常系 | E-07 (行350-426) | ○ |
| C-100 | tochar各型正常系 | E-07 (行299-332) | ○ |

### qa_apex_app_pkg (UT-PKG-101〜108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | get_faceted_search_dashboard_data正常系 | E-08 (行59-115) | ○ |
| C-102 | p_upload_rules_json正常系 | E-08 (行117-161) | ○ |
| C-103 | p_upload_rules_json異常系 | E-08 (行143-146) | ○ |
| C-104 | p_download_rules_json正常系 | E-08 (行163-207) | ○ |
| C-105 | p_upload_unit_test_xml正常系 | E-08 (行209-246) | ○ |
| C-106 | p_upload_unit_test_xml異常系 | E-08 (行232-235) | ○ |
| C-107 | p_download_unit_test_xml正常系 | E-08 (行248-295) | ○ |
| C-108 | p_fill_faceted_search_collection正常系 | E-08 (行297-315) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースにソースコード根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに対応

### 追加確認推奨項目
1. **qa_constant_pkg依存**：各パッケージはqa_constant_pkgの定数に依存しているが、このパッケージはpkgモジュール外のため未解析。テスト実行時に定数値が正しく設定されていることを確認すること。
2. **外部依存（logger）**：qa_logger_pkgはgc_logger_flag=1の場合にloggerパッケージを呼び出す。loggerがインストールされていない環境でのテストに注意。
3. **APEX依存**：qa_apex_app_pkg, qa_apex_api_pkgはAPEXビューおよびAPEX_*パッケージに依存。APEX環境がない場合は該当テストをスキップすること。

## 6) レビュアーチェックリスト（最小）
- [ ] 各パッケージのパブリックメソッドがテストケースで網羅されているか
- [ ] 正常系・異常系・境界値の観点が適切にカバーされているか
- [ ] テストケースの優先度（高/中/低）が適切か
- [ ] 前提条件と入力値の組み合わせが現実的か
- [ ] 期待結果がソースコードの実装と一致しているか
- [ ] 外部依存（qa_constant_pkg, logger, APEX）の影響を考慮しているか
