---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 56
  claims_with_evidence: 56
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：scripts単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：56 / 56、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/create_scheduler_job_for_unit_tests.sql`
- E-02: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/export_rules_to_file.sql`
- E-03: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/export_rules_to_file_old.sql`
- E-04: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/import_file_to_rules.js`
- E-05: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/import_qa_import_file_to_qa_rules.sql`
- E-06: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/install_constant_package.sql`
- E-07: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/install_prereqs.sql`
- E-08: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/recompile_apex_objects.sql`
- E-09: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/recompile_quasto_objects.sql`
- E-10: `/Users/tomokababa/Work/reverse-engineering/quasto-dev/src/scripts/recompile_utplsql_objects.sql`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブが存在しない場合に新規作成されること | E-01 (L3-44) | ○ |
| C-02 | ジョブが既に存在する場合は作成をスキップすること | E-01 (L37-38) | ○ |
| C-03 | dbms_schedulerエラー時にエラーメッセージが出力されること | E-01 (L41-43) | ○ |
| C-04 | 作成されたジョブの設定が正しいこと | E-01 (L13-24) | ○ |
| C-05 | クライアント名のみ指定でエクスポートできること | E-02 (L24-33) | ○ |
| C-06 | クライアント名とカテゴリ指定でエクスポートできること | E-02 (L24-33) | ○ |
| C-07 | ファイル名が正しく生成されること | E-02 (L20-21) | ○ |
| C-08 | カテゴリ指定時のファイル名が正しいこと | E-02 (L21) | ○ |
| C-09 | クライアント名にスペースが含まれる場合 | E-02 (L21 replace関数) | ○ |
| C-10 | 旧版エクスポートが正常に動作すること | E-03 (L9-19) | ○ |
| C-11 | p_clob_to_outputで出力されること | E-03 (L17) | ○ |
| C-12 | 新規マップにバインド変数を追加できること | E-04 (L9-29) | ○ |
| C-13 | 既存マップにバインド変数を追加できること | E-04 (L20-27) | ○ |
| C-14 | .jsonファイルのMIMEタイプが正しいこと | E-04 (L45-47) | ○ |
| C-15 | .sqlファイルのMIMEタイプが正しいこと | E-04 (L39-41) | ○ |
| C-16 | .jsファイルのMIMEタイプが正しいこと | E-04 (L36-38) | ○ |
| C-17 | .logファイルのMIMEタイプが正しいこと | E-04 (L42-44) | ○ |
| C-18 | 未知の拡張子のMIMEタイプがデフォルト値になること | E-04 (L48-49) | ○ |
| C-19 | qa_import_filesへの挿入が成功すること | E-04 (L57-68) | ○ |
| C-20 | import_flag=1でルールインポートが実行されること | E-04 (L74-79) | ○ |
| C-21 | import_flag!=1でルールインポートがスキップされること | E-04 (L74条件分岐) | ○ |
| C-22 | 処理終了時にコミットされること | E-04 (L87-88) | ○ |
| C-23 | 指定IDでルールインポートが実行されること | E-05 (L7-9) | ○ |
| C-24 | 存在しないIDでエラーになること | E-05 (L8呼び出し先) | ○ |
| C-25 | qa_constant_pkgが作成されること | E-06 (L25-63) | ○ |
| C-26 | utPLSQLフラグが正しく設定されること | E-06 (L10, L44) | ○ |
| C-27 | APEXフラグが正しく設定されること | E-06 (L11, L45) | ○ |
| C-28 | Loggerフラグが正しく設定されること | E-06 (L13, L46) | ○ |
| C-29 | APEXバージョンが正しく設定されること | E-06 (L14, L43) | ○ |
| C-30 | パッケージ作成失敗時にエラーメッセージが出力されること | E-06 (L70-78) | ○ |
| C-31 | 定数値が正しく設定されること | E-06 (L50) | ○ |
| C-32 | 全ての必要権限が存在する場合に成功すること | E-07 (L43-45) | ○ |
| C-33 | CREATE TABLE権限が不足している場合にエラーになること | E-07 (L15, L36-38) | ○ |
| C-34 | CREATE VIEW権限が不足している場合にエラーになること | E-07 (L16, L36-38) | ○ |
| C-35 | CREATE PROCEDURE権限が不足している場合にエラーになること | E-07 (L18, L36-38) | ○ |
| C-36 | CREATE JOB権限が不足している場合にエラーになること | E-07 (L21, L36-38) | ○ |
| C-37 | CREATE PUBLIC SYNONYM権限が不足している場合にエラーになること | E-07 (L22, L36-38) | ○ |
| C-38 | 複数の権限が不足している場合に全て報告されること | E-07 (L30-41ループ処理) | ○ |
| C-39 | 存在するAPEXオブジェクトが再コンパイルされること | E-08 (L111-146) | ○ |
| C-40 | パッケージのspecとbody両方がコンパイルされること | E-08 (L126-132) | ○ |
| C-41 | ビューが再コンパイルされること | E-08 (L131) | ○ |
| C-42 | タイプが再コンパイルされること | E-08 (L131) | ○ |
| C-43 | 存在しないオブジェクトの場合は警告が出力されること | E-08 (L118-123) | ○ |
| C-44 | コンパイルエラー時にエラーメッセージが出力されること | E-08 (L141-144) | ○ |
| C-45 | 予期しないエラー時に例外が再スローされること | E-08 (L147-150) | ○ |
| C-46 | 存在するQUASTOオブジェクトが再コンパイルされること | E-09 (L104-139) | ○ |
| C-47 | タイプが正しい順序でコンパイルされること | E-09 (L25-59) | ○ |
| C-48 | QA_CONSTANT_PKGはbodyなしでコンパイルされること | E-09 (L119条件分岐) | ○ |
| C-49 | トリガーが再コンパイルされること | E-09 (L86-92) | ○ |
| C-50 | 存在しないオブジェクトの場合は警告が出力されること | E-09 (L111-116) | ○ |
| C-51 | コンパイルエラー時にエラーメッセージが出力されること | E-09 (L134-137) | ○ |
| C-52 | 存在するutPLSQLオブジェクトが再コンパイルされること | E-10 (L41-76) | ○ |
| C-53 | パッケージのspecとbody両方がコンパイルされること | E-10 (L56-61) | ○ |
| C-54 | utPLSQL用トリガーが再コンパイルされること | E-10 (L28-38) | ○ |
| C-55 | 存在しないオブジェクトの場合は警告が出力されること | E-10 (L48-53) | ○ |
| C-56 | コンパイルエラー時にエラーメッセージが出力されること | E-10 (L71-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースはソースコードから直接導出）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに明確な根拠を持つ

### 注意点
- スクリプトはPL/SQL匿名ブロックおよびJavaScript(Nashorn)で構成されており、単体テストはデータベース接続を必要とする
- import_file_to_rules.jsはOracle SQLclのNashornエンジン上で動作するため、テスト環境の構築に注意が必要
- 再コンパイルスクリプトは実際のデータベースオブジェクトの存在に依存するため、テスト時はモック環境またはテスト用スキーマが必要

## 6) レビュアーチェックリスト（最小）
- [ ] create_scheduler_job_for_unit_tests.sql: dbms_schedulerのパラメータ設定が要件を満たしているか
- [ ] export_rules_to_file.sql: g_spool_activeフラグの目的と影響を確認
- [ ] import_file_to_rules.js: Nashornエンジン特有の動作を考慮したテストが必要か
- [ ] install_constant_package.sql: 動的SQL生成による定数パッケージの妥当性を確認
- [ ] install_prereqs.sql: 必要権限リストの網羅性を確認
- [ ] recompile_*.sql: オブジェクト間の依存関係が正しく考慮されているか確認
