---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 58
  claims_with_evidence: 58
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：tab モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：58 / 58、根拠なし：0
- 優先レビュー（高）
  1. **外部キー制約**：DDL定義に明示的なFK制約がないため、論理的整合性の確認が必要
  2. **トリガーとテーブルの連携**：トリガーファイルを参照して動作を確認
  3. **エラーレベル値（1/2/4）**：コメントに記載された値の妥当性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_import_files.sql` - QA_IMPORT_FILESテーブル定義
- E-02: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-03: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義
- E-04: `src/ddl/tab/qa_test_run_invalid_objects.sql` - QA_TEST_RUN_INVALID_OBJECTSテーブル定義
- E-05: `src/ddl/tab/qa_test_runs.sql` - QA_TEST_RUNSテーブル定義
- E-06: `src/plsql/trg/qaif_i_trg.sql` - QA_IMPORT_FILES INSERTトリガー
- E-07: `src/plsql/trg/qaru_iu_trg.sql` - QA_RULES INSERT/UPDATEトリガー
- E-08: `src/plsql/trg/qatr_i_trg.sql` - QA_TEST_RESULTS INSERTトリガー
- E-09: `src/plsql/trg/qato_i_trg.sql` - QA_TEST_RUN_INVALID_OBJECTS INSERTトリガー
- E-10: `src/plsql/trg/qatru_i_trg.sql` - QA_TEST_RUNS INSERTトリガー

## 3) Claims と根拠の対応（レビューの主戦場）

### QA_IMPORT_FILES テーブル（UT-TAB-001〜012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qaif_idがNULLの場合シーケンス自動採番 | E-06（トリガー: `qaif_seq.nextval`） | ○ |
| C-02 | qaif_id明示指定時は指定値使用 | E-06（トリガー: `if :new.qaif_id is null then`） | ○ |
| C-03 | qaif_created_onのデフォルト値SYSDATE | E-01（DDL: `default sysdate`） | ○ |
| C-04 | qaif_created_byのデフォルト値USER | E-01（DDL: `default user`） | ○ |
| C-05 | qaif_filename NOT NULL制約 | E-01（DDL: `not null`） | ○ |
| C-06 | qaif_mimetype NOT NULL制約 | E-01（DDL: `not null`） | ○ |
| C-07 | qaif_clob_data NOT NULL制約 | E-01（DDL: `not null`） | ○ |
| C-08 | qaif_filename最大長200 CHAR | E-01（DDL: `VARCHAR2(200 CHAR)`） | ○ |
| C-09 | qaif_filename最大長超過エラー | E-01（DDL: `VARCHAR2(200 CHAR)`） | ○ |
| C-10 | qaif_error_log最大長4000 CHAR | E-01（DDL: `VARCHAR2(4000 CHAR)`） | ○ |
| C-11 | qaif_status更新可能 | E-01（DDL: `qaif_status VARCHAR2(50 CHAR)`） | ○ |
| C-12 | 監査カラム更新 | E-01（DDL: `qaif_updated_on`, `qaif_updated_by`） | ○ |

### QA_RULES テーブル（UT-TAB-013〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | qaru_idがNULLの場合シーケンス自動採番 | E-07（トリガー: `qaru_seq.nextval`） | ○ |
| C-14 | qaru_created_onがトリガーでSYSDATE設定 | E-07（トリガー: `:new.qaru_created_on := SYSDATE`） | ○ |
| C-15 | qaru_created_byがトリガーでユーザー設定 | E-07（トリガー: `:new.qaru_created_by := l_user`） | ○ |
| C-16 | qaru_updated_on/byがトリガーで設定 | E-07（トリガー: `IF updating OR inserting THEN`） | ○ |
| C-17 | qaru_is_activeデフォルト値1 | E-02（DDL: `default 1`） | ○ |
| C-18 | qaru_rule_number NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-19 | qaru_client_name NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-20 | qaru_name NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-21 | qaru_category NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-22 | qaru_object_types NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-23 | qaru_error_message NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-24 | qaru_error_level NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-25 | qaru_sql NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-26 | qaru_layer NOT NULL制約 | E-02（DDL: `not null`） | ○ |
| C-27 | qaru_rule_number最大長20 CHAR | E-02（DDL: `VARCHAR2(20 CHAR)`） | ○ |
| C-28 | qaru_error_message最大長4000 CHAR | E-02（DDL: `VARCHAR2(4000 CHAR)`） | ○ |
| C-29 | qaru_error_level=1（Error） | E-02（コメント: `1=Error, 2=Warning, 4=Info`） | ○ |
| C-30 | qaru_error_level=2（Warning） | E-02（コメント: `1=Error, 2=Warning, 4=Info`） | ○ |
| C-31 | qaru_error_level=4（Info） | E-02（コメント: `1=Error, 2=Warning, 4=Info`） | ○ |
| C-32 | qaru_predecessor_idsコロン区切り | E-02（コメント: `colon delimted list`） | ○ |
| C-33 | UPDATE時監査カラム自動更新 | E-07（トリガー: `IF updating OR inserting THEN`） | ○ |
| C-34 | UPDATE時作成情報不変 | E-07（トリガー: `IF inserting THEN`のみで設定） | ○ |

### QA_TEST_RESULTS テーブル（UT-TAB-035〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | qatr_idがNULLの場合シーケンス自動採番 | E-08（トリガー: `qatr_seq.nextval`） | ○ |
| C-36 | qatr_added_onがトリガーでSYSDATE設定 | E-08（トリガー: `:new.qatr_added_on := SYSDATE`） | ○ |
| C-37 | qatr_added_byがトリガーでユーザー設定 | E-08（トリガー: `:new.qatr_added_by := l_user`） | ○ |
| C-38 | qatr_xml_result NOT NULL制約 | E-03（DDL: `not null`） | ○ |
| C-39 | qatr_description NOT NULL制約 | E-03（DDL: `not null`） | ○ |
| C-40 | qatr_description最大長255 CHAR | E-03（DDL: `VARCHAR2(255 CHAR)`） | ○ |
| C-41 | qatr_xml_resultにCLOB保存可能 | E-03（DDL: `CLOB not null`） | ○ |

### QA_TEST_RUN_INVALID_OBJECTS テーブル（UT-TAB-042〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | qato_idがNULLの場合シーケンス自動採番 | E-09（トリガー: `qato_seq.nextval`） | ○ |
| C-43 | qato_object_name NOT NULL制約 | E-04（DDL: `not null`） | ○ |
| C-44 | qato_object_details NOT NULL制約 | E-04（DDL: `not null`） | ○ |
| C-45 | qato_qatr_id NOT NULL制約 | E-04（DDL: `not null`） | ○ |
| C-46 | qato_object_name最大長4000 CHAR | E-04（DDL: `VARCHAR2(4000 CHAR)`） | ○ |
| C-47 | qato_qatr_id外部キー参照 | E-04（コメント: `foreign key column to QA_TEST_RUNS`） | ○ |

### QA_TEST_RUNS テーブル（UT-TAB-048〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | qatr_idがNULLの場合シーケンス自動採番 | E-10（トリガー: `qatru_seq.nextval`） | ○ |
| C-49 | qatr_dateがトリガーでSYSDATE設定 | E-10（トリガー: `:new.qatr_date := SYSDATE`） | ○ |
| C-50 | qatr_added_byがトリガーでユーザー設定 | E-10（トリガー: `:new.qatr_added_by := l_user`） | ○ |
| C-51 | qatr_scheme_name NOT NULL制約 | E-05（DDL: `not null`） | ○ |
| C-52 | qatr_result NOT NULL制約 | E-05（DDL: `not null`） | ○ |
| C-53 | qatr_qaru_id NOT NULL制約 | E-05（DDL: `not null`） | ○ |
| C-54 | qatr_scheme_name最大長255 CHAR | E-05（DDL: `VARCHAR2(255 CHAR)`） | ○ |
| C-55 | qatr_runtime_error最大長4000 CHAR | E-05（DDL: `VARCHAR2(4000 CHAR)`） | ○ |
| C-56 | qatr_qaru_id外部キー参照 | E-05（コメント: `foreign key column to QA_RULES`） | ○ |
| C-57 | qatr_program_name設定可能 | E-05（DDL: `QATR_PROGRAM_NAME VARCHAR2(4000 CHAR)`） | ○ |
| C-58 | qatr_runtime_error設定可能 | E-05（DDL: `QATR_RUNTIME_ERROR VARCHAR2(4000 CHAR)`） | ○ |

## 4) 不足情報（Unknown / Missing）
- **明示的な外部キー制約定義なし**
  - QA_TEST_RUN_INVALID_OBJECTS.qato_qatr_id -> QA_TEST_RUNS.qatr_id（コメントのみ）
  - QA_TEST_RUNS.qatr_qaru_id -> QA_RULES.qaru_id（コメントのみ）
  - 候補：ALTER TABLE文での制約追加 / アプリケーション層での整合性チェック / 将来の移行スクリプト

- **シーケンス定義ファイル未確認**
  - qaif_seq, qaru_seq, qatr_seq, qato_seq, qatru_seq の定義ファイルが別途存在すると推測
  - 候補：seq/ ディレクトリ / install_prereqs.sql / 別途DDLファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テーブル定義とトリガー定義が明確でコード根拠が十分
- **1: 中リスク** - 外部キー制約が明示的に定義されていないため、データ整合性はアプリケーション層に依存
- **0: 低リスク** - エラーレベル値（1/2/4）はコメントに明記されている

## 6) レビュアーチェックリスト（最小）
- [ ] 各テーブルのNOT NULL制約が実際のDDLと一致しているか確認
- [ ] トリガーによる自動採番・監査カラム設定が正しく動作するか確認
- [ ] 外部キー参照先（QA_RULES, QA_TEST_RUNS）のテストデータ準備方法を確認
- [ ] VARCHAR2のCHARセマンティクス（バイト数ではなく文字数）がテスト環境で正しく動作するか確認
- [ ] CLOBカラムの大容量データ保存テストの実施方法を確認
- [ ] シーケンス（qaif_seq, qaru_seq等）が事前に作成されていることを確認
