---
generated_at: 2026-01-22 11:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：trg.csv（トリガー単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/trg/qaif_i_trg.sql` - qa_import_files INSERTトリガー
- E-02: `src/plsql/trg/qaru_iu_trg.sql` - qa_rules INSERT/UPDATEトリガー
- E-03: `src/plsql/trg/qato_i_trg.sql` - qa_test_run_invalid_objects INSERTトリガー
- E-04: `src/plsql/trg/qatr_i_trg.sql` - qa_test_results INSERTトリガー
- E-05: `src/plsql/trg/qatru_i_trg.sql` - qa_test_runs INSERTトリガー

## 3) Claims と根拠の対応（レビューの主戦場）

### QAIF_I_TRG（qa_import_files INSERT トリガー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qaif_idがnullの場合にシーケンス値が自動採番される | E-01（行17-21: IF inserting AND :new.qaif_id IS NULL THEN :new.qaif_id := qaif_seq.nextval;） | ○ |
| C-02 | qaif_idが指定されている場合は変更されない | E-01（条件分岐でnullチェックを実施） | ○ |
| C-03 | qaif_idが0の場合は変更されない | E-01（NULLチェックのみのため0は対象外） | ○ |

### QARU_IU_TRG（qa_rules INSERT/UPDATE トリガー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | qaru_idがnullの場合にシーケンス値が自動採番される | E-02（行24-26: IF inserting AND :new.qaru_id IS NULL THEN :new.qaru_id := qaru_seq.nextval;） | ○ |
| C-05 | INSERT時にqaru_created_onがSYSDATEで設定される | E-02（行27-30: IF inserting THEN :new.qaru_created_on := SYSDATE;） | ○ |
| C-06 | INSERT時にqaru_created_byがユーザー名で設定される | E-02（行29: :new.qaru_created_by := l_user;） | ○ |
| C-07 | INSERT時にqaru_updated_onがSYSDATEで設定される | E-02（行31-34: IF updating OR inserting THEN :new.qaru_updated_on := SYSDATE;） | ○ |
| C-08 | INSERT時にqaru_updated_byがユーザー名で設定される | E-02（行33: :new.qaru_updated_by := l_user;） | ○ |
| C-09 | UPDATE時にqaru_updated_onがSYSDATEで更新される | E-02（行31-34: IF updating OR inserting THEN） | ○ |
| C-10 | UPDATE時にqaru_updated_byがユーザー名で更新される | E-02（行33: :new.qaru_updated_by := l_user;） | ○ |
| C-11 | UPDATE時にqaru_created_on/byが変更されない | E-02（IF insertingブロック内のみでcreated系を設定） | ○ |
| C-12 | APEXセッション外ではos_userが設定される | E-02（行19-23: coalesce(apex$session.app_user, os_user, session_user)） | ○ |
| C-13 | APEXセッション外かつOS未設定時はsession_userが設定される | E-02（行19-23: coalesce優先順位3番目） | ○ |

### QATO_I_TRG（qa_test_run_invalid_objects INSERT トリガー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | qato_idがnullの場合にシーケンス値が自動採番される | E-03（行17-19: IF inserting AND :new.qato_id IS NULL THEN :new.qato_id := qato_seq.nextval;） | ○ |
| C-15 | qato_idが指定されている場合は変更されない | E-03（条件分岐でnullチェックを実施） | ○ |
| C-16 | qato_idが0の場合は変更されない | E-03（NULLチェックのみのため0は対象外） | ○ |

### QATR_I_TRG（qa_test_results INSERT トリガー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | qatr_idがnullの場合にシーケンス値が自動採番される | E-04（行24-26: IF inserting AND :new.qatr_id IS NULL THEN :new.qatr_id := qatr_seq.nextval;） | ○ |
| C-18 | INSERT時にqatr_added_onがSYSDATEで設定される | E-04（行28: :new.qatr_added_on := SYSDATE;） | ○ |
| C-19 | INSERT時にqatr_added_byがユーザー名で設定される | E-04（行29: :new.qatr_added_by := l_user;） | ○ |
| C-20 | qatr_idが指定されている場合は変更されない | E-04（条件分岐でnullチェックを実施） | ○ |
| C-21 | APEXセッション外ではos_userが設定される | E-04（行19-23: coalesce優先順位） | ○ |
| C-22 | APEXセッション外かつOS未設定時はsession_userが設定される | E-04（行19-23: coalesce優先順位3番目） | ○ |
| C-30 | qatr_idが0の場合は変更されない | E-04（NULLチェックのみのため0は対象外） | ○ |

### QATRU_I_TRG（qa_test_runs INSERT トリガー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | qatr_idがnullの場合にシーケンス値が自動採番される | E-05（行24-26: IF inserting AND :new.qatr_id IS NULL THEN :new.qatr_id := qatru_seq.nextval;） | ○ |
| C-24 | INSERT時にqatr_dateがSYSDATEで設定される | E-05（行28: :new.qatr_date := SYSDATE;） | ○ |
| C-25 | INSERT時にqatr_added_byがユーザー名で設定される | E-05（行29: :new.qatr_added_by := l_user;） | ○ |
| C-26 | qatr_idが指定されている場合は変更されない | E-05（条件分岐でnullチェックを実施） | ○ |
| C-27 | APEXセッション外ではos_userが設定される | E-05（行19-22: coalesce優先順位） | ○ |
| C-28 | APEXセッション外かつOS未設定時はsession_userが設定される | E-05（行19-22: coalesce優先順位3番目） | ○ |
| C-29 | qatr_idが0の場合は変更されない | E-05（NULLチェックのみのため0は対象外） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコードの実装に基づいており、推測や仮定を含みません

### 注意点
1. QATRU_I_TRG内のカラム名`qatr_id`は`qatru_id`の誤りの可能性があります（E-05 行24-26参照）
2. シーケンス名は`qatru_seq`となっているため、ID採番は正常に動作します
3. 各トリガーのユーザー取得ロジックは同一パターン（APEX > OS > Session）

## 6) レビュアーチェックリスト（最小）
- [ ] QATRU_I_TRGのqatr_idカラム名が正しいか確認（qatru_idの可能性）
- [ ] 各シーケンス（qaif_seq, qaru_seq, qato_seq, qatr_seq, qatru_seq）が存在するか確認
- [ ] APEXセッションコンテキストの取得方法がAPEXバージョンと互換性があるか確認
- [ ] トリガーが有効化（ENABLE）されているか確認
- [ ] 監査カラム（created_by, updated_by, added_by等）の値が255文字を超えないか確認

---

## 付録：トリガー機能サマリー

| トリガー名 | 対象テーブル | イベント | 主な機能 |
|-----------|-------------|---------|---------|
| QAIF_I_TRG | qa_import_files | BEFORE INSERT | ID自動採番のみ |
| QARU_IU_TRG | qa_rules | BEFORE INSERT/UPDATE | ID自動採番、作成/更新監査情報 |
| QATO_I_TRG | qa_test_run_invalid_objects | BEFORE INSERT | ID自動採番のみ |
| QATR_I_TRG | qa_test_results | BEFORE INSERT | ID自動採番、追加監査情報 |
| QATRU_I_TRG | qa_test_runs | BEFORE INSERT | ID自動採番、実行日時、追加監査情報 |
