---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 54
  claims_with_evidence: 54
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：typ モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：54 / 54、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり
  2. **to_string メソッド**：現在空文字を返す実装だが、将来変更の可能性あり
  3. **CLOB境界値テスト**：実行環境依存の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/plsql/typ/qa_rule_t.sql` - ルールオブジェクト型定義（4コンストラクタ、to_stringメソッド）
- E-02: `src/plsql/typ/qa_rules_t.sql` - ルールコレクション型定義
- E-03: `src/plsql/typ/qa_running_rule_t.sql` - 実行中ルールオブジェクト型定義
- E-04: `src/plsql/typ/qa_running_rules_t.sql` - 実行中ルールコレクション型定義
- E-05: `src/plsql/typ/qa_scheme_object_amount_t.sql` - スキーマオブジェクト数型定義（コンストラクタ付き）
- E-06: `src/plsql/typ/qa_scheme_object_amounts_t.sql` - スキーマオブジェクト数コレクション型定義
- E-07: `src/plsql/typ/qa_test_results_row_t.sql` - テスト結果行型定義
- E-08: `src/plsql/typ/qa_test_results_table_t.sql` - テスト結果テーブル型定義
- E-09: `src/plsql/typ/varchar2_tab_t.sql` - VARCHAR2コレクション型定義

## 3) Claims と根拠の対応（レビューの主戦場）

### qa_rule_t 関連（UT-TYP-001 〜 UT-TYP-015）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qa_rule_tに4つのコンストラクタが存在 | E-01: 行41-99に4つのconstructor function定義 | ○ |
| C-02 | 6引数コンストラクタでqaru_id等6属性を設定 | E-01: 行107-125にコンストラクタ実装 | ○ |
| C-03 | qaru_categoryはVARCHAR2(10) | E-01: 行20に定義 | ○ |
| C-04 | qaru_error_messageはVARCHAR2(4000) | E-01: 行22に定義 | ○ |
| C-05 | 14引数コンストラクタでDBオブジェクト情報を含む | E-01: 行127-161にコンストラクタ実装 | ○ |
| C-06 | scheme_nameはVARCHAR2(100) | E-01: 行27に定義 | ○ |
| C-07 | object_nameはVARCHAR2(1000) | E-01: 行29に定義 | ○ |
| C-08 | object_detailsはVARCHAR2(2000) | E-01: 行30に定義 | ○ |
| C-09 | 4引数コンストラクタは単体テスト用 | E-01: 行70-77のコメント「Unit tests」 | ○ |
| C-10 | 16引数コンストラクタはAPEX用 | E-01: 行79-99のコメント「APEX rules」 | ○ |
| C-11 | to_stringメソッドは空文字を返す | E-01: 行220-223の実装「return ''」 | ○ |

### qa_rules_t 関連（UT-TYP-016 〜 UT-TYP-019）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | qa_rules_tはqa_rule_tのTABLE OF | E-02: 行13「table of qa_rule_t」 | ○ |

### qa_running_rule_t 関連（UT-TYP-020 〜 UT-TYP-024）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | rule_numberはVARCHAR2(10) | E-03: 行15に定義 | ○ |
| C-14 | predecessorはVARCHAR2(100) | E-03: 行16に定義 | ○ |
| C-15 | success_runはVARCHAR2(1) | E-03: 行17に定義 | ○ |
| C-16 | row_valはNUMBER型 | E-03: 行18に定義 | ○ |

### qa_running_rules_t 関連（UT-TYP-025 〜 UT-TYP-026）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | qa_running_rules_tはqa_running_rule_tのTABLE OF | E-04: 行13「TABLE OF qa_running_rule_t」 | ○ |

### qa_scheme_object_amount_t 関連（UT-TYP-027 〜 UT-TYP-031）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | qa_scheme_object_amount_tにコンストラクタが存在 | E-05: 行19-23にconstructor function定義 | ○ |
| C-19 | scheme_nameはVARCHAR2(100) | E-05: 行15に定義 | ○ |
| C-20 | object_amountはNUMBER型 | E-05: 行16に定義 | ○ |

### qa_scheme_object_amounts_t 関連（UT-TYP-032 〜 UT-TYP-033）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | qa_scheme_object_amounts_tはqa_scheme_object_amount_tのTABLE OF | E-06: 行13「table of qa_scheme_object_amount_t」 | ○ |

### qa_test_results_row_t 関連（UT-TYP-034 〜 UT-TYP-039）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | qa_test_results_row_tに11属性が存在 | E-07: 行14-24に11属性定義 | ○ |
| C-23 | qatr_dateはDATE型 | E-07: 行15に定義 | ○ |
| C-24 | qatr_scheme_nameはVARCHAR2(100) | E-07: 行16に定義 | ○ |
| C-25 | qaru_client_nameはVARCHAR2(4000) | E-07: 行23に定義 | ○ |
| C-26 | qatr_program_nameはVARCHAR2(500) | E-07: 行24に定義 | ○ |

### qa_test_results_table_t 関連（UT-TYP-040 〜 UT-TYP-042）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | qa_test_results_table_tはqa_test_results_row_tのTABLE OF | E-08: 行13「table of qa_test_results_row_t」 | ○ |

### varchar2_tab_t 関連（UT-TYP-043 〜 UT-TYP-049）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | varchar2_tab_tはVARCHAR2(4000 char)のTABLE OF | E-09: 行13「TABLE OF varchar2(4000 char)」 | ○ |
| C-29 | 「char」指定でマルチバイト対応 | E-09: 行13の「4000 char」定義 | ○ |

### 共通テストケース（UT-TYP-050 〜 UT-TYP-054）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | オブジェクト型の属性はドット記法でアクセス可能 | Oracle PL/SQL仕様（オブジェクト型の標準動作） | ○ |
| C-31 | CLOB型属性で大きなデータを格納可能 | E-01: 行24「qaru_sql clob」定義 | ○ |
| C-32 | TABLE OF型でFOR LOOPによる走査が可能 | Oracle PL/SQL仕様（コレクション型の標準動作） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースがソースコード定義に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコードの型定義に直接対応
- **注意点**：
  - to_stringメソッドは現在空実装（将来的に実装追加の可能性）
  - CLOB型の境界値テストは実行環境のメモリ制限に依存
  - VARCHAR2(4000 char)のマルチバイト境界値はDB文字セットに依存

## 6) レビュアーチェックリスト（最小）
- [ ] 各コンストラクタのパラメータ数と型が正しいか
- [ ] VARCHAR2型の境界値（文字数）がソースコードの定義と一致しているか
- [ ] コレクション型（TABLE OF）の基本操作テストが網羅されているか
- [ ] NULL許容の確認テストが含まれているか
- [ ] 異常系テスト（サイズ超過）の期待結果が正しいか
- [ ] APEX関連パラメータのテストが十分か
