---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：vw.csv（単体テストケース一覧 - ビューモジュール）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **qa_faceted_search_dashboard_data_p0001_v の日付変換エラー**：APEXコレクションの日付形式に依存
  2. **qa_predecessor_order_v の循環参照対策**：NOCYCLE句の動作確認が必要
  3. **qa_unit_test_packages_p0002_v のLIKEエスケープ**：定数パッケージとの連携確認

## 2) 参照した情報（Evidence一覧）
> 各ビューのSQLソースコードを根拠として使用

- E-01: `src/plsql/vw/qa_apex_blacklisted_apps_v.sql`
- E-02: `src/plsql/vw/qa_application_owner_v.sql`
- E-03: `src/plsql/vw/qa_client_names_p0008_v.sql`
- E-04: `src/plsql/vw/qa_faceted_search_dashboard_data_p0001_v.sql`
- E-05: `src/plsql/vw/qa_job_details_P0009_v.sql`
- E-06: `src/plsql/vw/qa_job_run_details_p0009_v.sql`
- E-07: `src/plsql/vw/qa_job_run_details_p0011_v.sql`
- E-08: `src/plsql/vw/qa_overview_quota_p0001_v.sql`
- E-09: `src/plsql/vw/qa_overview_tests_p0001_v.sql`
- E-10: `src/plsql/vw/qa_overview_timeline_error_p0001_v.sql`
- E-11: `src/plsql/vw/qa_overview_timeline_failure_p0001_v.sql`
- E-12: `src/plsql/vw/qa_overview_timeline_success_p0001_v.sql`
- E-13: `src/plsql/vw/qa_predecessor_order_v.sql`
- E-14: `src/plsql/vw/qa_rule_categories_lov.sql`
- E-15: `src/plsql/vw/qa_rule_error_levels_lov.sql`
- E-16: `src/plsql/vw/qa_rule_layers_lov.sql`
- E-17: `src/plsql/vw/qa_rules_p0006_v.sql`
- E-18: `src/plsql/vw/qa_rules_p0007_v.sql`
- E-19: `src/plsql/vw/qa_scheme_names_for_testing_v.sql`
- E-20: `src/plsql/vw/qa_test_execution_dates_lov.sql`
- E-21: `src/plsql/vw/qa_test_result_files_p0005_v.sql`
- E-22: `src/plsql/vw/qa_test_run_details_p0004_v.sql`
- E-23: `src/plsql/vw/qa_test_runtime_error_p0003_v.sql`
- E-24: `src/plsql/vw/qa_test_scheme_names_lov.sql`
- E-25: `src/plsql/vw/qa_unit_test_packages_p0002_v.sql`

## 3) Claims と根拠の対応（レビューの主戦場）

### qa_apex_blacklisted_apps_v（UT-VW-001〜002）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INTERNALワークスペースのフィルタ条件 | E-01: `where workspace_display_name in ('INTERNAL')` | ○ |
| C-02 | 空結果のケース | E-01: フィルタ条件確認 | ○ |

### qa_application_owner_v（UT-VW-003〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | owner昇順ソート | E-02: `order by owner asc` | ○ |
| C-04 | 空結果のケース | E-02: apex_applications依存 | ○ |

### qa_client_names_p0008_v（UT-VW-005〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | ROWNUMによる連番生成 | E-03: `rownum as clientid` | ○ |
| C-06 | GROUP BYによる重複排除 | E-03: `group by qaru_client_name` | ○ |
| C-07 | 空結果のケース | E-03: QA_RULES依存 | ○ |

### qa_faceted_search_dashboard_data_p0001_v（UT-VW-008〜011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | APEXコレクション参照 | E-04: `from apex_collections where collection_name = 'FACETED_SEARCH_DASHBOARD_DATA_P0001'` | ○ |
| C-09 | 日付変換処理 | E-04: `to_date(c002,'MM/DD/YYYY')` | ○ |
| C-10 | 不正日付形式のエラー | E-04: to_date関数の仕様 | ○ |
| C-11 | 空結果のケース | E-04: コレクション依存 | ○ |

### qa_job_details_P0009_v（UT-VW-012〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | スケジューラジョブ詳細取得 | E-05: `from USER_SCHEDULER_JOBS where job_name = qa_utils_pkg.f_get_constant_string_value(...)` | ○ |
| C-13 | HH:MM:SS形式変換 | E-05: `lpad(to_char(extract(hour from LAST_RUN_DURATION)),2,'0') || ':' || ...` | ○ |
| C-14 | NVL処理によるNULL対策 | E-05: `nvl(..., '00')` | ○ |
| C-15 | 空結果のケース | E-05: job_name条件依存 | ○ |

### qa_job_run_details_p0009_v（UT-VW-016〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | quastoジョブの実行履歴取得 | E-06: `where job_name = qa_utils_pkg.f_get_constant_string_value(...)` | ○ |
| C-17 | FAILEDからERRORへの変換 | E-06: `case when status = 'FAILED' then 'ERROR' else status end` | ○ |
| C-18 | SUCCEEDED非変換 | E-06: CASE式確認 | ○ |
| C-19 | HH:MM:SS形式変換 | E-06: extract関数使用 | ○ |
| C-20 | log_date降順ソート | E-06: `order by log_date desc` | ○ |

### qa_job_run_details_p0011_v（UT-VW-021〜023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | quastoジョブ以外の履歴取得 | E-07: `where job_name != qa_utils_pkg.f_get_constant_string_value(...)` | ○ |
| C-22 | FAILEDからERRORへの変換 | E-07: CASE式確認 | ○ |
| C-23 | フィルタ条件確認 | E-07: != 演算子使用 | ○ |

### qa_overview_quota_p0001_v（UT-VW-024〜028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | ステータス別件数取得 | E-08: `count(1) over (partition by qatr_result)` | ○ |
| C-25 | Failure色コード#c42222 | E-08: `when 'Failure' then '#c42222'` | ○ |
| C-26 | Error色コード#7a1616 | E-08: `when 'Error' then '#7a1616'` | ○ |
| C-27 | Success色コード#1c6d11 | E-08: `else '#1c6d11'` | ○ |
| C-28 | PARTITION BY集計 | E-08: ウィンドウ関数確認 | ○ |

### qa_overview_tests_p0001_v（UT-VW-029〜037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | テスト結果一覧取得 | E-09: QA_TEST_RUNS JOIN QA_RULES | ○ |
| C-30 | qatr_result=0がFailure | E-09: `when 0 then 'Failure'` | ○ |
| C-31 | qatr_result=1がSuccess | E-09: `when 1 then 'Success'` | ○ |
| C-32 | qatr_result=2がError | E-09: `when 2 then 'Error'` | ○ |
| C-33 | 無効オブジェクト時の詳細リンク | E-09: `case when qatr.qatr_result in (0,2) and vc.invalid_exists = 1 then '<a href="' || APEX_PAGE.GET_URL(...)` | ○ |
| C-34 | 成功時の詳細リンクNULL | E-09: CASE条件外確認 | ○ |
| C-35 | 再実行リンク生成 | E-09: `qatr_restart_unit_test`カラム定義 | ○ |
| C-36 | エラーリンク生成 | E-09: `case when qatr.qatr_runtime_error is not null then '<a href="' || ...` | ○ |
| C-37 | ソート順 | E-09: `order by qaru_client_name asc, qatr_date desc, ...` | ○ |

### qa_overview_timeline_error_p0001_v（UT-VW-038〜042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | 直近10日間のError件数 | E-10: `fetch first 10 rows only` + `where q2.qatr_result = 'Error'` | ○ |
| C-39 | 色コード#7a1616固定 | E-10: `'#7a1616' as color_hex` | ○ |
| C-40 | MM/DD/YYYY形式 | E-10: `to_char(qatr_date, 'MM/DD/YYYY')` | ○ |
| C-41 | 日付昇順ソート | E-10: `order by qatr_date asc` | ○ |
| C-42 | 空結果のケース | E-10: フィルタ条件確認 | ○ |

### qa_overview_timeline_failure_p0001_v（UT-VW-043〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | 直近10日間のFailure件数 | E-11: `where q2.qatr_result = 'Failure'` | ○ |
| C-44 | 色コード#c42222固定 | E-11: `'#c42222' as color_hex` | ○ |
| C-45 | 空結果のケース | E-11: フィルタ条件確認 | ○ |

### qa_overview_timeline_success_p0001_v（UT-VW-046〜048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | 直近10日間のSuccess件数 | E-12: `where q2.qatr_result = 'Success'` | ○ |
| C-47 | 色コード#1c6d11固定 | E-12: `'#1c6d11' as color_hex` | ○ |
| C-48 | 空結果のケース | E-12: フィルタ条件確認 | ○ |

### qa_predecessor_order_v（UT-VW-049〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 先行順序取得 | E-13: `qa_main_pkg.f_get_full_rule_pred(pi_rule_number => qaru_rule_number)` | ○ |
| C-50 | コロン区切りパース | E-13: `regexp_substr(t.qaru_predecessor_ids, '[^:]+'...)` | ○ |
| C-51 | 階層的先行関係解決 | E-13: `connect by nocycle prior qaru_rule_number = predec` | ○ |
| C-52 | f_get_full_rule_pred連携 | E-13: パッケージ関数呼び出し確認 | ○ |
| C-53 | NULLの先行ID処理 | E-13: `start with predec is null` | ○ |
| C-54 | 循環参照対策 | E-13: `nocycle`キーワード使用 | ○ |

### qa_rule_categories_lov（UT-VW-055〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | カテゴリ一覧（APEX, DATA, DDL） | E-14: UNION ALL定義確認 | ○ |
| C-56 | display_value=return_value | E-14: カラム定義確認 | ○ |

### qa_rule_error_levels_lov（UT-VW-057〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | エラーレベル一覧（Error, Info, Warning） | E-15: UNION ALL定義確認 | ○ |
| C-58 | return_valueが数値 | E-15: `1 as return_value`, `2`, `4` | ○ |

### qa_rule_layers_lov（UT-VW-059〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | レイヤー一覧（APPLICATION, DATABASE, PAGE） | E-16: UNION ALL定義確認 | ○ |
| C-60 | display_value=return_value | E-16: カラム定義確認 | ○ |

### qa_rules_p0006_v（UT-VW-061〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ルール一覧取得 | E-17: `from QA_RULES`全カラム選択 | ○ |
| C-62 | 監査カラム含む | E-17: `QARU_CREATED_ON, QARU_CREATED_BY, QARU_UPDATED_ON, QARU_UPDATED_BY` | ○ |
| C-63 | 空結果のケース | E-17: QA_RULES依存 | ○ |

### qa_rules_p0007_v（UT-VW-064〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ルール詳細取得 | E-18: QARU_SQL, QARU_OBJECT_TYPES等選択 | ○ |
| C-65 | QARU_SQL取得 | E-18: カラム定義確認 | ○ |
| C-66 | QARU_SQL NULL処理 | E-18: NULLable確認 | ○ |

### qa_scheme_names_for_testing_v（UT-VW-067〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | テスト対象スキーマ一覧 | E-19: `from all_users where username not in (...)` | ○ |
| C-68 | Oracleシステムスキーマ除外 | E-19: SYS, SYSTEM等のNOT IN条件 | ○ |
| C-69 | APEXスキーマ除外 | E-19: APEX_LISTENER, APEX_PUBLIC_USER等のNOT IN条件 | ○ |
| C-70 | APEXバージョンスキーマ除外 | E-19: `not regexp_like(username, '^APEX_[0-9]{4}00$')` | ○ |
| C-71 | ORDSスキーマ除外 | E-19: ORDS_METADATA, ORDS_PUBLIC_USERのNOT IN条件 | ○ |
| C-72 | PUBLIC除外 | E-19: PUBLICのNOT IN条件 | ○ |

### qa_test_execution_dates_lov（UT-VW-073〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | テスト実行日LOV | E-20: `from QA_OVERVIEW_TESTS_P0001_V group by qatr_date` | ○ |
| C-74 | 日付降順ソート | E-20: `order by v.qatr_date desc` | ○ |
| C-75 | 日付集約 | E-20: GROUP BY確認 | ○ |
| C-76 | 空結果のケース | E-20: 依存ビュー確認 | ○ |

### qa_test_result_files_p0005_v（UT-VW-077〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | テスト結果ファイル一覧 | E-21: `from QA_TEST_RESULTS` | ○ |
| C-78 | 空結果のケース | E-21: テーブル依存 | ○ |

### qa_test_run_details_p0004_v（UT-VW-079〜081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | 無効オブジェクト詳細取得 | E-22: `QA_TEST_RUNS join QA_TEST_RUN_INVALID_OBJECTS` | ○ |
| C-80 | JOIN条件確認 | E-22: `on qato.qato_qatr_id = qatr.qatr_id` | ○ |
| C-81 | 空結果のケース | E-22: JOIN依存 | ○ |

### qa_test_runtime_error_p0003_v（UT-VW-082〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | 実行時エラー情報取得 | E-23: `qatr_id, qatr_runtime_error from QA_TEST_RUNS` | ○ |
| C-83 | qatr_runtime_error NULL許容 | E-23: カラム定義確認 | ○ |
| C-84 | 空結果のケース | E-23: テーブル依存 | ○ |

### qa_test_scheme_names_lov（UT-VW-085〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | テスト用スキーマ名LOV | E-24: `from QA_SCHEME_NAMES_FOR_TESTING_V order by username asc` | ○ |
| C-86 | display_value=return_value | E-24: `username as display_value, username as return_value` | ○ |
| C-87 | 空結果のケース | E-24: 依存ビュー確認 | ○ |

### qa_unit_test_packages_p0002_v（UT-VW-088〜093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | 単体テストパッケージ一覧 | E-25: `from user_objects where object_type = 'PACKAGE'` | ○ |
| C-89 | MM/DD/YYYY形式変換 | E-25: `to_char(last_ddl_time, 'MM/DD/YYYY')` | ○ |
| C-90 | プレフィックス条件フィルタ | E-25: `object_name like ... || '%'` | ○ |
| C-91 | アンダースコアエスケープ | E-25: `replace(..., '_', '\_') ... escape '\'` | ○ |
| C-92 | package_name昇順ソート | E-25: `order by object_name asc` | ○ |
| C-93 | 空結果のケース | E-25: 条件依存 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースがソースコードに基づいて作成されている

## 5) リスクフラグ（レビュー観点）
- **リスク 1（中リスク）**: qa_faceted_search_dashboard_data_p0001_v の日付変換（to_date）は、APEXコレクションのデータ品質に依存。不正な日付形式のデータが入った場合のエラーハンドリングはビュー側では行われていない。
- **リスク 1（中リスク）**: qa_predecessor_order_v のCONNECT BY NOCYCLEは循環参照を検出するが、パフォーマンスへの影響は大量データ時に確認が必要。
- **リスク 0（低リスク）**: LOVビュー（qa_rule_categories_lov等）は静的データのため、テストは形式的確認が中心。

## 6) レビュアーチェックリスト（最小）
- [ ] qa_faceted_search_dashboard_data_p0001_v：APEXコレクション内の日付形式が'MM/DD/YYYY'で統一されていることを確認
- [ ] qa_overview_tests_p0001_v：APEX_PAGE.GET_URLで生成されるリンクが正しい画面に遷移することを確認
- [ ] qa_predecessor_order_v：qa_main_pkg.f_get_full_rule_predの存在と引数仕様を確認
- [ ] qa_job_details_P0009_v, qa_job_run_details_p0009/p0011_v：qa_utils_pkg.f_get_constant_string_valueの定数名が正しいことを確認
- [ ] qa_unit_test_packages_p0002_v：gc_utplsql_ut_test_packages_prefix定数が定義されていることを確認
- [ ] qa_scheme_names_for_testing_v：除外スキーマリストが環境に適合していることを確認
