---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **UAT-027（レスポンシブデザイン）**：実装詳細の確認が必要
  2. **UAT-032（認証・認可）**：OpenDoor認証の動作検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - QUASTO概要、インストール手順、使用方法
- E-02: `src/apex/f141/application/pages/page_00001.sql` - Dashboard画面定義
- E-03: `src/apex/f141/application/pages/page_00002.sql` - Unit Test Generation画面定義
- E-04: `src/apex/f141/application/pages/page_00003.sql` - Runtime Error画面定義
- E-05: `src/apex/f141/application/pages/page_00004.sql` - Invalid Objects画面定義
- E-06: `src/apex/f141/application/pages/page_00005.sql` - Test Result Files画面定義
- E-07: `src/apex/f141/application/pages/page_00006.sql` - Rules画面定義
- E-08: `src/apex/f141/application/pages/page_00007.sql` - Add/Edit Rule画面定義
- E-09: `src/apex/f141/application/pages/page_00008.sql` - Rule Files画面定義
- E-10: `src/apex/f141/application/pages/page_00009.sql` - Config Scheduler Job画面定義
- E-11: `src/apex/f141/application/pages/page_00011.sql` - Restart Unit Test画面定義
- E-12: `src/apex/f141/embedded_code/pages/p00001.js` - Dashboard JavaScript
- E-13: `src/apex/f141/application/shared_components/security/authorizations/administration_rights.sql` - 認可設定
- E-14: `src/apex/f141/application/shared_components/security/authentications/` - 認証設定ディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: ダッシュボード初期表示でQuotaチャート、Timelineチャート、テスト実行レポート、フィルター領域が表示される | E-02, E-12 | ○ |
| C-02 | UAT-002: Categoriesフィルターで絞り込みが可能 | E-02 | ○ |
| C-03 | UAT-003: Clients/Projectsフィルターで絞り込みが可能 | E-02 | ○ |
| C-04 | UAT-004: Schemesフィルターで絞り込みが可能 | E-02 | ○ |
| C-05 | UAT-005: Test Resultsフィルターで絞り込みが可能 | E-02 | ○ |
| C-06 | UAT-006: Error Levelsフィルターで絞り込みが可能 | E-02 | ○ |
| C-07 | UAT-007: Datesフィルターで絞り込みが可能 | E-02 | ○ |
| C-08 | UAT-008: 不適合オブジェクト詳細がモーダルダイアログで表示される | E-05 | ○ |
| C-09 | UAT-009: ランタイムエラー詳細がモーダルダイアログで表示される | E-04 | ○ |
| C-10 | UAT-010: ルール一覧がレポート形式で表示される | E-07 | ○ |
| C-11 | UAT-011: 新規ルール作成でルール番号、クライアント名、名前等が必須 | E-08 | ○ |
| C-12 | UAT-012: 既存ルール編集時にルール番号とクライアント名が読み取り専用 | E-08 | ○ |
| C-13 | UAT-013: テスト結果保存済みルールは削除不可 | E-08 | ○ |
| C-14 | UAT-014: スキーム単位でユニットテスト生成が可能 | E-03 | ○ |
| C-15 | UAT-015: ルール単位でユニットテスト生成が可能 | E-03 | ○ |
| C-16 | UAT-016: ユニットテスト削除が可能 | E-03 | ○ |
| C-17 | UAT-017: スケジューラジョブの有効化/無効化が可能 | E-10 | ○ |
| C-18 | UAT-018: Cronjobの即時実行が可能 | E-10 | ○ |
| C-19 | UAT-019: ジョブ実行履歴が確認できる | E-10 | ○ |
| C-20 | UAT-020: 特定ルールのユニットテスト再実行が可能 | E-11 | ○ |
| C-21 | UAT-021: XMLテスト結果ファイルのアップロードが可能 | E-06 | ○ |
| C-22 | UAT-022: XMLテスト結果ファイルのダウンロードが可能 | E-06 | ○ |
| C-23 | UAT-023: ルールJSONファイルのインポートが可能 | E-09 | ○ |
| C-24 | UAT-024: ルールJSONファイルのエクスポートが可能 | E-09 | ○ |
| C-25 | UAT-025: ルール定義からテスト実行までの完全フローが動作する | E-01, E-02, E-07, E-08, E-10 | ○ |
| C-26 | UAT-026: ルールのエクスポート/インポートフローが動作する | E-01, E-09 | ○ |
| C-27 | UAT-027: レスポンシブデザインが適切に動作する | **根拠なし** | △ |
| C-28 | UAT-028: フィルター操作が即時反映される | E-02, E-12 | ○ |
| C-29 | UAT-029: 重複ルール番号でバリデーションエラーが表示される | E-08 | ○ |
| C-30 | UAT-030: 重複ルール名でバリデーションエラーが表示される | E-08 | ○ |
| C-31 | UAT-031: テスト結果保存済みルール削除時にエラーが表示される | E-08 | ○ |
| C-32 | UAT-032: 未認証状態でアクセス拒否される | E-13, E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- **UAT-027（レスポンシブデザイン）の根拠なし**
  - Universal ThemeはOracle APEXの標準機能として提供されるが、本プロジェクトでのカスタマイズ状況は未確認
  - 候補：テーマ設定ファイル / CSSカスタマイズ / APEX管理画面設定

- **UAT-032（認証・認可）の詳細確認が必要**
  - Oracle APEXアカウント認証とOpenDoor認証の両方が設定されているが、実運用時の認証方式の詳細確認が必要
  - 候補：認証設定SQL / セキュリティポリシー文書

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UAT-001〜UAT-026, UAT-028〜UAT-031 - ソースコードに明確な根拠あり
- **1（中リスク）**: UAT-027 - Universal Theme依存、カスタマイズ状況要確認
- **1（中リスク）**: UAT-032 - 認証設定は存在するが、実環境での動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001〜UAT-007: ダッシュボード画面でフィルター機能が正しく動作するか確認
- [ ] UAT-008〜UAT-009: モーダルダイアログでの詳細表示が正しいか確認
- [ ] UAT-010〜UAT-013: ルール管理のCRUD操作が正しく動作するか確認
- [ ] UAT-014〜UAT-016: ユニットテスト生成・削除が正しく動作するか確認
- [ ] UAT-017〜UAT-019: スケジューラジョブ設定が正しく動作するか確認
- [ ] UAT-020: テスト再実行が正しく動作するか確認
- [ ] UAT-021〜UAT-024: ファイルアップロード/ダウンロード機能が正しく動作するか確認
- [ ] UAT-025〜UAT-026: エンドツーエンドシナリオが完全に動作するか確認
- [ ] UAT-027: 様々な画面サイズでレイアウト崩れがないか確認（実機検証推奨）
- [ ] UAT-028: フィルター操作のレスポンスが十分に速いか確認
- [ ] UAT-029〜UAT-031: バリデーションエラーメッセージが正しく表示されるか確認
- [ ] UAT-032: ログアウト状態でのアクセス拒否を確認（実環境検証推奨）
