---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 6
  claims_with_evidence: 6
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：6 / 6、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_apex_app_pkg.sql` - p_download_rules_json プロシージャ（32-35行目、163-207行目）
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` - p_download_unit_test_xml プロシージャ（44-47行目、248-295行目）
- E-03: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - f_export_rules_table_to_clob 関数（27-31行目、82-239行目）
- E-04: `src/plsql/pkg/qa_unit_tests_pkg.sql` - f_export_test_result 関数（189-193行目）
- E-05: `src/apex/f141/application/pages/page_00008.sql` - Export Rules リージョン定義（27行目）
- E-06: `src/apex/f141/application/pages/page_00005.sql` - File Download リージョン定義（27行目）
- E-07: `src/apex/f141/application/shared_components/logic/application_processes/getrulejsonattachment.sql` - getRuleJSONAttachment アプリケーションプロセス
- E-08: `src/apex/f141/application/shared_components/logic/application_processes/getutxmlattachment.sql` - getUTXMLAttachment アプリケーションプロセス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルールエクスポート帳票が存在する | E-01, E-03, E-05, E-07 | ○ |
| C-02 | ルールはJSON形式でエクスポートされる | E-01, E-03 | ○ |
| C-03 | ルールエクスポートファイル名は export_rules_{クライアント名}_{日時}.json 形式 | E-01（188行目） | ○ |
| C-04 | テスト結果エクスポート帳票が存在する | E-02, E-04, E-06, E-08 | ○ |
| C-05 | テスト結果はXML形式でエクスポートされる | E-02, E-04 | ○ |
| C-06 | テスト結果エクスポートファイル名は export_unit_test_results_{日時}.xml 形式 | E-02（276行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に明確な根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての帳票機能はコード上で明確に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票一覧に記載された2件の帳票がシステム要件と一致しているか確認
- [ ] 帳票のカテゴリ分類が適切か確認
- [ ] 帳票の説明文がエンドユーザーにとって理解しやすい内容か確認
