# 帳票設計書 1-ルールエクスポート（JSON形式）

## 概要

本ドキュメントは、QUASTOシステムにおけるルールエクスポート（JSON形式）機能の帳票設計を定義する。本帳票は、QA_RULESテーブルに格納されたQUASTOルール定義をJSON形式でファイル出力する機能を提供する。

### 本帳票の処理概要

QUASTOルールをJSON形式でエクスポートし、クライアント名ごとにルール定義をファイルとしてダウンロード可能にする機能である。

**業務上の目的・背景**：QUASTOは品質管理ツールであり、データベースオブジェクトの品質ルールを定義・管理している。異なる環境間（開発・検証・本番）でルール定義を共有したり、バックアップを取得したり、他プロジェクトにルールを移植したりするためのエクスポート機能が必要である。JSON形式を採用することで、人間が可読であり、かつシステム間でのデータ交換が容易になる。

**帳票の利用シーン**：本帳票は以下の場面で利用される。
- 環境間でのルール移行時（開発環境から本番環境へのルール移植）
- ルール定義のバックアップ取得時
- 他のQUASTOインスタンスへのルール共有時
- ルール変更履歴の記録のためのスナップショット作成時

**主要な出力内容**：
1. ルールのバージョン番号（version）
2. クライアント名（client_name）とカテゴリ（category）による階層構造
3. 各ルールの詳細情報（rule_number, name, object_types, error_message, comment, exclude_objects, error_level, is_active, sql, predecessor_ids, layer）

**帳票の出力タイミング**：APEX画面「Rule Files」（ページ8）において、ユーザーがエクスポート対象のクライアント名を選択し、ダウンロードアイコンをクリックした時に出力される。

**帳票の利用者**：システム管理者、品質管理担当者、開発者

## 帳票種別

データエクスポート帳票（JSON形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 8 | Rule Files | /f?p=141:8 | ダウンロードアイコンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | export_rules_{クライアント名}_{日時}.json |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| Pretty Print | 有（json_serialize...pretty） |
| バージョン番号 | 1.1 |
| 構造 | 階層構造（client_names > categories > rules） |

## 帳票レイアウト

### レイアウト概要

JSON形式のデータ構造として、バージョン情報を含むルートオブジェクト内に、クライアント名・カテゴリ・ルールの階層構造でデータを格納する。

```json
{
  "version": 1.1,
  "qa_rules": [
    {
      "client_names": [
        {
          "client_name": "クライアント名",
          "categories": [
            {
              "category": "カテゴリ名",
              "rules": [...]
            }
          ]
        }
      ]
    }
  ]
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | JSONフォーマットのバージョン | 定数（g_version_number = 1.1） | 数値 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | client_name | クライアント名 | QA_RULES.qaru_client_name | 文字列 | - |
| 2 | category | ルールカテゴリ | QA_RULES.qaru_category | 文字列 | - |
| 3 | rule_number | ルール番号 | QA_RULES.qaru_rule_number | 文字列 | - |
| 4 | name | ルール名 | QA_RULES.qaru_name | 文字列 | - |
| 5 | object_types | 対象オブジェクトタイプ | QA_RULES.qaru_object_types | 文字列 | - |
| 6 | error_message | エラーメッセージ | QA_RULES.qaru_error_message | 文字列 | - |
| 7 | comment | コメント | QA_RULES.qaru_comment | 文字列 | - |
| 8 | exclude_objects | 除外オブジェクト | QA_RULES.qaru_exclude_objects | 文字列 | - |
| 9 | error_level | エラーレベル | QA_RULES.qaru_error_level | 数値 | - |
| 10 | is_active | アクティブフラグ | QA_RULES.qaru_is_active | 数値（0/1） | - |
| 11 | sql | SQLクエリ | QA_RULES.qaru_sql | CLOB | - |
| 12 | predecessor_ids | 先行ルールID | QA_RULES.qaru_predecessor_ids | 文字列 | - |
| 13 | layer | レイヤー | QA_RULES.qaru_layer | 文字列 | - |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| クライアント名 | pi_client_nameで指定されたクライアント名に一致するルール | Yes |
| カテゴリ | pi_categoryで指定されたカテゴリに一致するルール（NULL時は全カテゴリ） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | qaru_client_name | 昇順 |
| 2 | qaru_category | 昇順 |
| 3 | qaru_id | 昇順（暗黙的） |

### 改ページ条件

該当なし（JSONファイル出力のため）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| QA_RULES | ルール定義の取得 | 単一テーブル |

### テーブル別参照項目詳細

#### QA_RULES

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| qaru_client_name | client_name | WHERE条件（pi_client_nameと一致） | GROUP BY対象 |
| qaru_category | category | WHERE条件（pi_categoryと一致、NULL時は全件） | GROUP BY対象 |
| qaru_rule_number | rule_number | - | - |
| qaru_name | name | - | - |
| qaru_object_types | object_types | - | - |
| qaru_error_message | error_message | - | - |
| qaru_comment | comment | - | - |
| qaru_exclude_objects | exclude_objects | - | - |
| qaru_error_level | error_level | - | - |
| qaru_is_active | is_active | - | - |
| qaru_sql | sql | - | CLOB型 |
| qaru_predecessor_ids | predecessor_ids | NULLの場合空文字に変換 | nvl(...,'') |
| qaru_layer | layer | - | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ルール件数 | count(1) from QA_RULES | - | ログ出力用 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ダウンロード要求] --> B[APEXアプリケーションプロセス getRuleJSONAttachment 呼出]
    B --> C[qa_apex_app_pkg.p_download_rules_json 呼出]
    C --> D[qa_export_import_rules_pkg.f_export_rules_table_to_clob 呼出]
    D --> E{ルール存在チェック}
    E -->|ルールなし| F[NULL返却]
    E -->|ルールあり| G[クライアント名ループ]
    G --> H[カテゴリループ]
    H --> I[ルールループ]
    I --> J[JSON構造構築]
    J --> K[json_serialize でPretty Print]
    K --> L[CLOB返却]
    L --> M[HTTPヘッダー設定]
    M --> N[ファイル名生成]
    N --> O[Content-Disposition設定]
    O --> P[チャンク分割出力]
    P --> Q[apex_application.stop_apex_engine]
    Q --> R[終了]
    F --> R
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定クライアント名のルールが存在しない | No rules found. | ログ出力し、NULLを返却 |
| NO_DATA_FOUND | ルール取得時に予期せぬデータなし | qa_logger_pkg経由でログ | 例外を再スロー |
| OTHERS | その他の例外 | There has been an error while trying to Export Rules from Table | qa_logger_pkgでログ後、例外を再スロー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 制限なし（APEXセッション依存） |

## セキュリティ考慮事項

- ルールのSQLクエリにはデータベーススキーマ情報が含まれる可能性があるため、エクスポートファイルの取り扱いには注意が必要
- APEX保護レベル「C」（Unrestricted）に設定されているため、認証済みユーザーのみアクセス可能
- ファイルダウンロード時にCache-Control: no-cacheを設定し、キャッシュを無効化

## 備考

- バージョン番号（g_version_number）は1.1として定義
- JSON出力時はjson_serializeのprettyオプションを使用し、可読性を向上
- g_spool_activeフラグがtrueの場合、ログ出力（dbms_output）が抑制される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、出力対象となるテーブル構造と、出力されるJSON形式の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_rules.sql | `src/ddl/tab/qa_rules.sql` | ルールテーブルのカラム定義、各カラムのコメントを確認 |

**読解のコツ**: QA_RULESテーブルの各カラム（qaru_client_name, qaru_category, qaru_rule_number等）がJSON出力のどのフィールドに対応するかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるAPEXアプリケーションプロセスとAPEX画面を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_processes.sql | `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` | getRuleJSONAttachmentプロセスの呼び出し |
| 2-2 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | Rule Files画面のダウンロードリンク設定 |

**主要処理フロー**:
1. **行14-16**: getRuleJSONAttachmentプロセスでqa_apex_app_pkg.p_download_rules_json呼び出し
2. **行99**: ダウンロードリンクのURL構成（AI_CLIENT_NAMEパラメータ渡し）

#### Step 3: APEXアプリケーション層を理解する

APEX画面からの呼び出しを受けて、ダウンロード処理を行うパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_download_rules_json手続きの実装 |

**主要処理フロー**:
- **行163-207**: p_download_rules_json手続き
- **行179**: f_export_rules_table_to_clobの呼び出し
- **行183-189**: HTTPヘッダー設定（Content-Type, Content-Disposition）
- **行191-195**: CLOBデータのチャンク分割出力

#### Step 4: コアロジック層を理解する

実際のJSON生成処理を行うパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | f_export_rules_table_to_clob関数の実装 |

**主要処理フロー**:
- **行82-239**: f_export_rules_table_to_clob関数
- **行113-118**: ルール件数チェック
- **行133-209**: 三重ループ（クライアント名→カテゴリ→ルール）でJSON構造構築
- **行170-195**: 各ルールのJSONオブジェクト生成
- **行215-218**: メインJSONオブジェクトにバージョンとルール配列を設定
- **行220-224**: json_serialize関数でPretty Print

### プログラム呼び出し階層図

```
APEX Page 8 (Rule Files)
    │
    ├─ Download Link Click
    │      │
    │      └─ APPLICATION_PROCESS: getRuleJSONAttachment
    │             │
    │             └─ qa_apex_app_pkg.p_download_rules_json
    │                    │
    │                    ├─ qa_export_import_rules_pkg.f_export_rules_table_to_clob
    │                    │      │
    │                    │      ├─ QA_RULES テーブル参照
    │                    │      │
    │                    │      └─ JSON構造構築 (json_object_t, json_array_t)
    │                    │
    │                    ├─ qa_utils_pkg.f_get_unified_string (ファイル名生成)
    │                    │
    │                    ├─ HTP/OWA_UTIL (HTTPヘッダー設定)
    │                    │
    │                    └─ apex_application.stop_apex_engine
    │
    └─ QA_CLIENT_NAMES_P0008_V (クライアント名一覧表示)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

QA_RULES テーブル ───▶ f_export_rules_table_to_clob ───▶ JSON形式CLOB
                              │
AI_CLIENT_NAME     ───▶      │
(APEXアプリアイテム)          │
                              ▼
                      p_download_rules_json
                              │
                              ├─ HTTPヘッダー設定
                              │
                              └─ チャンク分割出力 ───▶ export_rules_{client}_{datetime}.json
                                                       (ファイルダウンロード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | ルールエクスポート/インポートのコアロジック |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEX画面からのダウンロード処理 |
| application_processes.sql | `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` | ソース | APEXアプリケーションプロセス定義 |
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | Rule Files画面定義 |
| qa_rules.sql | `src/ddl/tab/qa_rules.sql` | DDL | ルールテーブル定義 |
| export_rules_to_file.sql | `src/scripts/export_rules_to_file.sql` | スクリプト | SQLPlus用エクスポートスクリプト |
