# 帳票設計書 2-テスト結果エクスポート（XML形式）

## 概要

本ドキュメントは、QUASTOシステムにおけるテスト結果エクスポート（XML形式）機能の帳票設計を定義する。本帳票は、utPLSQLフレームワークを使用したユニットテスト実行結果をXML形式でファイル出力する機能を提供する。

### 本帳票の処理概要

ユニットテスト結果をXML形式でエクスポートし、テスト実行結果を外部ツールやCIパイプラインで利用可能にする機能である。

**業務上の目的・背景**：QUASTOはutPLSQLフレームワークと連携してデータベースオブジェクトの品質テストを自動実行する。テスト結果をJUnit互換のXML形式で出力することで、Jenkins、GitLab CI、GitHub Actionsなどの継続的インテグレーションツールとの連携が可能となる。また、テスト結果の履歴管理やトレンド分析にも活用できる。

**帳票の利用シーン**：本帳票は以下の場面で利用される。
- CI/CDパイプラインでのテスト結果取得時
- テスト実行履歴のアーカイブ作成時
- 外部品質管理ツールへのテスト結果連携時
- テスト結果レポートの生成・共有時

**主要な出力内容**：
1. utPLSQLフレームワークが生成するJUnit互換XMLレポート
2. テストスイート情報（名前、テスト数、失敗数、エラー数、実行時間）
3. 各テストケースの詳細結果（成功/失敗/エラー、実行時間）
4. 失敗・エラー時のメッセージとスタックトレース

**帳票の出力タイミング**：APEX画面「Test Result Files」（ページ5）において、ユーザーがテスト結果を選択し、ダウンロードアイコンをクリックした時に出力される。また、f_run_all_unit_tests関数実行時に自動的にQA_TEST_RESULTSテーブルに保存され、後からダウンロード可能。

**帳票の利用者**：システム管理者、品質管理担当者、開発者、CI/CDエンジニア

## 帳票種別

データエクスポート帳票（XML形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 5 | Test Result Files | /f?p=141:5 | ダウンロードアイコンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML（JUnit互換形式） |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | export_unit_test_results_{日時}.xml |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8（デフォルト：Windows-1251） |

### XML固有設定

| 項目 | 内容 |
|-----|------|
| XMLバージョン | 1.0 |
| スキーマ | JUnit XML形式（utPLSQL ut_junit_reporter準拠） |
| エンコーディングタグ | pi_character_setパラメータで指定（デフォルト：Windows-1251） |

## 帳票レイアウト

### レイアウト概要

JUnit互換のXML形式として、テストスイート（testsuite）要素の下にテストケース（testcase）要素を格納する階層構造。

```xml
<?xml version="1.0" encoding="Windows-1251"?>
<testsuites>
  <testsuite name="スイート名" tests="テスト数" failures="失敗数" errors="エラー数" time="実行時間">
    <testcase name="テストケース名" classname="クラス名" time="実行時間">
      <!-- 失敗時 -->
      <failure message="エラーメッセージ">詳細</failure>
      <!-- エラー時 -->
      <error message="エラーメッセージ">スタックトレース</error>
    </testcase>
  </testsuite>
</testsuites>
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | XML宣言 | XMLバージョンとエンコーディング | utPLSQL ut_junit_reporter | XML宣言 |
| 2 | testsuites | ルート要素 | utPLSQLフレームワーク | XML要素 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | testsuite/@name | テストスイート名 | utPLSQL suitepath | 属性 | - |
| 2 | testsuite/@tests | テスト総数 | utPLSQL実行結果 | 数値属性 | - |
| 3 | testsuite/@failures | 失敗数 | utPLSQL実行結果 | 数値属性 | - |
| 4 | testsuite/@errors | エラー数 | utPLSQL実行結果 | 数値属性 | - |
| 5 | testsuite/@time | スイート実行時間 | utPLSQL実行結果 | 数値属性（秒） | - |
| 6 | testcase/@name | テストケース名 | ルール名から生成 | 属性 | - |
| 7 | testcase/@classname | クラス名（パッケージ.プロシージャ） | 生成されたテストパッケージ名 | 属性 | - |
| 8 | testcase/@time | テスト実行時間 | utPLSQL実行結果 | 数値属性（秒） | - |
| 9 | failure | 失敗メッセージ | ut.expect結果 | XML要素 | - |
| 10 | error | エラーメッセージ | 例外情報 | XML要素 | - |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| テスト結果ID | pi_qatr_idで指定されたテスト結果レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | utPLSQL実行順序に依存 | - |

### 改ページ条件

該当なし（XMLファイル出力のため）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| QA_TEST_RESULTS | XML結果CLOBの取得 | qatr_id = pi_qatr_id |
| QA_RULES | テスト対象ルール情報 | 間接参照（テスト実行時） |
| QA_TEST_RUNS | テスト実行履歴 | 間接参照（テスト実行時） |

### テーブル別参照項目詳細

#### QA_TEST_RESULTS

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| qatr_id | 主キー | WHERE条件 | - |
| qatr_xml_result | XMLデータ全体 | - | CLOB型 |
| qatr_added_on | ファイル名の日時部分 | - | DATE型 |
| qatr_added_by | 追加者情報 | - | 画面表示用 |
| qatr_description | 説明 | - | 画面表示用 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| XMLデータ長 | DBMS_LOB.getlength(l_clob_xml) | - | Content-Length用 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ダウンロード要求] --> B[APEXアプリケーションプロセス getUTXMLAttachment 呼出]
    B --> C[qa_apex_app_pkg.p_download_unit_test_xml 呼出]
    C --> D[qa_unit_tests_pkg.f_export_test_result 呼出]
    D --> E[QA_TEST_RESULTS から qatr_xml_result 取得]
    E --> F[qatr_added_on 取得（ファイル名用）]
    F --> G[HTTPヘッダー設定]
    G --> H[ファイル名生成]
    H --> I[Content-Disposition設定]
    I --> J[チャンク分割出力]
    J --> K[apex_application.stop_apex_engine]
    K --> L[終了]
```

### テスト結果保存フロー（参考）

```mermaid
flowchart TD
    A[テスト実行要求] --> B[qa_unit_tests_pkg.f_run_all_unit_tests 呼出]
    B --> C[utPLSQL ut.run 実行]
    C --> D[ut_junit_reporter による XML 生成]
    D --> E[XMLAGG/XMLELEMENT で結合]
    E --> F[DBMS_XMLGEN.CONVERT でエスケープ処理]
    F --> G[QA_TEST_RESULTS に INSERT]
    G --> H[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| NO_DATA_FOUND | 指定IDのテスト結果が存在しない | qa_logger_pkg経由でログ | 例外を再スロー |
| OTHERS | その他の例外 | There has been an error while trying to get the xml file of an unit test execution! | qa_logger_pkgでログ後、例外を再スロー |
| e_stop_apex_engine | APEXエンジン停止（正常系） | - | NULL処理（握りつぶし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一テスト結果XMLファイル） |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし（APEXセッション依存） |

## セキュリティ考慮事項

- テスト結果にはスキーマ名やオブジェクト名が含まれる可能性があるため、エクスポートファイルの取り扱いには注意が必要
- APEX保護レベル「C」（Unrestricted）に設定されているため、認証済みユーザーのみアクセス可能
- ファイルダウンロード時にCache-Control: no-cacheを設定し、キャッシュを無効化

## 備考

- utPLSQLフレームワークのut_junit_reporterを使用してXML形式を生成
- 文字セットはpi_character_setパラメータで指定可能（デフォルト：Windows-1251）
- テスト結果は実行時に自動的にQA_TEST_RESULTSテーブルに保存される
- アップロードされたテスト結果ファイルはダッシュボード画面の集計には含まれない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、出力対象となるテーブル構造と、保存されるXMLデータの形式を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | テスト結果テーブルのカラム定義、qatr_xml_resultがCLOB型であることを確認 |
| 1-2 | qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | テスト結果行型の定義 |

**読解のコツ**: QA_TEST_RESULTSテーブルのqatr_xml_resultカラムにはutPLSQLが生成したJUnit XML形式のデータが格納される。qatr_descriptionには実行方法の説明が格納される。

#### Step 2: エントリーポイントを理解する

処理の起点となるAPEXアプリケーションプロセスとAPEX画面を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_processes.sql | `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` | getUTXMLAttachmentプロセスの呼び出し |
| 2-2 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | Test Result Files画面のダウンロードリンク設定 |

**主要処理フロー**:
1. **行19-23**: getUTXMLAttachmentプロセスでqa_apex_app_pkg.p_download_unit_test_xml呼び出し
2. **行102**: ダウンロードリンクのURL構成（AI_XML_TEST_RESULT_IDパラメータ渡し）

#### Step 3: APEXアプリケーション層を理解する

APEX画面からの呼び出しを受けて、ダウンロード処理を行うパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_download_unit_test_xml手続きの実装 |

**主要処理フロー**:
- **行248-295**: p_download_unit_test_xml手続き
- **行264**: f_export_test_resultの呼び出し
- **行266-269**: qatr_added_onの取得（ファイル名生成用）
- **行271-277**: HTTPヘッダー設定（Content-Type, Content-Disposition）
- **行279-283**: CLOBデータのチャンク分割出力

#### Step 4: コアロジック層を理解する

テスト結果の保存・取得を行うパッケージを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_export_test_result関数とf_run_all_unit_tests関数の実装 |

**主要処理フロー**:
- **行1460-1486**: f_export_test_result関数 - qatr_xml_resultを取得して返却
- **行935-988**: f_run_all_unit_tests関数 - utPLSQL実行とXML結果の保存
- **行971-973**: ut.runでテスト実行、ut_junit_reporterでXML生成
- **行976-977**: QA_TEST_RESULTSへのINSERT

#### Step 5: テスト実行とXML生成を理解する

utPLSQLとの連携部分を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_handle_test_result手続きでのXML要素出力 |

**主要処理フロー**:
- **行1072-1141**: p_handle_test_result手続き
- **行1102-1138**: dbms_output.put_lineでXMLタグ出力（Results, Scheme, Object要素）
- **行1090**: ut.expectでテスト結果判定

### プログラム呼び出し階層図

```
APEX Page 5 (Test Result Files)
    │
    ├─ Download Link Click
    │      │
    │      └─ APPLICATION_PROCESS: getUTXMLAttachment
    │             │
    │             └─ qa_apex_app_pkg.p_download_unit_test_xml
    │                    │
    │                    ├─ qa_unit_tests_pkg.f_export_test_result
    │                    │      │
    │                    │      └─ QA_TEST_RESULTS テーブル参照
    │                    │
    │                    ├─ HTP/OWA_UTIL (HTTPヘッダー設定)
    │                    │
    │                    └─ apex_application.stop_apex_engine
    │
    └─ QA_TEST_RESULT_FILES_P0005_V (テスト結果一覧表示)


テスト実行時のXML生成・保存フロー:

qa_unit_tests_pkg.f_run_all_unit_tests
    │
    ├─ f_get_suitepath (スイートパス生成)
    │
    ├─ ut.run (utPLSQL実行)
    │      │
    │      ├─ ut_junit_reporter (XML形式レポーター)
    │      │
    │      └─ 生成されたテストパッケージ呼び出し
    │             │
    │             └─ p_handle_test_result (テスト結果処理)
    │                    │
    │                    ├─ f_save_scheme_result
    │                    │
    │                    └─ p_save_scheme_faulty_objects
    │
    ├─ DBMS_XMLGEN.CONVERT (XMLエスケープ)
    │
    └─ INSERT into QA_TEST_RESULTS
```

### データフロー図

```
[入力]                            [処理]                              [出力]

--- テスト実行時 ---
QA_RULES テーブル ───▶ qa_unit_tests_pkg.f_run_all_unit_tests
                              │
                              ├─ ut.run (utPLSQL)
                              │       │
                              │       └─ ut_junit_reporter ───▶ XML CLOB
                              │
                              └─ INSERT ───▶ QA_TEST_RESULTS.qatr_xml_result


--- ダウンロード時 ---
QA_TEST_RESULTS ───▶ qa_unit_tests_pkg.f_export_test_result
                              │
AI_XML_TEST_RESULT_ID ───▶   │
(APEXアプリアイテム)          │
                              ▼
                      qa_apex_app_pkg.p_download_unit_test_xml
                              │
                              ├─ HTTPヘッダー設定
                              │
                              └─ チャンク分割出力 ───▶ export_unit_test_results_{datetime}.xml
                                                       (ファイルダウンロード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | テスト実行・結果エクスポートのコアロジック |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEX画面からのダウンロード/アップロード処理 |
| application_processes.sql | `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` | ソース | APEXアプリケーションプロセス定義 |
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | Test Result Files画面定義 |
| qa_test_results.sql | `src/ddl/tab/qa_test_results.sql` | DDL | テスト結果テーブル定義 |
| qa_test_results_row_t.sql | `src/plsql/typ/qa_test_results_row_t.sql` | ソース | テスト結果行型定義 |
| qa_test_results_table_t.sql | `src/plsql/typ/qa_test_results_table_t.sql` | ソース | テスト結果テーブル型定義 |
| qa_test_result_files_p0005_v.sql | `src/plsql/vw/qa_test_result_files_p0005_v.sql` | ソース | テスト結果ファイル一覧ビュー |
| qa_test_runs.sql | `src/ddl/tab/qa_test_runs.sql` | DDL | テスト実行履歴テーブル定義 |
| getutxmlattachment.sql | `src/apex/f141/application/shared_components/logic/application_items/ai_xml_test_result_id.sql` | ソース | テスト結果IDアプリケーションアイテム |
