---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-ルールエクスポート（JSON形式）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数**：数百〜数千件という記述は推定値であり、実データに基づく根拠なし
  2. **目標出力時間**：10秒以内という要件の根拠となるドキュメント未確認
  3. **同時出力数上限**：制限なしの根拠確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - ルールエクスポートのコアロジック
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX画面連携のダウンロード処理
- E-03: `src/apex/f141/application/pages/page_00008.sql` - Rule Files画面定義
- E-04: `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` - アプリケーションプロセス定義
- E-05: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-06: `src/scripts/export_rules_to_file.sql` - SQLPlus用エクスポートスクリプト
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル形式はJSON | E-01 (行184, 220-224) | ○ |
| C-02 | ファイル名形式は export_rules_{クライアント名}_{日時}.json | E-02 (行188) | ○ |
| C-03 | 文字コードはUTF-8 | E-02 (行184) | ○ |
| C-04 | バージョン番号は1.1 | E-01 (行14: g_version_number number := 1.1) | ○ |
| C-05 | Pretty Print形式で出力 | E-01 (行221-223: json_serialize...pretty) | ○ |
| C-06 | クライアント名でフィルタリング | E-01 (行84, 116-117) | ○ |
| C-07 | カテゴリでフィルタリング（オプション） | E-01 (行85, 117) | ○ |
| C-08 | Rule Files画面（ページ8）からダウンロード | E-03 (行15: p_id=>8) | ○ |
| C-09 | QA_RULESテーブルから12項目を取得 | E-01 (行153-165), E-05 | ○ |
| C-10 | 三重ループでJSON構造構築 | E-01 (行133-209) | ○ |
| C-11 | ルール件数チェックで0件時NULL返却 | E-01 (行119-126) | ○ |
| C-12 | HTTPヘッダーにContent-Type設定 | E-02 (行184-186) | ○ |
| C-13 | Cache-Control: no-cache設定 | E-02 (行187) | ○ |
| C-14 | Content-Disposition: attachment設定 | E-02 (行188) | ○ |
| C-15 | チャンク分割（3000文字）で出力 | E-02 (行172, 191-195) | ○ |
| C-16 | apex_application.stop_apex_engine呼出 | E-02 (行197) | ○ |
| C-17 | NO_DATA_FOUND例外処理 | E-01 (行227-232) | ○ |
| C-18 | OTHERS例外処理 | E-01 (行233-238) | ○ |
| C-19 | qa_logger_pkg経由でログ出力 | E-01 (行228-231), E-02 (行156-159) | ○ |
| C-20 | getRuleJSONAttachmentアプリケーションプロセス | E-04 (行14-16) | ○ |
| C-21 | AI_CLIENT_NAMEパラメータ使用 | E-03 (行99), E-04 (行15) | ○ |
| C-22 | APEX保護レベル「C」 | E-03 (行22: p_protection_level=>'C') | ○ |
| C-23 | g_spool_activeフラグでログ抑制 | E-01 (行18, 121-129) | ○ |
| C-24 | predecessor_idsがNULL時は空文字に変換 | E-01 (行190-192: nvl(...,'')) | ○ |
| C-25 | 想定データ件数：数百〜数千件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数（C-25）：実運用環境のデータ量に関する情報がコードからは読み取れない
  - 候補：運用ドキュメント / 要件定義書 / 実データ分析
- 目標出力時間：非機能要件定義書が未参照
  - 候補：性能要件書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼ全ての主張がソースコードから直接確認可能
- 1: 中リスク - パフォーマンス要件については実測値との比較が必要

## 6) レビュアーチェックリスト（最小）
- [ ] JSONフォーマットのバージョン番号（1.1）が最新であることを確認
- [ ] 出力ファイル名の命名規則が運用ルールに適合しているか確認
- [ ] 大量データ（数千件以上）でのパフォーマンステストが実施されているか確認
- [ ] ルールのSQLクエリに機密情報が含まれないか、セキュリティレビューが必要か確認
- [ ] Pretty Print設定がストレージ容量に与える影響を確認（必要に応じて無効化オプション検討）
