---
generated_at: 2026-01-22 15:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：2-テスト結果エクスポート（XML形式）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **JUnit互換XMLスキーマ**：utPLSQLのut_junit_reporterが生成するXML形式の詳細仕様は外部ドキュメント参照が必要
  2. **目標出力時間**：5秒以内という要件の根拠となるドキュメント未確認
  3. **デフォルト文字セットWindows-1251**：選定理由の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` - テスト実行・結果エクスポートのコアロジック
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX画面連携のダウンロード/アップロード処理
- E-03: `src/apex/f141/application/pages/page_00005.sql` - Test Result Files画面定義
- E-04: `src/apex/f141/embedded_code/shared_components/logic/application_processes.sql` - アプリケーションプロセス定義
- E-05: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル形式はXML（JUnit互換形式） | E-01 (行973: ut_junit_reporter) | ○ |
| C-02 | ファイル名形式は export_unit_test_results_{日時}.xml | E-02 (行276) | ○ |
| C-03 | 文字コードはUTF-8 | E-02 (行272) | ○ |
| C-04 | デフォルト文字セットはWindows-1251 | E-01 (行62-63, 939) | ○ |
| C-05 | Test Result Files画面（ページ5）からダウンロード | E-03 (行14: p_id=>5) | ○ |
| C-06 | QA_TEST_RESULTSテーブルからqatr_xml_resultを取得 | E-01 (行1473-1476) | ○ |
| C-07 | utPLSQLのut.run関数でテスト実行 | E-01 (行973) | ○ |
| C-08 | ut_junit_reporterでXML形式レポート生成 | E-01 (行973) | ○ |
| C-09 | DBMS_XMLGEN.CONVERTでエスケープ処理 | E-01 (行971) | ○ |
| C-10 | XMLAGGとXMLELEMENTで結合 | E-01 (行971) | ○ |
| C-11 | HTTPヘッダーにContent-Type設定 | E-02 (行272-274) | ○ |
| C-12 | Cache-Control: no-cache設定 | E-02 (行275) | ○ |
| C-13 | Content-Disposition: attachment設定 | E-02 (行276) | ○ |
| C-14 | チャンク分割（3000文字）で出力 | E-02 (行256, 279-283) | ○ |
| C-15 | apex_application.stop_apex_engine呼出 | E-02 (行285) | ○ |
| C-16 | e_stop_apex_engine例外はNULL処理 | E-02 (行287-288) | ○ |
| C-17 | OTHERS例外処理 | E-02 (行289-294) | ○ |
| C-18 | qa_logger_pkg経由でログ出力 | E-02 (行290-293) | ○ |
| C-19 | getUTXMLAttachmentアプリケーションプロセス | E-04 (行19-23) | ○ |
| C-20 | AI_XML_TEST_RESULT_IDパラメータ使用 | E-03 (行102), E-04 (行22) | ○ |
| C-21 | APEX保護レベル「C」 | E-03 (行22: p_protection_level=>'C') | ○ |
| C-22 | f_import_test_resultでXMLをインポート可能 | E-01 (行1435-1458) | ○ |
| C-23 | インポートファイルはダッシュボードに含まれない | E-03 (行193: プラグソース) | ○ |
| C-24 | テスト結果はQA_TEST_RESULTSに自動保存 | E-01 (行976-977) | ○ |
| C-25 | qatr_descriptionに実行方法の説明格納 | E-01 (行977) | ○ |
| C-26 | p_handle_test_resultでXML要素出力 | E-01 (行1102-1138) | ○ |
| C-27 | JUnit XML形式の詳細構造 | **根拠なし**（utPLSQL外部ドキュメント） | △ |
| C-28 | 目標出力時間5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- JUnit XML形式の詳細構造（C-27）：utPLSQLのut_junit_reporterが生成するXMLの正確なスキーマ定義はutPLSQL公式ドキュメントを参照する必要がある
  - 候補：utPLSQL公式ドキュメント / JUnit XML Schema定義
- 目標出力時間（C-28）：非機能要件定義書が未参照
  - 候補：性能要件書 / SLA定義書
- デフォルト文字セットWindows-1251の選定理由
  - 候補：設計決定記録 / 開発者ヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ダウンロード処理のほぼ全ての主張がソースコードから直接確認可能
- 1: 中リスク - XML形式の詳細仕様はutPLSQL依存であり、バージョンアップ時の互換性確認が必要
- 1: 中リスク - Windows-1251が日本語環境で適切かどうかの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] utPLSQL ut_junit_reporterが生成するXML形式がCI/CDツール（Jenkins, GitLab CI等）と互換性があるか確認
- [ ] デフォルト文字セットWindows-1251が日本語環境で適切か確認（UTF-8への変更要否検討）
- [ ] 大量のテストケース実行時のXMLファイルサイズとダウンロード性能を確認
- [ ] インポートされたテスト結果がダッシュボードに含まれない仕様が運用上問題ないか確認
- [ ] テスト結果XMLに機密情報（スキーマ名、オブジェクト名等）が含まれる影響を確認
